/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private final FileChannel mChannel;
    protected final ByteBuffer mBuffer;
    protected final int mBufferCapacity;
    protected int mBufferRemaining = 0;
    protected long mPos = 0L;

    public FileChannelInputStream(FileChannel channel) {
        this(channel, 524288);
    }

    public FileChannelInputStream(FileChannel channel, int bufferSize) {
        this.mChannel = channel;
        this.mBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.mBuffer.flip();
        this.mBufferRemaining = 0;
        this.mBufferCapacity = this.mBuffer.capacity();
    }

    public long position() {
        return this.mPos;
    }

    public void position(long newPos) throws IOException {
        long delta = newPos - this.mPos;
        if (newPos < this.mPos || delta >= (long)this.mBufferRemaining) {
            this.mBuffer.position(0);
            this.mBuffer.limit(0);
        } else {
            this.mBuffer.position(this.mBuffer.position() + (int)delta);
        }
        this.mPos = newPos;
        this.mBufferRemaining = this.mBuffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (!this.ensureBufferRemaining(1)) {
            return -1;
        }
        byte b = this.mBuffer.get();
        ++this.mPos;
        --this.mBufferRemaining;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] buf, int start, int length) throws IOException {
        if (start < 0) {
            throw new IllegalArgumentException("start was negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length was negative");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.ensureBufferRemaining(1)) {
            return -1;
        }
        int numToRead = Math.min(length, this.mBufferRemaining);
        this.mBuffer.get(buf, start, numToRead);
        this.mPos += (long)numToRead;
        this.mBufferRemaining -= numToRead;
        return numToRead;
    }

    @Override
    public void close() throws IOException {
        if (this.mChannel.isOpen()) {
            this.mChannel.close();
        }
    }

    protected boolean ensureBufferRemaining(int minSize) throws IOException {
        if (minSize > this.mBufferCapacity) {
            throw new IllegalArgumentException("minSize > mBufferCapacity");
        }
        while (this.mBufferRemaining < minSize && this.fillBuffer() >= 0) {
        }
        return this.mBufferRemaining >= minSize;
    }

    protected int fillBuffer() throws IOException {
        this.mBuffer.compact();
        int ret = this.mChannel.read(this.mBuffer, this.mPos + (long)this.mBuffer.position());
        this.mBuffer.flip();
        this.mBufferRemaining = this.mBuffer.remaining();
        return ret;
    }
}

