/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import com.ibm.cognos.aurora.core.io.BOMDetector;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

public final class FileEncodingDetector {
    private static final Charset ISO_8859_1_CHARSET = Charset.forName("ISO-8859-1");
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final int SAMPLE_SIZE = 102400;
    private static final float SAMPLE_COVERAGE_THRESHOLD = 0.5f;
    private static final int HEURISTIC_CONFIDENCE_THRESHOLD = 40;
    private static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");

    public static Charset detectCharset(File file) throws IOException {
        CharsetMatch match1;
        if (!file.exists()) {
            throw new IOException("File does not exist: " + file.getPath());
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        long fileLen = file.length();
        ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(102400L, fileLen));
        buffer.clear();
        int sampleSize = FileEncodingDetector.loadSample(file, buffer, 0L, buffer.capacity());
        float sampleCoverage = 1.0f - (float)(fileLen - (long)sampleSize) / (float)fileLen;
        if (isDebugEnabled) {
            String msg = String.format("Sampled first %d bytes (%.1f%%) of file '%s'", sampleSize, Float.valueOf(100.0f * sampleCoverage), file.getPath());
            logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
        }
        if (sampleSize < 4) {
            if (isDebugEnabled) {
                logger.debug("Sample size too small - falling back to ISO-8859-1", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            return ISO_8859_1_CHARSET;
        }
        String charsetName = FileEncodingDetector.detectBOM(buffer.array(), sampleSize);
        if (null != charsetName) {
            Charset charset = Charset.forName(charsetName);
            if (null != charset) {
                if (isDebugEnabled) {
                    String msg = String.format("BOM detected for %s", charsetName);
                    logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
                }
                return charset;
            }
            if (isDebugEnabled) {
                String msg = String.format("Unsupported BOM detected for %s - falling back to ISO-8859-1", charsetName);
                logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            return ISO_8859_1_CHARSET;
        }
        if (isDebugEnabled) {
            logger.debug("No BOM detected", FileEncodingDetector.class.getName() + "::detectCharset()");
        }
        if (null != (match1 = FileEncodingDetector.detectWithICU4J(buffer.array(), sampleSize)) && match1.getConfidence() < 40) {
            if (isDebugEnabled) {
                String msg = String.format("Heuristic confidence of sample is too low (%d %%)", match1.getConfidence());
                logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            match1 = null;
        }
        CharsetMatch match2 = null;
        charsetName = null;
        if (sampleCoverage < 0.5f) {
            String msg;
            buffer.clear();
            sampleSize = FileEncodingDetector.loadSample(file, buffer, fileLen - 102400L, buffer.capacity());
            if (isDebugEnabled) {
                msg = String.format("Sampled last %d bytes of file '%s'", sampleSize, file.getPath());
                logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            if (null != (match2 = FileEncodingDetector.detectWithICU4J(buffer.array(), sampleSize)) && match2.getConfidence() < 40) {
                if (isDebugEnabled) {
                    msg = String.format("Heuristic confidence of sample is too low (%d %%)", match2.getConfidence());
                    logger.debug(msg, FileEncodingDetector.class.getName() + "::detectCharset()");
                }
                match2 = null;
            }
        }
        if (null == match1) {
            if (null == match2) {
                if (isDebugEnabled) {
                    logger.debug("No heuristic matches", FileEncodingDetector.class.getName() + "::detectCharset()");
                }
                buffer.clear();
                int length_ISO_8859_1 = FileEncodingDetector.getDecodedLength(buffer, ISO_8859_1_CHARSET);
                buffer.clear();
                int length_UTF8 = FileEncodingDetector.getDecodedLength(buffer, UTF8_CHARSET);
                if (length_ISO_8859_1 <= length_UTF8) {
                    if (isDebugEnabled) {
                        logger.debug("Falling back to ISO-8859-1 based on decoded length", FileEncodingDetector.class.getName() + "::detectCharset()");
                    }
                    return ISO_8859_1_CHARSET;
                }
                if (isDebugEnabled) {
                    logger.debug("Falling back to UTF-8 based on decoded length", FileEncodingDetector.class.getName() + "::detectCharset()");
                }
                return UTF8_CHARSET;
            }
            if (isDebugEnabled) {
                logger.debug("Heuristic matched on second sample", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            charsetName = match2.getName();
        } else if (null == match2) {
            if (isDebugEnabled) {
                logger.debug("Heuristicly matched on first sample", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            charsetName = match1.getName();
        } else if (match1.getConfidence() >= match2.getConfidence()) {
            if (isDebugEnabled) {
                logger.debug("Heuristic matched both samples; first sample wins", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            charsetName = match1.getName();
        } else {
            if (isDebugEnabled) {
                logger.debug("Heuristic matched both samples; second sample wins", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            charsetName = match2.getName();
        }
        try {
            Charset charset = Charset.forName(charsetName);
            if (isDebugEnabled) {
                logger.debug("Using character set " + charsetName, FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            return charset;
        }
        catch (Exception ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("No supported character set could be detected - falling back to ISO-8859-1", FileEncodingDetector.class.getName() + "::detectCharset()");
            }
            return ISO_8859_1_CHARSET;
        }
    }

    private static String detectBOM(byte[] data, int length) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, 0, length);
        BOMDetector.BOM bom = BOMDetector.detect(is);
        if (null == bom) {
            return null;
        }
        return bom.getCharsetName();
    }

    private static CharsetMatch detectWithICU4J(byte[] data, int length) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, 0, length);
        CharsetDetector detector = new CharsetDetector();
        detector.setText((InputStream)is);
        return detector.detect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int loadSample(File file, ByteBuffer buffer, long startPos, int length) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int totalRead;
            int len;
            FileChannel channel = fis.getChannel();
            channel.position(startPos);
            for (totalRead = 0; totalRead < length; totalRead += len) {
                len = channel.read(buffer);
                if (len != -1) continue;
                int n = totalRead;
                return n;
            }
            int n = totalRead;
            return n;
        }
        finally {
            fis.close();
        }
    }

    private static int getDecodedLength(ByteBuffer buffer, Charset charset) {
        try {
            return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(buffer).remaining();
        }
        catch (CharacterCodingException ex) {
            return Integer.MAX_VALUE;
        }
    }

    private FileEncodingDetector() {
    }
}

