/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;

public class LineEndingDetector {
    private static final int SAMPLE_CHARACTERS = 1024;

    public static ELineEnding detect(String text) throws IOException {
        return LineEndingDetector.detect(new StringReader(text));
    }

    public static ELineEnding detect(Reader reader) throws IOException {
        int ch;
        if (!reader.markSupported()) {
            throw new RuntimeException("Mark is not supported by Reader.");
        }
        PushbackReader pbr = new PushbackReader(reader, 1);
        int numSampled = 0;
        boolean crlfFound = false;
        boolean crFound = false;
        boolean lfFound = false;
        reader.mark(1024);
        while (numSampled < 1024 && (ch = pbr.read()) >= 0) {
            ++numSampled;
            if (13 == ch) {
                int ch2 = pbr.read();
                if (ch2 < 0) {
                    crFound = true;
                    break;
                }
                if (10 == ch2) {
                    crlfFound = true;
                    ++numSampled;
                    continue;
                }
                pbr.unread(ch2);
                crFound = true;
                continue;
            }
            if (10 != ch) continue;
            lfFound = true;
        }
        reader.reset();
        if (crlfFound) {
            if (crFound || lfFound) {
                return ELineEnding.MIXED;
            }
            return ELineEnding.CRLF;
        }
        if (crFound) {
            if (lfFound) {
                return ELineEnding.MIXED;
            }
            return ELineEnding.CR;
        }
        if (lfFound) {
            return ELineEnding.LF;
        }
        return ELineEnding.UNKNOWN;
    }

    public static enum ELineEnding {
        LF,
        CR,
        CRLF,
        MIXED,
        UNKNOWN;

    }
}

