/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void zipDirectory(File dirToZip, File zipFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        File normalizeDirToZip = new File(FilenameUtils.normalizeNoEndSeparator((String)dirToZip.getAbsolutePath()));
        boolean success = false;
        try {
            ZipUtil.zip(normalizeDirToZip, normalizeDirToZip, zos);
            success = true;
        }
        finally {
            zos.close();
            if (!success) {
                zipFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zip(File dirToZip, File baseDir, ZipOutputStream zos) throws IOException {
        File[] files = dirToZip.listFiles();
        if (null == files) {
            throw new IOException("Invalid directory: " + dirToZip.toString());
        }
        byte[] buffer = new byte[8192];
        int read = 0;
        for (File file : files) {
            ZipEntry entry;
            String relPath = file.getPath().substring(baseDir.getPath().length() + 1);
            if (file.isDirectory()) {
                entry = new ZipEntry(relPath + "/");
                entry.setTime(file.lastModified());
                zos.putNextEntry(entry);
                ZipUtil.zip(file, baseDir, zos);
                continue;
            }
            entry = new ZipEntry(relPath);
            FileInputStream in = new FileInputStream(file);
            try {
                entry.setTime(file.lastModified());
                zos.putNextEntry(entry);
                while (-1 != (read = in.read(buffer))) {
                    zos.write(buffer, 0, read);
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzip(File zipFile, File destDir) throws IOException {
        byte[] buffer = new byte[8192];
        ZipFile archive = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> e = archive.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                File file = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!file.exists()) {
                        FileUtils.forceMkdir((File)file);
                    }
                    file.setLastModified(entry.getTime());
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    FileUtils.forceMkdir((File)file.getParentFile());
                }
                InputStream in = archive.getInputStream(entry);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        int read;
                        while (-1 != (read = in.read(buffer))) {
                            out.write(buffer, 0, read);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
                file.setLastModified(entry.getTime());
            }
        }
        finally {
            archive.close();
        }
    }

    private ZipUtil() {
    }
}

