/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class LoggingConfiguration {
    public static final String DEFAULT_CONFIG_LOCATION = "/athena_logging.properties";
    public static final String CONFIG_LOCATION = "athena_logging_config";
    private static Properties properties = null;

    private LoggingConfiguration() {
    }

    public static Properties getProperties() throws IOException {
        if (null == properties) {
            properties = LoggingConfiguration.loadProperties();
        }
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    private static Properties loadProperties() throws IOException {
        String location = System.getProperty(CONFIG_LOCATION, DEFAULT_CONFIG_LOCATION);
        Properties props = new Properties();
        InputStream in = LoggingConfiguration.class.getResourceAsStream(location);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(location);
        }
        if (in == null) {
            throw new IOException(String.format("%s is missing.", location));
        }
        props.load(in);
        in.close();
        return props;
    }
}

