/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.log4j;

import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.logging.log4j.ResourceCounterSet;

class Log4jPerfLogEvent
extends PerfLogEvent {
    private ResourceCounterSet rcs = null;
    private String action = LogAction.LOG.name();
    private String message = "";
    private String executionID = null;

    Log4jPerfLogEvent(String className, String methodName, ResourceCounterSet rcs) {
        super(className, methodName);
        this.rcs = rcs;
        this.executionID = System.currentTimeMillis() + "_" + Integer.toHexString(this.hashCode());
    }

    @Override
    public void enableResourceCounter() {
        this.rcs.enableResourceCounter();
    }

    @Override
    public void disableResourceCounter() {
        this.rcs.disableResourceCounter();
    }

    @Override
    public boolean isIPFPerfLogEvent() {
        return false;
    }

    @Override
    public boolean isLog4jPerfLogEvent() {
        return true;
    }

    ResourceCounterSet getRCS() {
        return this.rcs;
    }

    void setAction(String actionName) {
        if (actionName != null) {
            this.action = actionName;
        }
    }

    String getAction() {
        return this.action;
    }

    void setMessage(String message) {
        if (message != null) {
            this.message = message;
        }
    }

    String getMessage() {
        return this.message;
    }

    String getExecutionID() {
        return this.executionID;
    }
}

