/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.core.model.ProviderDataItem;

public class DataItemStats
implements IDataItemStats {
    private long mCount;
    private long mDistinctCount;
    private long mNullCount;
    private IValue mMinValue;
    private IValue mMaxValue;
    private boolean mNullable = false;
    private float mDensity = 1.0f;

    public long count() {
        return this.mCount;
    }

    public void setCount(long count) {
        this.mCount = count;
    }

    public long distinctCount() {
        return this.mDistinctCount;
    }

    public void setDistinctCount(long distinctCount) {
        this.mDistinctCount = distinctCount;
    }

    public long nullCount() {
        return this.mNullCount;
    }

    public void setNullCount(long nullCount) {
        this.mNullCount = nullCount;
    }

    public long totalCount() {
        return this.mCount + this.mNullCount;
    }

    public IValue minValue() {
        return this.mMinValue;
    }

    public void setMinValue(IValue minValue) {
        this.mMinValue = minValue;
    }

    public IValue maxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(IValue maxValue) {
        this.mMaxValue = maxValue;
    }

    public boolean isNullable() {
        return this.mNullable;
    }

    public void setNullable(boolean isNullable) {
        this.mNullable = isNullable;
    }

    public float density() {
        return this.mDensity;
    }

    public void setDensity(float density) {
        this.mDensity = density;
    }

    public static long computeDistinctTupleCount(IDataItem[] dataItems) {
        if (0 == dataItems.length) {
            return 0L;
        }
        IPhysicalModel physModel = null;
        if (null != dataItems[0].getPhysicalMetadata()) {
            physModel = dataItems[0].getPhysicalMetadata().getModel();
        }
        for (IDataItem di : dataItems) {
            if (null != physModel && (null == di.getPhysicalMetadata() || di.getPhysicalMetadata().getModel() != physModel)) {
                throw new UnsupportedOperationException("Inconsistent physical models");
            }
            if (di instanceof ProviderDataItem) continue;
            throw new UnsupportedOperationException("Not a ProviderDataItem");
        }
        IDataProvider provider = ((ProviderDataItem)dataItems[0]).getDataProvider();
        return provider.fetchDistinctTupleCount(dataItems);
    }
}

