/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.model.ConnectionSpec;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class DataSource
implements IDataSource {
    private EDataSourceType mType;
    private String mName;
    private IConnectionSpec mConnSpec;

    public DataSource() {
    }

    public DataSource(EDataSourceType type) {
        this.mType = type;
    }

    public DataSource(EDataSourceType type, String name) {
        this.mType = type;
        this.mName = name;
    }

    public final EDataSourceType getType() {
        return this.mType;
    }

    public final String getName() {
        return this.mName;
    }

    public final IConnectionSpec getConnectionSpec() {
        return this.mConnSpec;
    }

    public final void setConnectionSpec(IConnectionSpec connSpec) {
        this.mConnSpec = connSpec;
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeString(out, this.mName);
        out.writeShort(this.mType.ordinal());
        if (null != this.mConnSpec) {
            out.writeBoolean(true);
            this.mConnSpec.encodeBinary(out, ctx);
        } else {
            out.writeBoolean(false);
        }
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mName = EncodeUtil.readString(in);
        this.mType = EDataSourceType.values()[in.readShort()];
        if (in.readBoolean()) {
            this.mConnSpec = new ConnectionSpec();
            this.mConnSpec.decodeBinary(in, ctx);
        } else {
            this.mConnSpec = null;
        }
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        if (Boolean.TRUE.equals(ctx.get((Object)"stableTestOutput"))) {
            elem.addElement("name").setText("suppressed-for-testing");
        } else {
            elem.addElement("name").setText(this.mName);
        }
        elem.addElement("type").setText(this.mType.name());
        if (null != this.mConnSpec) {
            Element connSpecElem = elem.addElement("connectionSpec");
            this.mConnSpec.encodeElement(connSpecElem, ctx);
        }
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mName = elem.elementText("name");
        this.mType = EDataSourceType.valueOf((String)elem.elementText("type"));
        Element connSpecElem = elem.element("connectionSpec");
        if (null != connSpecElem) {
            this.mConnSpec = new ConnectionSpec();
            this.mConnSpec.decodeElement(connSpecElem, ctx);
        } else {
            this.mConnSpec = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.mName).append(';');
        sb.append("type=").append(this.mType).append(';');
        sb.append("spec=").append(this.mConnSpec);
        return sb.toString();
    }
}

