/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;

public final class EdgeFilters
extends Filters {
    private EdgeFilters() {
    }

    public static IFilter<IEdge> hasEdgeId(final String id) {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                return e.getId().equals(id);
            }
        };
    }

    public static IFilter<IEdge> hasLabel(final String label) {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                if (null == e.getLabel()) {
                    return null == label;
                }
                return e.getLabel().equals(label);
            }
        };
    }

    public static IFilter<IEdge> isWholePart() {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                return e.isWholePart();
            }
        };
    }

    public static IFilter<IEdge> hasStart(final INode start) {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                return e.getStart().equals(start);
            }
        };
    }

    public static IFilter<IEdge> hasEnd(final INode end) {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                return e.getEnd().equals(end);
            }
        };
    }

    public static IFilter<IEdge> isIncidentWith(final INode node) {
        return new IFilter<IEdge>(){

            @Override
            public boolean passes(IEdge e) {
                return e.getStart().equals(node) || e.getEnd().equals(node);
            }
        };
    }
}

