/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.pool;

import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;

public final class XQEIntegerPoolForNodeType {
    private static final int DEFAULT_NUM_ROWS = 12;
    private static final int DEFAULT_NUM_COLUMNS = 2000;
    private static final int RANGE_SIZE = 100000;
    private static final int MAX_NUMBER = 1201999;
    private static final int MIN_NUMBER = 100000;
    private static Integer[][] data = new Integer[12][];

    private XQEIntegerPoolForNodeType() {
    }

    public static Integer getInteger(int value) {
        if (value < 100000) {
            return XQEIntegerPool.getInteger(value);
        }
        if (value > 1201999) {
            return new Integer(value);
        }
        int rowNumber = value / 100000;
        int columnNumber = value % 100000;
        if (columnNumber >= 2000) {
            return new Integer(value);
        }
        return data[rowNumber - 1][columnNumber];
    }

    static {
        int rangeNumber = 1;
        int start = 0;
        int i = 0;
        while (i < 12) {
            XQEIntegerPoolForNodeType.data[i] = new Integer[2000];
            start = rangeNumber * 100000;
            int j = 0;
            while (j < 2000) {
                XQEIntegerPoolForNodeType.data[i][j] = new Integer(start);
                ++j;
                ++start;
            }
            ++i;
            ++rangeNumber;
        }
    }
}

