/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dictionary<T> {
    public static final int NULL_ID = -1;
    private final ArrayList<T> mValueList = new ArrayList();
    private final Map<T, Integer> mValueToId = new HashMap<T, Integer>();

    public int size() {
        return this.mValueList.size();
    }

    public int insert(T value) {
        if (null == value) {
            return -1;
        }
        Integer id = this.mValueToId.get(value);
        if (null == id) {
            this.mValueToId.put(value, this.mValueList.size());
            this.mValueList.add(value);
            return -1;
        }
        return id;
    }

    public T insertAndReturn(T value) {
        int id = this.insert(value);
        if (id == -1) {
            return value;
        }
        return this.lookup(id);
    }

    public T lookup(int id) {
        if (-1 == id) {
            return null;
        }
        return this.mValueList.get(id);
    }

    public Integer reverseLookup(T s) {
        if (null == s) {
            return -1;
        }
        return this.mValueToId.get(s);
    }

    public void clear() {
        this.mValueList.clear();
        this.mValueToId.clear();
    }

    public List<T> values() {
        return this.mValueList;
    }

    public void sort(Comparator<T> comparator) {
        this.mValueToId.clear();
        Collections.sort(this.mValueList, comparator);
        for (int i = 0; i < this.mValueList.size(); ++i) {
            T val = this.mValueList.get(i);
            this.mValueToId.put(val, i);
        }
    }

    public String toString() {
        return this.mValueToId.toString();
    }
}

