/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.api.util.IObservable;
import com.ibm.cognos.aurora.api.util.IObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ObservableResourceTracker<E extends IObservable<E>> {
    protected final LinkedList<E> resourceList = new LinkedList();
    protected final Lock readLock;
    protected final Lock writeLock;

    public ObservableResourceTracker() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public boolean add(E resource) {
        boolean result;
        this.writeLock.lock();
        try {
            result = this.resourceList.offerLast(resource);
            resource.addObserver((IObserver)new Remover(this, resource));
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(IResourceProcessor<E> resourceProcessor) {
        this.readLock.lock();
        try {
            for (IObservable resource : this.resourceList) {
                if (resourceProcessor.processAndContinue(resource)) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<E> getResources() {
        this.readLock.lock();
        try {
            ArrayList<E> arrayList = new ArrayList<E>(this.resourceList);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.resourceList.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static final class Remover
    implements IObserver<E> {
        private final E toBeRemoved;
        final /* synthetic */ ObservableResourceTracker this$0;

        Remover(E resource) {
            this.this$0 = var1_1;
            this.toBeRemoved = resource;
        }

        public void update(E observable) {
            observable.deleteObserver((IObserver)this);
            this.this$0.writeLock.lock();
            try {
                this.this$0.resourceList.remove(this.toBeRemoved);
            }
            finally {
                this.this$0.writeLock.unlock();
            }
        }
    }

    public static interface IResourceProcessor<E> {
        public boolean processAndContinue(E var1);
    }
}

