/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringSubstitutionEngine {
    private static final String SEMI_COLON = ";";
    private static final String XML_CONST_PREFIX = "&#";
    private static final int ASCII_32 = 32;
    private static final int ASCII_127 = 127;
    private static final String QUOTE = "'";
    private static final String C_CMNT_PATTERN = "(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)";
    private static final Pattern CSTYLE_CMNT_PATTERN = Pattern.compile("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)");
    private static final String CAPABILITY_SUBST_PATTERN = "\\$([1-9])";
    private static Pattern po = Pattern.compile("\\$([1-9])");

    private StringSubstitutionEngine() {
    }

    public static String escapeSQLString(String s) {
        return s.replaceAll(QUOTE, "''");
    }

    public static String substitute(String source, String oldString, String newString) {
        return StringSubstitutionEngine.replaceAll(source, oldString, newString);
    }

    public static String substitute(String source, Map<String, String> params) {
        if (source == null || source.length() == 0) {
            return source;
        }
        String result = source;
        Set<Map.Entry<String, String>> set = params.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey().toString();
            if (result.indexOf(key) == -1) continue;
            result = result.replaceAll(key, entry.getValue().toString());
        }
        return result;
    }

    private static String escapeString(String s, EscapeMode mode) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if (mode != EscapeMode.HTML) {
                        str.append("&quot;");
                        continue block7;
                    }
                    str.append("\"");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    char ival = ch;
                    if (mode == EscapeMode.XML_UNICODE && (ival < ' ' || ival > '\u007f')) {
                        char ch2;
                        if (Character.isHighSurrogate(ch) && i + 1 < s.length() && Character.isLowSurrogate(ch2 = s.charAt(i + 1))) {
                            str.append(XML_CONST_PREFIX);
                            str.append(String.valueOf(Character.toCodePoint(ch, ch2)));
                            str.append(SEMI_COLON);
                            ++i;
                            continue block7;
                        }
                        str.append(XML_CONST_PREFIX);
                        str.append(String.valueOf((int)ival));
                        str.append(SEMI_COLON);
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String escapeStringForHTML(String s) {
        return StringSubstitutionEngine.escapeString(s, EscapeMode.HTML);
    }

    public static String unicodeEscapeString(String s) {
        return StringSubstitutionEngine.escapeString(s, EscapeMode.XML_UNICODE);
    }

    public static String escapeString(String str) {
        return StringSubstitutionEngine.escapeString(str, EscapeMode.XML);
    }

    public static boolean hasInvalidXMLCharacter(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (!(ch >= '\u0001' && ch < '\t' || ch > '\n' && ch < '\r' || ch > '\r' && ch < ' ' || ch >= '\ud800' && ch <= '\udfff' || ch == '\ufffe' || ch == '\uffff' || ch >= '\u007f' && ch <= '\u0084' || ch >= '\u0086' && ch <= '\u009f') && (ch < '\ufdd0' || ch > '\ufdef')) continue;
            return true;
        }
        return false;
    }

    public static String substitute(String pattern, String[] replacement) {
        Matcher matcher = po.matcher(pattern);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String replacementIndex = matcher.group(1);
            String replaceStr = replacement[Integer.parseInt(replacementIndex) - 1];
            replaceStr = StringSubstitutionEngine.replaceAll(replaceStr, "\\", "\\\\");
            replaceStr = StringSubstitutionEngine.replaceAll(replaceStr, "$", "\\$");
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        String result = buf.toString();
        return result;
    }

    public static String replaceAll(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        boolean foundMatch = false;
        if (pattern.length() == 0) {
            return str;
        }
        while ((e = str.indexOf(pattern, s)) >= 0) {
            foundMatch = true;
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        if (!foundMatch) {
            return str;
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String removeCStyleComments(String str) {
        return CSTYLE_CMNT_PATTERN.matcher(str).replaceAll("");
    }

    private static enum EscapeMode {
        XML,
        HTML,
        XML_UNICODE;

    }
}

