/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.core.util.IArgumentedFactory;
import com.ibm.cognos.aurora.core.util.IAssociativeContainer;
import com.ibm.cognos.aurora.core.util.IAssociativeGetOrCreateContainer;
import com.ibm.cognos.aurora.core.util.IFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ValueContendedCache<K, V>
implements IAssociativeGetOrCreateContainer<K, V> {
    private final IAssociativeContainer<K, FutureEntry<K, V>> associativeContainer;
    private final Lock readLock;
    private final Lock writeLock;

    public ValueContendedCache() {
        this(new MapBasedAssociativeContainer());
    }

    public ValueContendedCache(IAssociativeContainer<K, FutureEntry<K, V>> associativeContainer) {
        this.associativeContainer = associativeContainer;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.associativeContainer.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws InterruptedException, ExecutionException {
        Future future;
        this.readLock.lock();
        try {
            future = this.associativeContainer.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        V value = null == future ? null : (V)this.getAndRemoveOnException(future, key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrCreate(K key, IFactory<V> factory) throws InterruptedException, ExecutionException {
        FutureEntry<K, V> future = null;
        this.readLock.lock();
        try {
            future = this.associativeContainer.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (null == future) {
            FutureEntry<K, V> futureEntry = null;
            this.writeLock.lock();
            try {
                future = this.associativeContainer.get(key);
                if (null == future) {
                    future = futureEntry = new FutureEntry<K, V>(key, factory);
                    this.associativeContainer.put(key, futureEntry);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (null != futureEntry) {
                futureEntry.run();
            }
        }
        return this.getAndRemoveOnException(future, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ARG> V getOrCreate(K key, ARG arg, IArgumentedFactory<V, ARG> argumentedFactory) throws InterruptedException, ExecutionException {
        FutureEntry<K, V> future = null;
        this.readLock.lock();
        try {
            future = this.associativeContainer.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (null == future) {
            FutureEntry<K, V> futureEntry = null;
            this.writeLock.lock();
            try {
                future = this.associativeContainer.get(key);
                if (null == future) {
                    future = futureEntry = new FutureEntry<K, V>(key, arg, argumentedFactory);
                    this.associativeContainer.put(key, futureEntry);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (null != futureEntry) {
                futureEntry.run();
            }
        }
        return this.getAndRemoveOnException(future, key);
    }

    @Override
    public Collection<V> values() {
        FutureEntry[] futureEntries;
        this.readLock.lock();
        try {
            futureEntries = new FutureEntry[this.associativeContainer.size()];
            this.associativeContainer.values().toArray(futureEntries);
        }
        finally {
            this.readLock.unlock();
        }
        ArrayList values = new ArrayList(futureEntries.length);
        for (FutureEntry futureEntry : futureEntries) {
            try {
                values.add(futureEntry.get());
            }
            catch (InterruptedException e) {
                this.removeFuture(futureEntry.getKey());
            }
            catch (ExecutionException e) {
                this.removeFuture(futureEntry.getKey());
            }
        }
        return values;
    }

    @Override
    public boolean remove(K key) {
        Future<V> future = this.removeFuture(key);
        return null != future;
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.associativeContainer.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected final V getAndRemoveOnException(Future<V> future, K key) throws InterruptedException, ExecutionException {
        V value;
        try {
            value = future.get();
        }
        catch (InterruptedException interruptedException) {
            this.removeFuture(key);
            throw interruptedException;
        }
        catch (ExecutionException executionException) {
            this.removeFuture(key);
            throw executionException;
        }
        return value;
    }

    protected final Future<V> removeFuture(K key) {
        this.writeLock.lock();
        try {
            Future future = this.associativeContainer.remove(key);
            return future;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static final class MapBasedAssociativeContainer<K, V>
    extends HashMap<K, V>
    implements IAssociativeContainer<K, V> {
        private MapBasedAssociativeContainer() {
        }
    }

    public static final class FutureEntry<K, V>
    extends FutureTask<V> {
        private final K key;

        FutureEntry(K key, final IFactory<V> factory) {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    Object value = factory.create();
                    if (null == value) {
                        throw new NullPointerException("\"null\" values are not supported by ValueContendedCache");
                    }
                    return value;
                }
            });
            this.key = key;
        }

        <ARG> FutureEntry(K key, final ARG arg, final IArgumentedFactory<V, ARG> argumentedFactory) {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    Object value = argumentedFactory.create(arg);
                    if (null == value) {
                        throw new NullPointerException("\"null\" values are not supported by ValueContendedCache");
                    }
                    return value;
                }
            });
            this.key = key;
        }

        K getKey() {
            return this.key;
        }
    }
}

