/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class UnionIterator<E>
implements Iterator<E> {
    private final Iterator<E>[] mIterators;
    private int mIndex = 0;
    private boolean mNextCalled = false;

    public UnionIterator(Iterator<E> ... iterators) {
        this.mIterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while (this.mIndex < this.mIterators.length) {
            if (this.mIterators[this.mIndex].hasNext()) {
                return true;
            }
            ++this.mIndex;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.mNextCalled = true;
        return this.mIterators[this.mIndex].next();
    }

    @Override
    public void remove() {
        if (!this.mNextCalled) {
            throw new IllegalStateException("next was not called");
        }
        this.mIterators[this.mIndex].remove();
        this.mNextCalled = false;
    }
}

