/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.moserfunction;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqebifw.bibushandler.MoserCommandAdapter;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.common.util.DAASUtils;
import com.ibm.bi.qs.model.api.data.common.generated.Connection;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValueType;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValueV2;
import com.ibm.bi.qs.model.api.data.common.generated.ValueOperatorType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.FunctionSpec;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.moserfunction.response.IMoserCommandResponseHandler;
import com.ibm.bi.qs.xqe.moserfunction.response.ResponseHandlerFactory;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FunctionSpecExecutor
extends BaseExecutor {
    private final FunctionSpec functionSpec;
    private Element xmlMoserFunction;
    private RequestEnvironment reqEnvironment;

    public FunctionSpecExecutor(FunctionSpec spec, ServletRequestContext servletRequestContext) {
        super(servletRequestContext, null, spec.getLocale());
        this.functionSpec = spec;
    }

    @Override
    public void planExecution() {
        this.reqEnvironment = this.envHelper.getRequestEnvironment();
        try {
            Document requestDocument = this.generateXMLCommand();
            BIBusEnvelope requestEnvelope = this.reqEnvironment.getRequestEnvelope();
            requestEnvelope.getBody().add(requestDocument.getRootElement());
        }
        catch (Exception e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
    }

    public Document generateXMLCommand() throws Exception {
        Field[] fields;
        Document requestDocument = DocumentHelper.createDocument();
        this.xmlMoserFunction = requestDocument.addElement("moserCommand");
        Element moserFunction = this.xmlMoserFunction.addElement("moserFunction");
        for (Field field : fields = FunctionSpec.class.getDeclaredFields()) {
            JsonProperty annotation;
            if (!Modifier.isPrivate(field.getModifiers()) || (annotation = field.getAnnotation(JsonProperty.class)) == null) continue;
            String name = annotation.value();
            String getMethodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = FunctionSpec.class.getMethod(getMethodName, new Class[0]);
            if (getMethod == null) {
                throw new Exception("No " + getMethodName + "() defined for class: " + FunctionSpec.class.getName());
            }
            Object v = getMethod.invoke((Object)this.functionSpec, new Object[0]);
            String value = null;
            String nm = name;
            if ("connections".equals(name)) {
                List conns;
                nm = "connectionSpec";
                if (v != null && !(conns = (List)v).isEmpty()) {
                    ArrayList<String[]> sConns = new ArrayList<String[]>();
                    for (Connection c : conns) {
                        String[] a = new String[]{c.getDatasource(), c.getConnection(), c.getSignon()};
                        sConns.add(a);
                    }
                    value = MoserCommandUtil.getConnectionValue(sConns);
                }
            } else {
                value = "parameterValue".equals(name) ? FunctionSpecExecutor.convertParameterValueToJSONString(v) : MoserCommandUtil.getStringValue((Object)v);
            }
            if (value == null) continue;
            Element item = moserFunction.addElement("item");
            item.addElement("name").addText(nm);
            item.addElement("value").addText(value);
        }
        if (QueryServiceLogger.isDebugEnabled((Object)this)) {
            QueryServiceLogger.debug((Object)this, (String)this.xmlMoserFunction.asXML());
        }
        return requestDocument;
    }

    protected static String convertParameterValueToJSONString(Object vObj) {
        if (vObj == null) {
            return null;
        }
        List parameterValues = (List)vObj;
        if (parameterValues.isEmpty()) {
            return null;
        }
        JSONArray jParameterValues = new JSONArray();
        for (ParameterValueV2 pv : parameterValues) {
            List values;
            JSONObject jParam = new JSONObject();
            jParameterValues.add((Object)jParam);
            jParam.put((Object)"parameterName", (Object)pv.getParameterName());
            jParam.put((Object)"dataType", (Object)pv.getDataType().value());
            Boolean bInvert = pv.getInvert();
            if (bInvert != null) {
                jParam.put((Object)"invert", (Object)bInvert);
            }
            if ((values = pv.getValues()) == null || values.isEmpty()) continue;
            JSONArray jValues = new JSONArray();
            jParam.put((Object)"values", (Object)jValues);
            for (ParameterValueType v : values) {
                String display2;
                String use2;
                String display;
                String use;
                JSONObject jV = new JSONObject();
                jValues.add((Object)jV);
                ValueOperatorType op = v.getOperator();
                if (op != null) {
                    jV.put((Object)"operator", (Object)op.value());
                }
                if ((use = v.getUse()) != null && !use.isEmpty()) {
                    jV.put((Object)"use", (Object)use);
                }
                if ((display = v.getDisplay()) != null && !display.isEmpty()) {
                    jV.put((Object)"display", (Object)display);
                }
                if ((use2 = v.getUse2()) != null && !use2.isEmpty()) {
                    jV.put((Object)"use2", (Object)use2);
                }
                if ((display2 = v.getDisplay2()) == null || display2.isEmpty()) continue;
                jV.put((Object)"display2", (Object)display2);
            }
        }
        return jParameterValues.toString();
    }

    @Override
    public String execute() {
        ResponseAdapter moserCommandResponse;
        BIBusEnvelope responseEnvelope;
        MoserCommandAdapter adaptor = (MoserCommandAdapter)V5QueryHandler.getInstance().getRequestAdapter("moserCommand");
        if (DAASUtils.isDAAS()) {
            this.reqEnvironment.setHttpServletRequest(this.servletRequestContext.getHttpServletRequest());
        }
        if ((responseEnvelope = (BIBusEnvelope)(moserCommandResponse = adaptor.executeRequest(this.reqEnvironment)).getSOAPResponse()) == null) {
            return "";
        }
        if (QueryServiceLogger.isDebugEnabled((Object)this)) {
            QueryServiceLogger.debug((Object)this, (String)responseEnvelope.getBody().asXML());
        }
        IMoserCommandResponseHandler responseHandler = null;
        responseHandler = moserCommandResponse instanceof SOAPFaultResponseAdapter ? ResponseHandlerFactory.get().create("soapFault") : ResponseHandlerFactory.get().create(this.functionSpec.getMoserFunctionType());
        return responseHandler.generateResponse(responseEnvelope.getBody());
    }

    @Override
    protected Date getLastModifiedFromQueryPlan() {
        return null;
    }

    @Override
    public Object executeImpl() {
        return null;
    }
}

