/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.moserfunction.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.xqe.moserfunction.response.IMoserCommandResponseHandler;
import com.ibm.bi.qs.xqe.moserfunction.response.ResponseHanlderEntry;

public class ResponseHandlerFactory {
    private static ResponseHandlerFactory factory;

    public static ResponseHandlerFactory get() {
        if (factory == null) {
            factory = new ResponseHandlerFactory();
        }
        return factory;
    }

    public IMoserCommandResponseHandler create(String moserFunctionName) {
        ResponseHanlderEntry entry = null;
        try {
            entry = ResponseHanlderEntry.valueOf(moserFunctionName);
        }
        catch (IllegalArgumentException e) {
            entry = ResponseHanlderEntry.Default;
        }
        try {
            Class<?> implClass = Class.forName(entry.getResponseHandlerClass());
            IMoserCommandResponseHandler handler = (IMoserCommandResponseHandler)implClass.newInstance();
            handler.setMoserFunctionName(moserFunctionName);
            return handler;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, String.format("can not create handler for moser command %s ", moserFunctionName));
        }
    }
}

