/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.predict;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.fastpattern.FastPatternService;
import com.ibm.bi.predict.fastpattern.chaid.Tree;
import com.ibm.bi.predict.fastpattern.exceptions.BadParametersException;
import com.ibm.bi.predict.fastpattern.exceptions.InvalidDataException;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.result.FastPatternResult;
import com.ibm.bi.predict.fastpattern.result.InputField;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.service.PredictService;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.Filter;
import com.ibm.bi.qs.model.api.data.predict.generated.KeyDriverSpec;
import com.ibm.bi.qs.model.api.data.predict.generated.MethodType;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.predict.PredictDataAccessResultSet;
import com.ibm.bi.qs.xqe.predict.PredictExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class KeyDriverExecutor
extends PredictExecutor {
    public static final String REQUEST_TYPE = KeyDriverExecutor.class.getSimpleName();
    private static final String ACCURACY = "accuracy";
    private static final String ACCURACY_LEVEL = "accuracyLevel";
    private static final String CATEGORIES = "categories";
    private static final String DATA_ITEMS = "dataItems";
    private static final String DETAILS = "details";
    private static final String ERRORS = "errors";
    private static final String FIELDS = "fields";
    private static final String VIS = "vis";
    private static final String IMPORTANCE = "importance";
    private static final String INPUTS = "inputs";
    private static final String LABEL = "label";
    private static final String METHODS = "methods";
    private static final String LOCALE = "locale";
    private static final String PREDICT_STATUS = "predictStatus";
    private static final String RESULTS = "results";
    private static final String STATE = "state";
    private static final String STATUS = "status";
    private static final String SUCCESS = "SUCCESS";
    private static final String TARGET = "target";
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private static final String VERSION_1 = "1";
    private static final String VERSION_1_1 = "1.1";
    private static final String WARNINGS = "warnings";
    private static final String MESSAGES = "messages";
    private final KeyDriverSpec keyDriverSpec;

    public KeyDriverExecutor(KeyDriverSpec keyDriverSpec, DataSet dataset, ServletRequestContext servletRequestContext) {
        super(dataset, REQUEST_TYPE, servletRequestContext);
        this.keyDriverSpec = keyDriverSpec;
        this.setRequestAndGlobalParameters(keyDriverSpec);
        this.setConnections(keyDriverSpec.getConnections());
        this.setupSampling(keyDriverSpec.getSampling());
        this.setupDataFilters(keyDriverSpec.getDataFilters(), keyDriverSpec.getTargetId());
        this.timeLimit = keyDriverSpec.getTimeLimit();
        this.validateVersion();
    }

    private void setRequestAndGlobalParameters(KeyDriverSpec keyDriverSpec) {
        this.setParameterValues(keyDriverSpec.getParameterValues());
        this.setGlobalParameterValues(keyDriverSpec.getGlobalParameterValues());
        this.setParameterValuesV2(keyDriverSpec.getParameterValuesV2());
        this.setGlobalParameterValuesV2(keyDriverSpec.getGlobalParameterValuesV2());
    }

    private void validateVersion() {
        String version = this.keyDriverSpec.getVersion();
        if (!VERSION_1.equals(version) && !VERSION_1_1.equals(version)) {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_KEYDRIVER_VERSION, version);
        }
    }

    public OrderedJSONObject executeImpl() {
        PredictDataAccessResultSet resultSet = this.executeSamplingQuery();
        OrderedJSONObject jsonResponse = null;
        String version = this.keyDriverSpec.getVersion();
        if (VERSION_1.equals(version)) {
            jsonResponse = this.keyDriversToResult(this.getKeyDrivers(resultSet));
        } else if (VERSION_1_1.equals(version)) {
            jsonResponse = this.getFastPatternJsonResponse(resultSet);
        }
        return jsonResponse;
    }

    private List<KeyDriver> getKeyDrivers(PredictDataAccessResultSet resultSet) {
        StringBuilder params = new StringBuilder("{ \"version\": \"" + FastPatternService.VERSION + "\", \"target\": 0, \"dataItems\": [");
        for (int i = 1; i <= this.keyDriverSpec.getInputs().size(); ++i) {
            if (i > 1) {
                params.append(",");
            }
            params.append(i);
        }
        params.append("]}");
        List keyDrivers = null;
        FastPatternService fastPatternService = FastPatternService.getService();
        try {
            keyDrivers = fastPatternService.run((DataAccessProvider)resultSet, params.toString());
        }
        catch (BadParametersException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_KEYDRIVER_BAD_PARAMETERS);
        }
        catch (InvalidDataException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_KEYDRIVER_DATA);
        }
        return keyDrivers;
    }

    private OrderedJSONObject getFastPatternJsonResponse(PredictDataAccessResultSet resultSet) {
        String locale = this.getProductLocale();
        JSONObject params = new JSONObject();
        try {
            params.put(VERSION, (Object)FastPatternService.VERSION);
            params.put(LOCALE, (Object)locale);
            params.put(TARGET, 0);
            JSONArray dataItemsArray = new JSONArray();
            for (int i = 1; i <= this.keyDriverSpec.getInputs().size(); ++i) {
                dataItemsArray.add((Object)i);
            }
            params.put(DATA_ITEMS, (Collection)dataItemsArray);
            JSONArray methodsArray = new JSONArray();
            List methods = this.keyDriverSpec.getMethods();
            if (methods.size() > 0) {
                for (MethodType method : methods) {
                    methodsArray.add((Object)method.value());
                }
            }
            params.put(METHODS, (Collection)methodsArray);
            if (resultSet.hasSampledData()) {
                params.put("sampledData", resultSet.hasSampledData());
            }
        }
        catch (JSONException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, "Error generating JSON request for keydrivers");
        }
        PredictService predictService = PredictService.getService();
        FastPatternResult fastPatternResult = null;
        try {
            fastPatternResult = predictService.runPatterns((DataAccessProvider)resultSet, params);
        }
        catch (BadParametersException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_KEYDRIVER_BAD_PARAMETERS);
        }
        catch (InvalidDataException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_KEYDRIVER_DATA);
        }
        return this.fastPatternResultToJsonResult(fastPatternResult);
    }

    OrderedJSONObject keyDriversToResult(List<KeyDriver> keyDrivers) {
        JSONArray results = new JSONArray();
        OrderedJSONObject result = new OrderedJSONObject();
        try {
            int keyDriversToReturn = keyDrivers.size();
            List filters = this.keyDriverSpec.getFilters();
            if (filters != null) {
                for (Filter filter : filters) {
                    Integer topCount = filter.getTopcount();
                    if (topCount == null || topCount >= keyDriversToReturn) continue;
                    keyDriversToReturn = topCount;
                }
            }
            for (int i = 0; i < keyDriversToReturn; ++i) {
                KeyDriver keyDriver = keyDrivers.get(i);
                OrderedJSONObject jsonKeyDriver = new OrderedJSONObject();
                jsonKeyDriver.put(ACCURACY, keyDriver.getAccuracy());
                jsonKeyDriver.put("id", (Object)keyDriver.getId());
                JSONObject fields = new JSONObject();
                JSONObject target = new JSONObject();
                String targetId = keyDriver.getTargetId();
                target.put("id", (Object)targetId);
                target.put(LABEL, (Object)this.getLabel(targetId));
                fields.put(TARGET, (Map)target);
                JSONArray inputs = new JSONArray();
                for (String fieldId : keyDriver.getFieldIds()) {
                    JSONObject input = new JSONObject();
                    input.put("id", (Object)fieldId);
                    input.put(LABEL, (Object)this.getLabel(fieldId));
                    inputs.add((Object)input);
                }
                fields.put(INPUTS, (Collection)inputs);
                jsonKeyDriver.put(FIELDS, (Map)fields);
                JSONArray visRecomendations = new JSONArray();
                for (VisRecommendation visRecomendation : keyDriver.getVis()) {
                    visRecomendations.add((Object)visRecomendation.toJSON());
                }
                jsonKeyDriver.put(VIS, (Collection)visRecomendations);
                results.add((Object)jsonKeyDriver);
            }
            result.put(VERSION, (Object)VERSION_1);
            JSONObject state = new JSONObject();
            state.put(STATE, (Object)SUCCESS);
            result.put(STATUS, (Map)state);
            result.put(RESULTS, (Collection)results);
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
        return result;
    }

    private OrderedJSONObject fastPatternResultToJsonResult(FastPatternResult fastPatternResult) {
        JSONArray results = new JSONArray();
        OrderedJSONObject result = new OrderedJSONObject();
        List keyDrivers = (List)fastPatternResult.getContent();
        try {
            result.put(VERSION, (Object)VERSION_1_1);
            OrderedJSONObject predictStatus = new OrderedJSONObject();
            StatusCode status = fastPatternResult.getStatus();
            predictStatus.put(STATE, (Object)status.name());
            predictStatus.put(ERRORS, (Collection)this.messagesToJSON(fastPatternResult.getErrorMessages()));
            predictStatus.put(WARNINGS, (Collection)this.messagesToJSON(fastPatternResult.getWarningMessages()));
            predictStatus.put(MESSAGES, (Collection)this.captionedMessagesToJSON(fastPatternResult.getMessages()));
            result.put(PREDICT_STATUS, (Map)predictStatus);
            int keyDriversToReturn = keyDrivers.size();
            List filters = this.keyDriverSpec.getFilters();
            if (filters != null) {
                for (Filter filter : filters) {
                    Integer topCount = filter.getTopcount();
                    if (topCount == null || topCount >= keyDriversToReturn) continue;
                    keyDriversToReturn = topCount;
                }
            }
            for (int i = 0; i < keyDriversToReturn; ++i) {
                KeyDriver keyDriver = (KeyDriver)keyDrivers.get(i);
                OrderedJSONObject jsonKeyDriver = new OrderedJSONObject();
                jsonKeyDriver.put(ACCURACY, keyDriver.getAccuracy());
                jsonKeyDriver.put(ACCURACY_LEVEL, keyDriver.getAccuracyLevel());
                jsonKeyDriver.put("id", (Object)keyDriver.getId());
                jsonKeyDriver.put(TYPE, (Object)keyDriver.getType().name());
                JSONObject fields = new JSONObject();
                JSONObject target = new JSONObject();
                String targetId = keyDriver.getTargetId();
                target.put("id", (Object)targetId);
                target.put(LABEL, (Object)this.getLabel(targetId));
                String[] targetCategories = keyDriver.getTargetCategories();
                if (targetCategories != null && targetCategories.length > 0) {
                    JSONArray targetCategoriesJson = new JSONArray();
                    for (String category : targetCategories) {
                        targetCategoriesJson.add((Object)category);
                    }
                    target.put(CATEGORIES, (Collection)targetCategoriesJson);
                }
                fields.put(TARGET, (Map)target);
                JSONArray inputs = new JSONArray();
                for (InputField inputField : keyDriver.getInputFields()) {
                    List categories;
                    JSONObject input = new JSONObject();
                    input.put("id", (Object)inputField.getId());
                    input.put(LABEL, (Object)inputField.getLabel());
                    Double importance = inputField.getImportance();
                    if (importance != null && !importance.equals(Double.NaN)) {
                        input.put(IMPORTANCE, (Object)importance);
                    }
                    if ((categories = inputField.getCategories()) != null && categories.size() > 0) {
                        JSONArray categoriesJson = new JSONArray();
                        for (String category : categories) {
                            categoriesJson.add((Object)category);
                        }
                        input.put(CATEGORIES, (Collection)categoriesJson);
                    }
                    inputs.add((Object)input);
                }
                fields.put(INPUTS, (Collection)inputs);
                jsonKeyDriver.put(FIELDS, (Map)fields);
                JSONArray visRecomendations = new JSONArray();
                for (VisRecommendation visRecomendation : keyDriver.getVis()) {
                    visRecomendations.add((Object)visRecomendation.toJSON());
                }
                jsonKeyDriver.put(VIS, (Collection)visRecomendations);
                if (keyDriver instanceof Tree) {
                    JSONObject structure = ((Tree)keyDriver).getStructure();
                    jsonKeyDriver.put(DETAILS, (Map)structure);
                }
                results.add((Object)jsonKeyDriver);
            }
            result.put(RESULTS, (Collection)results);
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
        return result;
    }

    @Override
    protected List<String> getInputIds() {
        ArrayList<String> inputIds = new ArrayList<String>();
        inputIds.add(this.keyDriverSpec.getTargetId());
        inputIds.addAll(this.keyDriverSpec.getInputs());
        return inputIds;
    }
}

