/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.predict;

import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XIterator;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.xqe.predict.PredictExecutor;
import com.ibm.bi.qs.xqe.predict.SampleTooSmallException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictDataAccessResultSet
implements DataAccessProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PredictDataAccessResultSet.class);
    private RSAPIDataset rsapiDataset;
    private IV5ResultSet v5ResultSet;
    private PredictExecutor predictExecutor;
    private PredictDataAccessMetadata metadata = new PredictDataAccessMetadata();
    private Map<String, CategoricalSet> categoricalMap = new HashMap<String, CategoricalSet>();
    private List<PredictRow> predictRows = new ArrayList<PredictRow>();
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    private int rowsRead = 0;
    private final boolean throwOnSmallSample;
    private int rowTraceCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PredictDataAccessResultSet(RSAPIDataset rsapiDataset, IV5ResultSet v5ResultSet, PredictExecutor predictExecutor, boolean throwOnSmallSample) {
        this.rsapiDataset = rsapiDataset;
        this.v5ResultSet = v5ResultSet;
        this.predictExecutor = predictExecutor;
        this.throwOnSmallSample = throwOnSmallSample;
        try {
            this.processV5ResultSet();
        }
        finally {
            v5ResultSet.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processV5ResultSet() {
        for (String input : this.predictExecutor.getInputIds()) {
            this.processColumn(input);
        }
        this.metadata.fieldCount = this.metadata.fieldInfoList.size();
        RSAPIEdge edge = this.rsapiDataset.getEdge(0);
        XIterator edgeIterator = this.v5ResultSet.getV5EdgeIterator(edge);
        int maxSampleRows = this.predictExecutor.getSampleRowCount() * 2;
        try {
            RowValue aRow = (RowValue)edgeIterator.next();
            while (aRow != null) {
                this.processRow(aRow);
                if (this.predictRows.size() > maxSampleRows) {
                    throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_SAMPLING_TOO_MUCH_DATA);
                }
                aRow = (RowValue)edgeIterator.next();
            }
            this.metadata.rowCount = this.predictRows.size();
            if (this.throwOnSmallSample && this.rsapiDataset.hasSampledData() && (double)this.metadata.rowCount * 1.1 < (double)this.predictExecutor.getSampleRowCount().intValue()) {
                throw new SampleTooSmallException(this.metadata.rowCount);
            }
        }
        finally {
            edgeIterator.release();
        }
        if (this.debugEnabled) {
            LOGGER.debug("    rowSize (bytes)=" + this.predictExecutor.getSampleRowSize());
            LOGGER.debug("    rowCount=" + this.metadata.rowCount);
            LOGGER.debug("    fieldCount=" + this.metadata.fieldCount);
            LOGGER.debug("    fieldInfo");
            for (int i = 0; i < this.metadata.fieldInfoList.size(); ++i) {
                FieldInfo fieldInfo = (FieldInfo)this.metadata.fieldInfoList.get(i);
                LOGGER.debug("      " + i + ": identifier=" + fieldInfo.identifier);
                LOGGER.debug("         categories=" + fieldInfo.categories);
            }
        }
    }

    private void processColumn(String columnName) {
        FieldInfo fieldInfo = new FieldInfo();
        this.metadata.fieldInfoList.add(fieldInfo);
        fieldInfo.categories = -1;
        fieldInfo.identifier = columnName;
        ColumnMetadata columnMetadata = this.predictExecutor.getColumnMetadata(columnName);
        fieldInfo.label = columnMetadata.getLabel();
        if (columnMetadata.getType() == ColumnMetadata.Type.ATTRIBUTE) {
            fieldInfo.type = FieldType.CATEGORICAL;
        } else {
            fieldInfo.type = FieldType.NUMERICAL;
        }
    }

    private void processRow(RowValue aRow) {
        if (this.debugEnabled) {
            ++this.rowsRead;
            LOGGER.debug("Processing row # " + this.rowsRead);
        }
        PredictRow predictRow = new PredictRow(this.metadata.fieldCount);
        this.predictRows.add(predictRow);
        for (int i = 0; i < aRow.getNumColumns(); ++i) {
            ContextValue contextValue = (ContextValue)aRow.getColumn(i);
            Value value = (Value)contextValue.getValue();
            if (value.isOK() && value instanceof TextValue) {
                ((TextValue)value).setCollator(null);
            }
            if (this.debugEnabled) {
                LOGGER.debug("  column=" + i + ", value=" + value.toString());
            }
            FieldInfo fieldInfo = (FieldInfo)this.metadata.fieldInfoList.get(i);
            ((PredictRow)predictRow).values[i] = Double.NaN;
            if (fieldInfo.type == FieldType.CATEGORICAL) {
                if (!value.isOK()) continue;
                int catIndex = this.getCategoricalIndex(fieldInfo.identifier, value);
                if (catIndex + 1 > fieldInfo.categories) {
                    fieldInfo.categories = catIndex + 1;
                }
                ((PredictRow)predictRow).values[i] = catIndex;
                continue;
            }
            if (value.isNumeric() && value.isOK()) {
                ((PredictRow)predictRow).values[i] = value.getDouble();
            }
            if (!this.debugEnabled) continue;
            LOGGER.debug("Metric value:" + predictRow.values[i]);
        }
    }

    private int getCategoricalIndex(String identifier, Value value) {
        CategoricalSet catSet = this.getCategoricalSet(identifier);
        catSet.addValue(value);
        return catSet.getValueIdx(value);
    }

    private CategoricalSet getCategoricalSet(String identifier) {
        CategoricalSet catSet = this.categoricalMap.get(identifier);
        if (catSet == null) {
            catSet = new CategoricalSet();
            this.categoricalMap.put(identifier, catSet);
        }
        return catSet;
    }

    public DataIterator getDataIterator() {
        return new PredictDataIterator();
    }

    public Decorator getDecorator() {
        return null;
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void release() {
        this.rsapiDataset = null;
        this.v5ResultSet = null;
        this.predictExecutor = null;
        this.metadata = null;
        this.categoricalMap = null;
        this.predictRows = null;
    }

    public boolean hasSampledData() {
        return this.rsapiDataset.hasSampledData();
    }

    private class CategoricalSet {
        Map<Value, Integer> valueMap = new HashMap<Value, Integer>();
        Value[] valueArray = null;

        private CategoricalSet() {
        }

        public void addValue(Value value) {
            if (!this.valueMap.containsKey(value)) {
                int index = this.valueMap.size();
                this.valueMap.put(value, index);
            }
        }

        public int getValueIdx(Value value) {
            Integer index = this.valueMap.get(value);
            if (index == null) {
                return -1;
            }
            return index;
        }

        public String getCategoricalStringValue(int valueIndex) {
            if (this.valueArray == null) {
                this.valueArray = new Value[this.valueMap.size()];
                for (Map.Entry<Value, Integer> entry : this.valueMap.entrySet()) {
                    Value value = entry.getKey();
                    Integer entryIndex = entry.getValue();
                    this.valueArray[entryIndex.intValue()] = value;
                }
            }
            if (valueIndex < 0 || valueIndex >= this.valueArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.valueArray[valueIndex].toString();
        }
    }

    private class PredictDataIterator
    implements DataIterator {
        private int rowIndex = 0;

        private PredictDataIterator() {
        }

        public boolean hasNext() {
            return this.rowIndex < PredictDataAccessResultSet.this.predictRows.size();
        }

        public DataRow next() {
            if (this.hasNext()) {
                PredictRow dataRow = (PredictRow)PredictDataAccessResultSet.this.predictRows.get(this.rowIndex);
                if (PredictDataAccessResultSet.this.rowTraceCount < 30 || this.rowIndex + 5 > PredictDataAccessResultSet.this.predictRows.size()) {
                    PredictDataAccessResultSet.this.rowTraceCount++;
                    StringBuilder rowTrace = new StringBuilder("Row " + this.rowIndex + ": values -> ");
                    for (int i = 0; i < dataRow.getColumnCount(); ++i) {
                        if (i > 0) {
                            rowTrace.append(", ");
                        }
                        rowTrace.append(dataRow.getValue(i));
                    }
                    LOGGER.debug(rowTrace.toString());
                }
                ++this.rowIndex;
                return dataRow;
            }
            throw new NoSuchElementException();
        }

        public void reset() {
            this.rowIndex = 0;
        }
    }

    private static class PredictRow
    implements DataRow {
        private double[] values;

        PredictRow(int columnCount) {
            this.values = new double[columnCount];
        }

        public double getValue(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.values.length) {
                throw new IllegalDataAccessRequest();
            }
            return this.values[columnIndex];
        }

        public double getStatistic(String statisticName, int columnIndex) {
            throw new IllegalDataAccessRequest();
        }

        public int getColumnCount() {
            return this.values.length;
        }
    }

    private static class FieldInfo {
        private int categories;
        private String identifier;
        private String label;
        private FieldType type;

        private FieldInfo() {
        }
    }

    private class PredictDataAccessMetadata
    implements MetaData {
        private int fieldCount;
        private List<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        private int rowCount = 0;

        private PredictDataAccessMetadata() {
        }

        public int fieldCount() {
            return this.fieldInfoList.size();
        }

        public int getFieldCategories(int columnIndex) {
            this.validateColumnIndex(columnIndex);
            return this.fieldInfoList.get(columnIndex).categories;
        }

        public String getFieldIdentifier(int columnIndex) {
            this.validateColumnIndex(columnIndex);
            return this.fieldInfoList.get(columnIndex).identifier;
        }

        public FieldType getFieldType(int columnIndex) {
            this.validateColumnIndex(columnIndex);
            return this.fieldInfoList.get(columnIndex).type;
        }

        private void validateColumnIndex(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.fieldInfoList.size()) {
                throw new IllegalDataAccessRequest();
            }
        }

        public StatisticStatus getStatisticStatus(String statisticName, int columnIndex) {
            return StatisticStatus.UNAVAILABLE;
        }

        public int rowCount() {
            return this.rowCount;
        }

        public String getFieldDisplayLabel(int columnIndex) {
            this.validateColumnIndex(columnIndex);
            return this.fieldInfoList.get(columnIndex).label;
        }

        public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
            CategoricalSet catSet = PredictDataAccessResultSet.this.getCategoricalSet(this.getFieldIdentifier(columnIndex));
            return catSet.getCategoricalStringValue(categoryIndex);
        }
    }
}

