/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.predict;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5EdgeSuppression;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.ibm.bi.predict.fastpattern.result.CaptionedMessage;
import com.ibm.bi.predict.fastpattern.result.MessageEntry;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.data.common.generated.DataFilter;
import com.ibm.bi.qs.model.api.data.common.generated.Filter;
import com.ibm.bi.qs.model.api.data.common.generated.FilterExpression;
import com.ibm.bi.qs.model.api.data.common.generated.FilterOperator;
import com.ibm.bi.qs.model.api.data.predict.generated.Sampling;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.predict.PredictDataAccessResultSet;
import com.ibm.bi.qs.xqe.predict.SampleTooSmallException;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import com.ibm.bi.qs.xqe.v5.FilterGenerator;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public abstract class PredictExecutor
extends BaseExecutor {
    protected static final String ID = "id";
    protected static final String SAMPLED_DATA = "sampledData";
    private static final String CAPTION = "caption";
    private static final String COLUMNS = "columns";
    private static final String ENTRIES = "entries";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String ZERO = "0";
    private static final Integer DEFAULT_SAMPLING_ROW_COUNT = 11000;
    private static final Integer DEFAULT_SAMPLING_SEED = 12347;
    private Map<String, ColumnMetadata> columns = new HashMap<String, ColumnMetadata>();
    private List<Filter> dataFilters;
    private ParameterAccessCoordinator requestPAC = null;
    private int rowSize = -1;

    public PredictExecutor(DataSet dataset, String requestType, ServletRequestContext servletRequestContext) {
        super(servletRequestContext, requestType, dataset);
        List columnList = dataset.getColumnMetadata();
        for (ColumnMetadata col : columnList) {
            this.columns.put(col.getColumnId(), col);
        }
    }

    public void setupDataFilters(List<Filter> queryDataFilters, String targetId) {
        if (queryDataFilters == null) {
            queryDataFilters = new ArrayList<Filter>();
        }
        Filter filter = new Filter();
        filter.setType(Filter.Type.POST);
        DataFilter dataFilter = new DataFilter();
        dataFilter.setOperator(FilterOperator.ISNOTNULL);
        dataFilter.setItemId(targetId);
        filter.setExpression((FilterExpression)dataFilter);
        queryDataFilters.add(filter);
        this.dataFilters = queryDataFilters;
    }

    public void setupDataFilters(List<Filter> queryDataFilters) {
        this.dataFilters = queryDataFilters;
    }

    protected PredictDataAccessResultSet executeSamplingQuery() {
        try {
            return this.executeSamplingQueryImpl(this.timeLimit, true);
        }
        catch (SampleTooSmallException e) {
            this.adjustBasedOnSampleTooSmall(e.getActualRows());
            this.planExecution();
            return this.executeSamplingQueryImpl(this.timeLimit, false);
        }
    }

    protected PredictDataAccessResultSet executeSamplingQueryImpl(Integer timeLimit, boolean throwOnSmallSample) {
        assert (null != this.plannedQuery);
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        IV5ResultSet[] v5ResultSets = null;
        try {
            ParameterAccessCoordinator reqPAC = reqEnv.getRequestPAC();
            if (reqPAC == null) {
                reqEnv.setRequestPAC(this.requestPAC);
            }
            this.bindParameterValues(reqEnv);
            this.createDataSourceConnections(reqEnv);
            v5ResultSets = this.executeV5Request(reqEnv, this.plannedQuery);
            RSAPIDataset rsDataset = (RSAPIDataset)this.plannedQuery.getFirstDescendantOfTypeOrdered(401005, false);
            PredictDataAccessResultSet predictDataAccessResultSet = new PredictDataAccessResultSet(rsDataset, v5ResultSets[0], this, throwOnSmallSample);
            return predictDataAccessResultSet;
        }
        catch (SampleTooSmallException e) {
            throw e;
        }
        finally {
            if (v5ResultSets != null) {
                v5ResultSets[0].release();
            }
        }
    }

    protected abstract List<String> getInputIds();

    protected JSONArray messagesToJSON(List<Message> messages) throws JSONException {
        JSONArray messagesJson = new JSONArray();
        for (Message message : messages) {
            OrderedJSONObject messageJson = new OrderedJSONObject();
            messageJson.put(ID, (Object)message.getMessageCode().name());
            messageJson.put(CAPTION, (Object)message.getCaption());
            JSONArray columns = new JSONArray();
            for (String columnId : message.getColumnIds()) {
                columns.add((Object)columnId);
            }
            messageJson.put(COLUMNS, (Collection)columns);
            messagesJson.add((Object)messageJson);
        }
        return messagesJson;
    }

    JSONArray captionedMessagesToJSON(List<CaptionedMessage> messages) throws JSONException {
        JSONArray messagesJson = new JSONArray();
        for (CaptionedMessage message : messages) {
            OrderedJSONObject messageJson = new OrderedJSONObject();
            messageJson.put(ID, (Object)message.getId());
            messageJson.put(CAPTION, (Object)message.getCaption());
            JSONArray entriesJson = new JSONArray();
            messageJson.put(ENTRIES, (Collection)entriesJson);
            for (MessageEntry entry : message.getEntries()) {
                JSONObject anEntryJson = new JSONObject();
                anEntryJson.put(SHORT, (Object)entry.getShortMsg());
                anEntryJson.put(LONG, (Object)entry.getLongMsg());
                entriesJson.add((Object)anEntryJson);
            }
            messagesJson.add((Object)messageJson);
        }
        return messagesJson;
    }

    protected String getLabel(String id) {
        ColumnMetadata metadata = this.getColumnMetadata(id);
        if (metadata == null) {
            return null;
        }
        return metadata.getLabel();
    }

    ColumnMetadata getOrAddColumnMetadata(String columnName) {
        ColumnMetadata metadata = this.columns.get(columnName);
        if (metadata == null) {
            metadata = new ColumnMetadata();
            this.columns.put(columnName, metadata);
        }
        return metadata;
    }

    ColumnMetadata getColumnMetadata(String columnName) {
        ColumnMetadata metadata = this.columns.get(columnName);
        if (metadata == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.MISSING_QUERY_COLUMN, columnName, this.dataset.getName());
        }
        return metadata;
    }

    @Override
    protected V5QuerySet generateV5QuerySet(PlanningEnvironment planEnv, String sampleMethod) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        V5QuerySet v5QuerySetNode = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySetNode.addToIndex();
        Boolean isModule = Boolean.TRUE;
        if (this.dataset.getType().equals((Object)DataSetType.PACKAGE)) {
            isModule = Boolean.FALSE;
        }
        V5Query primaryQuery = TransformationUtils.buildV5QueryNode(nodeFactory, null, null, isModule, null);
        v5QuerySetNode.addChild((IXQEQueryNode)primaryQuery);
        V5Selection v5Selection = (V5Selection)primaryQuery.getFirstChildByType(101009);
        String nullEdgeSuppression = "false";
        v5Selection.setAutoSummary(false);
        V5QueryResultDefinition v5rsdef = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        v5rsdef.setStringPropertyValue("name", (String)primaryQuery.getPropertyValue("name") + ".0");
        v5rsdef.setStringPropertyValue("refQuery", (String)primaryQuery.getPropertyValue("name"));
        if (sampleMethod != null) {
            this.setupSampling(sampleMethod, primaryQuery, v5QuerySetNode, v5rsdef);
        }
        v5QuerySetNode.addChild((IXQEQueryNode)v5rsdef);
        V5ValueSet v5ValueSet = null;
        V5Edge v5Edge = (V5Edge)nodeFactory.createNode(101049, (IXQEQueryNode)v5rsdef);
        V5EdgeSuppression v5EdgeSuppression = (V5EdgeSuppression)nodeFactory.createNode(101066);
        v5EdgeSuppression.setBooleanPropertyValue("nulls", nullEdgeSuppression);
        v5EdgeSuppression.setBooleanPropertyValue("zero", "false");
        v5EdgeSuppression.setBooleanPropertyValue("divByZero", "false");
        v5EdgeSuppression.setBooleanPropertyValue("overflow", "false");
        v5Edge.addChild((IXQEQueryNode)v5EdgeSuppression);
        v5Edge.setIntegerPropertyValue("edgeID", ZERO);
        v5Edge.setStringPropertyValue("name", ZERO);
        v5rsdef.addChild((IXQEQueryNode)v5Edge);
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)nodeFactory.createNode(101050);
        v5Edge.addChild((IXQEQueryNode)v5EdgeGroup);
        v5ValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        v5ValueSet.setNameProperty("VS");
        v5EdgeGroup.addChild((IXQEQueryNode)v5ValueSet);
        V5GroupBody v5GroupBody = (V5GroupBody)nodeFactory.createNode(101051);
        v5ValueSet.addChild((IXQEQueryNode)v5GroupBody);
        int dataItemCount = 1;
        for (String inputId : this.getInputIds()) {
            this.generateColumnV5DataItem(String.valueOf(dataItemCount), inputId, primaryQuery, v5GroupBody, nodeFactory);
            ++dataItemCount;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        String path = this.dataset.getModuleConnectionPath();
        v5QuerySetNode.setStringPropertyValue("modelPath", path);
        if (!this.dataset.getType().equals((Object)DataSetType.PACKAGE)) {
            v5QuerySetNode.setStringPropertyValue("modelType", "module");
        }
        v5QuerySetNode.setPropertyValue("expressionLocale", (Object)LocaleConverter.localeToStr((Locale)reqEnv.getExpressionLocale()));
        if (this.dataFilters != null && !this.dataFilters.isEmpty()) {
            Locale expressionLocale = ((RequestEnvironment)planEnv.getRequestEnvironment()).getExpressionLocale();
            for (Filter currFilter : this.dataFilters) {
                V5DetailFilter currDetailFilter = FilterGenerator.generateFilter(nodeFactory, primaryQuery, this.dataset, new ArrayList<DataItem>(), currFilter, expressionLocale);
                primaryQuery.addChild((IXQEQueryNode)currDetailFilter);
            }
            primaryQuery.setBooleanPropertyValue("containsQueryHint", Boolean.TRUE.toString());
            primaryQuery.setBooleanPropertyValue(V5Query.QueryHint.IGNORE_FILTERS_NOT_APPLICABLE.getPropertyName(), Boolean.TRUE.toString());
        }
        return v5QuerySetNode;
    }

    private void generateColumnV5DataItem(String id, String dataItemId, V5Query v5Query, V5GroupBody v5GroupBody, XQENodeFactory nodeFactory) {
        ColumnMetadata column = this.getColumnMetadata(dataItemId);
        String dataItemName = id;
        V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(column, nodeFactory);
        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, null, (IXQEQueryNode)identifier, nodeFactory);
        this.buildV5DataItemRef(v5GroupBody, nodeFactory, dataItemName);
    }

    private void buildV5DataItemRef(V5GroupBody v5GroupBody, XQENodeFactory nodeFactory, String dataItemName) {
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
        v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
    }

    @Override
    public void planExecution() {
        this.plannedQuery = this.planQuery(true, true);
        XSql xsql = (XSql)this.plannedQuery.getFirstDescendantOfTypeOrdered(501013, false);
        if (xsql != null) {
            RowsetInfo rowsetInfo = (RowsetInfo)xsql.getCalculatedRowsetInfo();
            this.rowSize = rowsetInfo.getRowLengthNoDefault();
        }
    }

    int getSampleRowSize() {
        return this.rowSize;
    }

    protected void setupSampling(Sampling sampling) {
        Integer rowCount = DEFAULT_SAMPLING_ROW_COUNT;
        Integer seed = DEFAULT_SAMPLING_SEED;
        Integer resultLimit = null;
        if (sampling != null) {
            if (sampling.getRowCount() != null) {
                rowCount = sampling.getRowCount();
            }
            if (sampling.getSeed() != null) {
                seed = sampling.getSeed();
            }
            if (sampling.getResultLimit() != null) {
                resultLimit = sampling.getResultLimit();
            }
        }
        this.setSamplingSettings(rowCount, null, seed, resultLimit, true);
    }

    @Override
    protected Date getLastModifiedFromQueryPlan() {
        if (this.plannedQuery != null && this.plannedQuery instanceof PlannedV5QuerySet) {
            return ((PlannedV5QuerySet)this.plannedQuery).getLastModified();
        }
        return null;
    }

    @Override
    public String getExecutionPlan() {
        return null;
    }

    @Override
    public DataSet getDataSet() {
        return this.dataset;
    }
}

