/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.predict;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.result.ExploreResult;
import com.ibm.bi.predict.explore.result.RelationshipResult;
import com.ibm.bi.predict.explore.result.RelationshipStrength;
import com.ibm.bi.predict.fastpattern.exceptions.InvalidDataException;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.service.PredictService;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.ExploreSpec;
import com.ibm.bi.qs.model.api.data.predict.generated.Filter;
import com.ibm.bi.qs.model.api.data.predict.generated.Group;
import com.ibm.bi.qs.model.api.data.predict.generated.Grouping;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.predict.PredictDataAccessResultSet;
import com.ibm.bi.qs.xqe.predict.PredictExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class PredictExploreExecutor
extends PredictExecutor {
    private static final String A = "a";
    private static final String B = "b";
    private static final String CANDIDATES = "candidates";
    private static final String ERRORS = "errors";
    private static final String GROUPINGS = "groupings";
    private static final String GROUPS = "groups";
    private static final String LOCALE = "locale";
    private static final String MEMBERS = "members";
    private static final String PREDICT_STATUS = "predictStatus";
    private static final String RELATIONSHIPS = "relationships";
    private static final String REQUESTED_ITEM_COUNT = "requestedItemCount";
    private static final String RESULTS = "results";
    private static final String STATE = "state";
    private static final String STRENGTH = "strength";
    private static final String TARGET = "target";
    private static final String VERSION = "version";
    private static final String VERSION_1 = "1";
    private static final String VERSION_2 = "2";
    private static final String WARNINGS = "warnings";
    public static final String REQUEST_TYPE = PredictExploreExecutor.class.getSimpleName();
    private final ExploreSpec exploreSpec;
    private final PredictService predictService;

    public PredictExploreExecutor(ExploreSpec exploreSpec, DataSet dataset, ServletRequestContext servletRequestContext) {
        super(dataset, REQUEST_TYPE, servletRequestContext);
        this.exploreSpec = exploreSpec;
        this.setRequestAndGlobalParameters(exploreSpec);
        this.setConnections(exploreSpec.getConnections());
        this.setupSampling(exploreSpec.getSampling());
        this.setupDataFilters(exploreSpec.getDataFilters());
        this.timeLimit = exploreSpec.getTimeLimit();
        this.predictService = PredictService.getService();
    }

    private void setRequestAndGlobalParameters(ExploreSpec exploreSpec) {
        this.setParameterValues(exploreSpec.getParameterValues());
        this.setGlobalParameterValues(exploreSpec.getGlobalParameterValues());
        this.setParameterValuesV2(exploreSpec.getParameterValuesV2());
        this.setGlobalParameterValuesV2(exploreSpec.getGlobalParameterValuesV2());
    }

    public OrderedJSONObject executeImpl() {
        String version = this.exploreSpec.getVersion();
        if (!VERSION_1.equals(version) && !VERSION_2.equals(version)) {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_PREDICT_EXPLORE_VERSION, version);
        }
        OrderedJSONObject jsonResponse = VERSION_2.equals(version) || this.exploreSpec.getRequestedItemCount() != null ? this.exploreToResultV2(this.getExploreResult(this.plannedQuery)) : this.exploreToResult(this.getExploreResult(this.plannedQuery));
        return jsonResponse;
    }

    private ExploreResult getExploreResult(IXQEQueryNode plannedSamplingQuery) {
        PredictDataAccessResultSet resultSet = this.executeSamplingQuery();
        JSONObject params = new JSONObject();
        try {
            params.put(VERSION, (Object)"1.0.2");
            JSONArray candidatesArray = new JSONArray();
            for (String candidate : this.exploreSpec.getCandidates()) {
                candidatesArray.add((Object)candidate);
            }
            params.put(CANDIDATES, (Collection)candidatesArray);
            params.put(TARGET, (Object)this.exploreSpec.getTargetId());
            params.put(LOCALE, (Object)this.getProductLocale());
            if (this.exploreSpec.getRequestedItemCount() != null) {
                params.put(REQUESTED_ITEM_COUNT, (Object)this.exploreSpec.getRequestedItemCount());
            }
            JSONArray groupingsArray = new JSONArray();
            for (Grouping grouping : this.exploreSpec.getGroupings()) {
                JSONObject groupingJson = new JSONObject();
                groupingJson.put("id", (Object)grouping.getId());
                JSONArray groupsArray = new JSONArray();
                for (Group group : grouping.getGroups()) {
                    JSONObject groupJson = new JSONObject();
                    groupJson.put("id", (Object)group.getId());
                    JSONArray membersArray = new JSONArray();
                    for (String member : group.getMembers()) {
                        membersArray.add((Object)member);
                    }
                    groupJson.put(MEMBERS, (Collection)membersArray);
                    groupsArray.add((Object)groupJson);
                }
                groupingJson.put(GROUPS, (Collection)groupsArray);
                groupingsArray.put((Map)groupingJson);
            }
            params.put(GROUPINGS, (Collection)groupingsArray);
            if (resultSet.hasSampledData()) {
                params.put("sampledData", resultSet.hasSampledData());
            }
        }
        catch (JSONException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, "Error generating JSON request for predict explore");
        }
        ExploreResult exploreResult = null;
        try {
            exploreResult = this.predictService.runExplorations((DataAccessProvider)resultSet, params);
        }
        catch (BadParametersException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_PREDICT_EXPLORE_BAD_PARAMETERS);
        }
        catch (InvalidDataException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.REST_ERROR_PREDICT_EXPLORE_DATA);
        }
        return exploreResult;
    }

    OrderedJSONObject exploreToResult(ExploreResult exploreResult) {
        JSONArray results = new JSONArray();
        OrderedJSONObject result = new OrderedJSONObject();
        List relationshipResults = (List)exploreResult.getContent();
        try {
            result.put(VERSION, (Object)VERSION_1);
            OrderedJSONObject predictStatus = new OrderedJSONObject();
            StatusCode status = exploreResult.getStatus();
            predictStatus.put(STATE, (Object)status.name());
            predictStatus.put(ERRORS, (Collection)this.messagesToJSON(exploreResult.getErrorMessages()));
            predictStatus.put(WARNINGS, (Collection)this.messagesToJSON(exploreResult.getWarningMessages()));
            result.put(PREDICT_STATUS, (Map)predictStatus);
            int relationshipResultsToReturn = relationshipResults.size();
            List filters = this.exploreSpec.getFilters();
            if (filters != null) {
                for (Filter filter : filters) {
                    Integer topCount = filter.getTopcount();
                    if (topCount == null || topCount >= relationshipResultsToReturn) continue;
                    relationshipResultsToReturn = topCount;
                }
            }
            for (int i = 0; i < relationshipResultsToReturn; ++i) {
                RelationshipResult relationshipResult = (RelationshipResult)relationshipResults.get(i);
                OrderedJSONObject jsonRelationshipResult = new OrderedJSONObject();
                jsonRelationshipResult.put("id", (Object)relationshipResult.getId());
                JSONArray relationshipsArray = new JSONArray();
                for (RelationshipStrength relationshipStrength : relationshipResult.getRelationships()) {
                    OrderedJSONObject relationship = new OrderedJSONObject();
                    relationship.put(STRENGTH, relationshipStrength.getStrength());
                    relationship.put(A, (Object)relationshipStrength.getA());
                    relationship.put(B, (Object)relationshipStrength.getB());
                    relationshipsArray.add((Object)relationship);
                }
                jsonRelationshipResult.put(RELATIONSHIPS, (Collection)relationshipsArray);
                results.add((Object)jsonRelationshipResult);
            }
            result.put(RESULTS, (Collection)results);
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
        return result;
    }

    OrderedJSONObject exploreToResultV2(ExploreResult exploreResult) {
        try {
            OrderedJSONObject result = new OrderedJSONObject((Map)exploreResult.getNodesDataset());
            result.put(VERSION, (Object)VERSION_2);
            return result;
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
    }

    @Override
    protected List<String> getInputIds() {
        HashSet<String> inputIds = new HashSet<String>();
        inputIds.add(this.exploreSpec.getTargetId());
        inputIds.addAll(this.exploreSpec.getCandidates());
        return new ArrayList<String>(inputIds);
    }
}

