/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.request;

import com.ibm.bi.qs.xqe.request.RequestManager;
import com.ibm.bi.qs.xqe.request.RequestStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class LoadMonitor {
    private final Duration updatePeriod;
    private int activeRequestCount = 0;
    private Duration activeRequestElapsedTime = Duration.ZERO;
    private double requestLoad = 0.0;
    private Instant lastUpdate = Instant.now();
    private final RequestManager requestManager;

    public LoadMonitor(Duration theUpdatePeriod, RequestManager theRequestManager) {
        this.updatePeriod = theUpdatePeriod;
        this.requestManager = theRequestManager;
    }

    public void update() {
        Duration timeSinceLastUpdate = Duration.between(this.lastUpdate, Instant.now());
        if (timeSinceLastUpdate.compareTo(this.updatePeriod) < 0) {
            return;
        }
        List<RequestStatus> activeRequests = this.requestManager.getActiveRequests();
        this.activeRequestCount = 0;
        this.activeRequestElapsedTime = Duration.ZERO;
        this.requestLoad = 0.0;
        for (RequestStatus requestStatus : activeRequests) {
            if (!requestStatus.isRunning()) continue;
            ++this.activeRequestCount;
            Duration elapsedTime = requestStatus.elapsedTime();
            this.activeRequestElapsedTime = this.activeRequestElapsedTime.plus(elapsedTime);
            this.requestLoad += (double)elapsedTime.toMillis() / 1000.0;
        }
        this.lastUpdate = Instant.now();
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    public Duration getActiveRequestElapsedTime() {
        return this.activeRequestElapsedTime;
    }

    public double getRequestLoad() {
        return this.requestLoad;
    }
}

