/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.request;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.ibm.bi.qs.xqe.request.CancellationReason;
import com.ibm.bi.qs.xqe.request.RequestStatus;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestManager.class);
    private final ConcurrentMap<String, RequestStatus> activeRequests = new ConcurrentHashMap<String, RequestStatus>();
    private final XQEServiceImpl xqeServiceImpl;

    public RequestManager(XQEServiceImpl xqeServiceImpl) {
        this.xqeServiceImpl = xqeServiceImpl;
        LOGGER.info("RequestManager initialized");
    }

    public List<RequestStatus> getActiveRequests() {
        return new ArrayList<RequestStatus>(this.activeRequests.values());
    }

    public RequestStatus createRequest(String requestType, RequestEnvironment requestEnvironment) {
        if (StringUtils.isEmpty((CharSequence)requestEnvironment.getRequestID())) {
            requestEnvironment.setRequestID(UUID.randomUUID().toString());
        }
        return new RequestStatus(requestType, requestEnvironment);
    }

    public void startRequest(RequestStatus request, int timeoutSeconds) {
        if (request.start()) {
            LOGGER.info("Starting request [id:{}, type:{} timeout:{}], activeRequests:{}", new Object[]{request.getRequestId(), request.getRequestType(), timeoutSeconds, this.activeRequests.size()});
            this.activeRequests.putIfAbsent(request.getRequestId(), request);
            if (timeoutSeconds > 0) {
                request.setTimeoutFuture(this.xqeServiceImpl.getScheduler().schedule(() -> this.timeoutRequest(request), (long)timeoutSeconds, TimeUnit.SECONDS));
            }
        } else {
            throw new IllegalStateException("Request could not be started");
        }
    }

    private boolean completeRequest(RequestStatus request) {
        if (request.complete()) {
            LOGGER.info("Completed request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis()});
            this.activeRequests.remove(request.getRequestId(), request);
            return true;
        }
        return false;
    }

    private boolean failRequest(RequestStatus request, Throwable reason) {
        if (request.fail(reason)) {
            LOGGER.info("Failed request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis(), reason});
            this.activeRequests.remove(request.getRequestId(), request);
            return true;
        }
        return false;
    }

    private boolean timeoutRequest(RequestStatus request) {
        if (request.timeout()) {
            LOGGER.info("Exceeded timeout for request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis()});
            this.activeRequests.remove(request.getRequestId(), request);
            return true;
        }
        return false;
    }

    public boolean cancelByRequestId(String requestId) {
        RequestStatus request = (RequestStatus)this.activeRequests.remove(requestId);
        if (null == request) {
            return false;
        }
        if (request.cancel(CancellationReason.CLIENT_REQUESTED)) {
            LOGGER.info("Canceled request [id:{}, type:{}, elapsedMs:{}", new Object[]{requestId, request.getRequestType(), request.elapsedTime().toMillis()});
            return true;
        }
        return false;
    }

    public void cancelAllRequests() {
        LOGGER.info("System is canceling all active requests");
        for (RequestStatus request : this.getActiveRequests()) {
            this.activeRequests.remove(request.getRequestId());
            if (!request.cancel(CancellationReason.SERVER_STOPPING)) continue;
            LOGGER.info("System has canceled request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis()});
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
    }

    public void finishRequest(String requestId, Throwable error) {
        RequestStatus request = (RequestStatus)this.activeRequests.get(requestId);
        if (request == null) {
            return;
        }
        if (null != error ? this.failRequest(request, error) : this.completeRequest(request)) {
            return;
        }
        if (request.hasCanceled()) {
            LOGGER.info("Acknowledging cancellation of request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis()});
        } else if (request.hasTimedOut()) {
            LOGGER.info("Acknowledging time out of request [id:{}, type:{}, elapsedMs:{}]", new Object[]{request.getRequestId(), request.getRequestType(), request.elapsedTime().toMillis()});
        } else {
            throw new IllegalStateException("Request: " + request.getRequestId() + " An unknown error occured");
        }
    }

    public RequestStatus getRequestStatusByRequestId(String requestId) {
        return (RequestStatus)this.activeRequests.get(requestId);
    }
}

