/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.request;

import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.ibm.bi.qs.xqe.request.CancellationException;
import com.ibm.bi.qs.xqe.request.CancellationReason;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RequestStatus {
    private final String requestType;
    private final RequestEnvironment requestEnvironment;
    private final AtomicReference<State> state;
    private volatile ScheduledFuture<?> timeoutFuture;
    private volatile Instant startTime;
    private volatile Instant stopTime;
    private volatile Throwable error;
    private volatile CancellationReason cancelReason;

    public RequestStatus(String theRequestType, RequestEnvironment theRequestEnvironment) {
        if (null == theRequestType) {
            throw new IllegalArgumentException("requestType was null");
        }
        if (null == theRequestEnvironment) {
            throw new IllegalArgumentException("theRequestEnvironment was null");
        }
        this.requestType = theRequestType;
        this.requestEnvironment = theRequestEnvironment;
        this.state = new AtomicReference<State>(State.PENDING);
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getRequestId() {
        return this.requestEnvironment.getRequestID();
    }

    public State getState() {
        return this.state.get();
    }

    public boolean isRunning() {
        return State.RUNNING == this.getState();
    }

    public boolean hasCompleted() {
        return State.COMPLETED == this.getState();
    }

    public boolean hasCanceled() {
        return State.CANCELED == this.getState();
    }

    public boolean hasTimedOut() {
        return State.TIMED_OUT == this.getState();
    }

    public boolean hasFailed() {
        return State.FAILED == this.getState();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getStopTime() {
        return this.stopTime;
    }

    public Duration elapsedTime() {
        if (null == this.startTime) {
            return Duration.ZERO;
        }
        if (null == this.stopTime) {
            return Duration.between(this.startTime, Instant.now());
        }
        return Duration.between(this.startTime, this.stopTime);
    }

    public Throwable getError() {
        return this.error;
    }

    public void checkCancellation() throws CancellationException {
        if (this.hasCanceled()) {
            throw new CancellationException(this.requestEnvironment.getRequestID(), this.cancelReason);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("requestType", (Object)this.requestType).append("requestId", (Object)this.requestEnvironment.getRequestID()).append("state", (Object)this.state.get()).append("startTime", (Object)this.startTime).append("stopTime", (Object)this.stopTime).append("error", (Object)this.error).append("cancelReason", (Object)this.cancelReason).build();
    }

    boolean start() {
        if (this.state.compareAndSet(State.PENDING, State.RUNNING)) {
            this.startTime = Instant.now();
            this.registerInXQE();
            return true;
        }
        return false;
    }

    void setTimeoutFuture(ScheduledFuture<?> theFuture) {
        this.timeoutFuture = theFuture;
    }

    private void cancelTimeoutFuture() {
        ScheduledFuture<?> future = this.timeoutFuture;
        if (null != future) {
            future.cancel(false);
            this.timeoutFuture = null;
        }
    }

    boolean complete() {
        if (this.state.compareAndSet(State.RUNNING, State.COMPLETED)) {
            this.stopTime = Instant.now();
            this.cancelTimeoutFuture();
            return true;
        }
        return false;
    }

    boolean fail(Throwable reason) {
        if (this.state.compareAndSet(State.RUNNING, State.FAILED)) {
            this.stopTime = Instant.now();
            this.error = reason;
            this.cancelTimeoutFuture();
            this.cancelInXQE();
            return true;
        }
        return false;
    }

    boolean cancel(CancellationReason reason) {
        if (this.state.compareAndSet(State.RUNNING, State.CANCELED)) {
            this.cancelReason = reason;
            this.stopTime = Instant.now();
            this.cancelTimeoutFuture();
            this.cancelInXQE();
            return true;
        }
        return false;
    }

    boolean timeout() {
        if (this.state.compareAndSet(State.RUNNING, State.TIMED_OUT)) {
            this.stopTime = Instant.now();
            this.timeoutFuture = null;
            this.cancelInXQE();
            return true;
        }
        return false;
    }

    private void registerInXQE() {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.requestEnvironment.getExecutionEnvironment();
        CancelableRequestRegistry cancelableRegistry = executionEnvironment.getCancelableRequestRegistry();
        cancelableRegistry.registerCancelable(this.requestEnvironment.getRequestID(), (ICancelable)executionEnvironment.getCancelManager());
    }

    private void cancelInXQE() {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.requestEnvironment.getExecutionEnvironment();
        CancelableRequestRegistry cancelableRegistry = executionEnvironment.getCancelableRequestRegistry();
        cancelableRegistry.cancel(this.requestEnvironment.getRequestID());
    }

    public static enum State {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED,
        CANCELED,
        TIMED_OUT;

    }
}

