/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.request;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.xqe.request.CancellationException;
import com.ibm.bi.qs.xqe.request.CancellationReason;
import com.ibm.bi.qs.xqe.request.PermitPoolPolicy;
import com.ibm.bi.qs.xqe.request.RequestStatus;
import com.ibm.bi.qs.xqe.request.WorkloadPolicy;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import com.ibm.bi.qs.xqe.util.SafeRunnable;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadManager {
    static final Integer DEFAULT_SUPERVISE_INTERVAL_MS = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkloadManager.class);
    private final XQEServiceImpl xqeServiceImpl;
    private final int superviseIntervalMs;
    private final WorkloadPolicy policy;
    private final Map<String, PermitPool> name2Pool = new HashMap<String, PermitPool>();
    private final Map<String, PermitPool> type2PermitPool = new HashMap<String, PermitPool>();
    private ScheduledFuture<?> superviseFuture;

    public WorkloadManager(XQEServiceImpl xqeServiceImpl) {
        this.xqeServiceImpl = xqeServiceImpl;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.superviseIntervalMs = configuration.getIntegerProperty("queryExecution.RESTWorkloadManagement.superviseIntervalMs[@value]", DEFAULT_SUPERVISE_INTERVAL_MS);
        this.policy = new WorkloadPolicy(this.superviseIntervalMs, xqeServiceImpl);
        this.setupPermitPool();
    }

    private void setupPermitPool() {
        for (PermitPoolPolicy poolPolicy : this.policy.getPermitPoolPolicies()) {
            PermitPool pool = new PermitPool(poolPolicy);
            if (null != this.name2Pool.putIfAbsent(poolPolicy.getName(), pool)) {
                throw new IllegalArgumentException("More than one PermitPoolPolicy was defined with the same name: " + poolPolicy.getName());
            }
            for (String type : poolPolicy.getRequestTypes()) {
                if (null == this.type2PermitPool.putIfAbsent(type, pool)) continue;
                throw new IllegalArgumentException("More than one PermitPoolPolicy was associated with RequestType: " + type);
            }
        }
    }

    public WorkloadManager(XQEServiceImpl xqeServiceImpl, WorkloadPolicy policy) {
        this.xqeServiceImpl = xqeServiceImpl;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.superviseIntervalMs = configuration.getIntegerProperty("queryExecution.RESTWorkloadManagement.superviseIntervalMs[@value]", DEFAULT_SUPERVISE_INTERVAL_MS);
        this.policy = policy;
        this.setupPermitPool();
    }

    public synchronized void start() {
        this.superviseFuture = this.xqeServiceImpl.getScheduler().scheduleWithFixedDelay(SafeRunnable.wrapWithHandler(this::supervise, t -> LOGGER.error("An unexpected error occured while supervising workloads", t)), this.superviseIntervalMs, this.superviseIntervalMs, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        this.superviseFuture.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeRequest(BaseExecutor executor, RequestStatus requestStatus) throws Exception {
        String type = requestStatus.getRequestType();
        PermitPool pool = this.getPermitPoolByType(type);
        if (null != pool) {
            if (this.policy.isUnderPressure()) {
                throw new QueryServiceException((Throwable)new CancellationException(requestStatus.getRequestId(), CancellationReason.WORKLOAD_MANAGEMENT), 503, QueryServiceMessageKeys.SERVICE_UNAVAILABLE);
            }
            this.acquirePermit(pool, requestStatus);
        }
        try {
            Object object = executor.executeImpl();
            return object;
        }
        finally {
            if (null != pool) {
                this.releasePermit(type, pool);
            }
        }
    }

    private void acquirePermit(PermitPool pool, RequestStatus requestStatus) throws Exception {
        if (pool.tryAcquire()) {
            return;
        }
        LOGGER.error("A request [id:{}, type:{}] was aborted by workload manager, because a permit could not be obtained within the timeout period [{} second(s)]", new Object[]{requestStatus.getRequestId(), requestStatus.getRequestType(), pool.getPolicy().getAcquireTimeoutSec()});
        throw new QueryServiceException((Throwable)new CancellationException(requestStatus.getRequestId(), CancellationReason.WORKLOAD_MANAGEMENT), 503, QueryServiceMessageKeys.SERVICE_UNAVAILABLE);
    }

    boolean acquirePermit(PermitPool pool) throws InterruptedException {
        return pool.tryAcquire();
    }

    void releasePermit(String type, PermitPool pool) {
        if (this.policy.isUnderPressure()) {
            LOGGER.warn("A permit for request type ({}) was released, but marked as unavailable due to workload pressure", (Object)type);
            pool.releaseAsUnavailable();
        } else {
            pool.releaseAsAvailable();
        }
    }

    PermitPool getPermitPoolByType(String type) {
        PermitPool pool = this.type2PermitPool.get(type);
        if (null == pool && null != this.policy.getDefaultPoolName()) {
            pool = this.getPermitPoolByName(this.policy.getDefaultPoolName());
        }
        return pool;
    }

    PermitPool getPermitPoolByName(String name) {
        return this.name2Pool.get(name);
    }

    private void supervise() {
        boolean isUnderPressure = this.policy.isUnderPressure();
        for (PermitPool pool : this.name2Pool.values()) {
            this.supervise(pool, isUnderPressure);
        }
    }

    private void supervise(PermitPool pool, boolean isUnderPressure) {
        int numRestored;
        Duration elapsedTime;
        PermitPoolPolicy poolPolicy = pool.getPolicy();
        if (isUnderPressure) {
            int numDrained = pool.drainToUnavailable();
            if (numDrained > 0) {
                LOGGER.warn("Marked {} permit(s) as unavailable in pool ({}), due to ongoing workload pressure", (Object)numDrained, (Object)poolPolicy.getName());
            }
        } else if (pool.unavailablePermits() > 0 && (elapsedTime = Duration.between(pool.lastRestoreTime(), Instant.now())).compareTo(poolPolicy.getRestorePeriod()) > 0 && (numRestored = pool.restoreToAvailable(poolPolicy.getRestoreDelta())) > 0) {
            LOGGER.warn("Marked {} permit(s) as available in pool ({}), due to release of workload pressure", (Object)numRestored, (Object)poolPolicy.getName());
        }
    }

    public static final class PermitPool {
        private final PermitPoolPolicy policy;
        private Semaphore available;
        private final AtomicInteger unavailable = new AtomicInteger();
        private Instant lastRestoreTime = Instant.EPOCH;

        PermitPool(PermitPoolPolicy policy) {
            this.policy = policy;
            this.available = new Semaphore(policy.getMaxPermits(), true);
        }

        public PermitPoolPolicy getPolicy() {
            return this.policy;
        }

        public int availablePermits() {
            return this.available.availablePermits();
        }

        public int unavailablePermits() {
            return this.unavailable.get();
        }

        Instant lastRestoreTime() {
            return this.lastRestoreTime;
        }

        private boolean tryAcquire() throws InterruptedException {
            return this.available.tryAcquire(this.policy.getAcquireTimeoutSec(), TimeUnit.SECONDS);
        }

        private void releaseAsAvailable() {
            this.available.release();
        }

        private void releaseAsUnavailable() {
            this.unavailable.incrementAndGet();
        }

        private int drainToUnavailable() {
            int numDrained = this.available.drainPermits();
            this.unavailable.addAndGet(numDrained);
            return numDrained;
        }

        private int restoreToAvailable(int numPermits) {
            int actualPermits = Math.min(numPermits, this.unavailable.get());
            this.unavailable.addAndGet(-actualPermits);
            this.available.release(actualPermits);
            this.lastRestoreTime = Instant.now();
            return actualPermits;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("max", this.policy.getMaxPermits()).append("available", this.availablePermits()).append("unavailable", this.unavailablePermits()).toString();
        }

        public void policyChanged() {
            if (this.available.availablePermits() != this.policy.getMaxPermits()) {
                this.available = new Semaphore(this.policy.getMaxPermits(), true);
            }
        }
    }
}

