/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.request;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.google.common.util.concurrent.AtomicDouble;
import com.ibm.bi.qs.xqe.request.LoadMonitor;
import com.ibm.bi.qs.xqe.request.PermitPoolPolicy;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class WorkloadPolicy {
    static final String QS_REST_WORKLOAD_MANAGEMENT_RESTORE_PERIOD_SEC = "queryExecution.RESTWorkloadManagement.restorePeriodSec[@value]";
    static final String QS_REST_WORKLOAD_MANAGEMENT_RESTORE_DELTA = "queryExecution.RESTWorkloadManagement.restoreDelta[@value]";
    private static final double DEFAULT_MAX_REQUEST_LOAD = 1000.0;
    private static final int DEFAULT_MAX_PERMITS = 200;
    private static final int DEFAULT_RESTORE_PERIOD_SEC = 60;
    private static final int DEFAULT_RESTORE_DELTA = 1;
    private static final String DEFAULT_POOL_NAME = "default";
    private final XQEServiceImpl xqeServiceImpl;
    private final Duration configUpdatePeriod = Duration.ofSeconds(10L);
    private volatile Instant lastConfigurationChange;
    private volatile Instant lastConfigurationUpdate;
    private final AtomicDouble maxRequestLoad = new AtomicDouble(1000.0);
    private final AtomicInteger maxPermits = new AtomicInteger(200);
    private final AtomicInteger restorePeriodSec = new AtomicInteger();
    private final AtomicInteger restoreDelta = new AtomicInteger();
    private volatile String defaultPoolName = "default";
    private final PermitPoolPolicy[] poolPolicies;
    private final LoadMonitor monitor;

    public WorkloadPolicy(int superviseIntervalMs, XQEServiceImpl xqeServiceImpl) {
        this.xqeServiceImpl = xqeServiceImpl;
        this.refreshConfiguration();
        this.poolPolicies = this.loadPoolPolicies(this.defaultPoolName);
        Duration updatePeriod = Duration.ofMillis(superviseIntervalMs);
        this.monitor = new LoadMonitor(updatePeriod, xqeServiceImpl.getRequestManager());
    }

    public PermitPoolPolicy[] getPermitPoolPolicies() {
        return this.poolPolicies;
    }

    public String getDefaultPoolName() {
        return this.defaultPoolName;
    }

    public boolean isUnderPressure() {
        this.monitor.update();
        return this.monitor.getRequestLoad() > this.maxRequestLoad.get();
    }

    private PermitPoolPolicy[] loadPoolPolicies(String poolName) {
        PoolPolicyImpl impl = new PoolPolicyImpl(poolName);
        this.updatePoolPolicyImpl(impl);
        PermitPoolPolicy[] poolPolicies = new PermitPoolPolicy[]{impl};
        return poolPolicies;
    }

    private void refreshConfiguration() {
        int newRestoreDelta;
        int newRestorePeriodSet;
        int newMaxPermits;
        Duration timeSinceLastUpdate;
        if (this.lastConfigurationUpdate != null && (timeSinceLastUpdate = Duration.between(this.lastConfigurationUpdate, Instant.now())).compareTo(this.configUpdatePeriod) < 0) {
            return;
        }
        boolean configSettingChanged = false;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        double newMaxRequestLoad = configuration.getDoubleProperty("queryExecution.RESTWorkloadManagement.maxRequestLoad[@value]", 1000.0);
        if (newMaxRequestLoad != this.maxRequestLoad.get()) {
            this.maxRequestLoad.set(newMaxRequestLoad);
            configSettingChanged = true;
        }
        if ((newMaxPermits = configuration.getIntegerProperty("queryExecution.RESTWorkloadManagement.maxPermits[@value]", Integer.valueOf(200)).intValue()) != this.maxPermits.get()) {
            this.maxPermits.set(newMaxPermits);
            configSettingChanged = true;
        }
        if ((newRestorePeriodSet = configuration.getIntegerProperty(QS_REST_WORKLOAD_MANAGEMENT_RESTORE_PERIOD_SEC, Integer.valueOf(60)).intValue()) != this.restorePeriodSec.get()) {
            this.restorePeriodSec.set(newRestorePeriodSet);
            configSettingChanged = true;
        }
        if ((newRestoreDelta = configuration.getIntegerProperty(QS_REST_WORKLOAD_MANAGEMENT_RESTORE_DELTA, Integer.valueOf(1)).intValue()) != this.restoreDelta.get()) {
            this.restoreDelta.set(newRestoreDelta);
            configSettingChanged = true;
        }
        if (this.lastConfigurationChange == null || configSettingChanged) {
            this.lastConfigurationChange = Instant.now();
        }
        this.lastConfigurationUpdate = Instant.now();
    }

    private void updatePoolPolicyImpl(PoolPolicyImpl impl) {
        impl.maxPermits = this.maxPermits.get();
        int defaultTimeout = this.xqeServiceImpl.getDefaultTimeout();
        impl.acquireTimeoutSec = defaultTimeout / 4 + 1;
        impl.restorePeriod = Duration.ofSeconds(this.restorePeriodSec.get());
        impl.restoreDelta = this.restoreDelta.get();
    }

    private static class PoolPolicyImpl
    implements PermitPoolPolicy {
        private final String name;
        private final Set<String> requestTypes = new TreeSet<String>();
        private int maxPermits = 200;
        private int acquireTimeoutSec = 30;
        private Duration restorePeriod = Duration.ofSeconds(60L);
        private int restoreDelta = 1;

        public PoolPolicyImpl(String theName) {
            this.name = theName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getRequestTypes() {
            return this.requestTypes;
        }

        @Override
        public int getMaxPermits() {
            return this.maxPermits;
        }

        @Override
        public int getAcquireTimeoutSec() {
            return this.acquireTimeoutSec;
        }

        @Override
        public Duration getRestorePeriod() {
            return this.restorePeriod;
        }

        @Override
        public int getRestoreDelta() {
            return this.restoreDelta;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

