/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.results;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemoser.MoserQueryItem;
import com.google.common.base.Objects;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.FieldOrdering;
import com.ibm.bi.qs.model.api.NullPlacement;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.model.api.data.queryspec.generated.AggregateType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Sort;
import com.ibm.bi.qs.model.api.data.queryspec.generated.SortOrder;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.IResultPage;
import com.ibm.bi.qs.xqe.results.EndorResultSetReader;
import com.ibm.bi.qs.xqe.v5.DataExecutor;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EndorResultSet
implements IQSResultSet {
    private static final String HEADER = "h";
    private static final String TUPLE = "t";
    private static final String USE = "u";
    private static final String DISPLAY = "d";
    private static final String DUN = "du";
    private static final String HUN = "hu";
    private static final String LUN = "lu";
    private static final String LEVEL_LABEL = "ll";
    private static final String LEVEL_NUM = "ln";
    private static final String PARENT_NUM = "pn";
    private static final String DECORATION = "deco";
    private static final String RANK = "rank";
    private static final String PARENT = "p";
    private static final String VALUE = "v";
    private static final String POINT = "pt";
    private static final String UNDERSCORE = "_";
    private static final String NULLCHAR = "\u0000";
    private static final String UNICODENULL = "\\u0000";
    private static final String EXCEPTION_STR = "Exception: ";
    private static final String MIN_STR = "MIN";
    private static final String MAX_STR = "MAX";
    private static final String AGGREGATE = "aggregate";
    private static final String ID = "id";
    public static final String CALCULATION_FORMAT = "calc_%s.calculated";
    private static final String EMPTY_STRING = "";
    private static final String STATE = "state";
    private static final String SPLIT_DOT = "\\.";
    public static final int REF_DATA_ITEM_ORDINAL = -1;
    private final Map<String, ColumnMetadata> columns;
    private final DataItem[] projectedDataItems;
    private final DataItem[] querySpecDataItems;
    private final QuerySpec querySpec;
    private final RSAPIEdge edge;
    private final long rowLimit;
    private final long maxExpectedRows;
    private boolean hasNext = false;
    private final long offset;
    private final Date lastModified;
    private final QueryFeedbackWrapper qfbWrapper;
    private boolean multiEdgeSort = false;
    private boolean allProperties = false;
    private NullBehavior olapNullBehavior = NullBehavior.NULL_FIRST;
    private TIntIntHashMap rowset2RowValueColumnPos = null;
    private final Map<String, ItemClass> itemClassLookup;
    private final Map<ItemClass, List<Item>> items;
    private final Map<ItemClass, Set<Item>> itemClasses2ItemSets;
    private final List<DataPoint> data;

    public EndorResultSet(Map<String, ColumnMetadata> mdColumns, QuerySpec qs, IV5ResultSet[] v5ResultSets, RSAPIDataset rsDataset, long maxRows, QueryFeedbackWrapper qfb) {
        if (null != qfb) {
            qfb.startResultMarshalling();
        }
        this.columns = mdColumns;
        List<String> projections = DataExecutor.getProjections(qs);
        this.querySpecDataItems = qs.getDataItems().toArray(new DataItem[qs.getDataItems().size()]);
        this.querySpec = qs;
        if (null != qfb && qfb.isValidateMode()) {
            this.edge = null;
            this.lastModified = Date.from(Instant.now());
            this.projectedDataItems = new DataItem[0];
        } else {
            this.edge = rsDataset.getEdge(0);
            this.lastModified = rsDataset.getLastModified();
            this.projectedDataItems = (DataItem[])projections.stream().map(projectedDataItemId -> qs.getDataItems().stream().filter(dataItem -> dataItem.getId().equals(projectedDataItemId))).flatMap(Function.identity()).toArray(DataItem[]::new);
        }
        this.rowLimit = maxRows;
        this.maxExpectedRows = qs.getSampling() != null && qs.getSampling().getRowCount() != null ? (long)(qs.getSampling().getRowCount() * 2) : Integer.MAX_VALUE;
        this.offset = qs.getOffset().intValue();
        this.itemClassLookup = new HashMap<String, ItemClass>();
        this.data = new LinkedList<DataPoint>();
        this.items = new HashMap<ItemClass, List<Item>>();
        this.itemClasses2ItemSets = new HashMap<ItemClass, Set<Item>>();
        this.allProperties = qs.getAllProperties();
        this.qfbWrapper = qfb;
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        if (providerCapabilities != null) {
            String strNullPosition = providerCapabilities.getStringValue("null.position.order.function", "FIRST");
            this.olapNullBehavior = "FIRST".equalsIgnoreCase(strNullPosition) ? NullBehavior.NULL_FIRST : NullBehavior.NULL_LAST;
        }
        this.multiEdgeSort = TransformationUtils.getMultiEdgeSortQueryHint(qs);
        if (null == qfb || !qfb.isValidateMode()) {
            IV5ResultSet v5ResultSet = v5ResultSets[0];
            this.loadItemClasses();
            this.loadResult(v5ResultSet);
            this.sortPostProcess();
        }
        if (null != qfb) {
            QueryFeedbackWrapper.retrieveColumnListFeedback(qfb, rsDataset);
            qfb.endResultMarshalling();
        }
    }

    public Map<String, ItemClass> getItemClassLookupMap() {
        return this.itemClassLookup;
    }

    public Map<ItemClass, List<Item>> getItemClassesAndItems() {
        return this.items;
    }

    public List<DataPoint> getDataPoints() {
        return this.data;
    }

    public JSONObject getFirstResultValue() {
        List<DataPoint> dataPoints = this.getDataPoints();
        JSONObject firstObject = this.getFirstObject(dataPoints);
        return firstObject;
    }

    private JSONObject getFirstObject(List<DataPoint> dataPoints) {
        Object firstObject;
        JSONArray firstPoint;
        if (dataPoints != null && !dataPoints.isEmpty() && !(firstPoint = dataPoints.get((int)0).point).isEmpty() && (firstObject = firstPoint.get(0)) instanceof JSONObject) {
            return (JSONObject)firstObject;
        }
        return null;
    }

    public DataItem[] getDataItems() {
        return this.projectedDataItems;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void dispose() {
    }

    public IPlanningEnvironment getPlanningEnvironment() {
        return this.edge.getDataset().getPlanningEnvironment();
    }

    public static String[] generateItemClassesMinAndMaxLookupKeys(DataItem di) {
        String[] minmaxKeys = new String[2];
        StringBuilder sbKeyMIN = new StringBuilder(di.getId());
        StringBuilder sbKeyMAX = new StringBuilder(di.getId());
        minmaxKeys[0] = sbKeyMIN.append(UNDERSCORE).append(MIN_STR).toString();
        minmaxKeys[1] = sbKeyMAX.append(UNDERSCORE).append(MAX_STR).toString();
        return minmaxKeys;
    }

    public void loadItemClasses() {
        for (DataItem di : this.projectedDataItems) {
            if (this.querySpec.getType() == QuerySpec.Type.MINMAX) {
                String[] minmaxKeys = EndorResultSet.generateItemClassesMinAndMaxLookupKeys(di);
                ItemClass minItemClass = new ItemClass(minmaxKeys[0], di);
                ItemClass maxItemClass = new ItemClass(minmaxKeys[1], di);
                minItemClass.setIsMin(true);
                maxItemClass.setIsMax(true);
                this.itemClassLookup.put(minItemClass.getId(), minItemClass);
                this.itemClassLookup.put(maxItemClass.getId(), maxItemClass);
                this.items.put(minItemClass, null);
                this.items.put(maxItemClass, null);
                continue;
            }
            ItemClass itemClass = new ItemClass(di);
            this.itemClassLookup.put(itemClass.getId(), itemClass);
            this.items.put(itemClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResult(IV5ResultSet v5ResultSet) {
        XIterator edgeIterator = v5ResultSet.getV5EdgeIterator(this.edge);
        RowValue currentRow = null;
        try {
            this.associateProjDIs2RowsetDIsOrdinalPos(this.projectedDataItems, this.edge);
            currentRow = (RowValue)edgeIterator.next();
            ROLAPContext.queryEnter((IExecutionEnvironment)((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()));
            boolean needToRemoveCubeName = false;
            try {
                needToRemoveCubeName = ROLAPContext.setCurrentCubeName((IPlanningEnvironment)this.getPlanningEnvironment());
                int dpIdx = 0;
                while (currentRow != null) {
                    if ((long)dpIdx >= this.offset + this.rowLimit) {
                        this.hasNext = true;
                        break;
                    }
                    if ((long)dpIdx >= this.maxExpectedRows) {
                        throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_SAMPLING_TOO_MUCH_DATA);
                    }
                    if ((long)dpIdx >= this.offset) {
                        DataPoint dataPoint = new DataPoint();
                        JSONArray dataPointValues = new JSONArray();
                        this.processRowValue(dataPointValues, currentRow);
                        if (!dataPointValues.isEmpty()) {
                            dataPoint.setValue(dataPointValues);
                            this.data.add(dataPoint);
                        }
                    }
                    currentRow = (RowValue)edgeIterator.next();
                    ++dpIdx;
                }
            }
            finally {
                ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
                ROLAPContext.queryExit((IExecutionEnvironment)((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()));
            }
        }
        finally {
            edgeIterator.release();
            edgeIterator = null;
        }
    }

    private TIntIntHashMap associateRowSetPos2RowValueColumnPos(RowValue rowValue) {
        TIntIntHashMap currentRowset2RowValueColumnPos = new TIntIntHashMap();
        if (rowValue == null) {
            return currentRowset2RowValueColumnPos;
        }
        for (int i = 0; i < rowValue.getNumColumns(); ++i) {
            IValue v = rowValue.getColumn(i);
            int dataItemIndex = -1;
            if (v instanceof ContextMember) {
                dataItemIndex = ((ContextMember)v).getDataItemIndex();
            } else if (v instanceof ContextValue) {
                dataItemIndex = ((ContextValue)v).getDataItemIndex();
            }
            currentRowset2RowValueColumnPos.put(dataItemIndex, i);
        }
        return currentRowset2RowValueColumnPos;
    }

    private void associateProjDIs2RowsetDIsOrdinalPos(DataItem[] projDIs, RSAPIEdge rsEdge) {
        for (DataItem projDI : projDIs) {
            if (this.querySpec.getType() == QuerySpec.Type.MINMAX) {
                String[] minmaxKeys;
                for (String key : minmaxKeys = EndorResultSet.generateItemClassesMinAndMaxLookupKeys(projDI)) {
                    ItemClass itemClass = this.itemClassLookup.get(key);
                    EndorResultSet.associateItemClass2RowsetDIsOrdinalPos(projDI, itemClass, rsEdge);
                }
                continue;
            }
            ItemClass itemClass = this.itemClassLookup.get(projDI.getId());
            EndorResultSet.associateItemClass2RowsetDIsOrdinalPos(projDI, itemClass, rsEdge);
        }
    }

    private static void associateItemClass2RowsetDIsOrdinalPos(DataItem projDI, ItemClass itemClass, RSAPIEdge rsEdge) {
        int[] ordinalPosArray = itemClass.getOrdinalPosInRowValueArray();
        if (projDI.getNest().isEmpty()) {
            int ordinalPos = rsEdge.getRootRowset().getDataItemOrdinalByName(itemClass.getRSDataItemIDs()[0]);
            if (ordinalPos == -1) {
                ordinalPos = rsEdge.getRootRowset().getDataItemOrdinalByName(itemClass.getRSDataItemIDs()[0] + "_OLAPAGG");
            }
            ordinalPosArray[0] = ordinalPos;
        } else {
            ordinalPosArray = Arrays.stream(itemClass.getRSDataItemIDs()).mapToInt(attrId -> rsEdge.getRootRowset().getDataItemOrdinalByName(attrId)).toArray();
            itemClass.setOrdinalPosInRowValueArray(ordinalPosArray);
        }
        int calcIndx = rsEdge.getRootRowset().getDataItemOrdinalByName(itemClass.generateCalcExpressionName());
        if (calcIndx != -1) {
            itemClass.setCalcPosInRowValue(calcIndx);
        }
    }

    private void processRowValue(JSONArray dataPointValues, RowValue currentRow) {
        TIntIntHashMap currentRowset2RowValueColumnPos = currentRow.getNumColumns() != this.projectedDataItems.length ? this.associateRowSetPos2RowValueColumnPos(currentRow) : (this.rowset2RowValueColumnPos != null ? this.rowset2RowValueColumnPos : (this.rowset2RowValueColumnPos = this.associateRowSetPos2RowValueColumnPos(currentRow)));
        for (int i = 0; i < this.projectedDataItems.length; ++i) {
            String[] minmaxItemClassKeys;
            DataItem projDI = this.projectedDataItems[i];
            if (this.querySpec.getType() != QuerySpec.Type.MINMAX) {
                ItemClass itemClass = this.itemClassLookup.get(projDI.getId());
                if (!(projDI.getAggregate() != null && projDI.getNest().isEmpty() || projDI.getCalculation() != null)) {
                    int itemPosition;
                    Set<Object> itemSet;
                    Item item = this.constructItem(itemClass, currentRow, projDI, currentRowset2RowValueColumnPos);
                    if (this.itemClasses2ItemSets.containsKey(itemClass)) {
                        itemSet = this.itemClasses2ItemSets.get(itemClass);
                    } else {
                        itemSet = new HashSet();
                        this.itemClasses2ItemSets.put(itemClass, itemSet);
                    }
                    if (itemSet.contains(item)) {
                        if (projDI.getBinning() != null && this.projectedDataItems.length == 1) {
                            return;
                        }
                        itemPosition = itemClass.getItemToPositionMap().get(item);
                    } else {
                        List<Item> currentItems = this.items.get(itemClass);
                        if (currentItems == null) {
                            currentItems = new LinkedList<Item>();
                            this.items.put(itemClass, currentItems);
                        }
                        item.setPosition(currentItems.size());
                        currentItems.add(item);
                        itemSet.add(item);
                        itemClass.getItemToPositionMap().put(item, item.getPosition());
                        itemPosition = item.getPosition();
                    }
                    dataPointValues.put(itemPosition);
                    continue;
                }
                int ordinalPos = itemClass.getOrdinalPosInRowValueArray()[0];
                OrderedJSONObject metricJSON = new OrderedJSONObject();
                try {
                    int columnPos;
                    IValue value;
                    NullValue aValue = NullValue.NULLVALUE;
                    if (currentRowset2RowValueColumnPos.containsKey(ordinalPos) && (value = currentRow.getColumn(columnPos = currentRowset2RowValueColumnPos.get(ordinalPos))) instanceof ContextValue) {
                        aValue = (Value)((ContextValue)value).getValue();
                        ContextValue contextValue = (ContextValue)value;
                        RSAPIDataItem[] rsapiDataItems = contextValue.getRowset().getDataItems();
                        if (rsapiDataItems != null && rsapiDataItems.length > 0 && rsapiDataItems[contextValue.getDataItemIndex()] != null && rsapiDataItems[contextValue.getDataItemIndex()].isNotApplicable()) {
                            ((Value)contextValue.getValue()).setState(ValueState.NOT_APPLICABLE);
                        }
                        aValue = (Value)contextValue.getValue();
                    }
                    Object aJSONValue = this.getJSONValue((Value)aValue);
                    this.putValueAndState((JSONObject)metricJSON, aJSONValue, (Value)aValue);
                    if (itemClass.isAssociatedWithCalcExpression()) {
                        JSONObject decorationObject = new JSONObject();
                        IValue rankV = currentRow.getColumn(currentRowset2RowValueColumnPos.get(itemClass.getCalcPosInRowValue()));
                        aJSONValue = ((ContextValue)rankV).getValue().toJSON();
                        decorationObject.put(RANK, aJSONValue);
                        metricJSON.put(DECORATION, (Map)decorationObject);
                    }
                    dataPointValues.put((Map)metricJSON);
                }
                catch (JSONException e) {
                    QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
                }
                continue;
            }
            for (String key : minmaxItemClassKeys = EndorResultSet.generateItemClassesMinAndMaxLookupKeys(projDI)) {
                ItemClass itemClass = this.itemClassLookup.get(key);
                int ordinalPos = itemClass.getOrdinalPosInRowValueArray()[0];
                JSONObject metricJSON = new JSONObject();
                try {
                    int columnPos = currentRowset2RowValueColumnPos.get(ordinalPos);
                    ContextValue contextValue = (ContextValue)currentRow.getColumn(columnPos);
                    Value aValue = (Value)contextValue.getValue();
                    Object aJSONValue = this.getJSONValue(aValue);
                    this.putValueAndState(metricJSON, aJSONValue, (Value)contextValue.getValue());
                    dataPointValues.put((Map)metricJSON);
                }
                catch (JSONException e) {
                    QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
                }
            }
        }
    }

    private void putValueAndState(JSONObject metricJSON, Object aJSONValue, Value value) throws JSONException {
        metricJSON.put(VALUE, aJSONValue);
        if (value.getState() != ValueState.OK && value.getState() != ValueState.CALC) {
            JSONObject decorationObject = new JSONObject();
            decorationObject.put(STATE, (Object)value.getState().toString());
            metricJSON.put(DECORATION, (Map)decorationObject);
        }
    }

    private void sortPostProcess() {
        if (!this.multiEdgeSort) {
            return;
        }
        int[][] allMappings = new int[this.projectedDataItems.length][];
        boolean localSortNeeded = false;
        for (int i = 0; i < this.projectedDataItems.length; ++i) {
            List<Item> currentItems;
            allMappings[i] = null;
            DataItem projDI = this.projectedDataItems[i];
            if (this.querySpec.getType() == QuerySpec.Type.MINMAX) continue;
            ItemClass itemClass = this.itemClassLookup.get(projDI.getId());
            if (projDI.getAggregate() != null && projDI.getNest().isEmpty() || null == (currentItems = this.items.get(itemClass))) continue;
            localSortNeeded = true;
            currentItems.sort(null);
            int[] mapsForSortedPosition = new int[currentItems.size()];
            ListIterator<Item> itr = currentItems.listIterator();
            int sortedPosition = 0;
            while (itr.hasNext()) {
                Item item = itr.next();
                mapsForSortedPosition[((Item)item).position] = sortedPosition++;
            }
            allMappings[i] = mapsForSortedPosition;
        }
        if (!localSortNeeded) {
            return;
        }
        List<DataPoint> dataPoints = this.getDataPoints();
        for (DataPoint dataPoint : dataPoints) {
            try {
                JSONArray point = dataPoint.point;
                for (int j = 0; j < point.size(); ++j) {
                    if (allMappings[j] == null) continue;
                    int[] mapsForSortedPosition = allMappings[j];
                    int oldPosition = point.getInt(j);
                    point.set(j, (Object)mapsForSortedPosition[oldPosition]);
                }
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to update DataPoints indices.");
                QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
            }
        }
    }

    private Item constructItem(ItemClass itemClass, RowValue rowValue, DataItem projDI, TIntIntHashMap currentRowset2RowValueColumnPos) {
        Item item = new Item();
        item.setItemClass(itemClass);
        int indexItem = 0;
        for (int ordinalPos : itemClass.getOrdinalPosInRowValueArray()) {
            if (!currentRowset2RowValueColumnPos.containsKey(ordinalPos)) {
                item.addValue(null, null);
                break;
            }
            int columnPos = currentRowset2RowValueColumnPos.get(ordinalPos);
            IValue v = rowValue.getColumn(columnPos);
            RSAPIDataItem dataItem = this.edge.getRootRowset().getDataItem(ordinalPos);
            boolean isfacetEnabled = this.facetEnabled(dataItem);
            NullValue sortValue = NullValue.NULLVALUE;
            if (this.multiEdgeSort) {
                if (itemClass.deflectedSortDataItemNames[indexItem] != null) {
                    int deflectedColumnPosition = this.edge.getRootRowset().getDataItemOrdinalByName(itemClass.deflectedSortDataItemNames[indexItem]);
                    if (ordinalPos >= 0) {
                        IValue columnSortValue = rowValue.getColumn(deflectedColumnPosition);
                        sortValue = this.extractSortValue(columnSortValue);
                    } else {
                        sortValue = NullValue.NULLVALUE;
                    }
                } else {
                    sortValue = this.extractSortValue(v);
                }
                ++indexItem;
            }
            if (v instanceof ContextValue) {
                Object value = ((ContextValue)v).getValue();
                if (value instanceof TextValue && !value.isNull()) {
                    value = value.toString().replace(NULLCHAR, UNICODENULL);
                } else if (value instanceof TimestampValue && dataItem.getDataType().isDate()) {
                    DateValue dateValue = DataValueFactory.createDateValue();
                    dateValue.set(value);
                    value = dateValue.toJSON();
                } else {
                    value = value instanceof Value ? this.getJSONValue((Value)value) : value.toJSON();
                }
                if (isfacetEnabled) {
                    item.addValue(this.getMUNforFacet(dataItem, (ContextValue)v).replace(NULLCHAR, UNICODENULL), value);
                } else {
                    item.addValue(value, value);
                }
            } else if (null == this.getFacet(dataItem) && this.isContextMemberForInternalDMR(v) && null != projDI.getId() && !projDI.getId().isEmpty()) {
                this.processContextMemberForPackage(dataItem, item, (ContextMember)v, projDI);
            } else if (v instanceof ContextMember) {
                this.processContextMember(dataItem, item, (ContextMember)v, projDI);
            } else {
                item.addValue(null, null);
                sortValue = NullValue.NULLVALUE;
            }
            item.addSortValue((Value)sortValue);
            if (itemClass.isAssociatedWithCalcExpression()) {
                IValue rankV = rowValue.getColumn(currentRowset2RowValueColumnPos.get(itemClass.getCalcPosInRowValue()));
                item.addRankValue(((ContextValue)rankV).getValue().toJSON());
                continue;
            }
            item.addRankValue(null);
        }
        item.makeImmutable();
        return item;
    }

    private Value extractSortValue(IValue value) {
        if (value instanceof ContextMember) {
            ContextMember contextMember = (ContextMember)value;
            Value sortValue = contextMember.getCaptionValue();
            if (sortValue != null && sortValue instanceof TextValue && ((TextValue)sortValue).getValue().equals(EMPTY_STRING)) {
                sortValue = contextMember.getBusinessKeyValue();
            }
            if (sortValue == null) {
                return NullValue.NULLVALUE;
            }
            return sortValue;
        }
        if (value instanceof ContextValue) {
            ContextValue cv = (ContextValue)value;
            return (Value)cv.getValue();
        }
        return NullValue.NULLVALUE;
    }

    private boolean isContextMemberForInternalDMR(IValue v) {
        return v instanceof ContextMember && null != ((ContextMember)v).getMember() && ((ContextMember)v).getMember() instanceof DMRMember && ((ContextMember)v).getDimension().getName().startsWith("TBdimension_");
    }

    protected boolean facetEnabled(RSAPIDataItem dataItem) {
        ColumnMetadata metadata;
        IFacet facet = this.getFacet(dataItem);
        if (facet == null && dataItem.getQueryItemModelId() != null && (metadata = this.columns.get(dataItem.getQueryItemModelId())) != null) {
            return metadata.isFacetEnabled();
        }
        return facet != null && facet.isEnabled();
    }

    private IFacet getFacet(RSAPIDataItem dataItem) {
        IMetadata md = dataItem.getModelReference();
        if (!(md instanceof MoserQueryItem)) {
            return null;
        }
        MoserQueryItem moserQI = (MoserQueryItem)md;
        return moserQI.getFacet();
    }

    protected String getMUNforFacet(RSAPIDataItem dataItem, ContextValue contextValue) {
        Value v = (Value)contextValue.getValue();
        if (v.getState() == ValueState.OK) {
            StringBuilder sb = new StringBuilder();
            IMetadata md = dataItem.getModelReference();
            if (md instanceof MoserQueryItem) {
                MoserQueryItem moserQI = (MoserQueryItem)md;
                sb.append(moserQI.getQuerySubject().getName());
                sb.append(".");
                sb.append(moserQI.getName());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)v.getV5formattedString()));
            } else {
                sb.append(dataItem.getQueryItemModelId());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)v.getV5formattedString()));
            }
            return sb.toString();
        }
        if (v.getState() == ValueState.NULL) {
            StringBuilder sb = new StringBuilder();
            IMetadata md = dataItem.getModelReference();
            if (md instanceof MoserQueryItem) {
                MoserQueryItem moserQI = (MoserQueryItem)md;
                sb.append(moserQI.getQuerySubject().getName());
                sb.append(".");
                sb.append(moserQI.getName());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart(null));
            } else {
                sb.append(dataItem.getQueryItemModelId());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart(null));
            }
            return sb.toString();
        }
        return null;
    }

    protected String getMUNforPackage(IMember member, DataItem projDI) {
        if (null != member) {
            StringBuilder sb = new StringBuilder();
            sb.append(projDI.getItemId());
            sb.append("->");
            sb.append("[");
            sb.append(member.getName());
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    private String getContextMemberDisplayValue(ContextMember ctxMember) {
        Value businessKeyValue;
        String caption = ctxMember.getCaption();
        if (caption != null && caption.equals(EMPTY_STRING) && ((businessKeyValue = ctxMember.getBusinessKeyValue()) == null || businessKeyValue.getState() == ValueState.NULL)) {
            return null;
        }
        return caption;
    }

    private void processContextMember(RSAPIDataItem dataItem, Item currentItem, ContextMember ctxMember, DataItem projDI) {
        String propertyName = this.getPropertyName(dataItem);
        if (propertyName != null) {
            Object propertyValue = propertyName.equalsIgnoreCase("description") ? ctxMember.getDescription() : this.getMemberPropertyValue(ctxMember, propertyName);
            currentItem.addValue(ctxMember.getV5UniqueName(), propertyValue);
        } else {
            ColumnMetadata metadata = null;
            if (projDI.getItemId() != null) {
                metadata = this.columns.get(projDI.getItemId());
            }
            boolean includeParent = this.allProperties || EndorResultSet.includeParent(metadata);
            String parentUniqueName = ctxMember.getParentObjectUniqueName();
            String alias = this.findAlias(projDI, ctxMember);
            if (alias != null && !alias.isEmpty()) {
                alias = alias + ".";
            }
            String useValue = alias + ctxMember.getV5UniqueName();
            String displayValue = this.getContextMemberDisplayValue(ctxMember);
            if (metadata != null && metadata.getHierarchy() == null && metadata.isCalculation().booleanValue()) {
                useValue = displayValue;
            }
            if (includeParent && parentUniqueName != null && !parentUniqueName.isEmpty()) {
                currentItem.addValue(useValue, displayValue, alias + parentUniqueName);
            } else {
                currentItem.addValue(useValue, displayValue);
            }
            if (this.allProperties) {
                currentItem.addExtraValue(alias + ctxMember.getDimension().getV5UniqueName());
                currentItem.addExtraValue(alias + ctxMember.getHierarchy().getV5UniqueName());
                currentItem.addExtraValue(alias + ctxMember.getLevel().getV5UniqueName());
                currentItem.addExtraValue(ctxMember.getLevel().getIndex());
                currentItem.addExtraValue(ctxMember.getLevel().getName());
                currentItem.addExtraValue(ctxMember.getParentLevelNumber());
            }
        }
    }

    private String findAlias(DataItem projDI, ContextMember ctxMember) {
        String left;
        String[] memberIdParts;
        int idx;
        String[] itemIdParts;
        String alias = EMPTY_STRING;
        String itemId = projDI.getItemId();
        String memberId = ctxMember.getV5UniqueName();
        if (itemId != null && memberId != null && (itemIdParts = itemId.split(SPLIT_DOT)).length > 2 && (idx = memberId.indexOf("->")) > 0 && (memberIdParts = (left = memberId.substring(0, idx)).split(SPLIT_DOT)).length > 0 && itemIdParts[1].equals(memberIdParts[0])) {
            alias = itemIdParts[0];
        }
        return alias;
    }

    private static boolean includeParent(ColumnMetadata metadata) {
        boolean includeParent = false;
        if (metadata != null && metadata.getSourceCategory() != null) {
            boolean isHierarchy = metadata.getSourceCategory().equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) || metadata.getSourceCategory().equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD);
            boolean isNamedSet = metadata.getSourceCategory().equals((Object)ColumnMetadata.SourceCategory.NAMED_SET);
            includeParent = isHierarchy || isNamedSet;
        }
        return includeParent;
    }

    private void processContextMemberForPackage(RSAPIDataItem dataItem, Item currentItem, ContextMember ctxMember, DataItem projDI) {
        String propertyName = this.getPropertyName(dataItem);
        if (propertyName != null) {
            currentItem.addValue(this.getMUNforPackage((IMember)ctxMember, projDI), this.getMemberPropertyValue(ctxMember, propertyName));
            return;
        }
        ColumnMetadata metadata = null;
        if (projDI.getItemId() != null) {
            metadata = this.columns.get(projDI.getItemId());
        }
        boolean includeParent = EndorResultSet.includeParent(metadata);
        String parentUniqueName = null;
        if (includeParent) {
            if (ctxMember.getMember() instanceof DMRMember) {
                IMember parent = ((DMRMember)ctxMember.getMember()).getParent();
                parentUniqueName = this.getMUNforPackage(parent, projDI);
            }
            if (null == parentUniqueName) {
                parentUniqueName = ctxMember.getParentObjectUniqueName();
            }
        }
        if (includeParent && parentUniqueName != null && !parentUniqueName.isEmpty()) {
            currentItem.addValue(this.getMUNforPackage((IMember)ctxMember, projDI), this.getContextMemberDisplayValue(ctxMember), parentUniqueName);
        } else {
            currentItem.addValue(this.getMUNforPackage((IMember)ctxMember, projDI), this.getContextMemberDisplayValue(ctxMember));
        }
    }

    private String getPropertyName(RSAPIDataItem dataItem) {
        String propertyName = dataItem.getPropertyName();
        if (propertyName == null) {
            IDataType datatype = dataItem.getDataType();
            if (datatype == DataTypeFactory.getMemberDescriptionType()) {
                return "DESCRIPTION";
            }
            if (datatype == DataTypeFactory.getMemberCaptionType()) {
                return "MEMBER_CAPTION";
            }
            if (datatype == DataTypeFactory.getMemberRollupType()) {
                return "_rollupType";
            }
        }
        return propertyName;
    }

    private Object getMemberPropertyValue(ContextMember member, String propertyName) {
        Object value = member.getProperty(propertyName);
        if (value == null) {
            return null;
        }
        if (value instanceof Value) {
            return this.getJSONValue((Value)value);
        }
        return value.toString();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isMinMaxResult() {
        return this.querySpec.getType() == QuerySpec.Type.MINMAX;
    }

    public IResultPage read(IQSResultSet resultSet) {
        return EndorResultSetReader.read(resultSet, (int)this.offset, (int)this.rowLimit);
    }

    QueryFeedbackWrapper getQueryFeedbackWrapper() {
        return this.qfbWrapper;
    }

    private Object getJSONValue(Value aValue) {
        if (this.querySpec.getWriteNumbersAsString().booleanValue() && aValue instanceof NumericValue) {
            BigDecimal bigDecimal = aValue.getBigDecimal();
            if (bigDecimal == null) {
                return null;
            }
            return bigDecimal.stripTrailingZeros().toPlainString();
        }
        return aValue.toJSON();
    }

    public class DataPoint {
        JSONArray point = new JSONArray();

        public void setValue(JSONArray v) {
            this.point = v;
        }

        public Object toJSON() {
            JSONObject dataPoint = new JSONObject();
            try {
                dataPoint.put(EndorResultSet.POINT, (Collection)this.point);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert DataPoint instance toJSON\npoint: {}.", (Object)this.point.toString());
                QueryServiceLogger.error((Object)this, (String)EndorResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return dataPoint;
        }

        public String toString() {
            return this.toJSON().toString();
        }

        public JSONArray getPoint() {
            return this.point;
        }
    }

    public class Item
    implements Comparable<Item> {
        private int hashCode = 0;
        private ItemClass itemClass;
        private int position;
        private LinkedList<Object> useValues = new LinkedList();
        private LinkedList<Object> displayValues = new LinkedList();
        private LinkedList<Value> sortValues = new LinkedList();
        private LinkedList<Object> rankValues = null;
        private LinkedList<Object> extraValues = null;
        private transient boolean immutable = false;

        public void setItemClass(ItemClass itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        public int compareTo(Item item) {
            for (int i = 0; i < this.sortValues.size(); ++i) {
                int result;
                if (this.itemClass.postProcessingSortOrders[i] == 0 || (result = this.itemClass.nullBehaviors == null ? this.sortValues.get(i).compareTo((Object)item.sortValues.get(i)) : this.sortValues.get(i).compareTo((Object)item.sortValues.get(i), this.itemClass.nullBehaviors[i]) * this.itemClass.postProcessingSortOrders[i]) == 0) continue;
                return result;
            }
            return 0;
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public int getPosition() {
            return this.position;
        }

        public void addValue(Object useValue, Object displayValue) {
            if (this.immutable) {
                throw new IllegalStateException("Cannot modify");
            }
            this.useValues.add(useValue);
            this.displayValues.add(displayValue);
        }

        public void addValue(Object useValue, Object displayValue, Object parentUseValue) {
            if (this.immutable) {
                throw new IllegalStateException("Cannot modify");
            }
            if (parentUseValue != null) {
                Pair useValueAndParent = new Pair(useValue, parentUseValue);
                this.useValues.add(useValueAndParent);
            } else {
                this.useValues.add(useValue);
            }
            this.displayValues.add(displayValue);
        }

        public void addSortValue(Value aSortValue) {
            this.sortValues.add(aSortValue);
        }

        public void addExtraValue(Object value) {
            if (this.immutable) {
                throw new IllegalStateException("Cannot modify");
            }
            if (this.extraValues == null) {
                this.extraValues = new LinkedList();
            }
            this.extraValues.add(value);
        }

        public void addRankValue(Object rank) {
            if (this.immutable) {
                throw new IllegalStateException("Cannot modify");
            }
            if (this.rankValues == null) {
                this.rankValues = new LinkedList();
            }
            this.rankValues.add(rank);
        }

        public void makeImmutable() {
            this.immutable = true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                Object[] objects = this.collectObjectsForHashCode();
                this.hashCode = new HashCodeBuilder(17, 37).append(objects).toHashCode();
            }
            return this.hashCode;
        }

        private Object[] collectObjectsForHashCode() {
            int size = this.useValues.size() + this.displayValues.size();
            size = this.rankValues == null ? ++size : (size += this.rankValues.size());
            size = this.extraValues == null ? ++size : (size += this.extraValues.size());
            Object[] objects = new Object[size];
            int index = 0;
            int useIdx = 0;
            while (useIdx < this.useValues.size()) {
                objects[index] = this.useValues.get(useIdx);
                ++useIdx;
                ++index;
            }
            int displayIdx = 0;
            while (displayIdx < this.displayValues.size()) {
                objects[index] = this.displayValues.get(displayIdx);
                ++displayIdx;
                ++index;
            }
            if (this.rankValues == null) {
                objects[index] = null;
                ++index;
            } else {
                int rankIdx = 0;
                while (rankIdx < this.rankValues.size()) {
                    objects[index] = this.rankValues.get(rankIdx);
                    ++rankIdx;
                    ++index;
                }
            }
            if (this.extraValues == null) {
                objects[index] = null;
                ++index;
            } else {
                int extraIdx = 0;
                while (extraIdx < this.extraValues.size()) {
                    objects[index] = this.extraValues.get(extraIdx);
                    ++extraIdx;
                    ++index;
                }
            }
            return objects;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Item)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            Item otherItem = (Item)other;
            if ((this.rankValues == null || otherItem.rankValues == null) && this.rankValues != otherItem.rankValues) {
                return false;
            }
            if ((this.extraValues == null || otherItem.extraValues == null) && this.extraValues != otherItem.extraValues) {
                return false;
            }
            EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.useValues, otherItem.useValues).append(this.displayValues, otherItem.displayValues);
            if (this.rankValues != null) {
                equalsBuilder.append(this.rankValues, otherItem.rankValues);
            }
            if (this.extraValues != null) {
                equalsBuilder.append(this.extraValues, otherItem.extraValues);
            }
            return equalsBuilder.isEquals();
        }

        public Object toJSON() {
            OrderedJSONObject tuple = new OrderedJSONObject();
            try {
                JSONArray tupleValues = new JSONArray();
                Iterator useIt = this.useValues.iterator();
                Iterator disIt = this.displayValues.iterator();
                Iterator rankIt = null;
                if (this.rankValues != null) {
                    rankIt = this.rankValues.iterator();
                }
                Iterator extraIt = null;
                if (this.extraValues != null) {
                    extraIt = this.extraValues.iterator();
                }
                while (useIt.hasNext()) {
                    OrderedJSONObject value = new OrderedJSONObject();
                    Object use = useIt.next();
                    if (use instanceof Pair) {
                        Pair useValueAndParent = (Pair)use;
                        Object parent = useValueAndParent.getSecond();
                        if (parent != null) {
                            JSONObject parentObject = new JSONObject();
                            parentObject.put(EndorResultSet.USE, parent);
                            value.put(EndorResultSet.PARENT, (Map)parentObject);
                        }
                        value.put(EndorResultSet.USE, useValueAndParent.getFirst());
                    } else {
                        value.put(EndorResultSet.USE, use);
                    }
                    Object displayValue = null;
                    if (disIt != null && disIt.hasNext()) {
                        displayValue = disIt.next();
                    }
                    if (displayValue != value.get(EndorResultSet.USE)) {
                        value.put(EndorResultSet.DISPLAY, displayValue);
                    }
                    Object rankValue = null;
                    if (rankIt != null && rankIt.hasNext()) {
                        rankValue = rankIt.next();
                    }
                    if (rankValue != null) {
                        JSONObject decorationObject = new JSONObject();
                        decorationObject.put(EndorResultSet.RANK, rankValue);
                        value.put(EndorResultSet.DECORATION, (Map)decorationObject);
                    }
                    if (extraIt != null && EndorResultSet.this.allProperties) {
                        String[] propNames = new String[]{EndorResultSet.DUN, EndorResultSet.HUN, EndorResultSet.LUN, EndorResultSet.LEVEL_NUM, EndorResultSet.LEVEL_LABEL, EndorResultSet.PARENT_NUM};
                        int propIdx = 0;
                        while (extraIt.hasNext() && propIdx <= propNames.length - 1) {
                            value.put(propNames[propIdx++], extraIt.next());
                        }
                    }
                    tupleValues.add((Object)value);
                }
                tuple.put(EndorResultSet.TUPLE, (Collection)tupleValues);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert Item instance toJSON\nuseValues: {}\ndisplayValues: {}.", this.useValues, this.displayValues);
                QueryServiceLogger.error((Object)this, (String)EndorResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return tuple;
        }

        public String toString() {
            return this.toJSON().toString();
        }

        public List<Object> getUseValues() {
            return this.useValues;
        }
    }

    public class ItemClass {
        private final String id;
        private String[] attrIdValues;
        private String[] displayValues;
        private String[] idValues;
        private AggregateType[] aggregateValues;
        private String idValue;
        private String[] rsCorrespondingDIIds;
        private Map<String, DataItem> nestedDataItemsMap = new HashMap<String, DataItem>();
        private int[] ordinalPosInRowValue;
        private int calcPosInRowValue = -1;
        private boolean isMin = false;
        private boolean isMax = false;
        private int hashCode = 0;
        private NullBehavior[] nullBehaviors;
        private String[] deflectedSortDataItemNames;
        private int[] postProcessingSortOrders;
        private final Map<Item, Integer> item2Position = new HashMap<Item, Integer>();

        public ItemClass(DataItem currentDataItem) {
            this(currentDataItem.getId(), currentDataItem);
        }

        public ItemClass(String itemClassId, DataItem currentDataItem) {
            this.id = itemClassId;
            if (currentDataItem.getNest().isEmpty()) {
                this.attrIdValues = new String[1];
                this.displayValues = new String[1];
                this.idValues = new String[1];
                this.rsCorrespondingDIIds = new String[1];
                this.ordinalPosInRowValue = new int[1];
                this.aggregateValues = new AggregateType[1];
                this.postProcessingSortOrders = new int[1];
                this.nullBehaviors = new NullBehavior[1];
                this.deflectedSortDataItemNames = new String[1];
                this.attrIdValues[0] = this.inferDataItemAttrId(currentDataItem);
                this.displayValues[0] = this.inferDataItemLabel(currentDataItem, EndorResultSet.this.columns);
                this.rsCorrespondingDIIds[0] = this.inferResultSetDataItemIdValue(currentDataItem);
                this.aggregateValues[0] = currentDataItem.getAggregate();
                SortOrder sortOrder = this.getPostProcessingSortOrder(currentDataItem);
                if (sortOrder != null) {
                    this.postProcessingSortOrders[0] = sortOrder == SortOrder.ASC ? 1 : -1;
                    this.nullBehaviors[0] = this.getNullBehavior(currentDataItem, EndorResultSet.this.columns, this.postProcessingSortOrders[0]);
                    this.deflectedSortDataItemNames[0] = this.getDeflectedSortDataItemName(currentDataItem, EndorResultSet.this.columns);
                    if (currentDataItem.getBinning() != null) {
                        String strNumericBinName;
                        this.deflectedSortDataItemNames[0] = strNumericBinName = DataExecutor.buildNumericBinName(currentDataItem.getId());
                    }
                } else {
                    this.postProcessingSortOrders[0] = 0;
                }
            } else {
                this.ordinalPosInRowValue = new int[currentDataItem.getNest().size()];
                DataItem[] nestedDataItems = (DataItem[])currentDataItem.getNest().stream().map(id -> Arrays.stream(EndorResultSet.this.querySpecDataItems).filter(x -> x.getId().equals(id))).flatMap(Function.identity()).toArray(DataItem[]::new);
                this.nestedDataItemsMap = Arrays.stream(nestedDataItems).collect(Collectors.toMap(DataItem::getId, Function.identity()));
                this.attrIdValues = (String[])Arrays.stream(nestedDataItems).map(x -> this.inferDataItemAttrId((DataItem)x)).toArray(String[]::new);
                this.displayValues = (String[])currentDataItem.getNest().stream().map(id -> this.inferDataItemLabel(this.nestedDataItemsMap.get(id), EndorResultSet.this.columns)).toArray(String[]::new);
                this.idValues = (String[])Arrays.stream(nestedDataItems).map(x -> this.inferDataItemId((DataItem)x)).toArray(String[]::new);
                this.rsCorrespondingDIIds = (String[])currentDataItem.getNest().stream().map(id -> this.inferResultSetDataItemIdValue(this.nestedDataItemsMap.get(id))).toArray(String[]::new);
                this.aggregateValues = (AggregateType[])Arrays.stream(nestedDataItems).map(x -> currentDataItem.getAggregate()).toArray(AggregateType[]::new);
                this.postProcessingSortOrders = new int[nestedDataItems.length];
                this.nullBehaviors = new NullBehavior[nestedDataItems.length];
                this.deflectedSortDataItemNames = new String[nestedDataItems.length];
                for (int i = 0; i < nestedDataItems.length; ++i) {
                    SortOrder sortOrder = this.getPostProcessingSortOrder(nestedDataItems[i]);
                    if (sortOrder != null) {
                        String strNumericBinName;
                        this.postProcessingSortOrders[i] = sortOrder == SortOrder.ASC ? 1 : -1;
                        this.nullBehaviors[i] = this.getNullBehavior(nestedDataItems[i], EndorResultSet.this.columns, this.postProcessingSortOrders[i]);
                        this.deflectedSortDataItemNames[i] = this.getDeflectedSortDataItemName(nestedDataItems[i], EndorResultSet.this.columns);
                        if (nestedDataItems[i].getBinning() == null) continue;
                        this.deflectedSortDataItemNames[i] = strNumericBinName = DataExecutor.buildNumericBinName(nestedDataItems[i].getId());
                        continue;
                    }
                    this.postProcessingSortOrders[i] = 0;
                }
            }
            this.idValue = currentDataItem.getId();
        }

        public String getId() {
            return this.id;
        }

        public SortOrder getPostProcessingSortOrder(DataItem dataItem) {
            if (EndorResultSet.this.multiEdgeSort) {
                for (Action action : dataItem.getSelection()) {
                    Integer priority;
                    SortOrder order;
                    Sort sort = action.getSort();
                    if (sort == null || (order = sort.getType()) == SortOrder.NONE || order == SortOrder.HIERARCHIZE || (priority = sort.getPriority()) == null) continue;
                    return order;
                }
            }
            return null;
        }

        private NullBehavior getNullBehavior(DataItem di, Map<String, ColumnMetadata> columns, int direction) {
            FieldOrdering fieldOrder;
            String itemId;
            ColumnMetadata metadata;
            NullPlacement placement = null;
            if (di.getItemId() != null && (metadata = columns.get(itemId = di.getItemId())) != null && (fieldOrder = metadata.getDefaultSort()) != null) {
                placement = fieldOrder.getNullPlacement();
            }
            if (placement != null) {
                if (direction == -1) {
                    return placement == NullPlacement.FIRST ? NullBehavior.NULL_LAST : NullBehavior.NULL_FIRST;
                }
                return placement == NullPlacement.FIRST ? NullBehavior.NULL_FIRST : NullBehavior.NULL_LAST;
            }
            if (direction == -1) {
                return EndorResultSet.this.olapNullBehavior == NullBehavior.NULL_FIRST ? NullBehavior.NULL_LAST : NullBehavior.NULL_FIRST;
            }
            return EndorResultSet.this.olapNullBehavior;
        }

        private String getDeflectedSortDataItemName(DataItem di, Map<String, ColumnMetadata> columns) {
            FieldOrdering fieldOrder;
            String itemId;
            ColumnMetadata metadata;
            if (di.getItemId() != null && (metadata = columns.get(itemId = di.getItemId())) != null && (fieldOrder = metadata.getDefaultSort()) != null && fieldOrder.getReferencedIdentifier() != null) {
                return TransformationUtils.getDeflectedDataItemName(fieldOrder.getReferencedIdentifier());
            }
            return null;
        }

        public String inferDataItemAttrId(DataItem di) {
            String attrId = di.getItemId();
            return attrId;
        }

        public String inferDataItemId(DataItem di) {
            String attrId = di.getId();
            return attrId;
        }

        public String inferDataItemLabel(DataItem di, Map<String, ColumnMetadata> columns) {
            String itemId;
            ColumnMetadata metadata;
            String label = di.getItemLabel();
            if (EndorResultSet.this.querySpec.getType() == QuerySpec.Type.MINMAX) {
                StringBuilder sb = new StringBuilder();
                sb.append(di.getItemId());
                if (di.getAggregate() != null) {
                    sb.append(EndorResultSet.UNDERSCORE).append(di.getAggregate());
                }
                return sb.toString();
            }
            if (label != null && !label.isEmpty()) {
                return label;
            }
            if (di.getItemId() != null && (metadata = columns.get(itemId = di.getItemId())) != null) {
                return metadata.getLabel();
            }
            return null;
        }

        public String inferResultSetDataItemIdValue(DataItem di) {
            String rsDataItemId = di.getId();
            return rsDataItemId;
        }

        public String removeSuffix(String input, String suffix) {
            if (input == null || suffix == null || input.endsWith(suffix)) {
                return input;
            }
            return input.substring(0, input.lastIndexOf(suffix));
        }

        public Map<Item, Integer> getItemToPositionMap() {
            return this.item2Position;
        }

        public String[] getRSDataItemIDs() {
            return this.rsCorrespondingDIIds;
        }

        public Map<String, DataItem> getNestedDataItemsMap() {
            return this.nestedDataItemsMap;
        }

        public int[] getOrdinalPosInRowValueArray() {
            return this.ordinalPosInRowValue;
        }

        public void setOrdinalPosInRowValueArray(int[] ordinalPos) {
            this.ordinalPosInRowValue = ordinalPos;
        }

        public boolean isMin() {
            return this.isMin;
        }

        public void setIsMin(boolean v) {
            this.isMin = v;
            if (v) {
                this.attrIdValues = (String[])Arrays.stream(this.attrIdValues).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MIN_STR).toArray(String[]::new);
                this.displayValues = (String[])Arrays.stream(this.displayValues).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MIN_STR).toArray(String[]::new);
                this.rsCorrespondingDIIds = (String[])Arrays.stream(this.rsCorrespondingDIIds).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MIN_STR).toArray(String[]::new);
            } else {
                this.attrIdValues = (String[])Arrays.stream(this.attrIdValues).map(e -> this.removeSuffix((String)e, EndorResultSet.MIN_STR)).toArray(String[]::new);
                this.displayValues = (String[])Arrays.stream(this.displayValues).map(e -> this.removeSuffix((String)e, EndorResultSet.MIN_STR)).toArray(String[]::new);
                this.rsCorrespondingDIIds = (String[])Arrays.stream(this.rsCorrespondingDIIds).map(e -> this.removeSuffix((String)e, EndorResultSet.MIN_STR)).toArray(String[]::new);
            }
        }

        public boolean isMax() {
            return this.isMax;
        }

        public void setIsMax(boolean v) {
            this.isMax = v;
            if (this.isMax) {
                this.attrIdValues = (String[])Arrays.stream(this.attrIdValues).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MAX_STR).toArray(String[]::new);
                this.displayValues = (String[])Arrays.stream(this.displayValues).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MAX_STR).toArray(String[]::new);
                this.rsCorrespondingDIIds = (String[])Arrays.stream(this.rsCorrespondingDIIds).map(e -> e + EndorResultSet.UNDERSCORE + EndorResultSet.MAX_STR).toArray(String[]::new);
            } else {
                this.attrIdValues = (String[])Arrays.stream(this.attrIdValues).map(e -> this.removeSuffix((String)e, EndorResultSet.MAX_STR)).toArray(String[]::new);
                this.displayValues = (String[])Arrays.stream(this.displayValues).map(e -> this.removeSuffix((String)e, EndorResultSet.MAX_STR)).toArray(String[]::new);
                this.rsCorrespondingDIIds = (String[])Arrays.stream(this.rsCorrespondingDIIds).map(e -> this.removeSuffix((String)e, EndorResultSet.MAX_STR)).toArray(String[]::new);
            }
        }

        public boolean isMinMax() {
            return this.isMin || this.isMax;
        }

        public String generateCalcExpressionName() {
            return String.format(EndorResultSet.CALCULATION_FORMAT, this.idValue);
        }

        public void setCalcPosInRowValue(int calcPosInRowValue) {
            this.calcPosInRowValue = calcPosInRowValue;
        }

        public int getCalcPosInRowValue() {
            return this.calcPosInRowValue;
        }

        public boolean isAssociatedWithCalcExpression() {
            return this.calcPosInRowValue != -1;
        }

        public int hashCode() {
            if (0 == this.hashCode) {
                this.hashCode = Objects.hashCode((Object[])new Object[]{this.toJSON().toString()});
                if (0 == this.hashCode) {
                    this.hashCode = 1;
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof ItemClass && this.id.equals(((ItemClass)obj).id);
        }

        public Object toJSON() {
            JSONObject header = new JSONObject();
            try {
                JSONArray headerValues = new JSONArray();
                for (int i = 0; i < this.attrIdValues.length; ++i) {
                    AggregateType agg;
                    OrderedJSONObject value = new OrderedJSONObject();
                    value.put(EndorResultSet.USE, (Object)this.attrIdValues[i]);
                    value.put(EndorResultSet.DISPLAY, (Object)this.displayValues[i]);
                    String id = this.idValues[i];
                    if (id != null) {
                        value.put(EndorResultSet.ID, (Object)id);
                    }
                    if ((agg = this.aggregateValues[i]) != null) {
                        value.put(EndorResultSet.AGGREGATE, (Object)agg.toString());
                    }
                    headerValues.add((Object)value);
                }
                header.put(EndorResultSet.HEADER, (Collection)headerValues);
                header.put(EndorResultSet.ID, (Object)this.idValue);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert ItemClass instance toJSON\nattrIdValues: {}\ndisplayValues: {}.", (Object)this.attrIdValues, (Object)this.displayValues);
                QueryServiceLogger.error((Object)this, (String)EndorResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return header;
        }

        public String toString() {
            return this.toJSON().toString();
        }
    }
}

