/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.results;

import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.service.EndorResultPage;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.IResultPage;
import com.ibm.bi.qs.xqe.results.EndorResultSet;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class EndorResultSetReader {
    EndorResultSetReader() {
    }

    public static IResultPage read(IQSResultSet resultSet, int startIndex, int pageSize) {
        OrderedJSONObject wrappedEndorResultSet = new OrderedJSONObject();
        try {
            EndorResultPage results;
            QueryFeedbackWrapper qfbWrapper;
            long begin = System.nanoTime();
            EndorResultSet endorResultSet = (EndorResultSet)resultSet;
            JSONArray dataItems = EndorResultSetReader.constructItemClasses(endorResultSet);
            JSONArray dataPoints = EndorResultSetReader.constructDataPoints(endorResultSet, pageSize, wrappedEndorResultSet);
            OrderedJSONObject meta = new OrderedJSONObject();
            wrappedEndorResultSet.put("version", (Object)"1");
            wrappedEndorResultSet.put("meta", (Map)meta);
            wrappedEndorResultSet.put("dataItems", (Collection)dataItems);
            wrappedEndorResultSet.put("data", (Collection)dataPoints);
            if (endorResultSet.hasNext()) {
                wrappedEndorResultSet.put("hasNext", true);
            }
            if (startIndex > 0) {
                wrappedEndorResultSet.put("hasPrev", true);
            }
            if (null != (qfbWrapper = endorResultSet.getQueryFeedbackWrapper())) {
                meta.put("perf", (Map)new JSONObject());
                if (qfbWrapper.requestedFeedback()) {
                    meta.put("messages", qfbWrapper.feedbackToJSON());
                }
                if (qfbWrapper.requestedColumnInfo()) {
                    meta.put("columnInfo", qfbWrapper.columnListToJSON());
                }
                if (qfbWrapper.requestedUsedParams()) {
                    meta.put("usedParams", qfbWrapper.usedParamsToJSON());
                }
                long end = System.nanoTime();
                qfbWrapper.incrementResultMarshallingTime(end - begin);
                meta.replace((Object)"perf", qfbWrapper.perfToJSON());
            } else {
                wrappedEndorResultSet.remove((Object)"meta");
            }
            EndorResultPage endorResultPage = results = new EndorResultPage(wrappedEndorResultSet, resultSet.getLastModified());
            return endorResultPage;
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
        finally {
            resultSet.dispose();
        }
    }

    private static JSONArray constructItemClasses(EndorResultSet endorResultSet) throws JSONException {
        JSONArray result = new JSONArray();
        DataItem[] querySpecDataItems = endorResultSet.getDataItems();
        Map<String, EndorResultSet.ItemClass> itemClassLookupMap = endorResultSet.getItemClassLookupMap();
        Map<EndorResultSet.ItemClass, List<EndorResultSet.Item>> itemClassesAndItems = endorResultSet.getItemClassesAndItems();
        for (DataItem querySpecDI : querySpecDataItems) {
            if (endorResultSet.isMinMaxResult()) {
                String[] minmaxKeys;
                for (String key : minmaxKeys = EndorResultSet.generateItemClassesMinAndMaxLookupKeys(querySpecDI)) {
                    OrderedJSONObject classItemJSON = EndorResultSetReader.constructItemClass(key, itemClassLookupMap, itemClassesAndItems);
                    result.add((Object)classItemJSON);
                }
                continue;
            }
            OrderedJSONObject classItemJSON = EndorResultSetReader.constructItemClass(querySpecDI.getId(), itemClassLookupMap, itemClassesAndItems);
            result.add((Object)classItemJSON);
        }
        return result;
    }

    private static OrderedJSONObject constructItemClass(String classItemKey, Map<String, EndorResultSet.ItemClass> itemClassLookupMap, Map<EndorResultSet.ItemClass, List<EndorResultSet.Item>> itemClassesAndItems) throws JSONException {
        OrderedJSONObject itemClassJSON = new OrderedJSONObject();
        JSONArray itemsJSON = new JSONArray();
        EndorResultSet.ItemClass itemClass = itemClassLookupMap.get(classItemKey);
        List<EndorResultSet.Item> itemList = itemClassesAndItems.get(itemClass);
        if (itemList != null) {
            for (EndorResultSet.Item i : itemList) {
                itemsJSON.add(i.toJSON());
            }
            itemClassJSON.put("itemClass", itemClass.toJSON());
            itemClassJSON.put("items", (Collection)itemsJSON);
        } else {
            itemClassJSON.put("itemClass", itemClass.toJSON());
        }
        return itemClassJSON;
    }

    private static JSONArray constructDataPoints(EndorResultSet endorResultSet, int pageSize, OrderedJSONObject wrappedEndorResultSet) throws JSONException {
        JSONArray result = new JSONArray();
        List<EndorResultSet.DataPoint> dataPoints = endorResultSet.getDataPoints();
        for (EndorResultSet.DataPoint dataPoint : dataPoints) {
            result.add(dataPoint.toJSON());
        }
        return result;
    }
}

