/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.results;

import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberForOLAP;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.rowInfo.ColumnInfo;
import com.cognos.xqe.util.rowInfo.RowInfo;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.IResultPage;
import com.ibm.bi.qs.xqe.results.QsResultSetReader;
import com.ibm.bi.qs.xqe.results.V5DataItem;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class QsResultSet
implements IQSResultSet {
    private static final String EDGE_ORDINAL = "ord";
    private static final String EDGE_NAME = "name";
    public static final String ITEM_CLASSES = "itemClasses";
    public static final String IDENTIFIERS = "identifiers";
    public static final String ITEMS = "items";
    private static final String HEADER = "h";
    private static final String ITEM_CLASS_ID = "icId";
    private static final String ITEM_CLASS_HEADER_ID = "ihId";
    private static final String TUPLE = "t";
    private static final String DATA_ITEM_NAME = "di";
    private static final String VALUE_SET_NAME = "vs";
    private static final String USE = "u";
    private static final String DISPLAY = "d";
    private static final String DESCRIPTION = "desc";
    private static final String BUSINESSKEY = "bk";
    private static final String DUN = "du";
    private static final String HUN = "hu";
    private static final String LUN = "lu";
    private static final String LEVEL_LABEL = "ll";
    private static final String LEVEL_NUM = "ln";
    private static final String PUN = "pu";
    private static final String PARENT_LEVEL_NUM = "pln";
    private static final String[] CANONICAL_ATTRIBUTE_KEYS = new String[]{"u", "desc", "bk", "du", "hu", "lu", "ln", "ll", "pu", "pln"};
    private static final List<String> CANONICAL_ATTRIBUTE_KEYS_LIST = Arrays.asList(CANONICAL_ATTRIBUTE_KEYS);
    private static final String DECORATION = "deco";
    private static final String VALUE = "v";
    private static final String POINT = "pt";
    public static final String HASNEXT = "hasNext";
    private static final String NULLCHAR = "\u0000";
    private static final String UNICODENULL = "\\u0000";
    private static final String EXCEPTION_STR = "Exception: ";
    private static final String AGGREGATE = "aggregate";
    private static final String EMPTY_STRING = "";
    private static final String STATE = "state";
    private static final String STRING_NULL = "null";
    public static final int REF_DATA_ITEM_ORDINAL = -1;
    private V5DataItem[] selectionDataItems;
    private RSAPIEdge[] rsapiEdges;
    IV5ResultSet v5ResultSet = null;
    private long limit;
    private QueryFeedbackWrapper qfbWrapper;
    private long offset;
    private boolean hasNextDataPoint = false;
    private Date lastModified;
    private boolean isListReport;
    private final List<DataPoint> data;
    private LinkedHashMap<Integer, RsEdge> rsEdges;
    private boolean foundEmptyEdge = false;
    private LinkedHashMap<Integer, List<RowInfo>> resultSetRowInfo;
    private long lastBaseCellOrdinal = -1L;
    private boolean needToSortRowcolumns = false;

    public QsResultSet(QuerySpec qs, IV5ResultSet aV5ResultSet, RSAPIDataset rsDataset, long maxRows, QueryFeedbackWrapper qfb) {
        if (null == aV5ResultSet) {
            throw new IllegalStateException("aV5ResultSet == null.");
        }
        if (null != qfb) {
            qfb.startResultMarshalling();
        }
        this.qfbWrapper = qfb;
        this.lastModified = Date.from(Instant.now());
        this.rsEdges = new LinkedHashMap();
        this.data = new LinkedList<DataPoint>();
        if (null == qfb || !qfb.isValidateMode()) {
            this.v5ResultSet = aV5ResultSet;
            this.selectionDataItems = QsResultSet.extractSelectionDataItems(qs);
            this.rsapiEdges = rsDataset.getEdges();
            this.rsEdges = new LinkedHashMap(this.rsapiEdges.length);
            this.limit = maxRows;
            this.lastModified = rsDataset.getLastModified();
            this.isListReport = rsDataset.isListReport();
            this.offset = 0L;
            for (RSAPIEdge currEdge : this.rsapiEdges) {
                RsEdge aRsEdge = new RsEdge();
                int edgeId = currEdge.getOrdinal();
                aRsEdge.setOrdinal(edgeId);
                aRsEdge.setBaseSize(this.v5ResultSet.getV5EdgeSize(currEdge));
                if (aRsEdge.getBaseSize() == 0L) {
                    this.foundEmptyEdge = true;
                }
                this.rsEdges.put(edgeId, aRsEdge);
            }
            this.resultSetRowInfo = (LinkedHashMap)rsDataset.getRESTRowInfo();
            this.loadEdgeItemClasses();
            this.loadEdgeItems(this.v5ResultSet);
            if (!this.isListReport) {
                this.loadData(this.v5ResultSet);
            }
        }
        if (null != qfb) {
            QueryFeedbackWrapper.retrieveColumnListFeedback(qfb, rsDataset);
            qfb.endResultMarshalling();
        }
    }

    public static V5DataItem[] extractSelectionDataItems(QuerySpec querySpec) {
        Map<Object, Object> queriesMap;
        Object queryValue;
        Map<Object, Object> root;
        Object queriesValue;
        LinkedList<V5DataItem> extractedDataItems = new LinkedList<V5DataItem>();
        Object querySet = querySpec.getV5QuerySet();
        if (querySet instanceof Map && (queriesValue = (root = QsResultSet.extractedMap(querySet)).get("queries")) instanceof Map && (queryValue = (queriesMap = QsResultSet.extractedMap(queriesValue)).get("query")) instanceof List) {
            List<Object> queryList = QsResultSet.extractedList(queryValue);
            for (Object query : queryList) {
                Map<Object, Object> selection;
                Object dataItemValue;
                Map<Object, Object> queryObj;
                Object selectionValue;
                if (!(query instanceof Map) || !((selectionValue = (queryObj = QsResultSet.extractedMap(query)).get("selection")) instanceof Map) || !((dataItemValue = (selection = QsResultSet.extractedMap(selectionValue)).get("dataItem")) instanceof List)) continue;
                List<Object> dataItemList = QsResultSet.extractedList(dataItemValue);
                for (Object dataItem : dataItemList) {
                    Map<Object, Object> dataItemObj;
                    Object attrNameValue;
                    String attrName = null;
                    String attrAggregate = null;
                    String attrExpression = null;
                    if (dataItem instanceof Map && (attrNameValue = (dataItemObj = QsResultSet.extractedMap(dataItem)).get("attr:name")) instanceof String) {
                        Object attrExpressionValue;
                        attrName = (String)attrNameValue;
                        Object attrAggregateValue = dataItemObj.get("attr:aggregate");
                        if (attrAggregateValue != null && attrAggregateValue instanceof String && !((String)attrAggregateValue).isEmpty()) {
                            attrAggregate = (String)attrAggregateValue;
                        }
                        if ((attrExpressionValue = dataItemObj.get("expression")) != null && attrExpressionValue instanceof String && !((String)attrExpressionValue).isEmpty()) {
                            attrExpression = (String)attrExpressionValue;
                        }
                    }
                    if (attrName == null || attrExpression == null) continue;
                    V5DataItem v5DataItem = new V5DataItem(attrName, attrAggregate, attrExpression);
                    extractedDataItems.add(v5DataItem);
                }
            }
        }
        return extractedDataItems.toArray(new V5DataItem[0]);
    }

    private static Map<Object, Object> extractedMap(Object dataItem) {
        return (Map)dataItem;
    }

    private static List<Object> extractedList(Object dataItemValue) {
        return (List)dataItemValue;
    }

    public long getCurrentEdgeSize(Integer edgeOrd) {
        RsEdge aRsEdge = this.rsEdges.get(edgeOrd);
        if (aRsEdge == null) {
            throw new IllegalStateException("Invalid edge ordinal.");
        }
        return aRsEdge.getCurrentSize();
    }

    public RsEdge[] getRsEdges() {
        Set<Integer> keySet = this.rsEdges.keySet();
        RsEdge[] edges = new RsEdge[this.rsEdges.size()];
        int i = 0;
        for (Integer edgeId : keySet) {
            edges[i++] = this.rsEdges.get(edgeId);
        }
        return edges;
    }

    public List<DataPoint> getDataPoints() {
        return this.data;
    }

    public JSONObject getFirstResultValue() {
        List<DataPoint> dataPoints = this.getDataPoints();
        JSONObject firstObject = this.getFirstObject(dataPoints);
        return firstObject;
    }

    private JSONObject getFirstObject(List<DataPoint> dataPoints) {
        Object firstObject;
        JSONArray firstPoint;
        if (dataPoints != null && !dataPoints.isEmpty() && !(firstPoint = dataPoints.get((int)0).point).isEmpty() && (firstObject = firstPoint.get(0)) instanceof JSONObject) {
            return (JSONObject)firstObject;
        }
        return null;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void dispose() {
        if (this.v5ResultSet != null) {
            this.v5ResultSet.release();
        }
        this.rsapiEdges = null;
        this.selectionDataItems = null;
        this.rsEdges.clear();
        this.resultSetRowInfo.clear();
        this.qfbWrapper = null;
    }

    public IPlanningEnvironment getPlanningEnvironment() {
        for (RSAPIEdge currEdge : this.rsapiEdges) {
            if (currEdge == null) continue;
            return currEdge.getDataset().getPlanningEnvironment();
        }
        return null;
    }

    public void loadEdgeItemClasses() {
        for (Integer edgeId : this.resultSetRowInfo.keySet()) {
            List<RowInfo> edgeRows = this.resultSetRowInfo.get(edgeId);
            for (RowInfo currRowInfo : edgeRows) {
                this.loadItemClassForRowInfo(edgeId, currRowInfo);
            }
        }
    }

    private void loadItemClassForRowInfo(Integer edgeId, RowInfo currRowInfo) {
        ArrayList<V5DataItem> dataItems = new ArrayList<V5DataItem>();
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
        block0: for (ColumnInfo currColumnInfo : currRowInfo.getColumnInfos()) {
            if (currColumnInfo.isNonDetail()) continue;
            for (V5DataItem currDataItem : this.selectionDataItems) {
                if (!currDataItem.getName().equals(currColumnInfo.getDataItemId())) continue;
                dataItems.add(currDataItem);
                columnInfos.add(currColumnInfo);
                continue block0;
            }
        }
        V5DataItem[] projDataItems = dataItems.toArray(new V5DataItem[dataItems.size()]);
        ItemClass itemClass = new ItemClass(currRowInfo.getRowId(), columnInfos, projDataItems);
        RsEdge aRsEdge = this.rsEdges.get(edgeId);
        if (aRsEdge == null) {
            throw new IllegalStateException("aRsEdge == null");
        }
        aRsEdge.addItemClass(itemClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEdgeItems(IV5ResultSet v5ResultSet) {
        Set<Integer> ordinalSet = this.rsEdges.keySet();
        Integer[] edgeOrdinals = ordinalSet.toArray(new Integer[ordinalSet.size()]);
        long[] edgeCoordinates = new long[edgeOrdinals.length];
        for (int i = 0; i < edgeCoordinates.length; ++i) {
            edgeCoordinates[i] = 0L;
        }
        int eCordIdx = -1;
        block7: for (RSAPIEdge currEdge : this.rsapiEdges) {
            Integer currOrdinal = currEdge.getOrdinal();
            ++eCordIdx;
            XIterator edgeIterator = v5ResultSet.getV5EdgeIterator(currEdge);
            RowValue currentRow = null;
            RsEdge currRsEdge = this.rsEdges.get(currOrdinal);
            try {
                currentRow = (RowValue)edgeIterator.next();
                ROLAPContext.queryEnter((IExecutionEnvironment)((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()));
                boolean needToRemoveCubeName = false;
                try {
                    needToRemoveCubeName = ROLAPContext.setCurrentCubeName((IPlanningEnvironment)this.getPlanningEnvironment());
                    while (currentRow != null) {
                        long dataPointOrdinal = -1L;
                        long expectedDatapointNum = this.getExpectedDataPointNumberForKnownItems();
                        if (!this.foundEmptyEdge) {
                            dataPointOrdinal = this.computeDataPointOrdinal(edgeCoordinates, currOrdinal);
                            if (!this.hasNextDataPoint && dataPointOrdinal > this.offset + this.limit - 1L) {
                                this.hasNextDataPoint = true;
                                if (expectedDatapointNum >= this.limit) {
                                    if (currRsEdge.getBaseSize() - 1L > currRsEdge.getCurrentSize()) {
                                        currRsEdge.setHasNextItem(true);
                                    }
                                    continue block7;
                                }
                            }
                        }
                        if (dataPointOrdinal >= this.offset || this.foundEmptyEdge) {
                            this.processRowValue(currEdge, currRsEdge, currentRow);
                        }
                        if (this.hasNextDataPoint) {
                            if (currRsEdge.getBaseSize() > currRsEdge.getCurrentSize()) {
                                currRsEdge.setHasNextItem(true);
                            }
                            continue block7;
                        }
                        currentRow = (RowValue)edgeIterator.next();
                        if (currentRow == null) continue;
                        edgeCoordinates[eCordIdx] = currRsEdge.getCurrentSize();
                    }
                }
                finally {
                    ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
                    ROLAPContext.queryExit((IExecutionEnvironment)((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()));
                }
            }
            finally {
                edgeIterator.release();
                edgeIterator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(IV5ResultSet v5ResultSet) {
        XScrollableCellIterator scrCellIterator = v5ResultSet.getScrollableV5CellIterator();
        try {
            for (long dataPointOrdinal = this.offset + 0L; dataPointOrdinal < this.offset + this.limit; ++dataPointOrdinal) {
                if (dataPointOrdinal > this.getLastBaseCellOrdinal()) {
                    break;
                }
                ICell cell = scrCellIterator.byOrdinal(dataPointOrdinal);
                if (cell == null) continue;
                if (dataPointOrdinal == this.offset + this.limit) {
                    this.hasNextDataPoint = true;
                    break;
                }
                NullValue value = NullValue.NULLVALUE;
                value = cell.getValue();
                if (value == null) continue;
                DataPoint dataPoint = new DataPoint();
                JSONArray dataPointValues = new JSONArray();
                try {
                    NullValue aValue = NullValue.NULLVALUE;
                    if (value instanceof ContextValue) {
                        ContextValue contextValue = (ContextValue)value;
                        aValue = (Value)contextValue.getValue();
                    } else if (value instanceof Value) {
                        aValue = (Value)value;
                    }
                    if (aValue == NullValue.NULLVALUE || aValue.getState() == ValueState.NULL) continue;
                    Set<Integer> ordinalSet = this.rsEdges.keySet();
                    long[] edgeCoordinates = new long[ordinalSet.size()];
                    this.getEdgeCoordinates(dataPointOrdinal, edgeCoordinates);
                    for (int i = 0; i < edgeCoordinates.length; ++i) {
                        dataPointValues.put(edgeCoordinates[i]);
                    }
                    OrderedJSONObject metricJSON = new OrderedJSONObject();
                    Object aJSONValue = aValue.toJSON();
                    this.putValueAndState((JSONObject)metricJSON, aJSONValue, (Value)aValue);
                    dataPointValues.put((Map)metricJSON);
                }
                catch (JSONException e) {
                    QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
                }
                if (dataPointValues.isEmpty()) continue;
                dataPoint.setValue(dataPointValues);
                this.data.add(dataPoint);
            }
        }
        finally {
            scrCellIterator.reset();
            scrCellIterator.release();
            scrCellIterator = null;
        }
    }

    private long getExpectedDataPointNumberForKnownItems() {
        long eNDP = 1L;
        Set<Integer> keySet = this.rsEdges.keySet();
        for (Integer edgeId : keySet) {
            long es;
            RsEdge rsE = this.rsEdges.get(edgeId);
            long currEdgeSize = 1L;
            if (rsE != null && (es = rsE.getCurrentSize()) > 0L) {
                currEdgeSize = es;
            }
            eNDP *= currEdgeSize;
        }
        return eNDP;
    }

    private RowInfo findRowInfo(int edgeId, RowValue currentRow) {
        if (this.resultSetRowInfo == null) {
            return null;
        }
        List<RowInfo> edgeRowInfos = this.resultSetRowInfo.get(edgeId);
        if (edgeRowInfos == null) {
            throw new IllegalStateException("edgeRowInfos == null");
        }
        RowInfo rowInfo = null;
        RowInfo currRowInfo = new RowInfo(-1);
        ArrayList<IHierarchy> raggedUnbalancedHierarchies = new ArrayList<IHierarchy>();
        for (IValue colValue : currentRow.getColumns()) {
            IHierarchy hier;
            ContextBase cb = (ContextBase)colValue;
            int dataItemOrdinal = cb.getDataItemIndex();
            RSAPIEdgeRowset rowSet = (RSAPIEdgeRowset)cb.getRowset();
            if (cb instanceof ContextMember && ((ContextMember)cb).getHierarchy() != null && ((hier = ((ContextMember)cb).getHierarchy()).isRagged() || hier.isUnbalanced())) {
                raggedUnbalancedHierarchies.add(hier);
            }
            String dataItemId = null;
            dataItemId = -1 == dataItemOrdinal ? rowSet.getRefDataItem().getName() : rowSet.getDataItem(dataItemOrdinal).getName();
            ColumnInfo currColumnInfo = new ColumnInfo(rowSet.getRowsetId(), dataItemOrdinal, dataItemId, rowSet.getName());
            currColumnInfo.setFooter(rowSet.isFooterRowset());
            currColumnInfo.setHeader(rowSet.isHeaderRowset());
            currRowInfo.addLastColumnInfo(currColumnInfo);
        }
        for (RowInfo aRowInfo : edgeRowInfos) {
            if (!aRowInfo.equals((Object)currRowInfo)) continue;
            rowInfo = aRowInfo;
            break;
        }
        if (rowInfo == null && !raggedUnbalancedHierarchies.isEmpty()) {
            int newId = edgeRowInfos.get(edgeRowInfos.size() - 1).getRowId();
            currRowInfo.setRowId(++newId);
            this.loadItemClassForRowInfo(edgeId, currRowInfo);
            edgeRowInfos.add(currRowInfo);
            this.resultSetRowInfo.replace(edgeId, edgeRowInfos);
            rowInfo = currRowInfo;
        }
        return rowInfo;
    }

    private void processRowValue(RSAPIEdge rsapiEdge, RsEdge aRsEdge, RowValue currentRow) {
        ContextBase firstColumn = (ContextBase)currentRow.getColumns()[0];
        int edgeOrdinal = firstColumn.getRowset().getEdge().getOrdinal();
        RowValue sortedRow = currentRow;
        RowInfo currentRowInfo = null;
        if (this.needToSortRowcolumns) {
            sortedRow = sortedRow.copyWithSortedByRSAPIInfo();
            currentRowInfo = this.findRowInfo(edgeOrdinal, sortedRow);
        } else {
            currentRowInfo = this.findRowInfo(edgeOrdinal, sortedRow);
            if (currentRowInfo == null) {
                this.needToSortRowcolumns = true;
                sortedRow = sortedRow.copyWithSortedByRSAPIInfo();
                currentRowInfo = this.findRowInfo(edgeOrdinal, sortedRow);
            }
        }
        if (currentRowInfo == null) {
            throw new IllegalStateException("currentRowInfo == null");
        }
        Item item = this.constructItem(rsapiEdge, currentRowInfo, sortedRow);
        ItemClass theItemClass = null;
        if (aRsEdge == null) {
            Set<Integer> edgeIds = this.rsEdges.keySet();
            block0: for (Integer id : edgeIds) {
                RsEdge rsEdge = this.rsEdges.get(id);
                for (ItemClass itemClass : rsEdge.getItemClasses()) {
                    if (itemClass.getId() != QsResultSet.createItemClassId(currentRowInfo.getRowId(), currentRowInfo.getColumnInfos())) continue;
                    aRsEdge = rsEdge;
                    theItemClass = itemClass;
                    continue block0;
                }
            }
        } else {
            for (ItemClass itemClass : aRsEdge.getItemClasses()) {
                if (itemClass.getId() != QsResultSet.createItemClassId(currentRowInfo.getRowId(), currentRowInfo.getColumnInfos())) continue;
                theItemClass = itemClass;
                break;
            }
        }
        if (aRsEdge != null && aRsEdge.getName() == null) {
            aRsEdge.setName(rsapiEdge.getName());
        }
        aRsEdge.addItem(item, theItemClass);
    }

    private void putValueAndState(JSONObject metricJSON, Object aJSONValue, Value value) throws JSONException {
        metricJSON.put(VALUE, aJSONValue);
        if (value != null && value.getState() != ValueState.OK && value.getState() != ValueState.CALC) {
            JSONObject decorationObject = new JSONObject();
            decorationObject.put(STATE, (Object)value.getState().toString());
            metricJSON.put(DECORATION, (Map)decorationObject);
        }
    }

    private Item constructItem(RSAPIEdge rsapiEdge, RowInfo rowInfo, RowValue rowValue) {
        Item item = new Item();
        int columnPos = -1;
        for (ColumnInfo currColumnInfo : rowInfo.getColumnInfos()) {
            ++columnPos;
            V5DataItem projDI = null;
            for (V5DataItem currDI : this.selectionDataItems) {
                if (!currDI.getName().equals(currColumnInfo.getDataItemId())) continue;
                projDI = currDI;
                break;
            }
            RSAPIDataItem dataItem = null;
            int ordinalPos = -1;
            RSAPIUsage usage = RSAPIUsage.UNKNOWN;
            RSAPIEdgeRowset rowset = null;
            if (currColumnInfo != null) {
                ordinalPos = currColumnInfo.getDataItemOrdinal();
                rowset = rsapiEdge.getRowset(currColumnInfo.getRowSetId());
                dataItem = ordinalPos != -1 ? rowset.getDataItem(ordinalPos) : rowset.getRefDataItem();
                usage = dataItem.getUsage();
            }
            if (this.isListReport && RSAPIUsage.ATTRIBUTE == usage && projDI != null && "count".equals(projDI.getAggregate())) {
                usage = RSAPIUsage.FACT;
            }
            if (!this.isListReport && currColumnInfo.isNonDetail() && ordinalPos != -1 && rowset.getRefDataItem() != null && rowset.getDataItems() != null && rowset.getDataItems().length > 0 && !rowset.getDataItem(ordinalPos).isGroupbodyMeasure()) {
                this.processAttributeGroupBody(rowValue, item, columnPos, dataItem);
                continue;
            }
            if (!this.isListReport || usage != RSAPIUsage.FACT) {
                IValue columnValue = rowValue.getColumn(columnPos);
                if (currColumnInfo == null) {
                    this.createTupleValue(currColumnInfo, null, null, item, dataItem, (RSAPIRowset)rowset);
                    continue;
                }
                if (columnValue instanceof ContextValue) {
                    Value value = (Value)((ContextValue)columnValue).getValue();
                    Object aJSONValue = null;
                    aJSONValue = value instanceof TextValue && !value.isNull() ? value.toString().replace(NULLCHAR, UNICODENULL) : value.toJSON();
                    if (aJSONValue == null) {
                        try {
                            OrderedJSONObject metricJSON = new OrderedJSONObject();
                            this.putValueAndState((JSONObject)metricJSON, aJSONValue, value);
                            this.createTupleValue(metricJSON, item, dataItem, (RSAPIRowset)rowset);
                        }
                        catch (JSONException e) {
                            QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
                        }
                        continue;
                    }
                    if (usage != RSAPIUsage.FACT) {
                        String usevalue = null;
                        TupleValue tupleValue = null;
                        if (usage == RSAPIUsage.UNKNOWN || this.isMoserCalculation(dataItem)) {
                            usevalue = value.getV5formattedString();
                            tupleValue = this.createTupleValue(currColumnInfo, usevalue, usevalue, item, dataItem, (RSAPIRowset)rowset);
                        } else {
                            usevalue = this.getMUNforFacet(dataItem, (ContextValue)columnValue).replace(NULLCHAR, UNICODENULL);
                            tupleValue = this.createTupleValue(currColumnInfo, usevalue, value, item, dataItem, (RSAPIRowset)rowset);
                        }
                        this.processCanonicalPropertiesForRelational((ContextBase)((ContextValue)columnValue), tupleValue, currColumnInfo);
                        continue;
                    }
                    String errorFormat = "Unexpected case. aJSONValue = %s, usage %s.";
                    String usageValue = usage == null ? STRING_NULL : usage.toString();
                    throw new IllegalStateException(String.format("Unexpected case. aJSONValue = %s, usage %s.", aJSONValue.toString(), usageValue));
                }
                if (columnValue instanceof ContextMember) {
                    TupleValue tupleValue;
                    String usevalue;
                    ContextMember ctxMember = (ContextMember)columnValue;
                    if (usage == RSAPIUsage.UNKNOWN || this.isMoserNonFactNonFacetEnableCalculation(dataItem, usage)) {
                        usevalue = ctxMember.getName();
                        tupleValue = this.createTupleValue(currColumnInfo, usevalue, usevalue, item, dataItem, (RSAPIRowset)rowset);
                        this.processCanonicalPropertiesForRelational((ContextBase)ctxMember, tupleValue, currColumnInfo);
                        continue;
                    }
                    if (usage == RSAPIUsage.IDENTIFIER && dataItem.getModelCalculationID() != null) {
                        usevalue = ctxMember.getName();
                        tupleValue = this.createTupleValue(currColumnInfo, usevalue, usevalue, item, dataItem, (RSAPIRowset)rowset);
                        this.processCanonicalPropertiesForRelational((ContextBase)ctxMember, tupleValue, currColumnInfo);
                        continue;
                    }
                    if (null != QsResultSet.getFacet(dataItem)) {
                        this.processContextMemberForFacet(item, currColumnInfo, dataItem, ctxMember);
                        continue;
                    }
                    this.processContextMember(dataItem, currColumnInfo, item, ctxMember, projDI);
                    continue;
                }
                this.createTupleValue(currColumnInfo, null, null, item, dataItem, (RSAPIRowset)rowset);
                continue;
            }
            OrderedJSONObject metricJSON = new OrderedJSONObject();
            try {
                NullValue aValue = NullValue.NULLVALUE;
                IValue value = rowValue.getColumn(columnPos);
                if (value instanceof ContextValue) {
                    aValue = (Value)((ContextValue)value).getValue();
                    ContextValue contextValue = (ContextValue)value;
                    RSAPIDataItem[] rsapiDataItems = contextValue.getRowset().getDataItems();
                    if (rsapiDataItems != null && rsapiDataItems.length > 0 && rsapiDataItems[contextValue.getDataItemIndex()] != null && rsapiDataItems[contextValue.getDataItemIndex()].isNotApplicable()) {
                        ((Value)contextValue.getValue()).setState(ValueState.NOT_APPLICABLE);
                    }
                    aValue = (Value)contextValue.getValue();
                }
                Object aJSONValue = aValue.toJSON();
                this.putValueAndState((JSONObject)metricJSON, aJSONValue, (Value)aValue);
                this.createTupleValue(metricJSON, item, dataItem, (RSAPIRowset)rowset);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
            }
        }
        item.makeImmutable();
        return item;
    }

    public boolean isMoserNonFactNonFacetEnableCalculation(RSAPIDataItem dataItem, RSAPIUsage usage) {
        return this.isMoserCalculation(dataItem) && usage != RSAPIUsage.FACT && ((MoserQueryItem)dataItem.getModelReference()).getFacet() != null && !((MoserQueryItem)dataItem.getModelReference()).getFacet().isEnabled();
    }

    public boolean isMoserCalculation(RSAPIDataItem dataItem) {
        if (dataItem.getModelReference() != null && dataItem.getModelReference() instanceof MoserQueryItem) {
            MoserQueryItem moserQueryItem = (MoserQueryItem)dataItem.getModelReference();
            return MoserModuleUtil.isMoserCalculation((MoserQueryItem)moserQueryItem);
        }
        return false;
    }

    private void processAttributeGroupBody(RowValue rowValue, Item item, int columnPos, RSAPIDataItem dataItem) {
        IValue value = rowValue.getColumn(columnPos);
        if (!(value instanceof ContextMember)) {
            throw new IllegalStateException("value is not an ContextMember");
        }
        ContextMember ctxMember = (ContextMember)value;
        TupleValue refDataItemValue = item.getLastTupleValue();
        Object propertyValue = null;
        if (dataItem.getDataType() == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE) {
            propertyValue = ctxMember.getDescription();
        } else {
            String propertyName = dataItem.getPropertyName();
            if (propertyName != null) {
                propertyValue = propertyName.equalsIgnoreCase("description") ? ctxMember.getDescription() : this.getMemberPropertyValue(ctxMember, propertyName);
            }
        }
        NullValue aValue = null;
        Object aJSONValue = null;
        if (propertyValue != null) {
            if (propertyValue instanceof IValue) {
                aValue = NullValue.NULLVALUE;
                aValue = propertyValue instanceof ContextValue ? (Value)((ContextValue)propertyValue).getValue() : (Value)propertyValue;
                aJSONValue = aValue.toJSON();
            } else {
                aJSONValue = propertyValue;
            }
        }
        try {
            if (aJSONValue == null) {
                aValue = NullValue.NULLVALUE;
            }
            OrderedJSONObject metricJSON = new OrderedJSONObject();
            this.putValueAndState((JSONObject)metricJSON, aJSONValue, (Value)aValue);
            refDataItemValue.addOptionalAttribute(dataItem.getName(), metricJSON);
        }
        catch (JSONException e) {
            QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
        }
    }

    private static boolean isMFWQueryItemOfQuerySubject(IMetadata md) {
        return md instanceof IQueryItemOfQuerySubject && !(md instanceof MoserQueryItem);
    }

    private static IFacet getFacet(RSAPIDataItem dataItem) {
        IMetadata md = dataItem.getModelReference();
        if (!(md instanceof MoserQueryItem)) {
            return null;
        }
        MoserQueryItem moserQI = (MoserQueryItem)md;
        return moserQI.getFacet();
    }

    protected String getMUNforRelational(RSAPIDataItem dataItem, ContextMember contextMember) {
        if (dataItem == null || contextMember == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dataItem.getQueryItemModelId());
        if (contextMember.getDimension() != null && !contextMember.getDimension().isMeasuresDimension()) {
            sb.append("->");
            sb.append(UniqueNameGenerator.createSingleNamePart((String)contextMember.getName()));
        }
        return sb.toString();
    }

    protected String getMUNforFacet(RSAPIDataItem dataItem, ContextMember contextMember) {
        if (dataItem == null || contextMember == null) {
            return null;
        }
        IMetadata md = dataItem.getModelReference();
        if (md instanceof MoserQueryItem) {
            StringBuilder sb = new StringBuilder();
            MoserQueryItem moserQI = (MoserQueryItem)md;
            sb.append(moserQI.getQuerySubject().getName());
            sb.append(".");
            sb.append(moserQI.getName());
            if (contextMember.getDimension() != null && !contextMember.getDimension().isMeasuresDimension()) {
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)contextMember.getName()));
            }
            return sb.toString();
        }
        return null;
    }

    protected String getMUNforFacet(RSAPIDataItem dataItem, ContextValue contextValue) {
        Value v = (Value)contextValue.getValue();
        if (v.getState() == ValueState.OK) {
            StringBuilder sb = new StringBuilder();
            IMetadata md = dataItem.getModelReference();
            if (md instanceof MoserQueryItem) {
                MoserQueryItem moserQI = (MoserQueryItem)md;
                sb.append(moserQI.getQuerySubject().getName());
                sb.append(".");
                sb.append(moserQI.getName());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)v.getV5formattedString()));
            } else {
                sb.append(dataItem.getQueryItemModelId());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)v.getV5formattedString()));
            }
            return sb.toString();
        }
        if (v.getState() == ValueState.NULL) {
            StringBuilder sb = new StringBuilder();
            IMetadata md = dataItem.getModelReference();
            if (md instanceof MoserQueryItem) {
                MoserQueryItem moserQI = (MoserQueryItem)md;
                sb.append(moserQI.getQuerySubject().getName());
                sb.append(".");
                sb.append(moserQI.getName());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart(null));
            } else {
                sb.append(dataItem.getQueryItemModelId());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart(null));
            }
            return sb.toString();
        }
        return null;
    }

    private String getContextMemberDisplayValue(ContextMember ctxMember) {
        Value businessKeyValue;
        Value businessKey;
        ICube cube;
        if (ctxMember.getMember() instanceof DMRMember && (cube = ctxMember.getMember().getDimension().getCube()) != null && cube instanceof RelationalCrosstabCube && (businessKey = ctxMember.getMember().getBusinessKeyValue()) != null && businessKey.isOK() && businessKey instanceof DateTimeValue) {
            return businessKey.getString();
        }
        String caption = ctxMember.getCaption();
        if (caption != null && caption.equals(EMPTY_STRING) && ((businessKeyValue = ctxMember.getBusinessKeyValue()) == null || businessKeyValue.getState() == ValueState.NULL)) {
            return null;
        }
        if (caption != null && caption.equals(ctxMember.getCalculatedMemberCaption()) && caption.startsWith("defaultMember_") && ctxMember.getMember() != null && ctxMember.getMember().getCaption() != null && !ctxMember.getMember().getCaption().isEmpty()) {
            caption = ctxMember.getMember().getCaption();
        }
        return caption;
    }

    private void processContextMember(RSAPIDataItem dataItem, ColumnInfo cInfo, Item currentItem, ContextMember ctxMember, V5DataItem projDI) {
        StringBuilder sb;
        TupleValue tValue = null;
        String useValue = null;
        Object displayValue = null;
        String alias = cInfo.getMoserAlias();
        if (alias == null) {
            alias = EMPTY_STRING;
        } else if (!alias.isEmpty()) {
            alias = alias + ".";
        }
        String v5UniqueName = null;
        IMetadata modRef = dataItem.getModelReference();
        RSAPIUsage usage = dataItem.getUsage();
        boolean isRelational = QsResultSet.isMFWQueryItemOfQuerySubject(modRef);
        ICube cube = ctxMember.getDimension().getCube();
        boolean isRelationalCrosstab = cube != null && cube instanceof RelationalCrosstabCube;
        DMRCase dmrCase = DMRCase.getDMRCase(ctxMember, modRef, usage);
        if (isRelationalCrosstab) {
            if (dmrCase == DMRCase.DMRMEMBER_RAWDATA && usage == RSAPIUsage.IDENTIFIER && dataItem.getOrgUsage() == RSAPIUsage.UNKNOWN) {
                v5UniqueName = ctxMember.getBaseMember().getCaptionValue().getV5formattedString();
            } else if (modRef == null && dataItem.getModelCalculationID() != null) {
                sb = new StringBuilder(dataItem.getModelCalculationID());
                sb.append("->");
                sb.append(UniqueNameGenerator.createSingleNamePart((String)ctxMember.getCaption()));
                v5UniqueName = sb.toString();
            }
        }
        if (v5UniqueName == null) {
            if (isRelational) {
                v5UniqueName = this.getMUNforRelational(dataItem, ctxMember);
            } else if (dmrCase == DMRCase.DMRMEASUE_MFWMEASURE) {
                v5UniqueName = ((IMeasure)modRef).getV5MUN();
            } else if (dmrCase == DMRCase.DMRMEASUE_MEASUREWRAPPER) {
                v5UniqueName = ((MeasureWrapper)modRef).getV5UniqueName();
            } else if (dmrCase == DMRCase.DMRMEMBER_PROPERTY) {
                v5UniqueName = null;
            } else if (dmrCase == DMRCase.DMRMEMBEROLAP) {
                sb = new StringBuilder(((ILevel)modRef).getV5UniqueName());
                sb.append("->");
                sb.append(UniqueNameParser.undoEscapedSquareBracket((String)ctxMember.getMember().getName()));
                v5UniqueName = sb.toString();
            } else {
                v5UniqueName = isRelationalCrosstab && dmrCase == DMRCase.DMRMEMBER_ATTRIBUTE ? ctxMember.getV5UniqueName() : ctxMember.getV5UniqueName();
            }
        }
        useValue = usage == RSAPIUsage.ATTRIBUTE && !isRelational ? projDI.getExpression() : v5UniqueName;
        if (alias != null && !alias.isEmpty() && useValue != null && !useValue.startsWith(alias)) {
            useValue = alias + useValue;
        }
        String propertyName = this.getPropertyName(dataItem);
        displayValue = dataItem.getDataType() == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE ? ctxMember.getDescription() : (propertyName != null ? (propertyName.equalsIgnoreCase("description") ? ctxMember.getDescription() : this.getMemberPropertyValue(ctxMember, propertyName)) : this.getContextMemberDisplayValue(ctxMember));
        if (propertyName == null & ctxMember.isCalculatedMember() && (isRelational || isRelationalCrosstab)) {
            useValue = (String)displayValue;
        }
        if ((tValue = this.createTupleValue(cInfo, useValue, displayValue, currentItem, dataItem, ctxMember.getRowset())) != null) {
            this.processGroupBodyMeasures(ctxMember, tValue);
            if (isRelational || isRelationalCrosstab) {
                this.processCanonicalPropertiesForRelational((ContextBase)ctxMember, tValue, cInfo);
            } else {
                this.processCanonicalProperties(dataItem, ctxMember, tValue, alias, cInfo);
            }
        }
    }

    private void processContextMemberForFacet(Item item, ColumnInfo cInfo, RSAPIDataItem dataItem, ContextMember ctxMember) {
        String displayValue;
        String usevalue = this.getMUNforFacet(dataItem, ctxMember);
        TupleValue tValue = this.createTupleValue(cInfo, usevalue, displayValue = this.getContextMemberDisplayValue(ctxMember), item, dataItem, ctxMember.getRowset());
        if (tValue != null) {
            this.processGroupBodyMeasures(ctxMember, tValue);
            this.processCanonicalPropertiesForRelational((ContextBase)ctxMember, tValue, cInfo);
        }
    }

    private void processCanonicalPropertiesForRelational(ContextBase ctxBase, TupleValue tValue, ColumnInfo cInfo) {
        if (tValue == null || ctxBase == null || cInfo == null) {
            return;
        }
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)ctxBase.getRowset();
        if (rowset == null) {
            return;
        }
        DataType[] requestedProperties = null;
        if (cInfo.getDataItemOrdinal() == -1 && rowset.getRefDataItemProperties() != null && rowset.getRefDataItemProperties().length > 0) {
            requestedProperties = rowset.getRefDataItemProperties();
        } else if (cInfo.getDataItemOrdinal() != -1 && rowset.getGroupBodyProperties() != null && rowset.getGroupBodyProperties().length > 0) {
            requestedProperties = rowset.getGroupBodyProperties();
        }
        if (requestedProperties == null) {
            return;
        }
        RSAPIDataItem dataItem = rowset.getRefDataItem();
        boolean isCalculatedAttribute = dataItem != null && RSAPIUsage.ATTRIBUTE.equals((Object)dataItem.getUsage()) && dataItem.getModelCalculationID() != null;
        for (DataType dataType : requestedProperties) {
            if (null == dataType) continue;
            String key = null;
            Object attribute = null;
            if (dataType.getTypeName().equals("memberUniqueName")) {
                key = USE;
                attribute = isCalculatedAttribute ? tValue.getDisplayValue() : tValue.getUseValue();
                if (attribute.equals(STRING_NULL)) {
                    attribute = null;
                }
            } else if (dataType.getTypeName().equals("businessKey")) {
                key = BUSINESSKEY;
                if (ctxBase instanceof ContextMember) {
                    attribute = ((ContextMember)ctxBase).getBusinessKeyValue();
                } else if (ctxBase instanceof ContextValue && ctxBase.getContextMember() != null) {
                    attribute = ctxBase.getContextMember().getBusinessKeyValue();
                }
            }
            if (key == null || attribute == null || attribute.equals(NullValue.NULLVALUE) || attribute.equals(StringValue.NULL_VALUE)) continue;
            tValue.addOptionalAttribute(key, attribute);
        }
    }

    private void processCanonicalProperties(RSAPIDataItem dataItem, ContextMember ctxMember, TupleValue tValue, String alias, ColumnInfo cInfo) {
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)ctxMember.getRowset();
        if (tValue == null || rowset == null || cInfo == null) {
            return;
        }
        DataType[] requestedProperties = null;
        if (cInfo.getDataItemOrdinal() == -1 && rowset.getRefDataItemProperties() != null && rowset.getRefDataItemProperties().length > 0) {
            requestedProperties = rowset.getRefDataItemProperties();
        } else if (cInfo.getDataItemOrdinal() != -1 && rowset.getGroupBodyProperties() != null && rowset.getGroupBodyProperties().length > 0) {
            requestedProperties = rowset.getGroupBodyProperties();
        }
        if (requestedProperties == null) {
            return;
        }
        IMetadata modRef = dataItem.getModelReference();
        RSAPIUsage usage = dataItem.getUsage();
        DMRCase dmrCase = DMRCase.getDMRCase(ctxMember, modRef, usage);
        ILevel theLevel = null;
        IHierarchy theHierarchy = null;
        IDimension theDimension = null;
        IMember theParent = null;
        if (dmrCase == DMRCase.DMRMEASUE_MFWMEASURE) {
            theHierarchy = ((IMeasure)modRef).getHierarchy();
            theDimension = theHierarchy.getDimension();
        } else if (dmrCase == DMRCase.DMRMEASUE_MEASUREWRAPPER) {
            theDimension = ((MeasureWrapper)modRef).getModelDimension();
            theHierarchy = theDimension.getDefaultHierarchy();
        } else if (dmrCase == DMRCase.DMRMEMBER_PROPERTY) {
            theLevel = (ILevel)modRef;
            theHierarchy = theLevel.getHierarchy();
            theDimension = theHierarchy.getDimension();
        } else if (dmrCase == DMRCase.DMRMEMBEROLAP) {
            theLevel = (ILevel)modRef;
            theHierarchy = theLevel.getHierarchy();
            theDimension = theHierarchy.getDimension();
            theParent = ctxMember.getMember().getParent();
        } else if (dmrCase == DMRCase.CALCULATEDMEMBER_MFWLEVEL) {
            theLevel = (ILevel)modRef;
            theHierarchy = theLevel.getHierarchy();
            theDimension = theHierarchy.getDimension();
        } else {
            if (usage != RSAPIUsage.FACT) {
                theLevel = ctxMember.getLevel();
            }
            theHierarchy = ctxMember.getHierarchy();
            theDimension = ctxMember.getDimension();
            theParent = ctxMember.getMember().getParent();
        }
        for (DataType dataType : requestedProperties) {
            if (null == dataType) continue;
            String key = null;
            Object attribute = null;
            if (dataType.getTypeName().equals("memberUniqueName")) {
                key = USE;
                attribute = tValue.getUseValue();
            } else {
                if (dataType.getTypeName().equals("memberCaption")) continue;
                if (dataType.getTypeName().equals("memberDescription")) {
                    key = DESCRIPTION;
                    attribute = ctxMember.getDescription();
                } else if (usage != RSAPIUsage.FACT && !ctxMember.isCalculatedMember() && dataType.getTypeName().equals("businessKey")) {
                    key = BUSINESSKEY;
                    attribute = ctxMember.getBusinessKeyValue();
                } else if (dataType.getTypeName().equals("dimensionUniqueName")) {
                    key = DUN;
                    attribute = theDimension.getV5UniqueName();
                    if (attribute != null && !((String)attribute).isEmpty()) {
                        attribute = alias + attribute;
                    }
                } else if (dataType.getTypeName().equals("hierarchyUniqueName")) {
                    key = HUN;
                    attribute = theHierarchy.getV5UniqueName();
                    if (attribute != null && !((String)attribute).isEmpty()) {
                        attribute = alias + attribute;
                    }
                } else if (theLevel != null && dataType.getTypeName().equals("levelUniqueName")) {
                    key = LUN;
                    attribute = theLevel.getV5UniqueName();
                    if (attribute != null && !((String)attribute).isEmpty()) {
                        attribute = alias + attribute;
                    }
                } else if (theLevel != null && dataType.getTypeName().equals("levelNumber")) {
                    key = LEVEL_NUM;
                    attribute = theLevel.getIndex();
                } else if (theLevel != null && dataType.getTypeName().equals("levelLabel")) {
                    key = LEVEL_LABEL;
                    attribute = theLevel.getName();
                } else if (!ctxMember.isCalculatedMember() && dmrCase != DMRCase.DMRMEMBER_PROPERTY && dataType.getTypeName().equals("parentUniqueName")) {
                    key = PUN;
                    attribute = theParent != null ? theParent.getV5UniqueName() : ctxMember.getParentObjectUniqueName();
                    if (attribute != null && !((String)attribute).isEmpty()) {
                        attribute = alias + attribute;
                    }
                } else if (usage != RSAPIUsage.FACT && !ctxMember.isCalculatedMember() && dmrCase != DMRCase.DMRMEMBER_PROPERTY && dataType.getTypeName().equals("parentLevelNumber")) {
                    key = PARENT_LEVEL_NUM;
                    if (theParent != null) {
                        ILevel pLevel = theParent.getLevel();
                        if (pLevel != null) {
                            attribute = pLevel.getIndex();
                        }
                    } else if (theLevel != null && theLevel.getIndex() != 0) {
                        attribute = ctxMember.getParentLevelNumber();
                    }
                } else if (dataType.getTypeName().equals("currencyCode") || dataType.getTypeName().equals("rollupType") || dataType.getTypeName().equals("queryItemModelID")) continue;
            }
            if (key == null || attribute == null || attribute.equals(NullValue.NULLVALUE) || attribute.equals(StringValue.NULL_VALUE)) continue;
            tValue.addOptionalAttribute(key, attribute);
        }
    }

    private void processGroupBodyMeasures(ContextMember ctxMember, TupleValue tValue) {
        if (ctxMember.hasGroupBodyMeasures()) {
            for (ContextValue measure : ctxMember.getGroupBodyMeasures()) {
                RSAPIRowset rowset = measure.getRowset();
                RSAPIDataItem nonDetailDataItem = rowset.getDataItem(measure.getDataItemIndex());
                try {
                    String nonDetailDataItemName = nonDetailDataItem.getName();
                    OrderedJSONObject metricJSON = new OrderedJSONObject();
                    Value aValue = (Value)measure.getValue();
                    Object aJSONValue = aValue.toJSON();
                    this.putValueAndState((JSONObject)metricJSON, aJSONValue, aValue);
                    tValue.addOptionalValue(nonDetailDataItemName, metricJSON);
                }
                catch (JSONException e) {
                    QueryServiceLogger.error((Object)this, (String)EXCEPTION_STR, (Throwable)e);
                }
            }
        }
    }

    private String getPropertyName(RSAPIDataItem dataItem) {
        String propertyName = dataItem.getPropertyName();
        if (propertyName == null) {
            IDataType datatype = dataItem.getDataType();
            if (datatype == DataTypeFactory.getMemberDescriptionType()) {
                return "DESCRIPTION";
            }
            if (datatype == DataTypeFactory.getMemberCaptionType()) {
                return "MEMBER_CAPTION";
            }
            if (datatype == DataTypeFactory.getMemberRollupType()) {
                return "_rollupType";
            }
        }
        return propertyName;
    }

    private Object getMemberPropertyValue(ContextMember member, String propertyName) {
        Object value = member.getProperty(propertyName);
        if (value == null) {
            return null;
        }
        if (value instanceof Value) {
            return ((Value)value).toJSON();
        }
        return value.toString();
    }

    public boolean hasNextDataPoint() {
        return this.hasNextDataPoint;
    }

    public IResultPage read(IQSResultSet resultSet) {
        return QsResultSetReader.read(resultSet, (int)this.offset, (int)this.limit);
    }

    protected void getEdgeCoordinates(long dataPointOrdinal, long[] edgeCoordinates) {
        int eCordIdx = 0;
        Set<Integer> edgeOrdinals = this.rsEdges.keySet();
        for (Integer ord : edgeOrdinals) {
            long currAxisSize = this.getCurrentEdgeSize(ord);
            if (currAxisSize > 0L) {
                long axisOrdinal = dataPointOrdinal % currAxisSize;
                dataPointOrdinal /= currAxisSize;
                edgeCoordinates[eCordIdx++] = axisOrdinal;
                continue;
            }
            return;
        }
    }

    protected long computeDataPointOrdinal(long[] edgeCoordinates, int currEdgeIdx) {
        long dataPointOrdinal = 0L;
        long baseSize = 1L;
        int eCordIdx = 0;
        Set<Integer> edgeOrdinals = this.rsEdges.keySet();
        for (Integer ord : edgeOrdinals) {
            long edgeCoordinate = edgeCoordinates[eCordIdx++];
            long currAxisSize = this.getCurrentEdgeSize(ord);
            if (ord >= currEdgeIdx) {
                currAxisSize = currAxisSize == -1L ? 0L : currAxisSize;
                ++currAxisSize;
            }
            if (edgeCoordinate > currAxisSize || !this.hasNextDataPoint && edgeCoordinate == currAxisSize) {
                throw new IllegalStateException("edgeCoordinate > currAxisSize || (!this.hasNextDataPoint && edgeCoordinate == currAxisSize)");
            }
            if (currAxisSize <= 0L) {
                throw new IllegalStateException("currAxisSize <= 0L");
            }
            dataPointOrdinal += edgeCoordinate * baseSize;
            baseSize *= currAxisSize;
        }
        return dataPointOrdinal;
    }

    protected long getLastBaseCellOrdinal() {
        if (this.lastBaseCellOrdinal != -1L) {
            return this.lastBaseCellOrdinal;
        }
        long dataPointOrdinal = 0L;
        long baseVolSize = 1L;
        Set<Integer> edgeOrdinals = this.rsEdges.keySet();
        for (Integer ord : edgeOrdinals) {
            RsEdge rsEdge = this.rsEdges.get(ord);
            long eBaseSize = rsEdge.getBaseSize();
            dataPointOrdinal += (eBaseSize - 1L) * baseVolSize;
            baseVolSize *= eBaseSize;
        }
        this.lastBaseCellOrdinal = dataPointOrdinal;
        return this.lastBaseCellOrdinal;
    }

    public boolean isListReport() {
        return this.isListReport;
    }

    public TupleValue createTupleValue(ColumnInfo cInfo, Object useValue, Object displayValue, Item item, RSAPIDataItem dataItem, RSAPIRowset rowset) {
        TupleValue tValue = new TupleValue(cInfo, useValue, displayValue);
        item.AddTupleValue(tValue);
        tValue.setvId(item.getTupleValues().size());
        tValue.setDiName(dataItem.getName());
        tValue.setVsName(rowset.getName());
        return tValue;
    }

    public TupleValue createTupleValue(OrderedJSONObject metricJSON, Item item, RSAPIDataItem dataItem, RSAPIRowset rowset) {
        TupleValue tValue = new TupleValue(metricJSON);
        item.AddTupleValue(tValue);
        tValue.setvId(item.getTupleValues().size());
        tValue.setDiName(dataItem.getName());
        tValue.setVsName(rowset.getName());
        return tValue;
    }

    private static int pairIntegers(int x, int y) {
        int rId = ++x;
        int dOrd = ++y;
        return (rId + dOrd + 1) * (rId + dOrd) / 2 + dOrd;
    }

    QueryFeedbackWrapper getQueryFeedbackWrapper() {
        return this.qfbWrapper;
    }

    private static int createItemClassId(int rowId, List<ColumnInfo> columnInfos) {
        int aItemClassId = 0;
        int exponent = 0;
        int base = 1;
        for (ColumnInfo currColInfo : columnInfos) {
            int currPair;
            if (currColInfo.isNonDetail() || (currPair = QsResultSet.pairIntegers(currColInfo.getRowSetId(), currColInfo.getDataItemOrdinal()) + 1) <= base) continue;
            base = currPair;
        }
        base = (int)Math.ceil(Math.log10(base)) + 1;
        base = (int)Math.pow(10.0, base);
        for (int col = columnInfos.size() - 1; col > -1; --col) {
            ColumnInfo currColInfo;
            currColInfo = columnInfos.get(col);
            if (currColInfo.isNonDetail()) continue;
            aItemClassId += (int)Math.pow(base, exponent) * QsResultSet.pairIntegers(currColInfo.getRowSetId(), currColInfo.getDataItemOrdinal());
            ++exponent;
        }
        return aItemClassId += (int)Math.pow(base, exponent) * rowId;
    }

    static enum DMRCase {
        UNKNOWN,
        DMRMEASUE_MFWMEASURE,
        DMRMEASUE_MEASUREWRAPPER,
        DMRMEMBER_PROPERTY,
        DMRMEMBEROLAP,
        CALCULATEDMEMBER_MFWLEVEL,
        DMRMEMBER_RAWDATA,
        DMRMEMBER_ATTRIBUTE;


        private static DMRCase getDMRCase(ContextMember ctxMember, IMetadata modRef, RSAPIUsage usage) {
            IMember baseMember = ctxMember.getBaseMember();
            if (baseMember != null && baseMember instanceof DMRMember && ((DMRLevel)((DMRMember)baseMember).getLevel()).needReturnRawData()) {
                if (usage == RSAPIUsage.IDENTIFIER) {
                    return DMRMEMBER_RAWDATA;
                }
                if (usage == RSAPIUsage.ATTRIBUTE) {
                    return DMRMEMBER_ATTRIBUTE;
                }
            }
            if (ctxMember.getMember() instanceof DMRMeasure && modRef instanceof MeasureWrapper) {
                return DMRMEASUE_MEASUREWRAPPER;
            }
            if (ctxMember.getMember() instanceof DMRMeasure && modRef instanceof IMeasure) {
                return DMRMEASUE_MFWMEASURE;
            }
            if (ctxMember.getMember() instanceof DMRMember && modRef instanceof ILevel && usage == RSAPIUsage.ATTRIBUTE) {
                return DMRMEMBER_PROPERTY;
            }
            if (ctxMember.getMember() instanceof DMRMemberForOLAP && modRef instanceof ILevel) {
                return DMRMEMBEROLAP;
            }
            if (ctxMember.getMember() instanceof CalculatedMember && modRef instanceof ILevel) {
                return CALCULATEDMEMBER_MFWLEVEL;
            }
            return UNKNOWN;
        }
    }

    public class DataPoint {
        JSONArray point = new JSONArray();

        public void setValue(JSONArray v) {
            this.point = v;
        }

        public Object toJSON() {
            JSONObject dataPoint = new JSONObject();
            try {
                dataPoint.put(QsResultSet.POINT, (Collection)this.point);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert DataPoint instance toJSON\npoint: {}.", (Object)this.point.toString());
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return dataPoint;
        }

        public String toString() {
            return this.toJSON().toString();
        }

        public JSONArray getPoint() {
            return this.point;
        }
    }

    public class TupleValue {
        private int distinctId = 0;
        private int hashCode = 0;
        private int headerId = -1;
        private int rowSetId = -1;
        private int dataItemOrdinal = -1;
        private int vId = -1;
        private boolean isDistinct = false;
        private Object useValue;
        private Object displayValue;
        private OrderedJSONObject metricValue = null;
        private LinkedHashMap<String, Object> optionalValues = null;
        private LinkedHashMap<String, Object> optionalAttributes = null;
        private String diName;
        private String vsName;

        public TupleValue(ColumnInfo cInfo, Object useValue, Object displayValue) {
            if (cInfo != null) {
                this.rowSetId = cInfo.getRowSetId();
                this.dataItemOrdinal = cInfo.getDataItemOrdinal();
            }
            this.useValue = useValue;
            this.displayValue = displayValue;
        }

        public TupleValue(OrderedJSONObject value) {
            if (!this.getOuterType().isListReport) {
                throw new IllegalStateException("Not a list report");
            }
            this.metricValue = value;
        }

        public Integer getvId() {
            return this.vId;
        }

        public void setvId(int id) {
            this.vId = id;
        }

        public Object getUseValue() {
            return this.useValue;
        }

        public Object getDisplayValue() {
            if (this.displayValue instanceof Value) {
                return ((Value)this.displayValue).toJSON();
            }
            return this.displayValue;
        }

        public OrderedJSONObject getMetricValue() {
            return this.metricValue;
        }

        public void setMetricValue(OrderedJSONObject value) {
            this.metricValue = value;
        }

        public Object getOptionalValue(String key) {
            return this.optionalValues.get(key);
        }

        public Set<String> getOptionalValueKeys() {
            return this.optionalValues.keySet();
        }

        public void addOptionalValue(String key, Object value) {
            if (key == null || value == null) {
                return;
            }
            if (value instanceof String && ((String)value).isEmpty()) {
                return;
            }
            if (this.optionalValues == null) {
                this.optionalValues = new LinkedHashMap();
            }
            if (this.optionalValues.containsKey(key)) {
                throw new IllegalStateException("Duplicate optional value.");
            }
            this.optionalValues.put(key, value);
        }

        public Object getOptionalAttribute(String key) {
            return this.optionalAttributes.get(key);
        }

        public Set<String> getOptionalAttributeKeys() {
            if (null == this.optionalAttributes || this.optionalAttributes.isEmpty()) {
                return null;
            }
            return this.optionalAttributes.keySet();
        }

        public void addOptionalAttribute(String key, Object attribute) {
            if (key == null || attribute == null) {
                return;
            }
            if (attribute instanceof String && ((String)attribute).isEmpty()) {
                return;
            }
            if (this.optionalAttributes == null) {
                this.optionalAttributes = new LinkedHashMap();
            }
            if (this.optionalAttributes.containsKey(key)) {
                throw new IllegalStateException("Duplicate optional attribute.");
            }
            this.optionalAttributes.put(key, attribute);
        }

        public Object toJSON_AsIdentifier() {
            OrderedJSONObject theValue = new OrderedJSONObject();
            if (!this.isDistinct()) {
                throw new IllegalStateException("Not distinct.");
            }
            if (this.getMetricValue() != null) {
                throw new IllegalStateException("Is metric value.");
            }
            try {
                theValue.put(QsResultSet.ITEM_CLASS_HEADER_ID, this.getHeaderId());
                theValue.put(QsResultSet.DISPLAY, this.getDisplayValue());
                if (null != this.optionalAttributes && !this.optionalAttributes.isEmpty()) {
                    Set<String> keys = this.getOptionalAttributeKeys();
                    for (String key : keys) {
                        Object attribute = this.getOptionalAttribute(key);
                        if (attribute instanceof Value) {
                            attribute = ((Value)attribute).toJSON();
                        }
                        theValue.put(key, attribute);
                    }
                }
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert tupleValue.");
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return theValue;
        }

        public Object toJSON() {
            OrderedJSONObject theValue = new OrderedJSONObject();
            try {
                if (this.getMetricValue() == null) {
                    theValue.put("rId", (Object)this.getvId());
                    if (null != this.optionalValues && !this.optionalValues.isEmpty()) {
                        Set<String> keys = this.optionalValues.keySet();
                        for (String key : keys) {
                            theValue.put(key, this.getOptionalValue(key));
                        }
                    }
                } else {
                    theValue = this.getMetricValue();
                }
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert tupleValue.");
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return theValue;
        }

        private QsResultSet getOuterType() {
            return QsResultSet.this;
        }

        public int getDistinctId() {
            if (this.distinctId != 0) {
                return this.distinctId;
            }
            if (this.metricValue != null) {
                this.distinctId = -1;
                return this.distinctId;
            }
            int prime = 31;
            this.distinctId = 1;
            this.distinctId = 31 * this.distinctId + this.getOuterType().hashCode();
            this.distinctId = 31 * this.distinctId + QsResultSet.pairIntegers(this.rowSetId, this.dataItemOrdinal);
            this.distinctId = 31 * this.distinctId + (this.displayValue == null ? 0 : this.displayValue.hashCode());
            this.distinctId = 31 * this.distinctId + (this.useValue == null ? 0 : this.useValue.hashCode());
            Set<String> optionalAttributeKeys = this.getOptionalAttributeKeys();
            if (optionalAttributeKeys != null && !optionalAttributeKeys.isEmpty()) {
                for (String currKey : optionalAttributeKeys) {
                    if (CANONICAL_ATTRIBUTE_KEYS_LIST.contains(currKey)) continue;
                    Object optAttribute = this.getOptionalAttribute(currKey);
                    this.distinctId = 31 * this.distinctId + (optAttribute == null ? 0 : optAttribute.hashCode());
                }
            }
            return this.distinctId;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            int prime = 31;
            int result = 31 * (this.getDistinctId() == -1 ? 0 : this.getDistinctId());
            result = 31 * result + (this.metricValue == null ? 0 : this.metricValue.hashCode());
            this.hashCode = result = 31 * result + (this.optionalValues == null ? 0 : this.optionalValues.hashCode());
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TupleValue)) {
                return false;
            }
            TupleValue other = (TupleValue)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.dataItemOrdinal != other.dataItemOrdinal) {
                return false;
            }
            if (this.displayValue == null ? other.displayValue != null : !this.displayValue.equals(other.displayValue)) {
                return false;
            }
            if (this.metricValue == null ? other.metricValue != null : !this.metricValue.equals((Object)other.metricValue)) {
                return false;
            }
            if (this.optionalValues == null ? other.optionalValues != null : !this.optionalValues.equals(other.optionalValues)) {
                return false;
            }
            if (this.rowSetId != other.rowSetId) {
                return false;
            }
            return !(this.useValue == null ? other.useValue != null : !this.useValue.equals(other.useValue));
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean value) {
            this.isDistinct = value;
        }

        public String getDiName() {
            return this.diName;
        }

        public void setDiName(String diName) {
            this.diName = diName;
        }

        public String getVsName() {
            return this.vsName;
        }

        public void setVsName(String vsName) {
            this.vsName = vsName;
        }

        public int getRowSetId() {
            return this.rowSetId;
        }

        public int getDataItemOrdinal() {
            return this.dataItemOrdinal;
        }

        public int getHeaderId() {
            return this.headerId;
        }

        public void setHeaderId(int id) {
            this.headerId = id;
        }
    }

    public class Item {
        private int hashCode = 0;
        private int itemClassId = -1;
        private LinkedList<TupleValue> tupleValues = new LinkedList();
        private transient boolean immutable = false;

        public void AddTupleValue(TupleValue tupleValue) {
            if (this.immutable) {
                throw new IllegalStateException("Cannot modify");
            }
            this.tupleValues.add(tupleValue);
        }

        public void makeImmutable() {
            this.immutable = true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                Object[] objects = this.collectObjectsForHashCode();
                this.hashCode = new HashCodeBuilder(17, 37).append(objects).toHashCode();
            }
            return this.hashCode;
        }

        private Object[] collectObjectsForHashCode() {
            int size = this.tupleValues.size();
            Object[] objects = new Object[++size];
            int index = 0;
            objects[index++] = new Integer(this.itemClassId);
            int idx = 0;
            while (idx < this.tupleValues.size()) {
                objects[index] = this.tupleValues.get(idx);
                ++idx;
                ++index;
            }
            return objects;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Item)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            Item otherItem = (Item)other;
            EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.itemClassId, otherItem.itemClassId).append(this.tupleValues, otherItem.tupleValues);
            return equalsBuilder.isEquals();
        }

        public Object toJSON() {
            OrderedJSONObject theItem = new OrderedJSONObject();
            try {
                JSONArray tupleValueArray = new JSONArray();
                for (TupleValue value : this.tupleValues) {
                    tupleValueArray.add(value.toJSON());
                }
                theItem.put(QsResultSet.ITEM_CLASS_ID, this.itemClassId);
                theItem.put(QsResultSet.TUPLE, (Collection)tupleValueArray);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert Item instance toJSON for item class.", (Object)this.itemClassId);
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return theItem;
        }

        public String toString() {
            return this.toJSON().toString();
        }

        public LinkedList<TupleValue> getTupleValues() {
            return this.tupleValues;
        }

        public TupleValue getLastTupleValue() {
            if (this.tupleValues.isEmpty()) {
                return null;
            }
            return this.tupleValues.getLast();
        }

        public int getItemClassId() {
            return this.itemClassId;
        }

        public void setItemClassId(int id) {
            this.itemClassId = id;
        }
    }

    public class Header {
        private int hashCode = 0;
        private int headerId = -1;
        private String diName;
        private String vsName;
        private String aggregateValue;

        public Header(int rowsetId, int dataItemOrdinal, V5DataItem dataItem) {
            this.headerId = QsResultSet.pairIntegers(rowsetId, dataItemOrdinal);
            this.diName = dataItem.getName();
            this.aggregateValue = dataItem.getAggregate();
        }

        public String getDiName() {
            return this.diName;
        }

        public String getVsName() {
            return this.vsName;
        }

        public void setVsName(String name) {
            this.vsName = name;
        }

        public String getAggregateValue() {
            return this.aggregateValue;
        }

        public int getHeaderId() {
            return this.headerId;
        }

        private QsResultSet getOuterType() {
            return QsResultSet.this;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getOuterType().hashCode();
                this.hashCode = result = 31 * result + this.headerId;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Header other = (Header)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            return this.headerId == other.headerId;
        }

        public Object toJSON() {
            OrderedJSONObject value = new OrderedJSONObject();
            try {
                value.put(QsResultSet.ITEM_CLASS_HEADER_ID, this.getHeaderId());
                value.put(QsResultSet.DATA_ITEM_NAME, (Object)this.getDiName());
                value.put(QsResultSet.VALUE_SET_NAME, (Object)this.getVsName());
                String agg = this.getAggregateValue();
                if (agg != null && !agg.isEmpty()) {
                    value.put(QsResultSet.AGGREGATE, (Object)agg);
                }
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert ItemClass instance toJSON\ndiName: {}\nvsName: {}.", (Object)this.getDiName(), (Object)this.getVsName());
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return value;
        }
    }

    public class ItemClass {
        private final int itemClassId;
        private Header[] headers;
        private int hashCode = 0;

        public ItemClass(int rowId, List<ColumnInfo> columnInfos, V5DataItem[] dataItems) {
            if (dataItems == null || dataItems.length == 0) {
                throw new IllegalStateException("Invalid V5DataItem[]");
            }
            if (columnInfos == null || columnInfos.isEmpty()) {
                throw new IllegalStateException("Invalid List<ColumnInfo");
            }
            if (columnInfos.size() != dataItems.length) {
                throw new IllegalStateException("columnInfos.size() != dataItems.length");
            }
            this.itemClassId = QsResultSet.createItemClassId(rowId, columnInfos);
            this.headers = new Header[dataItems.length];
            for (int i = 0; i < dataItems.length; ++i) {
                this.headers[i] = new Header(columnInfos.get(i).getRowSetId(), columnInfos.get(i).getDataItemOrdinal(), dataItems[i]);
                this.headers[i].setVsName(columnInfos.get(i).getName());
            }
        }

        public int getId() {
            return this.itemClassId;
        }

        public Object toJSON() {
            JSONObject theItemClass = new JSONObject();
            try {
                JSONArray headerValues = new JSONArray();
                for (int i = 0; i < this.headers.length; ++i) {
                    OrderedJSONObject value = (OrderedJSONObject)this.headers[i].toJSON();
                    headerValues.add((Object)value);
                }
                theItemClass.put(QsResultSet.ITEM_CLASS_ID, this.itemClassId);
                theItemClass.put(QsResultSet.HEADER, (Collection)headerValues);
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert ItemClass instance toJSON itemClassId: {}.", (Object)this.itemClassId);
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return theItemClass;
        }

        public Header getHeader(int idx) {
            return this.headers[idx];
        }

        public String toString() {
            return this.toJSON().toString();
        }

        private QsResultSet getOuterType() {
            return QsResultSet.this;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.headers);
            this.hashCode = result = 31 * result + this.itemClassId;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ItemClass)) {
                return false;
            }
            ItemClass other = (ItemClass)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.itemClassId != other.itemClassId) {
                return false;
            }
            return Arrays.equals(this.headers, other.headers);
        }

        public int getHeaderNumber() {
            return this.headers.length;
        }
    }

    public class RsEdge {
        private String name = null;
        private int ordinal = -1;
        private List<ItemClass> itemClasses;
        private List<Item> items;
        private List<TupleValue> distinctIdentifiers;
        private boolean hasNextItem = false;
        long baseSize = -1L;

        public int getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(int ordinal) {
            this.ordinal = ordinal;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public List<ItemClass> getItemClasses() {
            return this.itemClasses;
        }

        public void addItemClass(ItemClass itemClass) {
            if (itemClass == null) {
                return;
            }
            if (this.itemClasses == null) {
                this.itemClasses = new LinkedList<ItemClass>();
            }
            this.itemClasses.add(itemClass);
        }

        public List<Item> getItems() {
            return this.items;
        }

        public long getCurrentSize() {
            if (this.getItems() == null) {
                return -1L;
            }
            return this.getItems().size();
        }

        public void addItem(Item item, ItemClass itemClass) {
            if (itemClass == null || item == null) {
                throw new IllegalStateException("itemClass == null || item == null");
            }
            if (this.items == null) {
                this.items = new LinkedList<Item>();
            }
            if (this.items.contains(item)) {
                throw new IllegalStateException("duplicate row?");
            }
            item.setItemClassId(itemClass.getId());
            this.items.add(item);
            this.assingHeaderIds(item, itemClass);
            LinkedList<TupleValue> values = item.getTupleValues();
            for (TupleValue value : values) {
                if (value.getDistinctId() == -1) continue;
                if (this.distinctIdentifiers == null) {
                    this.distinctIdentifiers = new ArrayList<TupleValue>();
                    value.setDistinct(true);
                    this.distinctIdentifiers.add(value);
                    value.setvId(this.distinctIdentifiers.size());
                    continue;
                }
                boolean found = false;
                for (TupleValue dValue : this.distinctIdentifiers) {
                    if (value.getDistinctId() != dValue.getDistinctId()) continue;
                    value.setvId(dValue.getvId());
                    found = true;
                    break;
                }
                if (found) continue;
                value.setDistinct(true);
                this.distinctIdentifiers.add(value);
                value.setvId(this.distinctIdentifiers.size());
            }
        }

        public Object toJSON() {
            OrderedJSONObject theEdge = new OrderedJSONObject();
            try {
                theEdge.put(QsResultSet.EDGE_ORDINAL, this.ordinal);
                theEdge.put(QsResultSet.EDGE_NAME, (Object)this.name);
                if (this.distinctIdentifiers != null && !this.distinctIdentifiers.isEmpty()) {
                    OrderedJSONObject identifiersJSON = new OrderedJSONObject();
                    for (TupleValue tupleValue : this.distinctIdentifiers) {
                        identifiersJSON.put(tupleValue.getvId().toString(), tupleValue.toJSON_AsIdentifier());
                    }
                    theEdge.put(QsResultSet.IDENTIFIERS, (Map)identifiersJSON);
                }
                JSONArray itemClassesJSON = new JSONArray();
                for (ItemClass itemClass : this.itemClasses) {
                    itemClassesJSON.add(itemClass.toJSON());
                }
                theEdge.put(QsResultSet.ITEM_CLASSES, (Collection)itemClassesJSON);
                if (this.items != null && !this.items.isEmpty()) {
                    JSONArray itemsJSON = new JSONArray();
                    for (Item currItem : this.items) {
                        itemsJSON.add(currItem.toJSON());
                    }
                    if (this.hasNextItem) {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put(QsResultSet.HASNEXT, true);
                        itemsJSON.add((Object)jSONObject);
                    }
                    theEdge.put(QsResultSet.ITEMS, (Collection)itemsJSON);
                }
            }
            catch (JSONException e) {
                QueryServiceLogger.error((Object)this, (String)"Failed to convert RsEdge instance toJSON ordinal: .", (Object)this.ordinal);
                QueryServiceLogger.error((Object)this, (String)QsResultSet.EXCEPTION_STR, (Throwable)e);
            }
            return theEdge;
        }

        public void assingHeaderIds(Item item, ItemClass itemClass) {
            if (item.getTupleValues().size() != itemClass.getHeaderNumber()) {
                throw new IllegalStateException("Number of tuple values in an item does not match the number of headers of is item class.");
            }
            for (int i = 0; i < itemClass.getHeaderNumber(); ++i) {
                TupleValue tv = item.getTupleValues().get(i);
                if (tv.getDistinctId() == -1) continue;
                Header h = itemClass.getHeader(i);
                int pairNumber = QsResultSet.pairIntegers(tv.getRowSetId(), tv.getDataItemOrdinal());
                if (pairNumber != h.getHeaderId()) {
                    throw new IllegalStateException("Tuple value does not match the expected item class header.");
                }
                tv.setHeaderId(h.getHeaderId());
            }
        }

        public void setHasNextItem(boolean value) {
            this.hasNextItem = value;
        }

        public long getBaseSize() {
            return this.baseSize;
        }

        public void setBaseSize(long value) {
            this.baseSize = value;
        }
    }
}

