/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.results;

import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.IResultPage;
import com.ibm.bi.qs.service.QsResultSetPage;
import com.ibm.bi.qs.xqe.results.QsResultSet;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class QsResultSetReader {
    public static IResultPage read(IQSResultSet resultSet, int startIndex, int pageSize) {
        OrderedJSONObject wrappedEndorResultSet = new OrderedJSONObject();
        try {
            QsResultSetPage results;
            QueryFeedbackWrapper qfbWrapper;
            long begin = System.nanoTime();
            QsResultSet qsResultSet = (QsResultSet)resultSet;
            OrderedJSONObject meta = new OrderedJSONObject();
            wrappedEndorResultSet.put("version", (Object)"2");
            wrappedEndorResultSet.put("meta", (Map)meta);
            JSONArray edges = QsResultSetReader.constructEdges(qsResultSet);
            wrappedEndorResultSet.put("edges", (Collection)edges);
            if (!qsResultSet.isListReport()) {
                JSONArray dataPoints = QsResultSetReader.constructDataPoints(qsResultSet, pageSize, wrappedEndorResultSet);
                if (qsResultSet.hasNextDataPoint()) {
                    JSONObject theHasNext = new JSONObject();
                    theHasNext.put("hasNext", true);
                    dataPoints.add((Object)theHasNext);
                }
                wrappedEndorResultSet.put("data", (Collection)dataPoints);
            }
            if (startIndex > 0) {
                wrappedEndorResultSet.put("hasPrev", true);
            }
            if (null != (qfbWrapper = qsResultSet.getQueryFeedbackWrapper())) {
                meta.put("perf", (Map)new JSONObject());
                if (qfbWrapper.requestedFeedback()) {
                    meta.put("messages", qfbWrapper.feedbackToJSON());
                }
                if (qfbWrapper.requestedColumnInfo()) {
                    meta.put("columnInfo", qfbWrapper.columnListToJSON());
                }
                if (qfbWrapper.requestedUsedParams()) {
                    meta.put("usedParams", qfbWrapper.usedParamsToJSON());
                }
                long end = System.nanoTime();
                qfbWrapper.incrementResultMarshallingTime(end - begin);
                meta.replace((Object)"perf", qfbWrapper.perfToJSON());
            } else {
                wrappedEndorResultSet.remove((Object)"meta");
            }
            QsResultSetPage qsResultSetPage = results = new QsResultSetPage(wrappedEndorResultSet, resultSet.getLastModified());
            return qsResultSetPage;
        }
        catch (JSONException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
        finally {
            resultSet.dispose();
        }
    }

    private static JSONArray constructEdges(QsResultSet qsResultSet) throws JSONException {
        QsResultSet.RsEdge[] rsEdges;
        JSONArray result = new JSONArray();
        for (QsResultSet.RsEdge rsEdge : rsEdges = qsResultSet.getRsEdges()) {
            result.add(rsEdge.toJSON());
        }
        return result;
    }

    private static JSONArray constructDataPoints(QsResultSet qsResultSet, int pageSize, OrderedJSONObject wrappedEndorResultSet) throws JSONException {
        JSONArray result = new JSONArray();
        List<QsResultSet.DataPoint> dataPoints = qsResultSet.getDataPoints();
        for (QsResultSet.DataPoint dataPoint : dataPoints) {
            result.add(dataPoint.toJSON());
        }
        return result;
    }
}

