/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.service;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieImpl;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.util.DAASUtils;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.predict.KeyDriverExecutor;
import com.ibm.bi.qs.xqe.predict.PredictExploreExecutor;
import com.ibm.bi.qs.xqe.request.RequestManager;
import com.ibm.bi.qs.xqe.request.RequestStatus;
import com.ibm.bi.qs.xqe.request.WorkloadManager;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XQEServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(XQEServiceImpl.class);
    private static final SingletonHelper<XQEServiceImpl> SINGLETON_HELPER = new SingletonHelper<XQEServiceImpl>(){

        protected XQEServiceImpl newInstance() {
            return new XQEServiceImpl();
        }

        protected void initializeImpl(XQEServiceImpl theInstance) {
            theInstance.initialize();
        }

        protected void releaseImpl(XQEServiceImpl theInstance) {
            theInstance.terminate();
        }
    };
    private static final int DEFAULT_REST_TIMEOUT = 290;
    private static final int DEFAULT_REST_PREDICT_TIMEOUT = 290;
    private static final int DEFAULT_REST_MAX_TIMEOUT = 299;
    private static final int MAXIMUM_TIMEOUT_ALLOWED = 299;
    private V5QueryHandler v5QueryHandler;
    private volatile RequestManager requestManager;
    private volatile WorkloadManager workloadManager;
    private ScheduledExecutorService scheduler;
    private AtomicInteger defaultTimeout = new AtomicInteger();
    private AtomicInteger defaultPredictTimeout = new AtomicInteger();
    private AtomicInteger maxTimeout = new AtomicInteger();
    private final Duration configUpdatePeriod = Duration.ofSeconds(10L);
    private volatile Instant lastConfigurationUpdate;

    public static XQEServiceImpl getInstance() {
        return (XQEServiceImpl)SINGLETON_HELPER.getInstance();
    }

    public static XQEServiceImpl getInstanceNoInit() {
        return (XQEServiceImpl)SINGLETON_HELPER.getInstance(true);
    }

    public static void releaseInstance() {
        SINGLETON_HELPER.releaseInstance();
    }

    private XQEServiceImpl() {
    }

    private void initialize() {
        if (QueryServiceLogger.isInfoEnabled((Object)this)) {
            QueryServiceLogger.info((Object)this, (String)"Initializing XQE XQEServiceImpl::initialize()");
        }
        this.v5QueryHandler = V5QueryHandler.getInstance();
        this.startRequestManagementIfRequired();
        if (QueryServiceLogger.isInfoEnabled((Object)this)) {
            QueryServiceLogger.info((Object)this, (String)"Done initializing XQE.");
        }
    }

    private void startRequestManagementIfRequired() {
        boolean enableWorkloadManagement;
        if (this.requestManager != null) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean enableRequestManagement = configuration == null || configuration.getBooleanProperty("queryExecution.RESTTimeout[@enabled]", true);
        boolean bl = enableWorkloadManagement = configuration == null || configuration.getBooleanProperty("queryExecution.RESTWorkloadManagement[@enabled]", false);
        if (enableRequestManagement || enableWorkloadManagement) {
            this.startRequestManagement(enableWorkloadManagement);
        }
    }

    private synchronized void startRequestManagement(boolean enableWorkloadManagement) {
        if (this.requestManager != null) {
            return;
        }
        this.requestManager = new RequestManager(this);
        this.setupScheduler();
        this.refreshTimeoutConfiguration();
        if (enableWorkloadManagement) {
            this.workloadManager = new WorkloadManager(this);
            this.workloadManager.start();
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout.get();
    }

    public Integer getDefaultPredictTimeout() {
        return this.defaultPredictTimeout.get();
    }

    public Integer getMaxTimeout() {
        return this.maxTimeout.get();
    }

    private void setupScheduler() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(2, r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("XQEServiceImpl.Scheduler-" + t.getId());
                return t;
            });
        }
    }

    public void terminate() {
        if (this.v5QueryHandler != null) {
            this.v5QueryHandler.release();
        }
        if (this.requestManager != null) {
            this.stopRequestManagement();
        }
    }

    private void stopRequestManagement() {
        try {
            this.requestManager.cancelAllRequests();
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected error while cancelling all active requests", (Throwable)ex);
        }
        finally {
            this.requestManager = null;
        }
        if (null != this.workloadManager) {
            try {
                this.workloadManager.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while stopping workload manager", (Throwable)ex);
            }
            finally {
                this.workloadManager = null;
            }
        }
    }

    public static ExecutionEnvironmentContext startRequestPlanning(String requestType, RequestEnvironment reqEnv, ExecutionEnvironment execEnv) {
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter((IExecutionEnvironment)execEnv);
        multiRequestContext.incrementRefCount();
        return executionEnvironmentContext;
    }

    public static void finishRequestPlanning(RequestEnvironment reqEnv, ExecutionEnvironment execEnv, ExecutionEnvironmentContext executionEnvironmentContext, Throwable error) {
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        multiRequestContext.decrementRefCount();
        executionEnvironmentContext.exit();
    }

    public static void startRequestExecution(String requestType, RequestEnvironment requestEnvironment, Integer timeoutSeconds) {
        XQEServiceImpl xqeServiceImpl = XQEServiceImpl.getInstanceNoInit();
        if (xqeServiceImpl == null) {
            return;
        }
        if (xqeServiceImpl.requestManager == null) {
            xqeServiceImpl.startRequestManagementIfRequired();
        } else {
            xqeServiceImpl.refreshTimeoutConfiguration();
        }
        if (xqeServiceImpl.requestManager != null) {
            RequestStatus request = xqeServiceImpl.requestManager.createRequest(requestType, requestEnvironment);
            int requestTimeout = timeoutSeconds == null ? xqeServiceImpl.getDefaultRequestTimeout(requestType) : (timeoutSeconds > xqeServiceImpl.getMaxTimeout() ? xqeServiceImpl.getMaxTimeout().intValue() : timeoutSeconds.intValue());
            xqeServiceImpl.requestManager.startRequest(request, requestTimeout);
        }
    }

    public static Object executeRequest(BaseExecutor baseExecutor, RequestEnvironment requestEnvironment) throws Exception {
        XQEServiceImpl xqeServiceImpl = XQEServiceImpl.getInstanceNoInit();
        if (xqeServiceImpl != null && xqeServiceImpl.workloadManager != null) {
            String requestId = requestEnvironment.getRequestID();
            RequestStatus requestStatus = xqeServiceImpl.requestManager.getRequestStatusByRequestId(requestId);
            if (requestStatus == null) {
                throw new IllegalStateException("No request status found for requestId: " + requestId);
            }
            return xqeServiceImpl.workloadManager.executeRequest(baseExecutor, requestStatus);
        }
        return baseExecutor.executeImpl();
    }

    public static void finishRequestExecution(RequestEnvironment requestEnvironment, Throwable error) {
        String requestId = requestEnvironment.getRequestID();
        XQEServiceImpl xqeServiceImpl = XQEServiceImpl.getInstanceNoInit();
        if (xqeServiceImpl == null) {
            return;
        }
        if (xqeServiceImpl.requestManager != null) {
            xqeServiceImpl.requestManager.finishRequest(requestId, error);
        }
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public static QueryEnvironmentHelper createQueryEnvironmentsNoBIBus(HttpServletRequest httpServletRequest) {
        BIBusEnvelope env = new BIBusEnvelope();
        Element biBusElement = env.getBIBusHeader();
        biBusElement.detach();
        return XQEServiceImpl.createQueryEnvironmentHelper(httpServletRequest, biBusElement, null, null);
    }

    public static QueryEnvironmentHelper createQueryEnvironments(HttpServletRequest httpServletRequest, String contentLocale, String productLocale) {
        Element datasetServiceBiBusElement;
        if (DAASUtils.isDAAS()) {
            return XQEServiceImpl.createQueryEnvironmentsNoBIBus(httpServletRequest);
        }
        Cookie[] cookies = httpServletRequest.getCookies();
        String camPassport = null;
        for (Cookie c : cookies) {
            if (!"cam_passport".equals(c.getName())) continue;
            camPassport = c.getValue();
        }
        if (camPassport != null) {
            Element camCookieXML;
            CAMCookie camCookie = CAMCookieImpl.createCookie(camPassport);
            BIBusEnvelope queryEnvelope = new BIBusEnvelope();
            Element biBusElement = queryEnvelope.getBIBusHeader();
            biBusElement.detach();
            try {
                camCookieXML = camCookie.asXML();
            }
            catch (DocumentException e) {
                throw new XQERuntimeException((Throwable)e);
            }
            queryEnvelope.setCAM(camCookieXML);
            for (Cookie c : cookies) {
                if (null == c.getName() || null == c.getValue()) continue;
                queryEnvelope.setCookie(c.getName(), c.getValue());
            }
            Element queryBiBusHeader = queryEnvelope.getBIBusHeader();
            datasetServiceBiBusElement = (Element)((Element)queryBiBusHeader.clone()).detach();
        } else {
            CMQuery queryCommand = new CMQuery("/");
            try {
                BIBusEnvelope queryEnvelope = new BIBusEnvelope();
                queryEnvelope.setCAMaction("logon");
                Element queryBIBusHeader = queryEnvelope.getBIBusHeader();
                queryBIBusHeader.detach();
                queryCommand.setBIBusHeader(queryBIBusHeader);
                queryCommand.execute();
                BIBusEnvelope responseEnvelope = queryCommand.getResponseEnvelope();
                String simulatedBiBusConversationContextID = responseEnvelope.getRequestContext();
                responseEnvelope.setConversationContextID(simulatedBiBusConversationContextID);
                responseEnvelope.setConversationContextNodeID("DatasetService.createQueryEnvironments()FakeNodeId");
                responseEnvelope.setConversationContextProcessID(1234);
                datasetServiceBiBusElement = responseEnvelope.getBIBusHeader();
                datasetServiceBiBusElement.detach();
            }
            catch (SoapFaultException sfe) {
                BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
                throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
            }
            catch (Exception ex) {
                throw new XQERuntimeException((Throwable)ex);
            }
        }
        return XQEServiceImpl.createQueryEnvironmentHelper(httpServletRequest, datasetServiceBiBusElement, contentLocale, productLocale);
    }

    public static QueryEnvironmentHelper createQueryEnvironmentHelper(HttpServletRequest httpServletRequest, Element biBusHeaderElement, String contentLocale, String productLocale) {
        QueryEnvironmentHelper queryEnvironmentHelper = new QueryEnvironmentHelper();
        queryEnvironmentHelper.setRunLocale(contentLocale);
        queryEnvironmentHelper.setProductLocale(productLocale);
        queryEnvironmentHelper.setRequestHeader(biBusHeaderElement);
        queryEnvironmentHelper.setRequestId(XQEServiceImpl.getCATransactionHeader(httpServletRequest));
        queryEnvironmentHelper.setUpEnvironment(true);
        RequestEnvironment reqEnv = queryEnvironmentHelper.getRequestEnvironment();
        reqEnv.setReportName(XQEServiceImpl.getDashboardName(httpServletRequest));
        return queryEnvironmentHelper;
    }

    private static String getCATransactionHeader(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        String transactionHeader = httpServletRequest.getHeader("X-CA-Transaction");
        if (transactionHeader != null) {
            try {
                transactionHeader = URLDecoder.decode(transactionHeader, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return transactionHeader;
    }

    private static String getDashboardName(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        String dashboardName = null;
        String auditDashboardPath = httpServletRequest.getHeader("x-audit-searchPath");
        if (auditDashboardPath != null && !auditDashboardPath.equalsIgnoreCase("null")) {
            try {
                auditDashboardPath = URLDecoder.decode(auditDashboardPath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String nameMarker = "[@name=";
            int lastNameIdx = auditDashboardPath.lastIndexOf("[@name=");
            dashboardName = lastNameIdx != -1 ? auditDashboardPath.substring(lastNameIdx + "[@name=".length() + 1, auditDashboardPath.lastIndexOf("]") - 1) : auditDashboardPath;
        }
        return dashboardName;
    }

    int getDefaultRequestTimeout(String requestType) {
        if (requestType.equals(PredictExploreExecutor.REQUEST_TYPE) || requestType.equals(KeyDriverExecutor.REQUEST_TYPE)) {
            return this.getDefaultPredictTimeout();
        }
        return this.getDefaultTimeout();
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    private void refreshTimeoutConfiguration() {
        int newMaxTimeout;
        int newDefaultPredictTimeout;
        Duration timeSinceLastUpdate;
        if (this.lastConfigurationUpdate != null && (timeSinceLastUpdate = Duration.between(this.lastConfigurationUpdate, Instant.now())).compareTo(this.configUpdatePeriod) < 0) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int newDefaultTimeout = configuration.getIntegerProperty("queryExecution.RESTDefaultTimeout[@value]", Integer.valueOf(290));
        if (newDefaultTimeout < 1) {
            newDefaultTimeout = 290;
        }
        if ((newDefaultPredictTimeout = configuration.getIntegerProperty("queryExecution.RESTDefaultPredictTimeout[@value]", Integer.valueOf(290)).intValue()) < 1) {
            newDefaultPredictTimeout = 290;
        }
        if ((newMaxTimeout = configuration.getIntegerProperty("queryExecution.RESTMaxTimeout[@value]", Integer.valueOf(299)).intValue()) < 1) {
            newMaxTimeout = 299;
        }
        if (newMaxTimeout > 299) {
            newMaxTimeout = 299;
        }
        if (newDefaultTimeout > newMaxTimeout) {
            newDefaultTimeout = newMaxTimeout;
        }
        if (newDefaultPredictTimeout > newMaxTimeout) {
            newDefaultPredictTimeout = newMaxTimeout;
        }
        this.defaultTimeout.set(newDefaultTimeout);
        this.defaultPredictTimeout.set(newDefaultPredictTimeout);
        this.maxTimeout.set(newMaxTimeout);
        this.lastConfigurationUpdate = Instant.now();
    }

    public static String createQueryContext(ServletRequestContext servletRequestContext) {
        return UUID.randomUUID().toString();
    }

    public static void deleteQueryContext(String queryContextId, ServletRequestContext servletRequestContext) {
    }

    public static boolean cancelRequest(String queryContextId, String requestId, ServletRequestContext servletRequestContext) {
        return true;
    }

    public static JSONObject getQueryContextRequests(String queryContextId, ServletRequestContext servletRequestContext) throws JSONException {
        JSONObject queryContextJson = new JSONObject();
        queryContextJson.put("queryContextId", (Object)queryContextId);
        return queryContextJson;
    }
}

