/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.service;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.ExploreSpec;
import com.ibm.bi.qs.model.api.data.predict.generated.KeyDriverSpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.FunctionSpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.stats.generated.StatsSpec;
import com.ibm.bi.qs.service.IQSExecutor;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.IResultPage;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.moserfunction.FunctionSpecExecutor;
import com.ibm.bi.qs.xqe.predict.KeyDriverExecutor;
import com.ibm.bi.qs.xqe.predict.PredictExploreExecutor;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import com.ibm.bi.qs.xqe.stats.StatsExecutor;
import com.ibm.bi.qs.xqe.v5.DataExecutor;
import com.ibm.bi.qs.xqe.v5.V5DataExecutor;
import com.ibm.bi.qs.xqe.v5.ValidateExecutor;
import java.util.concurrent.TimeoutException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class XqeDatasetService
implements QueryService {
    private static final double MIN_VERSION = 1.0;
    private static final double CURRENT_VERSION = 2.0;

    public void setUp() {
        XQEServiceImpl.getInstance();
    }

    public IQSExecutor createQueryExecutor(QuerySpec query, DataSet dataSet, ServletRequestContext servletRequestContext) {
        if (query.getValidate() != null && query.getValidate().booleanValue()) {
            return new ValidateExecutor(query, dataSet, servletRequestContext);
        }
        String version = query.getVersion();
        try {
            double versionNumber = Double.valueOf(version);
            if (versionNumber < 1.0 || versionNumber > 2.0) {
                throw new IllegalStateException();
            }
            if (2.0 == versionNumber) {
                return new V5DataExecutor(query, dataSet, servletRequestContext);
            }
            return new DataExecutor(query, dataSet, servletRequestContext);
        }
        catch (IllegalStateException ise) {
            throw new QueryServiceException(400, QueryServiceMessageKeys.INTERNAL_ERROR, "Query specification version '" + version + "' is not supported.");
        }
        catch (Exception e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.REST_INTERNAL_ERROR);
        }
    }

    public IResultPage executeQueries(IQSExecutor sourceDataExecutor) throws TimeoutException {
        IQSResultSet resultSet = (IQSResultSet)sourceDataExecutor.execute();
        return resultSet.read(resultSet);
    }

    public OrderedJSONObject executeJSONResult(IQSExecutor executor) throws TimeoutException {
        Object result = executor.execute();
        if (result instanceof IQSResultSet) {
            IQSResultSet resultSet = (IQSResultSet)result;
            return resultSet.read(resultSet).getFinalResult();
        }
        if (result instanceof OrderedJSONObject) {
            return (OrderedJSONObject)result;
        }
        throw new IllegalArgumentException("Expected IQSResultSet or OrderedJSONObject, executor return unhandled class: " + result.getClass().getName());
    }

    public String executeStringResult(IQSExecutor executor) throws TimeoutException {
        Object result = executor.execute();
        if (result instanceof String) {
            return (String)result;
        }
        throw new IllegalArgumentException("Expected String, executor return unhandled class: " + result.getClass().getName());
    }

    public IQSExecutor createFunctionExecutor(FunctionSpec functionSpec, ServletRequestContext servletRequestContext) {
        return new FunctionSpecExecutor(functionSpec, servletRequestContext);
    }

    public IQSExecutor createKeyDriverExecutor(KeyDriverSpec keyDriverSpec, DataSet dataSet, ServletRequestContext servletRequestContext) {
        return new KeyDriverExecutor(keyDriverSpec, dataSet, servletRequestContext);
    }

    public IQSExecutor createPredictExploreExecutor(ExploreSpec exploreSpec, DataSet dataSet, ServletRequestContext servletRequestContext) {
        return new PredictExploreExecutor(exploreSpec, dataSet, servletRequestContext);
    }

    public IQSExecutor createStatsExecutor(StatsSpec querySpec, DataSet dataSet, ServletRequestContext servletRequestContext) {
        return new StatsExecutor(querySpec, dataSet, servletRequestContext);
    }

    public String createQueryContext(ServletRequestContext servletRequestContext) {
        return XQEServiceImpl.createQueryContext(servletRequestContext);
    }

    public void deleteQueryContext(String queryContextId, ServletRequestContext servletRequestContext) {
        XQEServiceImpl.deleteQueryContext(queryContextId, servletRequestContext);
    }

    public boolean cancelRequest(String queryContextId, String requestId, ServletRequestContext servletRequestContext) {
        return XQEServiceImpl.cancelRequest(queryContextId, requestId, servletRequestContext);
    }

    public JSONObject getQueryContextRequests(String queryContextId, ServletRequestContext servletRequestContext) throws JSONException {
        return XQEServiceImpl.getQueryContextRequests(queryContextId, servletRequestContext);
    }
}

