/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.service.actions;

import com.cognos.xqe.ast.XQENodeFactory;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.xqe.service.actions.ActionMap;
import com.ibm.bi.qs.xqe.service.actions.IActionHandler;
import com.ibm.bi.qs.xqe.v5.DataExecutor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ActionFactory {
    private static volatile ActionFactory actionFactory;

    public static synchronized ActionFactory getInstance() {
        if (actionFactory == null) {
            actionFactory = new ActionFactory();
        }
        return actionFactory;
    }

    public IActionHandler create(Action action, DataExecutor executor, XQENodeFactory nodeFactory) throws QueryServiceException {
        if (action == null) {
            return null;
        }
        ActionMap entry = ActionMap.valueOf(action.getOperation().toString().toUpperCase());
        if (entry == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Unknown Operation");
        }
        try {
            Class<?> clazz = Class.forName(entry.getImplClass());
            Constructor<?> constructor = clazz.getConstructor(DataExecutor.class, XQENodeFactory.class);
            return (IActionHandler)constructor.newInstance(executor, nodeFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, "Unable to instantiate a handler for operation : " + action.getOperation().toString());
        }
    }
}

