/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.service.actions;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5FilterExpression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.data.common.generated.AndFilter;
import com.ibm.bi.qs.model.api.data.common.generated.DataFilter;
import com.ibm.bi.qs.model.api.data.common.generated.Filter;
import com.ibm.bi.qs.model.api.data.common.generated.FilterExpression;
import com.ibm.bi.qs.model.api.data.common.generated.FilterOperator;
import com.ibm.bi.qs.model.api.data.common.generated.NotFilter;
import com.ibm.bi.qs.model.api.data.common.generated.OrFilter;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.model.api.data.queryspec.generated.AggregateType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Between;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Context;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Descendants;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Sort;
import com.ibm.bi.qs.model.api.data.queryspec.generated.SortOrder;
import com.ibm.bi.qs.model.api.data.queryspec.generated.TopBottom;
import com.ibm.bi.qs.xqe.service.actions.ActionContext;
import com.ibm.bi.qs.xqe.service.actions.ActionFactory;
import com.ibm.bi.qs.xqe.service.actions.IActionHandler;
import com.ibm.bi.qs.xqe.service.actions.handlers.KeepActionHandler;
import com.ibm.bi.qs.xqe.v5.DataExecutor;
import com.ibm.bi.qs.xqe.v5.FilterGenerator;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class BaseActionHandler
implements IActionHandler {
    protected String expression;
    protected ActionContext actionContext;
    protected Action action;
    protected DataExecutor executor;
    protected XQENodeFactory nodeFactory;
    protected V5MultiPartIdentifier identifier;
    protected String dataItemID;
    protected DataItem dataItem;
    protected ArrayList<String> rankCalcIdentifiers = new ArrayList();
    protected boolean isMemberSet = false;
    protected boolean isProperty = false;
    protected static final String SEPARATOR = "; ";
    private static final String V5_ADD_FUNCTION = "union";
    private static final String FOR_REPORT_STR = "for report";
    private static final String V5_RANK_FUNCTION_DESC_FORMAT = "rank(distinct %s desc %s)";
    private static final String V5_RANK_FUNCTION_ASC_FORMAT = "rank(distinct %s asc %s)";
    private static final String V5_RANK_FUNCTION_DIM_DESC_FORMAT = "rank(distinct %s(%s for %s) desc %s)";
    private static final String V5_RANK_FUNCTION_DIM_ASC_FORMAT = "rank(distinct %s(%s for %s) asc %s)";
    private static final String UNDERSCORE_STR = "_";
    private static final String LEFT_PAREN_STR = "(";
    private static final String RIGHT_PAREN_STR = ")";
    private static final String LEFT_BRACKET_STR = "[";
    private static final String RIGHT_BRACKET_STR = "]";
    private static final String CONTEXTUAL_V5_RANK_FUNCTION = "rank( %s( %s ) %s )";
    private static final String CONTEXTUAL_V5_RANK_FUNCTION_FOR_CALC = "rank( distinct %s %s )";
    private static final String CONTEXTUAL_PROJ_V5_RANK_FUNCTION = "rank( %s( %s for %s) %s )";
    private static final String NONCONTEXTUAL_V5_RANK_FUNCTION = "rank( distinct %s( %s ) %s )";
    private static final String NONCONTEXTUAL_V5_RANK_FUNCTION_FOR_CALC = "rank(distinct %s %s)";
    private static final String NUM_EXPR_PREFIX = "_numExpr_%s";
    private static final String DATAITEM_REFERENCE = "[%s]";
    private static final String IN_FILTER = "%s in ( %s )";
    private static final String EMPTY_STRING = "";
    private static final String ASC_STR = "asc";
    private static final String DESC_STR = "desc";
    private static final String RANK_DATAITEM_NAME = "_rank_%s_for_%s";
    public static final String TOP_BOTTOM_COUNT_SUBQUERY_NAME = "topBottomCountQuery";
    public static final String IS_TOP_BOTTOM_COUNT_CONTEXTUAL = "isTopBottomCountContextual";

    public BaseActionHandler(DataExecutor executor, XQENodeFactory nodeFactory) {
        this.executor = executor;
        this.nodeFactory = nodeFactory;
    }

    public boolean init(ActionContext actionContext, DataItem currentDataItem) throws QueryServiceException {
        this.actionContext = actionContext;
        this.expression = (String)actionContext.get(ParamName.EXPRESSION);
        this.identifier = (V5MultiPartIdentifier)actionContext.get(ParamName.IDENTIFIER);
        this.dataItem = currentDataItem;
        this.dataItemID = currentDataItem.getId();
        if (this.expression == null) {
            ColumnMetadata metadata = this.executor.getColumnMetadata(this.getIdentifier());
            ColumnMetadata.SourceCategory category = metadata.getSourceCategory();
            this.isProperty = category.equals((Object)ColumnMetadata.SourceCategory.PROPERTY);
        }
        return true;
    }

    @Override
    public String getV5ActionFunction() {
        return V5_ADD_FUNCTION;
    }

    @Override
    public boolean isV5ActionFunctionRequired() {
        Sort sort = this.action.getSort();
        if (sort != null) {
            return false;
        }
        return this.expression != null;
    }

    @Override
    public String applyAction() {
        StringBuilder builder = new StringBuilder();
        boolean v5ActionFunctionRequired = this.isV5ActionFunctionRequired();
        if (v5ActionFunctionRequired) {
            builder.append(this.getV5ActionFunction());
            builder.append(LEFT_PAREN_STR);
            builder.append(this.getSubject());
            builder.append(SEPARATOR);
        }
        if (this.action.getTopBottom() != null) {
            String topBottomExpression = this.getTopBottomExpression();
            if (topBottomExpression != null) {
                builder.append(topBottomExpression);
            }
        } else if (this.action.getDescendants() != null) {
            builder.append(this.getDescendantsExpression());
        } else if (this.action.getChildren() != null) {
            builder.append(this.getChildrenExpression());
        } else if (this.action.getSiblings() != null) {
            builder.append(this.getSiblingsExpression());
        } else if (this.action.getHead() != null) {
            builder.append(this.getHeadExpression());
        } else if (this.action.getSet() != null && !this.action.getSet().isEmpty()) {
            builder.append(this.getSetExpression());
        } else if (this.action.getAscendants() != null && !this.action.getAscendants().isEmpty()) {
            builder.append(this.getAscendantsExpression());
        } else if (this.action.getRootMembers() != null && this.action.getRootMembers().booleanValue()) {
            builder.append(this.getRootMembersExpression());
        } else if (this.action.getIsNull() != null) {
            builder.append(this.getIsNullSelectionFilterExpression());
        } else if (this.action.getBetween() != null) {
            builder.append(this.getBetweenSelectionFilterExpression());
        } else if (this.action.getContainsignorecase() != null) {
            builder.append(this.getContainsSelectionFilterExpression());
        } else if (this.action.getFilter() != null) {
            builder.append(this.getSelectionFilterExpression());
        } else if (this.action.getEq() != null) {
            builder.append(this.getComparisonSelectionFilterExpression(" = ", this.action.getEq()));
        } else if (this.action.getLt() != null) {
            builder.append(this.getComparisonSelectionFilterExpression(" < ", this.action.getLt()));
        } else if (this.action.getLte() != null) {
            builder.append(this.getComparisonSelectionFilterExpression(" <= ", this.action.getLte()));
        } else if (this.action.getGt() != null) {
            builder.append(this.getComparisonSelectionFilterExpression(" > ", this.action.getGt()));
        } else if (this.action.getGte() != null) {
            builder.append(this.getComparisonSelectionFilterExpression(" >= ", this.action.getGte()));
        } else if (this.action.getDrillUp() != null) {
            builder.append(this.getDrillUpExpression());
        } else if (this.action.getSelectDepth() != null) {
            builder.append(this.getSelectDepthExpression());
        } else if (this.action.getSort() != null) {
            builder.append(this.getSortExpression());
        }
        if (v5ActionFunctionRequired) {
            builder.append(RIGHT_PAREN_STR);
        }
        if (builder.length() > 0) {
            this.expression = builder.toString();
        }
        return this.expression;
    }

    private String getDescendantsExpression() {
        Descendants descendants = this.action.getDescendants();
        StringBuilder builder = new StringBuilder("descendants(");
        builder.append(descendants.getMember()).append(SEPARATOR).append(descendants.getDistance()).append(SEPARATOR).append(descendants.getFlag()).append(RIGHT_PAREN_STR);
        return builder.toString();
    }

    private String getSelectDepthExpression() {
        StringBuilder builder = new StringBuilder();
        int depth = this.action.getSelectDepth();
        ColumnMetadata metadata = this.executor.getColumnMetadata(this.getSubject());
        if (metadata == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_COLUMN_IDX_NOT_FOUND, this.getSubject(), this.executor.getDataset().getName());
        }
        ColumnMetadata.SourceCategory category = metadata.getSourceCategory();
        if (category.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL)) {
            builder.append("members(levels(");
            builder.append(this.getSubject());
            builder.append(SEPARATOR);
            builder.append(depth);
            builder.append("))");
        } else if (category.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD)) {
            builder.append("descendants(rootMembers(");
            builder.append(this.getSubject());
            builder.append(RIGHT_PAREN_STR);
            builder.append(SEPARATOR);
            builder.append(depth);
            builder.append(RIGHT_PAREN_STR);
        } else if (category.equals((Object)ColumnMetadata.SourceCategory.COLUMN)) {
            builder.append("descendants(");
            builder.append(this.getIdentifier() + "->all");
            builder.append(SEPARATOR);
            builder.append(depth);
            builder.append(RIGHT_PAREN_STR);
        } else {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_SELECT_DEPTH_NOT_SUPPORTED, this.getSubject());
        }
        return builder.toString();
    }

    private String getDrillUpExpression() {
        StringBuilder builder = new StringBuilder();
        String drillUp = this.action.getDrillUp();
        if (drillUp == null || drillUp.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "drillUp function requires one pun.");
        }
        builder.append("union ( children(parent(");
        builder.append(this.action.getDrillUp());
        builder.append("))");
        builder.append(SEPARATOR);
        builder.append("head(");
        ColumnMetadata column = this.executor.getColumnMetadata(this.getIdentifier());
        ColumnMetadata.SourceCategory category = column.getSourceCategory();
        String rootMembers = EMPTY_STRING;
        rootMembers = category.equals((Object)ColumnMetadata.SourceCategory.COLUMN) ? "set(" + this.getIdentifier() + "->all)" : "rootMembers(" + this.getSubject() + RIGHT_PAREN_STR;
        builder.append(rootMembers);
        builder.append(SEPARATOR);
        builder.append("if ( count ( 1 within set children(parent(");
        builder.append(this.action.getDrillUp());
        builder.append("))) = 0) then (  count(1 within set " + rootMembers);
        builder.append(") ) else (0)))");
        return builder.toString();
    }

    private String getSubject() {
        return this.expression == null ? this.getIdentifier() : this.expression;
    }

    private String getIdentifier() {
        return this.identifier.getIdentifier();
    }

    @Override
    public String execute(ActionContext actionContext, Action action, DataItem currentDataItem) throws QueryServiceException {
        this.action = action;
        if (this.init(actionContext, currentDataItem)) {
            return this.applyAction();
        }
        return null;
    }

    protected String getTopBottomExpression() {
        ColumnMetadata metadata;
        boolean percentType;
        TopBottom topBottom = this.action.getTopBottom();
        TopBottom.Type type = topBottom.getType();
        boolean bl = percentType = type == TopBottom.Type.TOPPERCENT || type == TopBottom.Type.BOTTOMPERCENT;
        if (percentType) {
            if (this.executor.queryIncludesAutoBinningDataItems()) {
                throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_TOPBOTTOM_PERCENT_AUTOGROUP_INVALID_SPEC);
            }
            this.executor.setQueryIncludesTopBottomPercentDataItems(true);
        }
        if ((metadata = this.executor.getColumnMetadata(this.getIdentifier())) == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_COLUMN_IDX_NOT_FOUND, this.getSubject(), this.executor.getDataset().getName());
        }
        if (this.dataItem.getBinning() == null && (this.executor.getDataItemProjectionType(this.dataItemID) == DataExecutor.ProjectionType.METRIC || metadata.getType() == ColumnMetadata.Type.FACT)) {
            List context = this.action.getContext();
            if (context != null && !context.isEmpty()) {
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Context not supported on measures");
            }
            if (percentType) {
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "topPercent and bottomPercent not supported on measures");
            }
            com.ibm.bi.qs.model.api.AggregateType convertedAggType = null;
            if (this.dataItem.getAggregate() != null) {
                convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)this.dataItem.getAggregate().toString());
            }
            if (BaseActionHandler.useNewRelationalTopBottomCount(type, this.executor)) {
                this.processNonContextualTopBottomCountForRelational(topBottom, convertedAggType);
                return null;
            }
            String ctxName = this.dataItemID;
            ctxName = ctxName.replace(LEFT_BRACKET_STR, UNDERSCORE_STR);
            ctxName = ctxName.replace(RIGHT_BRACKET_STR, UNDERSCORE_STR);
            ctxName = convertedAggType != null ? ctxName + UNDERSCORE_STR + convertedAggType.toString() : ctxName + "_AGG_NULL";
            if (this.executor.getPrimaryQuery().getDataItemByName(ctxName) == null) {
                V5MultiPartIdentifier ctxIdentifier = TransformationUtils.createMultiPartIdentifier(metadata, this.nodeFactory);
                TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), ctxName, convertedAggType, (IXQEQueryNode)ctxIdentifier, this.nodeFactory);
            }
            String rankMeasureDataItem = LEFT_BRACKET_STR + ctxName + RIGHT_BRACKET_STR;
            String rankItemName = this.getRankDataItemName();
            V5Expression v5Expression = (V5Expression)this.nodeFactory.createNode(101004);
            v5Expression.setExpression(this.getMetricRankExpression(rankMeasureDataItem, TopBottom.Type.TOPCOUNT.equals((Object)type), this.executor.isDimensional()));
            TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), rankItemName, com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, (IXQEQueryNode)v5Expression, this.nodeFactory);
            if (this.executor.isDimensional() || this.executor.getSecondaryQuery() == null) {
                V5DetailFilter v5filter = this.injectTopBottomFilter(rankItemName, Integer.toString(topBottom.getValue() + 1), this.executor.getPrimaryQuery());
                this.executor.getPrimaryQuery().addChild((IXQEQueryNode)v5filter);
            } else {
                V5BoundDataItemReference rankRef = TransformationUtils.createBoundDataItemReference(this.executor.getPrimaryQuery(), rankItemName, this.nodeFactory, true);
                TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getSecondaryQuery(), rankItemName, null, (IXQEQueryNode)rankRef, this.nodeFactory);
                V5DetailFilter v5filter = this.injectTopBottomFilter(rankItemName, Integer.toString(topBottom.getValue() + 1), this.executor.getSecondaryQuery());
                this.executor.getSecondaryQuery().addChild((IXQEQueryNode)v5filter);
            }
            if (this.action.getTopBottom().getRank().booleanValue()) {
                this.rankCalcIdentifiers.add(rankItemName);
            }
            return null;
        }
        List context = this.action.getContext();
        if (context == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Context supports one parameter");
        }
        if (context.size() > 1 && this.action.getTopBottom().getRank().booleanValue()) {
            throw new QueryServiceException(QueryServiceMessageKeys.PLN_RANK_CONTEXT_ERROR);
        }
        if (context.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Context required on non-measures");
        }
        if (BaseActionHandler.useNewRelationalTopBottomCount(type, this.executor)) {
            this.processContextualTopBottomCountForRelational(topBottom, context);
            return this.getSubject();
        }
        String ctx = this.getContext(context);
        if (this.executor.getSecondaryQuery() == null) {
            StringBuilder builder = new StringBuilder();
            String n = topBottom.getValue().toString();
            builder.append(type.toString());
            builder.append(LEFT_PAREN_STR);
            builder.append(this.getSubject());
            builder.append(SEPARATOR);
            builder.append(n);
            builder.append(ctx);
            if (this.action.getTopBottom().getRank().booleanValue()) {
                String rankItemName = this.getRankDataItemName();
                V5Expression v5Expression = (V5Expression)this.nodeFactory.createNode(101004);
                com.ibm.bi.qs.model.api.AggregateType aggregate = (com.ibm.bi.qs.model.api.AggregateType)this.actionContext.get(ParamName.CONTEXT_AGGREGATE);
                this.actionContext.remove(ParamName.CONTEXT_AGGREGATE);
                v5Expression.setExpression(this.getCategoricalRankExpression(ctx.substring(2), this.getSubject(), TopBottom.Type.TOPCOUNT.equals((Object)type), this.executor.isDimensional(), aggregate));
                TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), rankItemName, com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, (IXQEQueryNode)v5Expression, this.nodeFactory);
                this.rankCalcIdentifiers.add(rankItemName);
            }
            builder.append(RIGHT_PAREN_STR);
            return builder.toString();
        }
        String rankItemName = this.getRankDataItemName();
        V5Expression v5Expression = (V5Expression)this.nodeFactory.createNode(101004);
        com.ibm.bi.qs.model.api.AggregateType aggregate = (com.ibm.bi.qs.model.api.AggregateType)this.actionContext.get(ParamName.CONTEXT_AGGREGATE);
        this.actionContext.remove(ParamName.CONTEXT_AGGREGATE);
        String forClauseDataItemId = this.getSubject();
        if (this.executor.getBaseQuery() != null && forClauseDataItemId.equals(this.dataItem.getItemId())) {
            forClauseDataItemId = this.dataItem.getId();
        }
        v5Expression.setExpression(this.getCategoricalRankExpression(ctx.substring(2), forClauseDataItemId, TopBottom.Type.TOPCOUNT.equals((Object)type) || TopBottom.Type.TOPPERCENT.equals((Object)type), this.executor.isDimensional(), aggregate));
        TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), rankItemName, com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, (IXQEQueryNode)v5Expression, this.nodeFactory);
        String topValue = Integer.toString(topBottom.getValue() + 1);
        V5DetailFilter v5filterForRank = this.injectTopBottomFilter(rankItemName, topValue, this.executor.getPrimaryQuery());
        this.executor.getPrimaryQuery().addChild((IXQEQueryNode)v5filterForRank);
        List<String> projections = DataExecutor.getProjections(this.executor.getQuerySpec());
        String contxtId = ((Context)context.get(0)).getItemId();
        ColumnMetadata contextMetadata = this.executor.getColumnMetadata(contxtId);
        if (contextMetadata != null && contextMetadata.getQuerySubjectID() != null) {
            boolean needNullFilterForContext = false;
            for (String projection : projections) {
                ColumnMetadata column;
                DataItem aDataItem;
                if (projection.equals(this.dataItem.getId()) || (aDataItem = this.executor.findDataItem(projection)) == null || aDataItem.getItemId() == null || (column = this.executor.getColumnMetadata(aDataItem.getItemId())) == null || column.getQuerySubjectID() == null || column.equals((Object)contextMetadata) || column.getQuerySubjectID().equals(contextMetadata.getQuerySubjectID()) || !(needNullFilterForContext = column.getType() == ColumnMetadata.Type.FACT)) continue;
                V5DetailFilter v5filterForNullRank = this.injectNullFilter(rankItemName, this.executor.getPrimaryQuery());
                this.executor.getPrimaryQuery().addChild((IXQEQueryNode)v5filterForNullRank);
                break;
            }
        }
        if (this.action.getTopBottom().getRank().booleanValue()) {
            v5Expression = (V5Expression)this.nodeFactory.createNode(101004);
            v5Expression.setExpression(this.getCategoricalRankExpression(ctx.substring(2), forClauseDataItemId, TopBottom.Type.TOPCOUNT.equals((Object)type), this.executor.isDimensional(), aggregate));
            TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), rankItemName, com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, (IXQEQueryNode)v5Expression, this.nodeFactory);
            this.rankCalcIdentifiers.add(rankItemName);
        }
        return this.getSubject();
    }

    private void processNonContextualTopBottomCountForRelational(TopBottom topBottom, com.ibm.bi.qs.model.api.AggregateType aggrType) {
        TopBottom.Type type = topBottom.getType();
        String numericExpr = this.dataItem.getItemId();
        String numericExprId = this.dataItem.getId();
        ColumnMetadata numericExprMetadata = this.executor.getColumnMetadata(numericExpr);
        String numericExprDIRef = String.format(DATAITEM_REFERENCE, numericExprId);
        String aggregateForRank = EMPTY_STRING;
        if (aggrType != null) {
            aggregateForRank = TransformationUtils.getV5SummaryFunction(aggrType);
        }
        if (aggrType == null) {
            aggrType = com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC;
        }
        V5QueryResultDefinition qrd = this.getQRD();
        this.addSortItemForNumExpression(numericExpr, numericExprId, aggrType, qrd);
        String rankItemName = this.getRankDataItemName();
        String sortType = EMPTY_STRING;
        if (type == TopBottom.Type.TOPCOUNT) {
            sortType = DESC_STR;
        } else if (type == TopBottom.Type.BOTTOMCOUNT) {
            sortType = ASC_STR;
        }
        String rankExpression = null;
        rankExpression = numericExprMetadata.isCalculation() == false ? String.format(NONCONTEXTUAL_V5_RANK_FUNCTION, aggregateForRank, numericExprDIRef, sortType) : String.format(NONCONTEXTUAL_V5_RANK_FUNCTION_FOR_CALC, numericExprDIRef, sortType);
        this.buildDataItem(this.executor.getPrimaryQuery(), com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, rankExpression, rankItemName);
        V5DetailFilter detailfilterForRankMainQuery = (V5DetailFilter)this.nodeFactory.createNode(101008);
        detailfilterForRankMainQuery.setUseProperty("required");
        detailfilterForRankMainQuery.setPostAutoAggregation(true);
        detailfilterForRankMainQuery.setPropertyValue(IS_TOP_BOTTOM_COUNT_CONTEXTUAL, (Object)Boolean.FALSE);
        V5FilterExpression filterExpr = (V5FilterExpression)this.nodeFactory.createNode(101013);
        detailfilterForRankMainQuery.addChild((IXQEQueryNode)filterExpr);
        V5ComparisonExpression compExpr = (V5ComparisonExpression)this.nodeFactory.createNode(201013);
        V5BoundDataItemReference rankIdentifier = TransformationUtils.createBoundDataItemReference(this.executor.getPrimaryQuery(), rankItemName, this.nodeFactory, false);
        compExpr.addChild((IXQEQueryNode)rankIdentifier);
        compExpr.setSubType(1);
        V5LiteralValue literal = (V5LiteralValue)this.nodeFactory.createNode(201026);
        compExpr.addChild((IXQEQueryNode)literal);
        String index = Integer.toString(topBottom.getValue());
        literal.setDataType(FilterGenerator.getNumericDataType(index));
        Value v = (Value)literal.getDataType().createValue();
        v.set(index);
        literal.setPropertyValue("value", (Object)v);
        V5IsNullExpression isNull = (V5IsNullExpression)this.nodeFactory.createNode(201010);
        rankIdentifier = TransformationUtils.createBoundDataItemReference(this.executor.getPrimaryQuery(), rankItemName, this.nodeFactory, false);
        isNull.addChild((IXQEQueryNode)rankIdentifier);
        V5LogicalExpression not = (V5LogicalExpression)this.nodeFactory.createNode(201003);
        not.setSubType(2);
        not.addChild((IXQEQueryNode)isNull);
        V5LogicalExpression and = (V5LogicalExpression)this.nodeFactory.createNode(201003);
        and.setSubType(0);
        and.addChild((IXQEQueryNode)compExpr);
        and.addChild((IXQEQueryNode)not);
        filterExpr.setExpression(and.getOriginalExpression());
        this.executor.getPrimaryQuery().addChild((IXQEQueryNode)detailfilterForRankMainQuery);
        this.projectRank(qrd);
        this.executor.setHasNonContextualTopBottomCount(true);
    }

    private void processContextualTopBottomCountForRelational(TopBottom topBottom, List<Context> context) {
        String numericExprDIRef;
        TopBottom.Type type = topBottom.getType();
        boolean isTopbottomCountProj = this.isProjectedByQuerySpec(this.dataItem);
        boolean isTopbottomCountInFilter = this.isFilteredByQuerySpec(this.dataItem);
        StringBuilder subQueryName = new StringBuilder(TOP_BOTTOM_COUNT_SUBQUERY_NAME);
        subQueryName.append(this.executor.getNextSubQueryId());
        V5Query topBottomQuery = TransformationUtils.buildV5QueryNode(this.nodeFactory, subQueryName.toString(), null, this.executor.isModuleDataset(), null);
        topBottomQuery.setBooleanPropertyValue("containsQueryHint", Boolean.TRUE.toString());
        topBottomQuery.setBooleanPropertyValue(V5Query.QueryHint.IGNORE_FILTERS_NOT_APPLICABLE.getPropertyName(), Boolean.TRUE.toString());
        this.executor.getPrimaryQuery().getParent().addChildAfterNode((IXQEQueryNode)topBottomQuery, (IXQEQueryNode)this.executor.getPrimaryQuery());
        this.executor.addTopBottomQuery(topBottomQuery);
        if (!isTopbottomCountProj && isTopbottomCountInFilter) {
            this.executor.addNonProjTopBottomCountInFilterDIs(this.dataItem);
        }
        String setExpression = this.dataItem.getItemId();
        String setExprId = this.dataItem.getId();
        V5DataItem setExprDataItem = this.buildDataItem(topBottomQuery, com.ibm.bi.qs.model.api.AggregateType.NONE, setExpression, setExprId);
        String numericExpr = context.get(0).getItemId();
        ColumnMetadata numericExprMetadata = this.executor.getColumnMetadata(numericExpr);
        String numericExprName = numericExprDIRef = numericExprMetadata.getColumnName();
        if (numericExprDIRef.startsWith(LEFT_BRACKET_STR) && numericExprDIRef.endsWith(RIGHT_BRACKET_STR)) {
            numericExprName = numericExprDIRef.replaceAll("(]\\.\\[)", UNDERSCORE_STR);
            numericExprName = numericExprDIRef.replaceAll("\\u005B|\\u005D", EMPTY_STRING);
        }
        String numericExprId = String.format(NUM_EXPR_PREFIX, numericExprName);
        numericExprDIRef = String.format(DATAITEM_REFERENCE, numericExprId);
        com.ibm.bi.qs.model.api.AggregateType aggregateType = (com.ibm.bi.qs.model.api.AggregateType)this.actionContext.get(ParamName.CONTEXT_AGGREGATE);
        this.actionContext.remove(ParamName.CONTEXT_AGGREGATE);
        String aggregateForRank = EMPTY_STRING;
        if (aggregateType == null) {
            aggregateType = numericExprMetadata.getDefaultAggregation();
        }
        if (aggregateType != null) {
            aggregateForRank = TransformationUtils.getV5SummaryFunction(aggregateType);
        }
        if (aggregateType == null) {
            aggregateType = com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC;
        }
        this.buildDataItem(topBottomQuery, aggregateType, numericExpr, numericExprId);
        V5QueryResultDefinition qrd = this.getQRD();
        this.addSortItemForNumExpression(numericExpr, numericExprId, aggregateType, qrd);
        String rankItemName = String.format(RANK_DATAITEM_NAME, numericExprName, setExprId);
        String sortType = EMPTY_STRING;
        if (type == TopBottom.Type.TOPCOUNT) {
            sortType = DESC_STR;
        } else if (type == TopBottom.Type.BOTTOMCOUNT) {
            sortType = ASC_STR;
        }
        String rankExpression = null;
        rankExpression = numericExprMetadata.isCalculation() == false ? String.format(CONTEXTUAL_V5_RANK_FUNCTION, aggregateForRank, numericExprDIRef, sortType) : String.format(CONTEXTUAL_V5_RANK_FUNCTION_FOR_CALC, numericExprDIRef, sortType);
        this.buildDataItem(topBottomQuery, com.ibm.bi.qs.model.api.AggregateType.AUTOMATIC, rankExpression, rankItemName);
        List<String> projections = DataExecutor.getProjections(this.executor.getQuerySpec());
        boolean isProjectedTopBottom = projections.contains(setExprId);
        if (isProjectedTopBottom && this.action.getTopBottom().getRank().booleanValue()) {
            this.buildDataItem(this.executor.getPrimaryQuery(), aggregateType, numericExpr, numericExprId);
            String rsRankItemName = this.getRankDataItemName();
            String projRankExpression = String.format(CONTEXTUAL_PROJ_V5_RANK_FUNCTION, aggregateForRank, numericExprDIRef, String.format(DATAITEM_REFERENCE, setExprId), sortType);
            this.buildDataItem(this.executor.getPrimaryQuery(), com.ibm.bi.qs.model.api.AggregateType.NONE, projRankExpression, rsRankItemName);
        }
        V5DetailFilter detailfilterForRankSubQuery = (V5DetailFilter)this.nodeFactory.createNode(101008);
        detailfilterForRankSubQuery.setUseProperty("required");
        detailfilterForRankSubQuery.setPostAutoAggregation(true);
        detailfilterForRankSubQuery.setPropertyValue(IS_TOP_BOTTOM_COUNT_CONTEXTUAL, (Object)Boolean.TRUE);
        V5FilterExpression filterExpr = (V5FilterExpression)this.nodeFactory.createNode(101013);
        detailfilterForRankSubQuery.addChild((IXQEQueryNode)filterExpr);
        V5ComparisonExpression compExpr = (V5ComparisonExpression)this.nodeFactory.createNode(201013);
        V5BoundDataItemReference rankIdentifier = TransformationUtils.createBoundDataItemReference(topBottomQuery, rankItemName, this.nodeFactory, false);
        compExpr.addChild((IXQEQueryNode)rankIdentifier);
        compExpr.setSubType(1);
        V5LiteralValue literal = (V5LiteralValue)this.nodeFactory.createNode(201026);
        compExpr.addChild((IXQEQueryNode)literal);
        String index = Integer.toString(topBottom.getValue());
        literal.setDataType(FilterGenerator.getNumericDataType(index));
        Value v = (Value)literal.getDataType().createValue();
        v.set(index);
        literal.setPropertyValue("value", (Object)v);
        filterExpr.setExpression(compExpr.getOriginalExpression());
        topBottomQuery.addChild((IXQEQueryNode)detailfilterForRankSubQuery);
        com.ibm.bi.qs.model.api.AggregateType convertedAggType = null;
        AggregateType aggType = this.dataItem.getAggregate();
        if (aggType != null) {
            convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
        }
        String dataItemExpr = this.dataItem.getItemId();
        String dataItemID = this.dataItem.getId();
        if (!isTopbottomCountProj && isTopbottomCountInFilter) {
            String subQueryDIName;
            dataItemExpr = subQueryDIName = BaseActionHandler.createInterQueryRefName(topBottomQuery, dataItemID);
        }
        V5DataItem v5DataItem = this.buildDataItem(this.executor.getPrimaryQuery(), convertedAggType, dataItemExpr, dataItemID);
        if (isTopbottomCountProj || !isTopbottomCountInFilter) {
            V5DetailFilter detailfilterForMainQuery = (V5DetailFilter)this.nodeFactory.createNode(101008);
            detailfilterForMainQuery.setUseProperty("required");
            detailfilterForMainQuery.setPostAutoAggregation(false);
            this.executor.getPrimaryQuery().addChild((IXQEQueryNode)detailfilterForMainQuery);
            filterExpr = (V5FilterExpression)this.nodeFactory.createNode(101013);
            detailfilterForMainQuery.addChild((IXQEQueryNode)filterExpr);
            String escapedName = UniqueNameParser.escapeSquareBrackets((String)v5DataItem.getNameProperty());
            String primaryQueryDIName = UniqueNameGenerator.createUniqueName((String)escapedName);
            String subQueryDIName = BaseActionHandler.createInterQueryRefName(topBottomQuery, setExprDataItem.getNameProperty());
            String inFilterExpr = String.format(IN_FILTER, primaryQueryDIName, subQueryDIName);
            filterExpr.setExpression(inFilterExpr);
        }
        if (isProjectedTopBottom) {
            this.projectRank(qrd);
        }
    }

    public static String createInterQueryRefName(V5Query query, String dataItemID) {
        String escapedName = UniqueNameParser.escapeSquareBrackets((String)dataItemID);
        String subQueryDIName = TransformationUtils.createInterQueryRefName(query, escapedName);
        return subQueryDIName;
    }

    private void projectRank(V5QueryResultDefinition qrd) {
        if (!this.action.getTopBottom().getRank().booleanValue()) {
            return;
        }
        String rankItemName = this.getRankDataItemName();
        IXQEQueryNode[] v5GroupBodyArray = qrd.getDescendantsOfType(101051, false);
        if (v5GroupBodyArray == null || v5GroupBodyArray.length == 0) {
            throw new IllegalStateException("No V5GroupBody");
        }
        V5DataItemRef v5DataItemRef = (V5DataItemRef)this.nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)rankItemName);
        v5GroupBodyArray[0].addChild((IXQEQueryNode)v5DataItemRef);
    }

    private V5QueryResultDefinition getQRD() {
        V5QueryResultDefinition qrd = null;
        V5QuerySet v5QuerySetNode = (V5QuerySet)this.executor.getPrimaryQuery().getAncestorOfType(101002);
        List qrds = v5QuerySetNode.getReferencedQRDs(this.executor.getPrimaryQuery());
        if (qrds == null || qrds.isEmpty()) {
            throw new IllegalStateException("No V5QueryResultDefinition");
        }
        qrd = (V5QueryResultDefinition)qrds.get(0);
        return qrd;
    }

    public void addSortItemForNumExpression(String numericExpr, String numericExprId, com.ibm.bi.qs.model.api.AggregateType aggregateType, V5QueryResultDefinition qrd) {
        List dataItems = this.executor.getQuerySpec().getDataItems();
        DataItem numericExprInQuerySpec = null;
        boolean isNumericExprProjected = false;
        for (DataItem aDataItem : dataItems) {
            if (!numericExpr.equals(aDataItem.getItemId())) continue;
            numericExprInQuerySpec = aDataItem;
            isNumericExprProjected = this.isProjectedByQuerySpec(aDataItem);
            if (!isNumericExprProjected) continue;
            break;
        }
        SortOrder numExprInQuerySpecSortOrderType = null;
        List selection = null;
        if (numericExprInQuerySpec != null) {
            selection = numericExprInQuerySpec.getSelection();
            Sort sort = null;
            for (Action action : selection) {
                sort = action.getSort();
                if (sort == null) continue;
                numExprInQuerySpecSortOrderType = sort.getType();
                break;
            }
        }
        boolean foundInQRD = false;
        if (isNumericExprProjected) {
            IXQEQueryNode[] qrdDataItemRefs;
            for (IXQEQueryNode dataItemRef : qrdDataItemRefs = qrd.getDescendantsOfType(101015, false)) {
                if (!((V5DataItemRef)dataItemRef).getDataItemRefProperty().equals(numericExprInQuerySpec.getId())) continue;
                foundInQRD = true;
                break;
            }
        }
        if (numExprInQuerySpecSortOrderType != null && isNumericExprProjected && foundInQRD) {
            this.addV5SortItemForTopBottom(numExprInQuerySpecSortOrderType, qrd, numericExprInQuerySpec.getId());
        }
    }

    private boolean isProjectedByQuerySpec(DataItem aDataItem) {
        List<String> projections = DataExecutor.getProjections(this.executor.getQuerySpec());
        for (String projection : projections) {
            if (!projection.equals(aDataItem.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isFilteredByQuerySpec(DataItem aDataItem) {
        List filters = this.executor.getQuerySpec().getFilters();
        if (filters == null || filters.isEmpty()) {
            return false;
        }
        for (Filter currFilter : filters) {
            FilterExpression targetFilterExpr = currFilter.getExpression();
            if (!BaseActionHandler.isDataItemReferencedByFilterExpression(targetFilterExpr, aDataItem.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDataItemReferencedByFilterExpression(FilterExpression targetFilterExpr, String aDataItemId) {
        if (targetFilterExpr instanceof NotFilter) {
            targetFilterExpr = ((NotFilter)targetFilterExpr).getNot();
            return BaseActionHandler.isDataItemReferencedByFilterExpression(targetFilterExpr, aDataItemId);
        }
        if (targetFilterExpr instanceof AndFilter) {
            List aFilterExprList = ((AndFilter)targetFilterExpr).getAnd();
            for (FilterExpression aFilterExp : aFilterExprList) {
                if (!BaseActionHandler.isDataItemReferencedByFilterExpression(aFilterExp, aDataItemId)) continue;
                return true;
            }
        } else if (targetFilterExpr instanceof OrFilter) {
            List aFilterExprList = ((OrFilter)targetFilterExpr).getOr();
            for (FilterExpression aFilterExp : aFilterExprList) {
                if (!BaseActionHandler.isDataItemReferencedByFilterExpression(aFilterExp, aDataItemId)) continue;
                return true;
            }
        } else if (((DataFilter)targetFilterExpr).getValueDataItem() != null && aDataItemId.equals(((DataFilter)targetFilterExpr).getValueDataItem())) {
            return true;
        }
        return false;
    }

    private void addV5SortItemForTopBottom(SortOrder sortOrderType, V5QueryResultDefinition qrd, String sortByItem) {
        V5SortItem sortItem = (V5SortItem)this.nodeFactory.createNode(101056);
        String orderString = EMPTY_STRING;
        if (sortOrderType == SortOrder.ASC) {
            orderString = "ascending";
        } else if (sortOrderType == SortOrder.DESC) {
            orderString = "descending";
        }
        sortItem.setStringPropertyValue("sortOrder", orderString);
        sortItem.setStringPropertyValue("refDataItem", sortByItem);
        IXQEQueryNode[] valueSets = qrd.getDescendantsOfType(101057, false);
        valueSets[0].addChild((IXQEQueryNode)sortItem);
    }

    private V5DataItem buildDataItem(V5Query query, com.ibm.bi.qs.model.api.AggregateType aggregateType, String expression, String dataItemID) {
        V5Expression v5Expression = (V5Expression)this.nodeFactory.createNode(101004);
        v5Expression.setExpression(expression);
        V5DataItem v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)query, dataItemID, aggregateType, (IXQEQueryNode)v5Expression, this.nodeFactory);
        return v5DataItem;
    }

    private String getRankDataItemName() {
        return String.format("calc_%s.calculated", this.dataItem.getId());
    }

    private V5DetailFilter injectTopBottomFilter(String rankItemName, String value, V5Query query) {
        Filter filter = new Filter();
        filter.setType(Filter.Type.POST);
        DataFilter dataFilter = new DataFilter();
        dataFilter.setOperator(FilterOperator.LT);
        dataFilter.setItemId(rankItemName);
        dataFilter.setValues(Arrays.asList(value));
        filter.setExpression((FilterExpression)dataFilter);
        V5DetailFilter v5filter = FilterGenerator.generateFilter(this.nodeFactory, query, this.executor.getDataset(), this.executor.getQuerySpec().getDataItems(), filter, null);
        return v5filter;
    }

    private V5DetailFilter injectNullFilter(String target, V5Query query) {
        DataFilter dataFilter = new DataFilter();
        dataFilter.setOperator(FilterOperator.ISNOTNULL);
        dataFilter.setItemId(target);
        Filter filter = new Filter();
        filter.setType(Filter.Type.POST);
        filter.setExpression((FilterExpression)dataFilter);
        V5DetailFilter v5filter = FilterGenerator.generateFilter(this.nodeFactory, query, this.executor.getDataset(), this.executor.getQuerySpec().getDataItems(), filter, null);
        return v5filter;
    }

    protected String getContext(List<Context> contextList) {
        StringBuilder builder = new StringBuilder();
        builder.append(SEPARATOR);
        if (contextList.size() > 1) {
            builder.append("tuple(");
        }
        for (int i = 0; i < contextList.size(); ++i) {
            Context context = contextList.get(i);
            String itemId = context.getItemId();
            List actions = context.getSelection();
            if (i > 0) {
                builder.append(SEPARATOR);
            }
            if (actions != null && !actions.isEmpty()) {
                ColumnMetadata column = this.executor.getColumnMetadata(itemId);
                V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(column, this.nodeFactory);
                String contextExpression = EMPTY_STRING;
                ActionFactory actionFactory = ActionFactory.getInstance();
                for (Action nestedAction : actions) {
                    ActionContext nestedActionContext = new ActionContext();
                    nestedActionContext.add(ParamName.IDENTIFIER, identifier);
                    IActionHandler actionHandler = actionFactory.create(nestedAction, this.executor, this.nodeFactory);
                    contextExpression = actionHandler.execute(nestedActionContext, nestedAction, this.dataItem);
                }
                if (!this.executor.getDataset().getType().equals((Object)DataSetType.MODULE)) {
                    builder.append("member(");
                }
                builder.append("aggregate(currentmeasure within set ");
                builder.append(contextExpression);
                builder.append(RIGHT_PAREN_STR);
                if (this.executor.getDataset().getType().equals((Object)DataSetType.MODULE)) continue;
                ColumnMetadata hierarchy = column.getHierarchy();
                if (hierarchy != null) {
                    String uuid = " '" + UUID.randomUUID().toString() + "'";
                    builder.append(SEPARATOR + uuid + SEPARATOR + uuid + SEPARATOR + " " + hierarchy.getColumnId());
                }
                builder.append(RIGHT_PAREN_STR);
                continue;
            }
            ColumnMetadata measureColumn = this.executor.getColumnMetadata(itemId);
            AggregateType aggType = context.getAggregate();
            if (aggType != null) {
                V5MultiPartIdentifier ctxIdentifier = TransformationUtils.createMultiPartIdentifier(measureColumn, this.nodeFactory);
                com.ibm.bi.qs.model.api.AggregateType convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
                this.actionContext.add(ParamName.CONTEXT_AGGREGATE, convertedAggType);
                String ctxName = BaseActionHandler.generateItemName(itemId, convertedAggType);
                if (this.executor.getPrimaryQuery().getDataItemByName(ctxName) == null) {
                    if (this.executor.getBaseQuery() == null) {
                        TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), ctxName, convertedAggType, (IXQEQueryNode)ctxIdentifier, this.nodeFactory);
                    } else {
                        TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getBaseQuery(), ctxName, convertedAggType, (IXQEQueryNode)ctxIdentifier, this.nodeFactory);
                        V5BoundDataItemReference ref = TransformationUtils.createBoundDataItemReference(this.executor.getBaseQuery(), ctxName, this.nodeFactory, true);
                        TransformationUtils.buildDataItem((IXQEQueryNode)this.executor.getPrimaryQuery(), ctxName, null, (IXQEQueryNode)ref, this.nodeFactory);
                    }
                }
                builder.append(BaseActionHandler.generateItemNameReference(itemId, convertedAggType));
                continue;
            }
            builder.append(itemId);
        }
        if (contextList.size() > 1) {
            builder.append(RIGHT_PAREN_STR);
        }
        return builder.toString();
    }

    public static String generateItemName(String itemId, com.ibm.bi.qs.model.api.AggregateType convertedAggType) {
        String ctxName = itemId;
        ctxName = ctxName.replace(LEFT_BRACKET_STR, UNDERSCORE_STR);
        ctxName = ctxName.replace(RIGHT_BRACKET_STR, UNDERSCORE_STR);
        ctxName = ctxName + UNDERSCORE_STR + convertedAggType.toString();
        return ctxName;
    }

    public static String generateItemNameReference(String name, com.ibm.bi.qs.model.api.AggregateType convertedAggType) {
        return String.format(DATAITEM_REFERENCE, BaseActionHandler.generateItemName(name, convertedAggType));
    }

    protected String getMetricRankExpression(String dataItemItemID, boolean isDescending, boolean isDimensional) {
        String forReport = EMPTY_STRING;
        if (isDimensional) {
            forReport = FOR_REPORT_STR;
        }
        if (isDescending) {
            return String.format(V5_RANK_FUNCTION_DESC_FORMAT, dataItemItemID, forReport);
        }
        return String.format(V5_RANK_FUNCTION_ASC_FORMAT, dataItemItemID, forReport);
    }

    protected String getCategoricalRankExpression(String ctxDataItemID, String dataItemID, boolean isDescending, boolean isDimensional, com.ibm.bi.qs.model.api.AggregateType aggregateType) {
        String forReport = EMPTY_STRING;
        if (isDimensional) {
            forReport = FOR_REPORT_STR;
        }
        String aggregate = "aggregate";
        if (aggregateType != null) {
            aggregate = TransformationUtils.getV5SummaryFunction(aggregateType);
        }
        if (isDescending) {
            return String.format(V5_RANK_FUNCTION_DIM_DESC_FORMAT, aggregate, ctxDataItemID, dataItemID, forReport);
        }
        return String.format(V5_RANK_FUNCTION_DIM_ASC_FORMAT, aggregate, ctxDataItemID, dataItemID, forReport);
    }

    protected String getChildrenExpression() {
        StringBuilder builder = new StringBuilder();
        String child = this.action.getChildren();
        if (child == null || child.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Children function requires one child member.");
        }
        builder.append("children(");
        builder.append(child);
        builder.append(RIGHT_PAREN_STR);
        return builder.toString();
    }

    protected String getSiblingsExpression() {
        StringBuilder builder = new StringBuilder();
        String sibling = this.action.getSiblings();
        if (sibling == null || sibling.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Siblings function requires one sibling member.");
        }
        builder.append("siblings(");
        builder.append(sibling);
        builder.append(RIGHT_PAREN_STR);
        return builder.toString();
    }

    protected String getHeadExpression() {
        StringBuilder builder = new StringBuilder();
        Integer headCount = this.action.getHead();
        if (headCount == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Head count required.");
        }
        builder.append("head(");
        builder.append(this.getSubject());
        builder.append(SEPARATOR);
        builder.append(headCount);
        builder.append(RIGHT_PAREN_STR);
        return builder.toString();
    }

    protected String getSetExpression() {
        List selectedValues = this.action.getSet();
        if (selectedValues == null || selectedValues.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Missing set values");
        }
        StringBuilder builder = new StringBuilder();
        ColumnMetadata.SourceCategory sourceCategory = null;
        try {
            boolean useFUN = false;
            ColumnMetadata column = this.executor.getColumnMetadata(this.identifier.getIdentifier());
            if (column != null) {
                sourceCategory = column.getSourceCategory();
                Action.ValueType valueType = this.action.getValueType();
                if (sourceCategory != null && sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && valueType != Action.ValueType.DISPLAY) {
                    String columnId = column.getParentColumn().getColumnId();
                    column = this.executor.getColumnMetadata(columnId);
                }
                useFUN = column.isFacetEnabled() && valueType != Action.ValueType.DISPLAY;
            }
            this.isMemberSet = useFUN || TransformationUtils.isMemberSet(column);
        }
        catch (QueryServiceException qse) {
            this.isMemberSet = true;
        }
        if (ColumnMetadata.SourceCategory.NAMED_SET == sourceCategory) {
            this.buildIntersectExpressionBegin(builder, selectedValues);
        } else {
            boolean isString = false;
            if (this.isMemberSet) {
                builder.append("set(");
            } else {
                isString = this.buildFilterExpressionBegin(builder);
            }
            if (!this.isMemberSet) {
                builder.append(this.getIdentifier());
                builder.append(" in ");
                builder.append(LEFT_PAREN_STR);
            }
            boolean first = true;
            for (String value : selectedValues) {
                if (first) {
                    first = false;
                } else {
                    builder.append(SEPARATOR);
                }
                if (isString) {
                    builder.append("'");
                }
                builder.append(value);
                if (!isString) continue;
                builder.append("'");
            }
            if (!this.isMemberSet) {
                builder.append(RIGHT_PAREN_STR);
            }
            builder.append(RIGHT_PAREN_STR);
        }
        return builder.toString();
    }

    protected String getRootMembersExpression() {
        StringBuilder builder = new StringBuilder();
        ColumnMetadata column = this.executor.getColumnMetadata(this.getIdentifier());
        ColumnMetadata.SourceCategory category = column.getSourceCategory();
        String rootMembers = EMPTY_STRING;
        rootMembers = category.equals((Object)ColumnMetadata.SourceCategory.COLUMN) ? "set(" + this.getIdentifier() + "->all)" : "rootMembers(" + this.getSubject() + RIGHT_PAREN_STR;
        builder.append(rootMembers);
        return builder.toString();
    }

    protected String getSortExpression() {
        StringBuilder builder = new StringBuilder();
        Sort sort = this.action.getSort();
        if (sort == null) {
            builder.append(this.getSubject());
            return builder.toString();
        }
        SortOrder order = sort.getType();
        if (order == SortOrder.HIERARCHIZE) {
            builder.append("hierarchize(");
            builder.append(this.getSubject());
            builder.append(RIGHT_PAREN_STR);
        }
        return builder.toString();
    }

    protected String getAscendantsExpression() {
        List ascendants = this.action.getAscendants();
        if (ascendants == null || ascendants.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Missing ascendants values");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("hierarchize(generate(set(");
        builder.append(String.join((CharSequence)SEPARATOR, ascendants));
        builder.append(RIGHT_PAREN_STR);
        builder.append(SEPARATOR);
        builder.append("ascendants(currentmember(");
        builder.append(this.getSubject());
        builder.append("))))");
        return builder.toString();
    }

    protected String getIsNullSelectionFilterExpression() {
        boolean isNot;
        StringBuilder builder = new StringBuilder();
        Boolean isNull = this.action.getIsNull();
        if (isNull == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Boolean for isNull required.");
        }
        this.buildFilterExpressionBegin(builder);
        boolean bl = isNot = isNull == false;
        if (isNot) {
            builder.append("not(");
        }
        builder.append("isEmpty(");
        builder.append(this.getFilterInput());
        builder.append(RIGHT_PAREN_STR);
        if (isNot) {
            builder.append(RIGHT_PAREN_STR);
        }
        this.buildFilterExpressionEnd(builder);
        return builder.toString();
    }

    protected String getBetweenSelectionFilterExpression() {
        StringBuilder builder = new StringBuilder();
        Between between = this.action.getBetween();
        if (between == null || between.getFrom() == null || between.getTo() == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "From and to values for between required.");
        }
        boolean isString = this.buildFilterExpressionBegin(builder);
        builder.append(this.getSubject());
        builder.append(" between ");
        if (isString) {
            builder.append("'");
        }
        builder.append(between.getFrom());
        if (isString) {
            builder.append("' and '");
        } else {
            builder.append(" and ");
        }
        builder.append(between.getTo());
        if (isString) {
            builder.append("'");
        }
        this.buildFilterExpressionEnd(builder);
        return builder.toString();
    }

    protected String getContainsSelectionFilterExpression() {
        StringBuilder builder = new StringBuilder();
        String containsString = this.action.getContainsignorecase();
        if (containsString == null || containsString.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "String for containsignorecase required.");
        }
        this.buildFilterExpressionBegin(builder);
        builder.append("lower(");
        builder.append(this.getFilterInput());
        builder.append(") contains lower('");
        builder.append(containsString);
        builder.append("')");
        this.buildFilterExpressionEnd(builder);
        return builder.toString();
    }

    protected String getSelectionFilterExpression() {
        FilterExpression filter = this.action.getFilter();
        StringBuilder builder = new StringBuilder();
        boolean isString = this.buildFilterExpressionBegin(builder);
        builder.append(this.getAssembledFilterExpression(filter, isString));
        this.buildFilterExpressionEnd(builder);
        return builder.toString();
    }

    protected String getAssembledFilterExpression(FilterExpression filter, boolean isString) {
        String expression;
        int idx;
        List filters;
        StringBuilder builder = new StringBuilder();
        if (filter instanceof DataFilter) {
            this.getFilterExpression(builder, (DataFilter)filter, isString);
        }
        if (filter instanceof NotFilter) {
            builder.append("not(");
            FilterExpression subFilter = ((NotFilter)filter).getNot();
            builder.append(this.getAssembledFilterExpression(subFilter, isString));
            builder.append(RIGHT_PAREN_STR);
        }
        if (filter instanceof AndFilter) {
            filters = ((AndFilter)filter).getAnd();
            for (idx = 0; idx < filters.size(); ++idx) {
                expression = this.getAssembledFilterExpression((FilterExpression)filters.get(idx), isString);
                if (idx > 0) {
                    builder.append(" and ");
                }
                builder.append(expression);
            }
        }
        if (filter instanceof OrFilter) {
            filters = ((OrFilter)filter).getOr();
            for (idx = 0; idx < filters.size(); ++idx) {
                expression = this.getAssembledFilterExpression((FilterExpression)filters.get(idx), isString);
                if (idx > 0) {
                    builder.append(" or ");
                }
                builder.append(expression);
            }
        }
        return builder.toString();
    }

    private void getFilterExpression(StringBuilder builder, DataFilter filter, boolean isString) {
        FilterOperator operator = filter.getOperator();
        List values = filter.getValues();
        if (values.size() != 1) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Search condition only supports one value.");
        }
        boolean ignoreCase = filter.getIgnoreCase();
        String filterInput = this.getFilterInput();
        if (operator.equals((Object)FilterOperator.CONTAINSIGNORECASE) || operator.equals((Object)FilterOperator.CONTAINS) && ignoreCase) {
            builder.append("lower(");
            builder.append(filterInput);
            builder.append(") contains lower('");
            builder.append((String)values.get(0));
            builder.append("')");
        } else if (operator.equals((Object)FilterOperator.CONTAINS) && !ignoreCase) {
            builder.append(filterInput);
            builder.append(" contains '");
            builder.append((String)values.get(0));
            builder.append("'");
        } else if (operator.equals((Object)FilterOperator.BEGINSWITH)) {
            if (ignoreCase) {
                builder.append("lower(");
                builder.append(filterInput);
                builder.append(") starts with lower('");
                builder.append((String)values.get(0));
                builder.append("')");
            } else {
                builder.append(filterInput);
                builder.append(" starts with '");
                builder.append((String)values.get(0));
                builder.append("'");
            }
        } else if (operator.equals((Object)FilterOperator.ENDSWITH)) {
            if (ignoreCase) {
                builder.append("lower(");
                builder.append(filterInput);
                builder.append(") ends with lower('");
                builder.append((String)values.get(0));
                builder.append("')");
            } else {
                builder.append(filterInput);
                builder.append(" ends with '");
                builder.append((String)values.get(0));
                builder.append("'");
            }
        } else if (operator.equals((Object)FilterOperator.IN)) {
            if (isString && ignoreCase) {
                builder.append("lower(");
                builder.append(filterInput);
                builder.append(") in (lower('");
                builder.append((String)values.get(0));
                builder.append("'))");
            } else {
                builder.append(filterInput);
                builder.append(" in (");
                if (isString) {
                    builder.append("'");
                }
                builder.append((String)values.get(0));
                if (isString) {
                    builder.append("'");
                }
                builder.append(RIGHT_PAREN_STR);
            }
        } else if (operator.equals((Object)FilterOperator.NOTIN)) {
            if (isString && ignoreCase) {
                builder.append("lower(");
                builder.append(filterInput);
                builder.append(") not in (lower('");
                builder.append((String)values.get(0));
                builder.append("'))");
            } else {
                builder.append(filterInput);
                builder.append(" not in (");
                if (isString) {
                    builder.append("'");
                }
                builder.append((String)values.get(0));
                if (isString) {
                    builder.append("'");
                }
                builder.append(RIGHT_PAREN_STR);
            }
        } else {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Invalid seach condition filter.");
        }
    }

    protected String getComparisonSelectionFilterExpression(String operator, String value) {
        StringBuilder builder = new StringBuilder();
        if (value == null || value.isEmpty()) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "String for comparison required.");
        }
        boolean isString = this.buildFilterExpressionBegin(builder);
        builder.append(this.identifier.getIdentifier());
        builder.append(operator);
        if (isString) {
            builder.append("'");
        }
        builder.append(value);
        if (isString) {
            builder.append("'");
        }
        this.buildFilterExpressionEnd(builder);
        return builder.toString();
    }

    private void buildIntersectExpressionBegin(StringBuilder builder, List<String> selectedValues) {
        String filterIdentifier = this.identifier.getIdentifier();
        builder.append("intersect( ");
        builder.append(filterIdentifier);
        builder.append(SEPARATOR);
        builder.append("set( ");
        boolean first = true;
        for (String value : selectedValues) {
            if (first) {
                first = false;
            } else {
                builder.append(SEPARATOR);
            }
            builder.append(value);
        }
        builder.append(RIGHT_PAREN_STR);
        builder.append(RIGHT_PAREN_STR);
    }

    private boolean buildFilterExpressionBegin(StringBuilder builder) {
        String filterOperand;
        boolean isString = false;
        ColumnMetadata column = this.executor.getColumnMetadata(this.identifier.getIdentifier());
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        DataFilter.ValueType valueType = null;
        FilterExpression filter = this.action.getFilter();
        if (filter instanceof DataFilter) {
            valueType = ((DataFilter)filter).getValueType();
        }
        if (TransformationUtils.isMemberSet(column)) {
            this.isMemberSet = true;
        }
        if (this.expression != null && this instanceof KeepActionHandler) {
            filterOperand = this.expression;
        } else if (sourceCategory != null && sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY)) {
            ColumnMetadata.DataType dataType = column.getDataType();
            if (ColumnMetadata.DataType.STRING.equals((Object)dataType) || ColumnMetadata.DataType.DATE.equals((Object)dataType) || ColumnMetadata.DataType.TIME.equals((Object)dataType) || ColumnMetadata.DataType.DATETIME.equals((Object)dataType)) {
                isString = true;
            }
            filterOperand = column.getParentColumn().getColumnId();
        } else {
            isString = TransformationUtils.isMemberSet(column) && valueType == DataFilter.ValueType.DISPLAY;
            filterOperand = column.getColumnId();
        }
        builder.append("filter(");
        builder.append(filterOperand);
        builder.append(SEPARATOR);
        return isString;
    }

    private void buildFilterExpressionEnd(StringBuilder builder) {
        builder.append(RIGHT_PAREN_STR);
    }

    @Override
    public boolean hasAdditionalCalculations() {
        return !this.rankCalcIdentifiers.isEmpty();
    }

    @Override
    public List<String> getRankCalcIdentifiers() {
        return this.rankCalcIdentifiers;
    }

    private String getFilterInput() {
        boolean members = TransformationUtils.isMemberSet(this.executor.getColumnMetadata(this.identifier.getIdentifier()));
        return !members && (this.isProperty || this.expression != null) ? this.getIdentifier() : "caption(" + this.getIdentifier() + RIGHT_PAREN_STR;
    }

    public static boolean useNewRelationalTopBottomCount(TopBottom.Type type, DataExecutor aExecutor) {
        return (type == TopBottom.Type.TOPCOUNT || type == TopBottom.Type.BOTTOMCOUNT) && aExecutor.getQuerySpec().getType() != QuerySpec.Type.MINMAX && aExecutor.isNewRelTopBottomCountEnabled && !aExecutor.isDimensional() && !aExecutor.isDMRTriggeredForRelational();
    }

    public static enum ParamName {
        EXPRESSION,
        IDENTIFIER,
        CONTEXT_AGGREGATE;

    }
}

