/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.stats;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.ExternalBufferType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.AggregateType;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QueryHints;
import com.ibm.bi.qs.model.api.data.stats.generated.DataItem;
import com.ibm.bi.qs.model.api.data.stats.generated.OverallStat;
import com.ibm.bi.qs.model.api.data.stats.generated.Stat;
import com.ibm.bi.qs.model.api.data.stats.generated.StatsSpec;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.stats.DataItemStatsResult;
import com.ibm.bi.qs.xqe.stats.OverallStatsResult;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang3.StringUtils;

public class StatsExecutor
extends BaseExecutor {
    private static final String GLOBAL_STATS_QUERY_ERR = "Cannot process global stat query result. Reason: Unsupported stat.";
    private static final String GLOBAL_STATS_PLANNING_MSG = "%s - Global Stats Query planning time: %.3f secs.";
    private static final String GLOBAL_STATS_EXEC_MSG = "%s - Global Stats Query execution time: %.3f secs.";
    private static final String COUNT_DISTINCT_STAT_PLANNING_MSG = "%s - Count Distinct Query planning time: %.3f secs.";
    private static final String COUNT_DISTINCT_STAT_EXEC_MSG = "%s - Count Distinct Query execution time: %.3f secs.";
    private static final String OVERALL_STAT_QUERIES_SUMMARY_MSG = "%s - Total Stat Queries executed: %d | Total Time: %.3f secs.";
    private static final double ONE_SECOND_TO_NANOS = (double)TimeUnit.SECONDS.toNanos(1L) * 1.0;
    private static final String ZERO = "0";
    private static final String VERSION_NUMBER = "1";
    private static final String MODULE_STR = "module";
    public static final String COUNT_STAR_STRING = "countStar";
    public static final String COUNT_STAR_REF_STRING = "countStarRef";
    public static final String SECONDARY_QUERY_NAME = "secondaryQuery";
    private static final String FALSE_STR = "false";
    private static final String TRUE_STR = "true";
    public static final String REQUEST_TYPE = StatsExecutor.class.getSimpleName();
    private static final DataItemComparator DATAITEMS_COMPARATOR = new DataItemComparator();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final List<Stat> MIN_MAX_STATS = Arrays.asList(Stat.MIN, Stat.MAX);
    private static final QueryHints QUERY_HINTS = new QueryHints();
    private final StatsSpec statsSpec;
    private long countStarStat = -1L;
    private String querySubjectName = "";
    private boolean requiresCountStarStatForCountNullEstimation = false;
    private final ArrayList<DataItem> globalStatsQueryEntries = new ArrayList();
    private final ArrayList<DataItem> separateStatsQueryEntries = new ArrayList();
    private final Map<String, ColumnMetadata> metadataColumns = new HashMap<String, ColumnMetadata>();
    private final Map<String, DataItem> id2DataItemMap = new HashMap<String, DataItem>();
    private final Map<String, String> id2ItemIdMap = new HashMap<String, String>();
    private final Map<String, DataItemStatsResult> diStatResults = new HashMap<String, DataItemStatsResult>();

    public StatsExecutor(StatsSpec theStatsSpec, DataSet dataSet, ServletRequestContext servletRequestContext) {
        super(servletRequestContext, REQUEST_TYPE, dataSet);
        this.statsSpec = theStatsSpec;
        this.validateStatsSpec();
        this.populateId2DataItemMap();
        this.populateDataItemStatsResults();
        this.populateId2ItemIdMap();
        this.setConnections(this.statsSpec.getConnections());
    }

    static boolean requiresCountEstimation(DataItem di, ColumnMetadata columnMd) {
        return di.getStats().contains(Stat.COUNT) || di.getStats().contains(Stat.COUNT_NULL) && columnMd.isNullable();
    }

    private void validateStatsSpec() {
        boolean isValid = true;
        StringJoiner sj = new StringJoiner(LINE_SEPARATOR);
        String version = this.statsSpec.getVersion();
        if (null == version) {
            isValid = false;
            sj.add("Version is a required field.");
        } else if (VERSION_NUMBER.compareTo(version) != 0) {
            isValid = false;
            sj.add("Only statsSpecs of Version 1 are supported for the moment.");
        }
        HashSet<String> tableNames = new HashSet<String>();
        HashSet<String> uniqueDataItems = new HashSet<String>();
        HashSet<String> nonUniqueDataItems = new HashSet<String>();
        HashSet<String> uniqueIds = new HashSet<String>();
        HashSet<String> nonUniqueIds = new HashSet<String>();
        List dataItems = this.statsSpec.getDataItems();
        try {
            Collections.sort(dataItems, DATAITEMS_COMPARATOR);
        }
        catch (NullPointerException e) {
            sj.add("Non-nullable \"id\" and \"itemId\" values are expected for each provided \"dataItem\" entity.");
            throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_STATS_INVALID_SPEC, sj.toString());
        }
        for (DataItem dataItem : dataItems) {
            String dataItemId = dataItem.getItemId();
            Optional<ColumnMetadata> optionalColumnMd = this.dataset.getColumnMetadata().stream().filter(columnMd -> StringUtils.equals((CharSequence)columnMd.getColumnId(), (CharSequence)dataItemId)).findAny();
            if (!optionalColumnMd.isPresent() || null == dataItem.getId()) {
                isValid = false;
                sj.add(String.format("DataItem '%s' cannot be bound to any metadata column.", dataItemId));
                continue;
            }
            this.metadataColumns.put(optionalColumnMd.get().getColumnId(), optionalColumnMd.get());
            if (!uniqueDataItems.add(dataItemId)) {
                nonUniqueDataItems.add(dataItemId);
            }
            if (!uniqueIds.add(dataItem.getId())) {
                nonUniqueIds.add(dataItem.getId());
            }
            tableNames.add(optionalColumnMd.get().getQuerySubjectID());
            ArrayList<Stat> dataItemStats = dataItem.getStats();
            if (null == dataItemStats || dataItemStats.isEmpty()) {
                dataItemStats = new ArrayList<Stat>();
                dataItem.setStats(dataItemStats);
                List<String> suggestedStats = Arrays.asList(this.metadataColumns.get(dataItem.getItemId()).getSuggestedStats());
                if (suggestedStats.contains(Stat.MIN.value())) {
                    dataItemStats.add(Stat.MIN);
                }
                if (suggestedStats.contains(Stat.MAX.value())) {
                    dataItemStats.add(Stat.MAX);
                }
                if (suggestedStats.contains(Stat.COUNT_NULL.value())) {
                    dataItemStats.add(Stat.COUNT_NULL);
                }
                if (suggestedStats.contains(Stat.COUNT.value())) {
                    dataItemStats.add(Stat.COUNT);
                }
                if (suggestedStats.contains(Stat.COUNT_DISTINCT.value())) {
                    dataItemStats.add(Stat.COUNT_DISTINCT);
                }
            }
            if (!this.requiresCountStarStatForCountNullEstimation) {
                boolean bl = this.requiresCountStarStatForCountNullEstimation = dataItemStats.contains(Stat.COUNT_NULL) && this.metadataColumns.get(dataItem.getItemId()).isNullable();
            }
            if (dataItemStats.contains(Stat.MIN) || dataItemStats.contains(Stat.MAX) || StatsExecutor.requiresCountEstimation(dataItem, this.metadataColumns.get(dataItem.getItemId()))) {
                this.globalStatsQueryEntries.add(dataItem);
            }
            if (!dataItemStats.contains(Stat.COUNT_DISTINCT)) continue;
            this.separateStatsQueryEntries.add(dataItem);
        }
        if (!nonUniqueDataItems.isEmpty()) {
            isValid = false;
            sj.add(String.format("Detected duplicate dataItems: %s.", ((Object)nonUniqueDataItems).toString()));
        }
        if (!nonUniqueIds.isEmpty()) {
            isValid = false;
            sj.add(String.format("Detected duplicate ids: %s.", ((Object)nonUniqueIds).toString()));
        }
        if (tableNames.size() > 1) {
            isValid = false;
            sj.add(String.format("Requesting stats for dataItems derived from different tables is not supported: '%s.", Arrays.toString(tableNames.toArray())));
        }
        if (!isValid) {
            throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_STATS_INVALID_SPEC, sj.toString());
        }
        if (!tableNames.isEmpty()) {
            this.querySubjectName = tableNames.toArray()[0].toString();
        } else if (!this.dataset.getColumnMetadata().isEmpty()) {
            this.querySubjectName = ((ColumnMetadata)this.dataset.getColumnMetadata().get(0)).getQuerySubjectID();
        }
    }

    private void populateId2DataItemMap() {
        this.id2DataItemMap.putAll(this.statsSpec.getDataItems().stream().collect(Collectors.toMap(DataItem::getId, Function.identity())));
    }

    private void populateDataItemStatsResults() {
        this.statsSpec.getDataItems().stream().forEach(di -> this.diStatResults.put(di.getId(), new DataItemStatsResult()));
    }

    private void populateId2ItemIdMap() {
        this.statsSpec.getDataItems().stream().forEach(di -> this.id2ItemIdMap.put(di.getId(), di.getItemId()));
    }

    public List<DataItem> getGlobalStatsQueryEntries() {
        return this.globalStatsQueryEntries;
    }

    public List<DataItem> getSeparateStatsQueryEntries() {
        return this.separateStatsQueryEntries;
    }

    public Map<String, ColumnMetadata> getMetadataColumns() {
        return this.metadataColumns;
    }

    public Map<String, DataItem> getId2DataItemMap() {
        return this.id2DataItemMap;
    }

    public Map<String, DataItemStatsResult> getDIStatResults() {
        return this.diStatResults;
    }

    public boolean requiresCountStarStatForCountNullEstimation() {
        return this.requiresCountStarStatForCountNullEstimation;
    }

    boolean isGlobalStatsQueryNecessary() {
        return !this.globalStatsQueryEntries.isEmpty() || null != this.statsSpec.getOverallStats() && !this.statsSpec.getOverallStats().isEmpty() || this.requiresCountStarStatForCountNullEstimation;
    }

    private static boolean isTextType(IDataType xqeDataType) {
        return null != xqeDataType && xqeDataType instanceof ExternalBufferType;
    }

    private void injectCountStarExpression(XQENodeFactory nodeFactory, V5Query v5Query, V5GroupBody v5GroupBody) {
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression("count(rows)");
        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, COUNT_STAR_STRING, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)COUNT_STAR_STRING);
        v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
    }

    private void injectAggregatesForGlobalQueryEntry(XQENodeFactory nodeFactory, V5Query v5Query, V5GroupBody v5GroupBody, DataItem currentDataItem) {
        V5DataItemRef v5DataItemRef;
        V5Expression v5Expression;
        String dataItemName;
        ColumnMetadata columnMd = this.metadataColumns.get(currentDataItem.getItemId());
        if (currentDataItem.getStats().contains(Stat.MIN)) {
            dataItemName = currentDataItem.getId() + "_MIN";
            v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(String.format("minimum(%s)", columnMd.getColumnId()));
            TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
            v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
            v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
            v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
        }
        if (currentDataItem.getStats().contains(Stat.MAX)) {
            dataItemName = currentDataItem.getId() + "_MAX";
            v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(String.format("maximum(%s)", columnMd.getColumnId()));
            TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
            v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
            v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
            v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
        }
        if (StatsExecutor.requiresCountEstimation(currentDataItem, columnMd)) {
            dataItemName = currentDataItem.getId() + "_CN";
            v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(String.format("count(%s)", columnMd.getColumnId()));
            TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
            v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
            v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
            v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
        }
    }

    private void injectHiddenAggregateForGlobalQueryEntry(XQENodeFactory nodeFactory, V5QuerySet v5QuerySetNode, V5Query v5Query, V5QueryResultDefinition qrd, V5GroupBody v5GroupBody) {
        ColumnMetadata columnMd = this.dataset.getColumnMetadata().stream().filter(e -> null != e.getXQEDataType() && e.getXQEDataType().isNumeric()).findFirst().orElse(null);
        if (null == columnMd) {
            columnMd = this.dataset.getColumnMetadata().stream().filter(e -> StatsExecutor.isTextType(e.getXQEDataType())).findFirst().orElse(null);
        }
        if (null == columnMd) {
            columnMd = (ColumnMetadata)this.dataset.getColumnMetadata().get(0);
        }
        String dataItemName = "hidden_MIN";
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(String.format("minimum(%s)", columnMd.getColumnId()));
        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
        V5Query v5SecondaryQuery = TransformationUtils.buildV5QueryNode(nodeFactory, SECONDARY_QUERY_NAME, v5Query, Boolean.FALSE, QUERY_HINTS);
        v5SecondaryQuery.setPropertyValue(V5Query.QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName(), (Object)FALSE_STR);
        v5SecondaryQuery.setPropertyValue(V5Query.QueryHint.IS_STATS_QUERY.getPropertyName(), (Object)TRUE_STR);
        v5QuerySetNode.addChild((IXQEQueryNode)v5SecondaryQuery);
        v5QuerySetNode.setUnreferencedQueriesRemoved();
        v5QuerySetNode.setUnreferencedQRDsRemoved();
        V5Selection v5SecondarySelection = (V5Selection)v5SecondaryQuery.getFirstChildByType(101009);
        v5SecondarySelection.setAutoSummary(false);
        V5BoundDataItemReference v5BoundItemRef = TransformationUtils.createBoundDataItemReference(v5Query, COUNT_STAR_STRING, nodeFactory, true);
        dataItemName = COUNT_STAR_REF_STRING;
        V5Expression v5SecondaryExpression = (V5Expression)nodeFactory.createNode(101004);
        v5SecondaryExpression.setExpression(v5BoundItemRef.getIdentifier());
        TransformationUtils.buildDataItem((IXQEQueryNode)v5SecondaryQuery, dataItemName, AggregateType.NONE, (IXQEQueryNode)v5SecondaryExpression, nodeFactory);
        qrd.setStringPropertyValue("name", (String)v5SecondaryQuery.getPropertyValue("name") + ".0");
        qrd.setStringPropertyValue("refQuery", (String)v5SecondaryQuery.getPropertyValue("name"));
        for (IXQEQueryNode dataItemRef : v5GroupBody.getChildrenOfType(101015)) {
            dataItemRef.detach();
        }
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
        v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
    }

    private void injectCountDistinctExpression(XQENodeFactory nodeFactory, V5Query v5Query, V5GroupBody v5GroupBody, DataItem currentDataItem) {
        ColumnMetadata columnMd = this.metadataColumns.get(currentDataItem.getItemId());
        String dataItemName = currentDataItem.getId() + "_CD";
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(String.format("count(distinct(%s))", columnMd.getColumnId()));
        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, AggregateType.CALCULATED, (IXQEQueryNode)v5Expression, nodeFactory);
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
        v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
    }

    V5QuerySet generateGlobalStatsV5QuerySet(PlanningEnvironment planningEnv) {
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        V5QuerySet v5QuerySetNode = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySetNode.addToIndex();
        V5Query v5Query = TransformationUtils.buildV5QueryNode(nodeFactory, null, null, !this.dataset.getType().equals((Object)DataSetType.PACKAGE), QUERY_HINTS);
        v5Query.setPropertyValue(V5Query.QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName(), (Object)FALSE_STR);
        v5Query.setPropertyValue(V5Query.QueryHint.IS_STATS_QUERY.getPropertyName(), (Object)TRUE_STR);
        V5Selection v5Selection = (V5Selection)v5Query.getFirstChildByType(101009);
        v5Selection.setAutoSummary(true);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        qrd.setStringPropertyValue("name", v5Query.getPropertyValue("name") + ".0");
        qrd.setStringPropertyValue("refQuery", (String)v5Query.getPropertyValue("name"));
        V5Edge v5Edge = (V5Edge)nodeFactory.createNode(101049, (IXQEQueryNode)qrd);
        qrd.addChild((IXQEQueryNode)v5Edge);
        v5Edge.setIntegerPropertyValue("edgeID", ZERO);
        v5Edge.setStringPropertyValue("name", ZERO);
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)nodeFactory.createNode(101050);
        v5Edge.addChild((IXQEQueryNode)v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        v5ValueSet.setNameProperty("VS");
        v5EdgeGroup.addChild((IXQEQueryNode)v5ValueSet);
        V5GroupBody v5GroupBody = (V5GroupBody)nodeFactory.createNode(101051);
        v5ValueSet.addChild((IXQEQueryNode)v5GroupBody);
        if (this.statsSpec.getOverallStats() != null && this.statsSpec.getOverallStats().contains(OverallStat.COUNT) || this.requiresCountStarStatForCountNullEstimation) {
            this.injectCountStarExpression(nodeFactory, v5Query, v5GroupBody);
        }
        for (DataItem dataItem : this.globalStatsQueryEntries) {
            this.injectAggregatesForGlobalQueryEntry(nodeFactory, v5Query, v5GroupBody, dataItem);
        }
        if (this.globalStatsQueryEntries.isEmpty()) {
            this.injectHiddenAggregateForGlobalQueryEntry(nodeFactory, v5QuerySetNode, v5Query, qrd, v5GroupBody);
        }
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_UNIQUE_NAME));
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_CAPTION));
        v5QuerySetNode.addChild((IXQEQueryNode)v5Query);
        v5QuerySetNode.addChild((IXQEQueryNode)qrd);
        RequestEnvironment reqEnv = (RequestEnvironment)planningEnv.getRequestEnvironment();
        v5QuerySetNode.setStringPropertyValue("modelPath", this.dataset.getModuleConnectionPath());
        if (!this.dataset.getType().equals((Object)DataSetType.PACKAGE)) {
            v5QuerySetNode.setStringPropertyValue("modelType", MODULE_STR);
        }
        v5QuerySetNode.setPropertyValue("expressionLocale", (Object)LocaleConverter.localeToStr((Locale)reqEnv.getExpressionLocale()));
        reqEnv.setModelPath(v5QuerySetNode.getModelPath());
        reqEnv.setModelType(v5QuerySetNode.getModelType());
        return v5QuerySetNode;
    }

    private IXQEQueryNode planGlobalStatsV5Request() {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter((IExecutionEnvironment)execEnv);
        multiRequestContext.incrementRefCount();
        try {
            PlanningEnvironment planEnv = this.setupPlanningEnvironment(reqEnv);
            V5QuerySet querySet = this.generateGlobalStatsV5QuerySet(planEnv);
            this.createDataSourceConnections(reqEnv);
            PlannedV5QuerySet plannedV5QuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
            return plannedV5QuerySet;
        }
        catch (Throwable t) {
            throw this.logXQEError(t);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
    }

    V5QuerySet generateCountDistinctV5QuerySet(PlanningEnvironment planningEnv, DataItem dataItem) {
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        V5QuerySet v5QuerySetNode = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySetNode.addToIndex();
        V5Query v5Query = TransformationUtils.buildV5QueryNode(nodeFactory, null, null, !this.dataset.getType().equals((Object)DataSetType.PACKAGE), QUERY_HINTS);
        v5Query.setPropertyValue(V5Query.QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName(), (Object)FALSE_STR);
        v5Query.setPropertyValue(V5Query.QueryHint.IS_STATS_QUERY.getPropertyName(), (Object)TRUE_STR);
        V5Selection v5Selection = (V5Selection)v5Query.getFirstChildByType(101009);
        v5Selection.setAutoSummary(true);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        qrd.setStringPropertyValue("name", v5Query.getPropertyValue("name") + ".0");
        qrd.setStringPropertyValue("refQuery", (String)v5Query.getPropertyValue("name"));
        V5Edge v5Edge = (V5Edge)nodeFactory.createNode(101049, (IXQEQueryNode)qrd);
        qrd.addChild((IXQEQueryNode)v5Edge);
        v5Edge.setIntegerPropertyValue("edgeID", ZERO);
        v5Edge.setStringPropertyValue("name", ZERO);
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)nodeFactory.createNode(101050);
        v5Edge.addChild((IXQEQueryNode)v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        v5ValueSet.setNameProperty("VS");
        v5EdgeGroup.addChild((IXQEQueryNode)v5ValueSet);
        V5GroupBody v5GroupBody = (V5GroupBody)nodeFactory.createNode(101051);
        v5ValueSet.addChild((IXQEQueryNode)v5GroupBody);
        this.injectCountDistinctExpression(nodeFactory, v5Query, v5GroupBody, dataItem);
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_UNIQUE_NAME));
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_CAPTION));
        v5QuerySetNode.addChild((IXQEQueryNode)v5Query);
        v5QuerySetNode.addChild((IXQEQueryNode)qrd);
        RequestEnvironment reqEnv = (RequestEnvironment)planningEnv.getRequestEnvironment();
        v5QuerySetNode.setStringPropertyValue("modelPath", this.dataset.getModuleConnectionPath());
        if (!this.dataset.getType().equals((Object)DataSetType.PACKAGE)) {
            v5QuerySetNode.setStringPropertyValue("modelType", MODULE_STR);
        }
        v5QuerySetNode.setPropertyValue("expressionLocale", (Object)LocaleConverter.localeToStr((Locale)reqEnv.getExpressionLocale()));
        reqEnv.setModelPath(v5QuerySetNode.getModelPath());
        reqEnv.setModelType(v5QuerySetNode.getModelType());
        return v5QuerySetNode;
    }

    private IXQEQueryNode planCountDistinctV5Request(DataItem dataItem) {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter((IExecutionEnvironment)execEnv);
        multiRequestContext.incrementRefCount();
        try {
            PlanningEnvironment planEnv = this.setupPlanningEnvironment(reqEnv);
            V5QuerySet querySet = this.generateCountDistinctV5QuerySet(planEnv, dataItem);
            this.createDataSourceConnections(reqEnv);
            PlannedV5QuerySet plannedV5QuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
            return plannedV5QuerySet;
        }
        catch (Throwable t) {
            throw this.logXQEError(t);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
    }

    @Override
    public void planExecution() {
    }

    void processRow(DataItem dataItem, Stat stat, RowValue currentRow) {
        if (null == dataItem) {
            int i;
            int offsetGlobalStats = this.statsSpec.getOverallStats() != null && this.statsSpec.getOverallStats().contains(OverallStat.COUNT) || this.requiresCountStarStatForCountNullEstimation ? 1 : 0;
            long[] binnedIndexes = new long[this.globalStatsQueryEntries.size()];
            int ceilIdx = offsetGlobalStats;
            for (i = 0; i < binnedIndexes.length; ++i) {
                DataItem globalStatsDataItem = this.globalStatsQueryEntries.get(i);
                if (globalStatsDataItem.getStats().contains(Stat.MIN) && globalStatsDataItem.getStats().contains(Stat.MAX) && StatsExecutor.requiresCountEstimation(globalStatsDataItem, this.metadataColumns.get(globalStatsDataItem.getItemId()))) {
                    ceilIdx += 2;
                } else if (globalStatsDataItem.getStats().contains(Stat.MIN) && globalStatsDataItem.getStats().contains(Stat.MAX) || globalStatsDataItem.getStats().contains(Stat.MIN) && StatsExecutor.requiresCountEstimation(globalStatsDataItem, this.metadataColumns.get(globalStatsDataItem.getItemId())) || globalStatsDataItem.getStats().contains(Stat.MAX) && StatsExecutor.requiresCountEstimation(globalStatsDataItem, this.metadataColumns.get(globalStatsDataItem.getItemId()))) {
                    ++ceilIdx;
                }
                binnedIndexes[i] = ceilIdx;
                ++ceilIdx;
            }
            for (i = 0; i < currentRow.getNumColumns(); ++i) {
                ContextValue contextValue = (ContextValue)currentRow.getColumn(i);
                Value value = (Value)contextValue.getValue();
                int rowPos = contextValue.getDataItemIndex();
                if (rowPos < offsetGlobalStats) {
                    this.countStarStat = ((NumericValue)value).getLong();
                    continue;
                }
                int globalStatsQEIdx = 0;
                while ((long)rowPos > binnedIndexes[globalStatsQEIdx]) {
                    ++globalStatsQEIdx;
                }
                DataItem globalStatsDataItem = this.globalStatsQueryEntries.get(globalStatsQEIdx);
                long mod = binnedIndexes[globalStatsQEIdx] - (long)rowPos;
                if (0L == mod) {
                    if (StatsExecutor.requiresCountEstimation(globalStatsDataItem, this.metadataColumns.get(globalStatsDataItem.getItemId()))) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setCount(((NumericValue)value).getLong());
                        continue;
                    }
                    if (globalStatsDataItem.getStats().contains(Stat.MAX)) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMax(value.toJSON());
                        continue;
                    }
                    if (globalStatsDataItem.getStats().contains(Stat.MIN)) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMin(value.toJSON());
                        continue;
                    }
                    throw new IllegalStateException(GLOBAL_STATS_QUERY_ERR);
                }
                if (1L == mod) {
                    if (globalStatsDataItem.getStats().containsAll(MIN_MAX_STATS) && StatsExecutor.requiresCountEstimation(globalStatsDataItem, this.metadataColumns.get(globalStatsDataItem.getItemId()))) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMax(value.toJSON());
                        continue;
                    }
                    if (globalStatsDataItem.getStats().containsAll(MIN_MAX_STATS)) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMin(value.toJSON());
                        continue;
                    }
                    if (globalStatsDataItem.getStats().contains(Stat.MAX)) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMax(value.toJSON());
                        continue;
                    }
                    if (globalStatsDataItem.getStats().contains(Stat.MIN)) {
                        this.diStatResults.get(globalStatsDataItem.getId()).setMin(value.toJSON());
                        continue;
                    }
                    throw new IllegalStateException(GLOBAL_STATS_QUERY_ERR);
                }
                if (2L == mod) {
                    this.diStatResults.get(globalStatsDataItem.getId()).setMin(value.toJSON());
                    continue;
                }
                throw new IllegalStateException(GLOBAL_STATS_QUERY_ERR);
            }
        } else {
            ContextValue contextValue = (ContextValue)currentRow.getColumn(0);
            Value value = (Value)contextValue.getValue();
            if (Stat.COUNT_DISTINCT.equals((Object)stat)) {
                this.diStatResults.get(dataItem.getId()).setCountDistinct(((NumericValue)value).getLong());
            } else {
                throw new IllegalStateException("Cannot process separate stat query result. Reason: Unsupported stat.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherStatsResults(DataItem dataItem, Stat stat, RSAPIDataset rsDataset, IV5ResultSet v5ResultSet) throws JSONException {
        RSAPIEdge edge = rsDataset.getEdge(0);
        XIterator edgeIterator = v5ResultSet.getV5EdgeIterator(edge);
        RowValue currentRow = null;
        try {
            currentRow = (RowValue)edgeIterator.next();
            do {
                this.processRow(dataItem, stat, currentRow);
            } while (null != (currentRow = (RowValue)edgeIterator.next()));
        }
        finally {
            edgeIterator.release();
            edgeIterator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatsQuery(DataItem dataItem, Stat stat, IXQEQueryNode aPlannedQuery) throws JSONException {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        IV5ResultSet[] v5ResultSets = null;
        try {
            this.createDataSourceConnections(reqEnv);
            v5ResultSets = this.executeV5Request(reqEnv, aPlannedQuery);
            RSAPIDataset rsDataset = (RSAPIDataset)aPlannedQuery.getFirstDescendantOfTypeOrdered(401005, false);
            this.gatherStatsResults(dataItem, stat, rsDataset, v5ResultSets[0]);
        }
        finally {
            if (v5ResultSets != null) {
                v5ResultSets[0].release();
            }
        }
    }

    void constructJSONResult(OrderedJSONObject result) throws JSONException {
        result.put("version", (Object)VERSION_NUMBER);
        if (null != this.statsSpec.getOverallStats() && !this.statsSpec.getOverallStats().isEmpty()) {
            result.append("overallStats", (Object)new OverallStatsResult(this.countStarStat).toJSON());
        }
        for (Map.Entry<String, DataItemStatsResult> statEntry : this.diStatResults.entrySet()) {
            DataItem currentDataItem = this.id2DataItemMap.get(statEntry.getKey());
            if (currentDataItem.getStats().contains(Stat.COUNT_NULL) && this.metadataColumns.get(currentDataItem.getItemId()).isNullable()) {
                long countValue = statEntry.getValue().getCount();
                statEntry.getValue().setCountNull(this.countStarStat - countValue);
            } else if (currentDataItem.getStats().contains(Stat.COUNT_NULL)) {
                statEntry.getValue().setCountNull(0L);
            }
            if (!currentDataItem.getStats().contains(Stat.COUNT)) {
                statEntry.getValue().setCount(-1L);
            }
            OrderedJSONObject jsonObject = new OrderedJSONObject();
            jsonObject.put("id", (Object)statEntry.getKey());
            jsonObject.put("itemId", (Object)this.id2ItemIdMap.get(statEntry.getKey()));
            jsonObject.put("stats", (Map)statEntry.getValue().toJSON());
            result.append("dataItems", (Object)jsonObject);
        }
    }

    public OrderedJSONObject executeImpl() {
        OrderedJSONObject result = new OrderedJSONObject();
        long numOfStatQueries = 0L;
        try {
            long end;
            long begin;
            long overallBegin = System.nanoTime();
            if (this.isGlobalStatsQueryNecessary()) {
                begin = System.nanoTime();
                IXQEQueryNode plannedV5GlobalStatsRequest = this.planGlobalStatsV5Request();
                end = System.nanoTime();
                QueryServiceLogger.info((Object)this, (String)String.format(GLOBAL_STATS_PLANNING_MSG, this.querySubjectName, (double)(end - begin) / ONE_SECOND_TO_NANOS));
                begin = System.nanoTime();
                this.executeStatsQuery(null, null, plannedV5GlobalStatsRequest);
                end = System.nanoTime();
                QueryServiceLogger.info((Object)this, (String)String.format(GLOBAL_STATS_EXEC_MSG, this.querySubjectName, (double)(end - begin) / ONE_SECOND_TO_NANOS));
                ++numOfStatQueries;
            }
            for (int i = 0; i < this.separateStatsQueryEntries.size(); ++i) {
                DataItem currentDataItem = this.separateStatsQueryEntries.get(i);
                if (!currentDataItem.getStats().contains(Stat.COUNT_DISTINCT)) continue;
                begin = System.nanoTime();
                IXQEQueryNode countDistinctRequest = this.planCountDistinctV5Request(currentDataItem);
                end = System.nanoTime();
                QueryServiceLogger.info((Object)this, (String)String.format(COUNT_DISTINCT_STAT_PLANNING_MSG, currentDataItem.getItemId(), (double)(end - begin) / ONE_SECOND_TO_NANOS));
                begin = System.nanoTime();
                this.executeStatsQuery(currentDataItem, Stat.COUNT_DISTINCT, countDistinctRequest);
                end = System.nanoTime();
                QueryServiceLogger.info((Object)this, (String)String.format(COUNT_DISTINCT_STAT_EXEC_MSG, currentDataItem.getItemId(), (double)(end - begin) / ONE_SECOND_TO_NANOS));
                ++numOfStatQueries;
            }
            this.constructJSONResult(result);
            long overallEnd = System.nanoTime();
            QueryServiceLogger.info((Object)this, (String)String.format(OVERALL_STAT_QUERIES_SUMMARY_MSG, this.querySubjectName, numOfStatQueries, (double)(overallEnd - overallBegin) / ONE_SECOND_TO_NANOS));
        }
        catch (JSONException jsone) {
            throw new QueryServiceException((Throwable)jsone, QueryServiceMessageKeys.INTERNAL_ERROR, "Error generating stats JSON result.");
        }
        return result;
    }

    @Override
    protected Date getLastModifiedFromQueryPlan() {
        return null;
    }

    static {
        QUERY_HINTS.setAdditionalProperty(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), (Object)"no");
    }

    private static class DataItemComparator
    implements Comparator<DataItem> {
        private DataItemComparator() {
        }

        @Override
        public int compare(DataItem o1, DataItem o2) {
            Objects.requireNonNull(o1);
            Objects.requireNonNull(o2);
            if (StringUtils.isEmpty((CharSequence)o1.getId()) || StringUtils.isEmpty((CharSequence)o2.getId())) {
                throw new NullPointerException();
            }
            Objects.requireNonNull(o1.getItemId());
            Objects.requireNonNull(o2.getItemId());
            return o1.getItemId().compareTo(o2.getItemId());
        }
    }
}

