/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.util;

import com.cognos.xqe.query.parameters.BoundedRangeParameterValueItem;
import com.cognos.xqe.query.parameters.HierarchicalParmValueItem;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.UnboundedEndRangeParameterValueItem;
import com.cognos.xqe.query.parameters.UnboundedStartRangeParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterCapabilities;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterDataType;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterFeedbackInfo;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterLocationType;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValueType;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValueV2;
import com.ibm.bi.qs.model.api.data.common.generated.ValueOperatorType;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;

public class ParameterUtil {
    public static Parameters convertToParameters(List<ParameterValueV2> qspecParameters) {
        Parameters parameters = new Parameters();
        if (qspecParameters == null) {
            return parameters;
        }
        for (ParameterValueV2 qspecParam : qspecParameters) {
            Parameter parameter = ParameterUtil.convertQuerySpecParamToParameter(qspecParam);
            if (parameter == null) continue;
            parameters.addParameter(qspecParam.getParameterName(), parameter);
        }
        return parameters;
    }

    public static List<ParameterFeedbackInfo> convertToParameterFeedbackInfo(Parameters requestParameters) {
        ArrayList<ParameterFeedbackInfo> feedbackInfo = new ArrayList<ParameterFeedbackInfo>();
        if (requestParameters == null) {
            return feedbackInfo;
        }
        for (Map.Entry entry : requestParameters.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param == null) continue;
            feedbackInfo.add(ParameterUtil.convertToParameterFeedbackInfo(param));
        }
        return feedbackInfo;
    }

    public static void loadParameterFromParamSpecV2(ParameterValueV2 qspecParam, Parameter parameter) {
        ParameterValues paramValueItems = parameter.getParameterValueItems();
        if (paramValueItems == null) {
            return;
        }
        for (ParameterValueType paramValue : qspecParam.getValues()) {
            UnboundedStartRangeParameterValueItem newRangeValue;
            if (ValueOperatorType.IS_NULL == paramValue.getOperator()) {
                parameter.addValue((String)null);
                continue;
            }
            if (ValueOperatorType.BETWEEN == paramValue.getOperator()) {
                paramValueItems.addValue(true, paramValue.getUse(), paramValue.getDisplay(), paramValue.getUse2(), paramValue.getDisplay2());
                continue;
            }
            if (ValueOperatorType.LESS_THAN == paramValue.getOperator() || ValueOperatorType.LESS_EQUAL == paramValue.getOperator()) {
                boolean inclusive = paramValue.getOperator() == ValueOperatorType.LESS_EQUAL;
                newRangeValue = new UnboundedStartRangeParameterValueItem(parameter);
                newRangeValue.getEndValue().setAll(inclusive, paramValue.getDisplay(), paramValue.getUse());
                paramValueItems.add((Object)newRangeValue);
                continue;
            }
            if (ValueOperatorType.GREATER_THAN == paramValue.getOperator() || ValueOperatorType.GREATER_EQUAL == paramValue.getOperator()) {
                boolean inclusive = paramValue.getOperator() == ValueOperatorType.GREATER_EQUAL;
                newRangeValue = new UnboundedEndRangeParameterValueItem(parameter);
                newRangeValue.getStartValue().setAll(inclusive, paramValue.getDisplay(), paramValue.getUse());
                paramValueItems.add((Object)newRangeValue);
                continue;
            }
            String use = paramValue.getUse();
            String display = paramValue.getDisplay();
            if (ParameterDataType.MEMBER_UNIQUE_NAME == qspecParam.getDataType()) {
                HierarchicalParmValueItem hierItem = new HierarchicalParmValueItem(parameter);
                V5ParameterValueItem v = hierItem.getValue();
                v.setInternalValue(use);
                if (display != null) {
                    v.setDisplayValue(display);
                }
                paramValueItems.add((Object)hierItem);
                continue;
            }
            parameter.addValue(true, display, use);
        }
        if (qspecParam.getInvert() != null && qspecParam.getInvert().booleanValue()) {
            for (ParameterValueItem pValueItem : paramValueItems) {
                pValueItem.setInclusive(false);
            }
        }
        if (paramValueItems.isEmpty()) {
            parameter.setValueToNil();
        }
    }

    public static Object parameterFeedbackToJSON(List<ParameterFeedbackInfo> usedParams) {
        if (usedParams == null) {
            return null;
        }
        JSONArray usedParamsArray = new JSONArray();
        try {
            for (ParameterFeedbackInfo pInfo : usedParams) {
                usedParamsArray.add((Object)ModelFactory.getInstance().createOrdered((Object)pInfo));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return usedParamsArray;
    }

    private static Parameter convertQuerySpecParamToParameter(ParameterValueV2 qspecParam) {
        ParameterDataType pdt = qspecParam.getDataType();
        if (pdt == null) {
            return null;
        }
        Parameter parameter = new Parameter(qspecParam.getParameterName(), Parameter.getParameterDataType((String)qspecParam.getDataType().value()));
        Boolean invert = qspecParam.getInvert();
        if (invert != null) {
            parameter.setInvert(invert.booleanValue());
        }
        ParameterUtil.loadParameterFromParamSpecV2(qspecParam, parameter);
        return parameter;
    }

    private static ParameterFeedbackInfo convertToParameterFeedbackInfo(Parameter param) {
        ParameterFeedbackInfo pInfo = new ParameterFeedbackInfo();
        pInfo.setParameterName(param.getName());
        pInfo.setDataType(ParameterUtil.toParamInfoDataType(param));
        pInfo.setModelFilterItem(param.getModelItem());
        pInfo.setCapabilities(ParameterUtil.toParamInfoCapabilities(param.getCapabilities()));
        pInfo.setInvert(Boolean.valueOf(param.getInvert()));
        pInfo.setLocation(ParameterUtil.toLocationType(param.getLocation()));
        pInfo.setValues(ParameterUtil.toParamInfoValues(param));
        return pInfo;
    }

    private static ParameterLocationType toLocationType(Parameter.LOCATION location) {
        return ParameterLocationType.fromValue((String)location.getValue());
    }

    private static List<ParameterValueType> toParamInfoValues(Parameter param) {
        ArrayList<ParameterValueType> pInfoValues = new ArrayList<ParameterValueType>();
        for (ParameterValueItem pValItem : param.getParameterValueItems()) {
            ParameterValueType pVal = new ParameterValueType();
            pInfoValues.add(pVal);
            if (pValItem.hasNullValue()) {
                pVal.setOperator(ValueOperatorType.IS_NULL);
                continue;
            }
            if (pValItem instanceof BoundedRangeParameterValueItem) {
                BoundedRangeParameterValueItem boundRangeItem = (BoundedRangeParameterValueItem)pValItem;
                pVal.setOperator(ValueOperatorType.BETWEEN);
                pVal.setUse(boundRangeItem.getStartValue().getInternalValue());
                pVal.setDisplay(boundRangeItem.getStartValue().getDisplayValue());
                pVal.setUse2(boundRangeItem.getEndValue().getInternalValue());
                pVal.setDisplay2(boundRangeItem.getEndValue().getDisplayValue());
                continue;
            }
            if (pValItem instanceof UnboundedStartRangeParameterValueItem) {
                UnboundedStartRangeParameterValueItem startRange = (UnboundedStartRangeParameterValueItem)pValItem;
                if (startRange.getInclusive()) {
                    pVal.setOperator(ValueOperatorType.LESS_EQUAL);
                } else {
                    pVal.setOperator(ValueOperatorType.LESS_THAN);
                }
                pVal.setUse(startRange.getEndValue().getInternalValue());
                pVal.setDisplay(startRange.getEndValue().getDisplayValue());
                continue;
            }
            if (pValItem instanceof UnboundedEndRangeParameterValueItem) {
                UnboundedEndRangeParameterValueItem endRange = (UnboundedEndRangeParameterValueItem)pValItem;
                if (endRange.getInclusive()) {
                    pVal.setOperator(ValueOperatorType.GREATER_EQUAL);
                } else {
                    pVal.setOperator(ValueOperatorType.GREATER_THAN);
                }
                pVal.setUse(endRange.getStartValue().getInternalValue());
                pVal.setDisplay(endRange.getStartValue().getDisplayValue());
                continue;
            }
            if (pValItem instanceof HierarchicalParmValueItem) {
                HierarchicalParmValueItem hierItem = (HierarchicalParmValueItem)pValItem;
                pVal.setUse(hierItem.getValue().getInternalValue());
                pVal.setDisplay(hierItem.getValue().getDisplayValue());
                pVal.setOperator(ValueOperatorType.EQUAL);
                continue;
            }
            V5ParameterValueItem valueItem = (V5ParameterValueItem)pValItem;
            if (pValItem.getInclusive()) {
                pVal.setOperator(ValueOperatorType.EQUAL);
            } else {
                pVal.setOperator(ValueOperatorType.NOT_EQUAL);
            }
            pVal.setUse(valueItem.getInternalValue());
            pVal.setDisplay(valueItem.getDisplayValue());
        }
        return pInfoValues;
    }

    private static ParameterCapabilities toParamInfoCapabilities(com.cognos.xqe.query.parameters.ParameterCapabilities capabilities) {
        ParameterCapabilities pInfoCapability = new ParameterCapabilities();
        pInfoCapability.setBoundRange(Boolean.valueOf(capabilities.isBoundRange()));
        pInfoCapability.setDiscreteValue(Boolean.valueOf(capabilities.isDiscreteValue()));
        pInfoCapability.setMultivalued(Boolean.valueOf(capabilities.isMultivalued()));
        pInfoCapability.setOptional(Boolean.valueOf(capabilities.isOptional()));
        pInfoCapability.setUnboundedRange(Boolean.valueOf(capabilities.isUnboundRange()));
        return pInfoCapability;
    }

    private static ParameterDataType toParamInfoDataType(Parameter param) {
        switch (param.getDataTypeName()) {
            case "xsdLong": 
            case "xsdInt": 
            case "xsdShort": {
                return ParameterDataType.INTEGER;
            }
            case "xsdDate": {
                return ParameterDataType.DATE;
            }
            case "xsdTime": {
                return ParameterDataType.TIME;
            }
            case "xsdDateTime": {
                return ParameterDataType.DATETIME;
            }
            case "xsdInterval": {
                return ParameterDataType.INTERVAL;
            }
            case "xsdFloat": 
            case "xsdDecimal": 
            case "xsdDouble": {
                return ParameterDataType.DECIMAL;
            }
            case "memberUniqueName": {
                return ParameterDataType.MEMBER_UNIQUE_NAME;
            }
        }
        if (param.getDataType().getCCLTypeCode() == 51) {
            return ParameterDataType.BOOLEAN;
        }
        if (param.getParameterValueItems().size() > 0 && param.getParameterValueItems().get(0) instanceof HierarchicalParmValueItem) {
            return ParameterDataType.MEMBER_UNIQUE_NAME;
        }
        return ParameterDataType.STRING;
    }
}

