/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.util;

import java.util.Objects;
import java.util.function.Consumer;

public class SafeRunnable
implements Runnable {
    private final Runnable delegate;
    private final Consumer<Throwable> throwableHandler;

    public SafeRunnable(Runnable delegate, Consumer<Throwable> throwableHandler) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.throwableHandler = throwableHandler;
    }

    @Override
    public void run() {
        try {
            this.delegate.run();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    private void handleThrowable(Throwable t) {
        try {
            if (null != this.throwableHandler) {
                this.throwableHandler.accept(t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static SafeRunnable wrap(Runnable r) {
        return new SafeRunnable(r, null);
    }

    public static SafeRunnable wrapWithHandler(Runnable r, Consumer<Throwable> handler) {
        return new SafeRunnable(r, handler);
    }
}

