/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQETableSampleRowCountException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.PlanValidationUtil;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplySamplingQueryHintToTables;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.MissingParameterValueException;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.common.util.DAASUtils;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.QueryFeedbackMode;
import com.ibm.bi.qs.model.api.data.common.generated.Connection;
import com.ibm.bi.qs.model.api.data.common.generated.GlobalParameterValue;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValue;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterValueV2;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.service.IQSExecutor;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import com.ibm.bi.qs.xqe.util.ParameterUtil;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public abstract class BaseExecutor
implements IQSExecutor {
    protected final ServletRequestContext servletRequestContext;
    private final String requestType;
    protected final DataSet dataset;
    private String auditRequestId = null;
    private String auditModelPath = null;
    private String auditDashboardId = null;
    private String auditDashboardPath = null;
    private String auditExtraParameters = null;
    private List<ParameterValue> parameterValues = null;
    private List<GlobalParameterValue> globalParameterValues = null;
    private List<ParameterValueV2> globalParameterValuesV2 = null;
    private List<ParameterValueV2> parameterValuesV2 = null;
    private List<Connection> connections = null;
    protected Date lastModified = null;
    protected QueryEnvironmentHelper envHelper = null;
    protected Integer timeLimit = null;
    private boolean queryPlanned = false;
    private Integer sampleRowCount = null;
    private Integer actualRowCount = null;
    private Integer sampleSeed = null;
    private Double samplePercentage = null;
    private Integer sampleResultLimit = null;
    private boolean sampleAdjustPercentage;
    protected IXQEQueryNode plannedQuery = null;
    protected QueryFeedbackWrapper qfbWrapper = null;
    protected ParameterAccessCoordinator requestPAC = null;
    private static final String AUDIT_OBJECT_TYPE = "Exploration QueryService";
    protected static final String AUDIT_LOGGER_NAME = "Audit.RTUsage.DSS";
    private static final String CAUGHT_ERROR = "Caught error in the Query Service: ";
    protected static final String BERNOULLI = "BERNOULLI";
    protected static final String NTH = "NTH";
    protected static final String NOSAMPLE = "";
    private static final Comparator<RSAPIDataset> RSAPI_DATASETS_COMPARATOR = new Comparator<RSAPIDataset>(){

        @Override
        public int compare(RSAPIDataset dataset1, RSAPIDataset dataset2) {
            return dataset1.getName().compareTo(dataset2.getName());
        }
    };

    protected BaseExecutor(ServletRequestContext servletRequestContext, String requestType, DataSet dataset) {
        this.servletRequestContext = servletRequestContext;
        this.requestType = requestType;
        this.dataset = dataset;
        this.init(dataset.getContentLocale());
    }

    protected BaseExecutor(ServletRequestContext servletRequestContext, String requestType, String contentLocale) {
        this.servletRequestContext = servletRequestContext;
        this.requestType = requestType;
        this.dataset = null;
        this.init(contentLocale);
    }

    private void init(String contentLocale) {
        this.envHelper = null == this.servletRequestContext || null == this.servletRequestContext.getHttpServletRequest() ? null : XQEServiceImpl.createQueryEnvironments(this.servletRequestContext.getHttpServletRequest(), contentLocale, this.servletRequestContext.getProductLocale());
    }

    protected PlanningEnvironment setupPlanningEnvironment(RequestEnvironment reqEnv) {
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment((IRequestEnvironment)reqEnv);
        planEnv.setValidateExpressions(false);
        return planEnv;
    }

    protected IV5ResultSet[] executeV5Request(RequestEnvironment reqEnv, IXQEQueryNode plannedQuerySet) {
        if (null != this.qfbWrapper) {
            this.qfbWrapper.startExecution();
        }
        IXQEQueryNode[] rsapiDatasetsToExecute = this.getRSAPIDatasetsToExecute(plannedQuerySet);
        List<RSAPIDataset> dataSets = this.getSortedDatasets(rsapiDatasetsToExecute);
        IV5ResultSet[] resultSets = new IV5ResultSet[dataSets.size()];
        for (int i = 0; i < dataSets.size(); ++i) {
            RSAPIDataset dataset = dataSets.get(i);
            int status = PlanValidationUtil.isRSAPISupportedQuery((RSAPIDataset)dataset);
            if (status != -1) continue;
            resultSets[i] = this.executeQuery(reqEnv, dataset);
        }
        if (null != this.qfbWrapper) {
            this.qfbWrapper.endExecution();
        }
        return resultSets;
    }

    private IXQEQueryNode[] getRSAPIDatasetsToExecute(IXQEQueryNode aPlannedQuery) {
        List datasets = aPlannedQuery.getDescendantsOfTypeOrdered(401005, false);
        return datasets.toArray(new IXQEQueryNode[datasets.size()]);
    }

    private List<RSAPIDataset> getSortedDatasets(IXQEQueryNode[] planDescendants) {
        ArrayList<RSAPIDataset> result = this.extractDatasets(planDescendants);
        Collections.sort(result, RSAPI_DATASETS_COMPARATOR);
        return result;
    }

    private ArrayList<RSAPIDataset> extractDatasets(IXQEQueryNode[] planDescendants) {
        ArrayList<RSAPIDataset> result = new ArrayList<RSAPIDataset>(planDescendants.length);
        for (IXQEQueryNode planDescendant : planDescendants) {
            RSAPIDataset dataset;
            if (planDescendant.getTypeObject() != 401005 || (dataset = (RSAPIDataset)planDescendant).getName().indexOf("_subTabularResult") != -1) continue;
            result.add(dataset);
        }
        return result;
    }

    private IV5ResultSet executeQuery(RequestEnvironment reqEnv, RSAPIDataset dataset) {
        int nEdges = dataset.getNumEdges();
        int[] startRowNumbers = new int[nEdges];
        int[] numRows = new int[nEdges];
        for (int i = 0; i < nEdges; ++i) {
            startRowNumbers[i] = 1;
            numRows[i] = 0;
        }
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        XQETrace trace = new XQETrace();
        QueryEngineLoggingUtils.addExecutionTraceLevels((XQETrace)trace, (IRequestEnvironment)executionEnvironment.getRequestEnvironment());
        RSAPIResultSet rsapiResultset = QueryEngine.getInstance().executeRSAPIDataset(dataset, executionEnvironment);
        IHybridResultSet resultset = null;
        if (rsapiResultset != null) {
            resultset = rsapiResultset.unwrapResultSet();
            executionEnvironment.getMultiRequestContext().removeResultset(dataset);
        }
        return resultset;
    }

    protected RequestEnvironment setupRequestEnvironment() {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        return reqEnv;
    }

    protected static LogLevel getExceptionLogLevel(Throwable throwable) {
        LogLevel logLevel = LogLevel.ERROR;
        if (throwable instanceof XQEException) {
            logLevel = ((XQEException)throwable).getLogLevel();
        } else if (throwable instanceof XQERuntimeException) {
            logLevel = ((XQERuntimeException)throwable).getLogLevel();
        }
        return logLevel;
    }

    protected void auditStartExecution(LogTypedLogger ipfLog, RequestEnvironment reqEnv) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("DSS", 0);
        HttpServletRequest httpServletRequest = this.servletRequestContext.getHttpServletRequest();
        this.auditDashboardPath = httpServletRequest.getHeader("x-audit-searchPath");
        this.auditDashboardId = httpServletRequest.getHeader("x-audit-dashboardId");
        this.auditModelPath = httpServletRequest.getHeader("x-audit-datasearchPath");
        try {
            if (this.auditDashboardPath != null) {
                this.auditDashboardPath = URLDecoder.decode(this.auditDashboardPath, "UTF-8");
            }
            if (this.auditDashboardId != null) {
                this.auditDashboardId = URLDecoder.decode(this.auditDashboardId, "UTF-8");
            }
            if (this.auditModelPath != null) {
                this.auditModelPath = URLDecoder.decode(this.auditModelPath, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder extraParameters = new StringBuilder();
        extraParameters.append("<parameters>");
        if (this.auditModelPath != null) {
            extraParameters.append("<item name=\"model\"><![CDATA[");
            extraParameters.append(this.auditModelPath);
            extraParameters.append("]]></item>");
        }
        if (this.auditDashboardId != null) {
            extraParameters.append("<item name=\"storeID\"><![CDATA[");
            extraParameters.append(this.auditDashboardId);
            extraParameters.append("]]></item>");
        }
        extraParameters.append("</parameters>");
        this.auditExtraParameters = extraParameters.toString();
        indication.setLevel(30000);
        indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
        indication.setOperation("Execute");
        indication.setObjectType(AUDIT_OBJECT_TYPE);
        indication.setObjectPath(this.auditDashboardPath);
        indication.setLogData(this.auditExtraParameters);
        if (reqEnv != null) {
            String camSessionId;
            String requestId = reqEnv.getRequestID();
            if (requestId != null) {
                this.auditRequestId = requestId;
                indication.setRequestID(requestId);
            }
            if ((camSessionId = reqEnv.getCAMUserPassport()) != null) {
                indication.setSessionID(camSessionId);
            }
        }
        ipfLog.log((Object)indication);
    }

    protected void auditFinishExecution(LogTypedLogger ipfLog, RequestEnvironment reqEnv, String errorMsg) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("DSS", 0);
        indication.setLevel(30000);
        indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
        indication.setOperation("Execute");
        if (errorMsg == null) {
            indication.setStatus("Success");
        } else {
            indication.setStatus("Failure");
            indication.setErrorMessage(errorMsg);
        }
        indication.setObjectType(AUDIT_OBJECT_TYPE);
        indication.setObjectPath(this.auditDashboardPath);
        indication.setLogData(this.auditExtraParameters);
        if (reqEnv != null) {
            String camSessionId;
            if (this.auditRequestId != null) {
                indication.setRequestID(this.auditRequestId);
            }
            if ((camSessionId = reqEnv.getCAMUserPassport()) != null) {
                indication.setSessionID(camSessionId);
            }
        }
        ipfLog.log((Object)indication);
    }

    protected QueryServiceException logXQEError(Throwable e) {
        XQELogger xqeLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Exception", (LogLevel)LogLevel.ERROR);
        if (xqeLogger.isOn(BaseExecutor.getExceptionLogLevel(e))) {
            xqeLogger.log(CAUGHT_ERROR, e);
        }
        if (e instanceof QueryServiceException) {
            return (QueryServiceException)e;
        }
        if (e instanceof XQERuntimeException && (!XQEMessages.isInternalException((Throwable)e) || XQERuntimeException.isOomError((Throwable)e))) {
            if (XQERuntimeException.isOomError((Throwable)e)) {
                return QueryServiceException.wrap((Throwable)XQERuntimeException.wrapOomError((Throwable)e));
            }
            if (this.isParameterMissingException(e)) {
                UnresolvedParameterException xqeException = (UnresolvedParameterException)e;
                Parameters params = xqeException.getUnresolvedParameters();
                RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
                Object usedParameters = null;
                if (this.qfbWrapper != null && this.qfbWrapper.requestedUsedParams()) {
                    QueryFeedbackWrapper.retrieveParameterFeedbackInfo(this.qfbWrapper, ParameterUtil.convertToParameterFeedbackInfo(this.getResolvedParameters(reqEnv)));
                    usedParameters = this.qfbWrapper.usedParamsToJSON();
                }
                return new MissingParameterValueException(e, params, usedParameters);
            }
            if (this.isPromptedSignonException(e)) {
                return QueryServiceException.wrap((Throwable)e);
            }
            XQERuntimeException ex = (XQERuntimeException)e;
            QueryServiceException qsDSException = QueryServiceException.getDataSourceException((XQERuntimeException)ex);
            if (qsDSException != null) {
                return qsDSException;
            }
            return QueryServiceException.wrap((Throwable)e);
        }
        XQERuntimeException xqeError = new XQERuntimeException(XQEMessageKeys.GEN_InternalException, e);
        return QueryServiceException.wrap((Throwable)xqeError);
    }

    private boolean isParameterMissingException(Throwable e) {
        return e instanceof UnresolvedParameterException;
    }

    private boolean isPromptedSignonException(Throwable e) {
        return e instanceof LogonFailureException && ((LogonFailureException)e).getSubCode() == LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS;
    }

    public static Parameters getParameters(IRequestEnvironment reqEnv) {
        Parameters parameters = reqEnv.getRequestParameters();
        return parameters.getUnresolvedParameters();
    }

    protected void setParameterValues(List<ParameterValue> theParameterValues) {
        this.parameterValues = theParameterValues;
    }

    protected void setGlobalParameterValues(List<GlobalParameterValue> theGlobalParameterValues) {
        this.globalParameterValues = theGlobalParameterValues;
    }

    protected void bindParameterValues(RequestEnvironment reqEnv) {
        if (this.hasParameterValuesV2()) {
            this.bindParameterValuesV2(reqEnv);
        } else if (this.hasParameterValues()) {
            this.bindParameterValues_obsolete(reqEnv);
        }
    }

    private void bindParameterValuesV2(RequestEnvironment reqEnv) {
        Parameters parameters = ParameterUtil.convertToParameters(this.parameterValuesV2);
        reqEnv.setRequestParameters(parameters);
    }

    private boolean hasParameterValuesV2() {
        return this.parameterValuesV2 != null && !this.parameterValuesV2.isEmpty();
    }

    private void bindParameterValues_obsolete(RequestEnvironment reqEnv) {
        Parameters parameters = new Parameters();
        for (ParameterValue paramValue : this.parameterValues) {
            Parameter parameter = new Parameter();
            parameter.setName(paramValue.getName());
            parameter.setDataType(parameters.getDataTypeByXSDName(paramValue.getDataType()));
            parameter.setDataTypeName();
            List values = paramValue.getValues();
            if (paramValue.getCapabilities() != null) {
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.discreteValue, paramValue.getCapabilities().getDiscreteValue().booleanValue());
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.optional, paramValue.getCapabilities().getOptional().booleanValue());
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.multivalued, paramValue.getCapabilities().getMultivalued().booleanValue());
            } else {
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.discreteValue, true);
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.optional, false);
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.multivalued, false);
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.unboundedRange, false);
                parameter.getCapabilities().setCapability(ParameterCapabilityEnum.boundRange, false);
            }
            if (values != null && !values.isEmpty() && "NIL".equalsIgnoreCase((String)values.get(0))) {
                parameter.setValueToNil();
            } else if (paramValue.getCapabilities() != null && paramValue.getCapabilities().getUnboundedRange().booleanValue()) {
                if (values == null || values.size() != 2) {
                    throw new QueryServiceException(QueryServiceMessageKeys.REST_MISSING_RANGE_PARAMETER_VALUE, paramValue.getName());
                }
                ParameterValues rangeParamValues = parameter.getParameterValueItems();
                rangeParamValues.addValue(true, (String)values.get(0), (String)values.get(0), (String)values.get(1), (String)values.get(1));
            } else {
                for (String value : values) {
                    parameter.addValue(value);
                }
            }
            parameter.setModelItem(paramValue.getModelFilterItem());
            parameters.addParameter(paramValue.getName(), parameter);
        }
        reqEnv.setRequestParameters(parameters);
    }

    protected void loadGlobalParameterValues(RequestEnvironment reqEnv, MultiRequestContext multiRequestContext) {
        if (this.hasGlobalParameterValuesV2()) {
            this.loadGlobalParametersV2(multiRequestContext);
        } else if (this.hasGlobalParameterValues()) {
            this.loadGlobalParameters_obsolete(multiRequestContext);
        }
    }

    private void loadGlobalParametersV2(MultiRequestContext multiRequestContext) {
        HashMap<String, Parameter> globalParams = new HashMap<String, Parameter>();
        for (ParameterValueV2 paramValue : this.globalParameterValuesV2) {
            String paramName = paramValue.getParameterName();
            Parameter parameter = null;
            Parameters requestParameters = multiRequestContext.getRequestParameters().getParameters();
            if (requestParameters != null) {
                parameter = requestParameters.getParameter(paramName);
            }
            if (parameter == null) {
                parameter = new Parameter(paramName, Parameter.getParameterDataType((String)paramValue.getDataType().value()));
                parameter.setIsGlobalParameter(true);
            }
            if (!parameter.hasValueProvidedWithRequest()) {
                ParameterUtil.loadParameterFromParamSpecV2(paramValue, parameter);
            }
            globalParams.put(paramName, parameter);
        }
        multiRequestContext.setGlobalParametersEnabled(true);
        multiRequestContext.setGlobalParametersInfoLoaded(true);
        multiRequestContext.setGlobalParametersMap(globalParams);
    }

    private void loadGlobalParameters_obsolete(MultiRequestContext multiRequestContext) {
        Parameters parameters = new Parameters();
        HashMap<String, Parameter> globalParams = new HashMap<String, Parameter>();
        for (GlobalParameterValue paramValue : this.globalParameterValues) {
            String paramName = paramValue.getName();
            Parameter parameter = null;
            Parameters requestParameters = multiRequestContext.getRequestParameters().getParameters();
            if (requestParameters != null) {
                parameter = requestParameters.getParameter(paramName);
            }
            if (parameter == null) {
                parameter = new Parameter(paramName);
                parameter.setIsGlobalParameter(true);
            }
            if (!parameter.hasValueProvidedWithRequest()) {
                parameter.setDataType(parameters.getDataTypeByXSDName(paramValue.getDataType()));
                parameter.setDataTypeName();
                List values = paramValue.getValues();
                if (paramValue.getCapabilities() != null) {
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.discreteValue, paramValue.getCapabilities().getDiscreteValue().booleanValue());
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.optional, paramValue.getCapabilities().getOptional().booleanValue());
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.multivalued, paramValue.getCapabilities().getMultivalued().booleanValue());
                } else {
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.discreteValue, true);
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.optional, false);
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.multivalued, false);
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.unboundedRange, false);
                    parameter.getCapabilities().setCapability(ParameterCapabilityEnum.boundRange, false);
                }
                if (values != null && !values.isEmpty() && ((String)values.get(0)).equalsIgnoreCase("NIL")) {
                    parameter.setValueToNil();
                } else if (paramValue.getCapabilities() != null && paramValue.getCapabilities().getUnboundedRange().booleanValue()) {
                    if (values == null || values.size() != 2) {
                        throw new QueryServiceException(QueryServiceMessageKeys.REST_MISSING_RANGE_PARAMETER_VALUE, paramValue.getName());
                    }
                    ParameterValues rangeParamValues = parameter.getParameterValueItems();
                    rangeParamValues.addValue(true, (String)values.get(0), (String)values.get(0), (String)values.get(1), (String)values.get(1));
                } else {
                    for (String value : values) {
                        parameter.addValue(value);
                    }
                }
                parameter.setModelItem(paramValue.getModelFilterItem());
            }
            globalParams.put(paramName, parameter);
        }
        multiRequestContext.setGlobalParametersEnabled(true);
        multiRequestContext.setGlobalParametersInfoLoaded(true);
        multiRequestContext.setGlobalParametersMap(globalParams);
    }

    private boolean hasGlobalParameterValuesV2() {
        return this.globalParameterValuesV2 != null && !this.globalParameterValuesV2.isEmpty();
    }

    public boolean hasParameterValues() {
        return this.parameterValues != null && !this.parameterValues.isEmpty();
    }

    public boolean hasGlobalParameterValues() {
        return this.globalParameterValues != null && !this.globalParameterValues.isEmpty();
    }

    protected void setConnections(List<Connection> theConnections) {
        this.connections = theConnections;
    }

    protected void createDataSourceConnections(RequestEnvironment requestEnv) {
        if (null == requestEnv || null == requestEnv.getExecutionEnvironment() || null == this.connections || this.connections.isEmpty()) {
            return;
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        Element connectionTopElem = DocumentHelper.createElement((String)"connection");
        for (Connection connection : this.connections) {
            Element connectionElem = connectionTopElem.addElement("connection");
            Element dsTypeElem = connectionElem.addElement("dataSourceType");
            dsTypeElem.addAttribute("value", "Database");
            Element nameElem = connectionElem.addElement("name");
            nameElem.addAttribute("value", connection.getConnection());
            Element dataSourceElem = connectionElem.addElement("dataSource");
            dataSourceElem.addAttribute("value", connection.getDatasource());
            String signon = connection.getSignon();
            if (signon == null) continue;
            Element signonElem = connectionElem.addElement("signon");
            Element nameElement = signonElem.addElement("name");
            nameElement.addAttribute("value", signon);
        }
        execEnv.setConnectionElement(connectionTopElem);
    }

    public Date getLastModified() {
        if (!this.queryPlanned) {
            this.planExecution();
            this.queryPlanned = true;
            this.lastModified = this.getLastModifiedFromQueryPlan();
        }
        return this.lastModified;
    }

    public long getDataCacheExpiry() {
        IXQEQueryNode[] rsapiDataSets;
        if (this.plannedQuery == null) {
            return 0L;
        }
        if (!this.queryPlanned) {
            this.planExecution();
            this.queryPlanned = true;
        }
        if ((rsapiDataSets = this.plannedQuery.getDescendantsOfType(401005, false)).length > 0 && rsapiDataSets[0] != null) {
            return ((RSAPIDataset)rsapiDataSets[0]).getCurrentDataCacheExpiry();
        }
        return 0L;
    }

    public void close() {
        if (this.envHelper != null) {
            this.envHelper.tearDownEnvironment();
            this.envHelper = null;
        }
    }

    protected abstract Date getLastModifiedFromQueryPlan();

    protected abstract void planExecution();

    protected IXQEQueryNode planQuery(boolean hasSampling, boolean useV5QuerySet) {
        boolean hasUnresolvedParameters;
        if (null != this.qfbWrapper) {
            this.qfbWrapper.startPlanning();
        }
        IXQEQueryNode aPlannedQuery = null;
        String previousSamplingMethod = null;
        String samplingMethod = null;
        if (hasSampling) {
            samplingMethod = this.getNextSamplingMethod(null, false);
        }
        int samplingMethodCount = 0;
        boolean hadRowCount = false;
        do {
            if (samplingMethod != null) {
                ++samplingMethodCount;
            }
            if ((aPlannedQuery = this.planQuery(samplingMethod, useV5QuerySet)) == null) {
                previousSamplingMethod = samplingMethod;
                samplingMethod = this.getNextSamplingMethod(previousSamplingMethod, hadRowCount);
                boolean bl = hadRowCount = this.actualRowCount != null;
                if (QueryServiceLogger.isDebugEnabled((Object)this)) {
                    QueryServiceLogger.debug((Object)this, (String)("Unable to plan query using sampling method: " + this.samplingMethodToDescription(previousSamplingMethod) + ", trying " + this.samplingMethodToDescription(samplingMethod)));
                }
                if (samplingMethodCount < 10) continue;
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Exceeded limit of 10 sampling methods");
            }
            if (!hasSampling || !QueryServiceLogger.isDebugEnabled((Object)this)) continue;
            QueryServiceLogger.debug((Object)this, (String)("Query planned using sampling method: " + this.samplingMethodToDescription(samplingMethod)));
        } while (aPlannedQuery == null);
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        if (this.qfbWrapper != null && this.qfbWrapper.requestedUsedParams()) {
            QueryFeedbackWrapper.retrieveParameterFeedbackInfo(this.qfbWrapper, ParameterUtil.convertToParameterFeedbackInfo(this.getResolvedParameters(reqEnv)));
        }
        boolean bl = hasUnresolvedParameters = BaseExecutor.getParameters((IRequestEnvironment)reqEnv).size() > 0;
        if (hasUnresolvedParameters) {
            UnresolvedParameterException e = new UnresolvedParameterException((IRequestEnvironment)reqEnv, aPlannedQuery, BaseExecutor.getParameters((IRequestEnvironment)reqEnv));
            throw this.logXQEError((Throwable)e);
        }
        QueryFeedbackWrapper.retrieveQueryFeedback(this.qfbWrapper, aPlannedQuery, reqEnv, this.servletRequestContext);
        return aPlannedQuery;
    }

    private Parameters getResolvedParameters(RequestEnvironment reqEnv) {
        Parameters resolvedParameters = new Parameters();
        Parameters allParameters = reqEnv.getRequestParameters();
        for (Map.Entry entry : allParameters.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isResolved()) continue;
            String name = (String)entry.getKey();
            resolvedParameters.put((Object)name, (Object)parameter);
        }
        return resolvedParameters;
    }

    private IXQEQueryNode planQuery(String sampleMethod, boolean useV5QuerySet) {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        reqEnv.setHttpServletRequest(this.servletRequestContext.getHttpServletRequest());
        ExecutionEnvironmentContext executionEnvironmentContext = XQEServiceImpl.startRequestPlanning(this.getClass().getSimpleName(), reqEnv, execEnv);
        PlannedV5QuerySet planTree = null;
        LogTypedLogger ipfLog = null;
        Throwable error = null;
        try {
            RSAPIDataset rsDataset;
            if (!DAASUtils.isDAAS() && (ipfLog = LogTypedLogger.getInstance((String)AUDIT_LOGGER_NAME, LogAuditIndication.class)).isEnabled(30000)) {
                this.auditStartExecution(ipfLog, reqEnv);
            }
            PlanningEnvironment planEnv = this.setupPlanningEnvironment(reqEnv);
            V5QuerySet querySet = null;
            Document v5Query = null;
            if (useV5QuerySet) {
                querySet = this.generateV5QuerySet(planEnv, sampleMethod);
                if (QueryServiceLogger.isDebugEnabled((Object)this)) {
                    QueryServiceLogger.debug((Object)this, (String)querySet.dumpToString());
                }
            } else {
                v5Query = this.generateDocument();
                if (QueryServiceLogger.isDebugEnabled((Object)this)) {
                    QueryServiceLogger.debug((Object)this, (String)v5Query.asXML());
                }
            }
            this.bindParameterValues(reqEnv);
            MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
            this.loadGlobalParameterValues(reqEnv, multiRequestContext);
            reqEnv.initializeRequestPAC(execEnv.getConnectionElement());
            this.requestPAC = reqEnv.getRequestPAC();
            String localeFromPAC = this.requestPAC.get("runLocale");
            if (localeFromPAC == null || localeFromPAC.isEmpty()) {
                ParameterMapsApp envMap = new ParameterMapsApp("_env", IParameterMaps.EPRIORITY.CQE_REQUEST.getKey());
                envMap.set("runLocale", this.dataset.getContentLocale());
                this.requestPAC.addParameterMap((IParameterMaps)envMap);
            }
            this.createDataSourceConnections(reqEnv);
            if (null != this.qfbWrapper && this.qfbWrapper.requestedFeedback()) {
                reqEnv.setMaxSeverityLevel(this.qfbWrapper.getSeverityLevel());
                if (QueryFeedbackMode.VALIDATE == this.qfbWrapper.getQueryFeedbackMode()) {
                    reqEnv.setValidateRequest(true);
                } else {
                    reqEnv.setMixedRequest(true);
                }
                if (this.qfbWrapper.requestedColumnInfo()) {
                    reqEnv.setResolveIsNullable(true);
                    ParameterMapsApp modelMap = new ParameterMapsApp("_governor", IParameterMaps.EPRIORITY.MODEL.getKey());
                    modelMap.set("_governor", "rads", "true");
                    this.requestPAC.addParameterMap((IParameterMaps)modelMap);
                }
            }
            planTree = useV5QuerySet ? QueryPlanner.getInstance().planQuery(querySet, planEnv) : QueryPlanner.getInstance().planQuery(v5Query, planEnv);
            if (BERNOULLI.equals(sampleMethod) && (rsDataset = (RSAPIDataset)planTree.getFirstDescendantOfTypeOrdered(401005, false)).hasSampledData()) {
                this.executeAndReleaseResultSet((IXQEQueryNode)planTree, this.requestPAC);
            }
            PlannedV5QuerySet plannedV5QuerySet = planTree;
            return plannedV5QuerySet;
        }
        catch (Throwable e2) {
            UnresolvedParameterException e2;
            if (sampleMethod != null && !NOSAMPLE.equals(sampleMethod)) {
                XQELogger xqeLogger;
                XQERuntimeException runtimeException;
                boolean logException = true;
                if (e2 instanceof XQETableSampleRowCountException) {
                    this.actualRowCount = ((XQETableSampleRowCountException)e2).getRowCount();
                    logException = false;
                } else if (e2 instanceof XQERuntimeException && XQEMessageKeys.PLN_UnsupportedFeature == (runtimeException = (XQERuntimeException)e2).getMessageKey()) {
                    logException = false;
                }
                if (logException && (xqeLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Exception", (LogLevel)LogLevel.ERROR)).isOn(BaseExecutor.getExceptionLogLevel(e2))) {
                    xqeLogger.log(CAUGHT_ERROR, e2);
                }
                IXQEQueryNode iXQEQueryNode = null;
                return iXQEQueryNode;
            }
            if (e2 instanceof XQERuntimeException) {
                boolean hasUnresolvedParameters;
                boolean bl = hasUnresolvedParameters = BaseExecutor.getParameters((IRequestEnvironment)reqEnv).size() > 0;
                if (hasUnresolvedParameters) {
                    e2 = new UnresolvedParameterException((IRequestEnvironment)reqEnv, planTree, BaseExecutor.getParameters((IRequestEnvironment)reqEnv));
                }
            }
            if (!DAASUtils.isDAAS() && ipfLog.isEnabled(30000)) {
                this.auditFinishExecution(ipfLog, reqEnv, e2.getMessage());
            }
            error = e2;
            if (this.qfbWrapper != null && this.qfbWrapper.requestedUsedParams()) {
                QueryFeedbackWrapper.retrieveParameterFeedbackInfo(this.qfbWrapper, ParameterUtil.convertToParameterFeedbackInfo(this.getResolvedParameters(reqEnv)));
            }
            throw this.logXQEError((Throwable)e2);
        }
        finally {
            XQEServiceImpl.finishRequestPlanning(reqEnv, execEnv, executionEnvironmentContext, error);
        }
    }

    protected V5QuerySet generateV5QuerySet(PlanningEnvironment planEnv, String sampleMethod) {
        throw new UnsupportedOperationException();
    }

    protected Document generateDocument() throws IOException, DocumentException, ParserConfigurationException, SAXException {
        throw new UnsupportedOperationException();
    }

    public String getExecutionPlan() throws Exception {
        return null;
    }

    public String getProductLocale() {
        return this.servletRequestContext.getProductLocale();
    }

    public Object execute() throws TimeoutException {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        XQEServiceImpl.startRequestExecution(this.requestType, reqEnv, this.timeLimit);
        String errorMsg = null;
        Throwable error = null;
        try {
            Object object = this.executeImpl();
            return object;
        }
        catch (Throwable e) {
            error = e;
            errorMsg = e.getMessage();
            throw this.logXQEError(e);
        }
        finally {
            LogTypedLogger ipfLog;
            if (!DAASUtils.isDAAS() && (ipfLog = LogTypedLogger.getInstance((String)AUDIT_LOGGER_NAME, LogAuditIndication.class)).isEnabled(30000)) {
                this.auditFinishExecution(ipfLog, reqEnv, errorMsg);
            }
            XQEServiceImpl.finishRequestExecution(reqEnv, error);
        }
    }

    public abstract Object executeImpl() throws TimeoutException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAndReleaseResultSet(IXQEQueryNode aPlannedQuery, ParameterAccessCoordinator planningPAC) {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        if (reqEnv.getRequestPAC() == null) {
            reqEnv.setRequestPAC(planningPAC);
        }
        IV5ResultSet[] v5ResultSets = null;
        try {
            this.bindParameterValues(reqEnv);
            this.createDataSourceConnections(reqEnv);
            v5ResultSets = this.executeV5Request(reqEnv, aPlannedQuery);
        }
        finally {
            if (v5ResultSets != null) {
                v5ResultSets[0].release();
            }
        }
    }

    protected String samplingMethodToDescription(String samplingMethod) {
        if (BERNOULLI.equals(samplingMethod)) {
            return "Bernoulli sample in SQL";
        }
        if (NTH.equals(samplingMethod)) {
            return "Nth row sample in SQL";
        }
        if (NOSAMPLE.equals(samplingMethod)) {
            return "Result set row sample using Bernoulli";
        }
        return "Unrecognized sampling method";
    }

    protected String getNextSamplingMethod(String previousSamplingMethod, boolean hadRowCount) {
        if (previousSamplingMethod != null && !hadRowCount && this.actualRowCount != null) {
            return previousSamplingMethod;
        }
        if (previousSamplingMethod == null) {
            return BERNOULLI;
        }
        if (BERNOULLI.equals(previousSamplingMethod)) {
            return NTH;
        }
        return NOSAMPLE;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    protected void setSamplingSettings(Integer rowCount, Double percentage, Integer seed, Integer resultLimit, boolean adjustPercentage) {
        this.sampleRowCount = rowCount;
        this.samplePercentage = percentage;
        this.sampleSeed = seed;
        this.sampleResultLimit = resultLimit;
        this.sampleAdjustPercentage = true;
        if (this.samplePercentage != null && this.sampleRowCount != null) {
            throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Only Percent or RowCount can specified for sampling");
        }
    }

    protected void setupSampling(String sampleMethod, V5Query query, V5QuerySet queryset, V5QueryResultDefinition qrd) {
        if (BERNOULLI.equals(sampleMethod)) {
            this.setupTableSampling(query, true);
        } else if (NTH.equals(sampleMethod)) {
            this.setupTableSampling(query, false);
        } else {
            this.setupResultSetSampling(query, queryset, qrd);
        }
    }

    private void setupTableSampling(V5Query query, boolean isBernoulli) {
        if (isBernoulli) {
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_METHOD.getPropertyName(), (Object)BERNOULLI);
        } else {
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_METHOD.getPropertyName(), (Object)NTH);
            query.setPropertyValue(V5Query.QueryHint.USE_SQL_WITH_CLAUSE.getPropertyName(), (Object)"false");
        }
        if (this.samplePercentage == null && this.sampleRowCount != null && this.actualRowCount != null) {
            this.samplePercentage = ApplySamplingQueryHintToTables.calculatePercent((int)this.sampleRowCount, (int)this.actualRowCount, (boolean)this.sampleAdjustPercentage);
        }
        if (this.samplePercentage != null) {
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_PERCENT.getPropertyName(), (Object)this.samplePercentage.toString());
        } else if (this.sampleRowCount != null) {
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_ROW_COUNT.getPropertyName(), (Object)this.sampleRowCount);
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_THROW_ON_SUBQUERY.getPropertyName(), (Object)Boolean.TRUE);
        }
        if (this.sampleSeed != null) {
            query.setPropertyValue(V5Query.QueryHint.TABLE_SAMPLING_SEED.getPropertyName(), (Object)this.sampleSeed);
        }
    }

    private void setupResultSetSampling(V5Query query, V5QuerySet queryset, V5QueryResultDefinition qrd) {
        if (this.sampleRowCount != null) {
            queryset.setPropertyValue("sampleRowCount", (Object)this.sampleRowCount);
        } else {
            queryset.setPropertyValue("samplePercent", (Object)this.samplePercentage);
        }
        queryset.setPropertyValue("sampleSeed", (Object)this.sampleSeed);
        if (this.sampleResultLimit != null) {
            qrd.setStringPropertyValue("topNRows", this.sampleResultLimit.toString());
        }
        query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), (Object)Governors.ExecutionOptimization.FIRSTROW.toString());
    }

    protected void adjustBasedOnSampleTooSmall(double actualRows) {
        this.sampleRowCount = (int)((double)this.sampleRowCount.intValue() * ((double)this.sampleRowCount.intValue() / actualRows));
        if (this.actualRowCount != null && this.samplePercentage != null) {
            this.samplePercentage = null;
        }
    }

    public Integer getSampleRowCount() {
        return this.sampleRowCount;
    }

    public boolean convertsXMLToJSON() {
        return false;
    }

    public static void logResultSet(IV5ResultSet resultset, Object logger) {
        if (resultset != null) {
            XMLWriter writer = new XMLWriter();
            StringWriter stringWriter = new StringWriter();
            writer.addStream((Writer)stringWriter);
            writer.setIndentString(" ");
            resultset.toXML(writer);
            String sResultset = stringWriter.toString();
            System.err.println(sResultset);
            if (QueryServiceLogger.isDebugEnabled((Object)logger)) {
                QueryServiceLogger.debug((Object)logger, (String)sResultset);
            }
        }
    }

    public static void logValue(IValue value, Object logger) {
        if (value != null) {
            XMLWriter writer = new XMLWriter();
            StringWriter stringWriter = new StringWriter();
            writer.addStream((Writer)stringWriter);
            writer.setIndentString(" ");
            value.toXML(writer);
            String sValue = stringWriter.toString();
            System.err.println(sValue);
            if (QueryServiceLogger.isDebugEnabled((Object)logger)) {
                QueryServiceLogger.debug((Object)logger, (String)sValue);
            }
        }
    }

    IXQEQueryNode getPlannedQuery() {
        return this.plannedQuery;
    }

    protected void setRequestAndGlobalParameterValues(QuerySpec querySpec) {
        this.setParameterValues(querySpec.getParameterValues());
        this.setGlobalParameterValues(querySpec.getGlobalParameterValues());
        this.setParameterValuesV2(querySpec.getParameterValuesV2());
        this.setGlobalParameterValuesV2(querySpec.getGlobalParameterValuesV2());
    }

    protected void setGlobalParameterValuesV2(List<ParameterValueV2> globalValuesV2) {
        this.globalParameterValuesV2 = globalValuesV2;
    }

    protected void setParameterValuesV2(List<ParameterValueV2> valuesV2) {
        this.parameterValuesV2 = valuesV2;
    }
}

