/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5EdgeSuppression;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.bi.platform.moser.expressions.v5.bin.EqualDistributionBinsExpression;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.FieldOrdering;
import com.ibm.bi.qs.model.api.NullPlacement;
import com.ibm.bi.qs.model.api.data.common.generated.AndFilter;
import com.ibm.bi.qs.model.api.data.common.generated.DataFilter;
import com.ibm.bi.qs.model.api.data.common.generated.Filter;
import com.ibm.bi.qs.model.api.data.common.generated.FilterExpression;
import com.ibm.bi.qs.model.api.data.common.generated.NotFilter;
import com.ibm.bi.qs.model.api.data.common.generated.OrFilter;
import com.ibm.bi.qs.model.api.data.common.generated.SuppressionType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.model.api.data.queryspec.generated.AggregateType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Argument;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Binning;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Calculation;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Context;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Function;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Operand;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QueryHints;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Sampling;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Sort;
import com.ibm.bi.qs.model.api.data.queryspec.generated.SortOrder;
import com.ibm.bi.qs.model.api.data.queryspec.generated.TopBottom;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.results.EndorResultSet;
import com.ibm.bi.qs.xqe.service.actions.ActionContext;
import com.ibm.bi.qs.xqe.service.actions.ActionFactory;
import com.ibm.bi.qs.xqe.service.actions.BaseActionHandler;
import com.ibm.bi.qs.xqe.service.actions.IActionHandler;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import com.ibm.bi.qs.xqe.v5.FilterGenerator;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DataExecutor
extends BaseExecutor {
    private static final String _MAX = "_MAX";
    private static final String _MIN = "_MIN";
    private static final String BLANK_SPACE = " ";
    private static final Double CURRENT_VERSION = 2.0;
    private static final String QS_NAMEDSET_PREFIX = "QS_NS_";
    private static final String BASE_QUERY_NAME = "baseQuery";
    private static final String SECONDARY_QUERY_NAME = "secondaryQuery";
    private static final String BINNING_QUERY = "binningQuery";
    private static final String BINNING_QUERY_QN = "[binningQuery].[";
    private static final String NUM_BINS = "NumericBins";
    private static final int DEFAULT_MAX_DECIMAL_PLACES = 2;
    private static final String[] BINNING_AUTOMATIC_LABELS = new String[]{"less than", "and above", "<blank>", "to <"};
    private static final String SPACE_OPEN_PARENTHESIS_SPACE = " ( ";
    private static final String SPACE_CLOSE_PARENTHESIS = " )";
    private static final String COMMA = ",";
    private static final String APOSTROPHE = "'";
    private static final String ZERO = "0";
    private static final String OPERAND_PLACE_HOLDER = "@s";
    private static final String AT_OPERAND_ORDER = ".[@operandOrder]";
    private static final String AT_EXPRESSION = ".[@expression]";
    private static final String QUERY_PLANNING_DEFINED_CALCULATIONS = "queryPlanning.definedCalculations.";
    private static final String CLOSE_BRACKET = "]";
    private static final String OPEN_BRACKET = "[";
    public static final String REQUEST_TYPE = DataExecutor.class.getSimpleName();
    private static final String ACTION_CONTEXT_AGGREGATE_FORMAT = "aggregate(%s for %s)";
    private static final String QS_ACTION_CONTEXT_AGGREGATE = "_qsActionContextAggregate";
    public static final String NEW_REL_TOPBORROMCOUNT_KEY = "queryPlanning.newRelTopBottomCount[@enabled]";
    public boolean isNewRelTopBottomCountEnabled = false;
    private QuerySpec querySpec;
    private V5Query baseQuery;
    private V5Query primaryQuery;
    private List<V5Query> topBottomCountQueries;
    private List<DataItem> nonProjTopBottomCountInFilterDIs;
    private boolean hasNonContextualTopBottomCount = false;
    private boolean useSecondaryForNonContextualTopBottomCount = false;
    private V5Query secondaryQuery;
    private Map<String, ColumnMetadata> columns;
    private Map<String, ProjectionType> projectionsTypes;
    private List<DataItem> dimensions;
    private boolean isDimensional = false;
    private boolean isDMRTriggeredForRelational = false;
    private String stringOpForDMRTriggeredForRelational;
    private boolean multiEdgeSort = false;
    private Integer rowLimit = 3000;
    private Integer startRow = 0;
    private boolean queryIncludesAutoBinningDataItems = false;
    private boolean queryIncludesTopBottomPercentDataItems = false;
    private static final String SEPARATOR = "; ";
    private boolean needBaseQuery;
    private boolean needSecondaryQuery;
    public int subQueryId = 0;

    public DataExecutor(QuerySpec querySpec, DataSet dataset, ServletRequestContext servletRequestContext) {
        super(servletRequestContext, REQUEST_TYPE, dataset);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.isNewRelTopBottomCountEnabled = configuration.getBooleanProperty(NEW_REL_TOPBORROMCOUNT_KEY, false);
        this.querySpec = querySpec;
        this.multiEdgeSort = TransformationUtils.getMultiEdgeSortQueryHint(querySpec);
        this.columns = new Hashtable<String, ColumnMetadata>();
        List columnList = dataset.getColumnMetadata();
        this.addColumns(columnList);
        this.projectionsTypes = new HashMap<String, ProjectionType>();
        if (querySpec.getOffset() != null) {
            this.startRow = querySpec.getOffset();
        } else {
            querySpec.setOffset(this.startRow);
        }
        if (querySpec.getLimit() != null) {
            this.rowLimit = querySpec.getLimit();
        } else {
            querySpec.setLimit(this.rowLimit);
        }
        this.timeLimit = querySpec.getTimeLimit();
        this.setRequestAndGlobalParameterValues(querySpec);
        this.setConnections(querySpec.getConnections());
        if (querySpec.getSampling() != null) {
            Sampling sampling = querySpec.getSampling();
            this.setSamplingSettings(sampling.getRowCount(), sampling.getPercentage(), sampling.getSeed(), sampling.getResultLimit(), false);
        }
        this.dimensions = new ArrayList<DataItem>();
        List dataItems = this.querySpec.getDataItems();
        for (DataItem field : dataItems) {
            if (field.getAggregate() == null) {
                this.dimensions.add(field);
            }
            if (field.getItemId() != null) {
                ColumnMetadata column = this.getColumnMetadata(field.getItemId());
                if (!this.isDimensional && DataExecutor.isDimensional(column)) {
                    this.isDimensional = true;
                }
            }
            if (this.queryIncludesAutoBinningDataItems) continue;
            this.queryIncludesAutoBinningDataItems = field.getBinning() != null && field.getBinning().getAuto() != null;
        }
        this.needSecondaryQuery = this.needSecondaryQuery();
        this.needBaseQuery = this.needBaseQuery();
        String qfbValue = null;
        String qfbLevel = null;
        String qfbMode = null;
        if (null != servletRequestContext && null != servletRequestContext.getHttpServletRequest()) {
            qfbValue = servletRequestContext.getHttpServletRequest().getParameter("qfb");
            qfbLevel = servletRequestContext.getHttpServletRequest().getParameter("qfbLevel");
            qfbMode = servletRequestContext.getHttpServletRequest().getParameter("qfbMode");
        }
        this.qfbWrapper = new QueryFeedbackWrapper(qfbValue);
        this.qfbWrapper.setSeverityLevel(qfbLevel);
        this.qfbWrapper.setQueryFeedbackMode(qfbMode);
        if (null != servletRequestContext) {
            this.qfbWrapper.setMetadataRetrievalTime(servletRequestContext.getMetadataRetrievalTime());
        }
    }

    private void addColumns(List<ColumnMetadata> columnList) {
        if (columnList == null || columnList.isEmpty()) {
            return;
        }
        for (ColumnMetadata col : columnList) {
            this.columns.put(col.getColumnId(), col);
            List children = col.getChildColumns();
            this.addColumns(children);
        }
    }

    private boolean needSecondaryQuery() {
        if (QuerySpec.Type.MINMAX.equals((Object)this.querySpec.getType()) && !this.isDimensional()) {
            for (DataItem item : this.querySpec.getDataItems()) {
                ColumnMetadata itemMeta = this.getColumnMetadata(item.getItemId());
                if (itemMeta == null || !ColumnMetadata.SourceCategory.CALCULATION.equals((Object)itemMeta.getSourceCategory())) continue;
                return true;
            }
        }
        if (this.setDMRValuesForForNewRelTopBottomCount()) {
            return false;
        }
        if (!this.querySpec.getType().equals((Object)QuerySpec.Type.SUMMARY)) {
            return false;
        }
        if (this.isDimensional()) {
            return false;
        }
        boolean onlyFoundProjTopCount = false;
        for (DataItem item : this.querySpec.getDataItems()) {
            if (item.getItemId() == null) continue;
            List actions = item.getSelection();
            for (Action action : actions) {
                if (action.getTopBottom() == null) continue;
                if (action.getTopBottom().getType().equals((Object)TopBottom.Type.TOPPERCENT) || action.getTopBottom().getType().equals((Object)TopBottom.Type.BOTTOMPERCENT)) {
                    this.isDMRTriggeredForRelational = true;
                    this.stringOpForDMRTriggeredForRelational = action.getTopBottom().getType().toString();
                    return false;
                }
                boolean foundProjTopCount = false;
                for (String projDataItemName : DataExecutor.getProjections(this.querySpec)) {
                    DataItem projDataItem = this.findDataItem(projDataItemName);
                    List nestedDataItemNames = projDataItem.getNest();
                    if (nestedDataItemNames != null && !nestedDataItemNames.isEmpty()) {
                        for (int i = 0; i < nestedDataItemNames.size(); ++i) {
                            String nestedDataItemName = (String)nestedDataItemNames.get(i);
                            if (!nestedDataItemName.equals(item.getId())) continue;
                            if (i == 0) {
                                foundProjTopCount = true;
                                break;
                            }
                            this.isDMRTriggeredForRelational = true;
                            this.stringOpForDMRTriggeredForRelational = action.getTopBottom().getType().toString();
                            return false;
                        }
                        if (!foundProjTopCount) continue;
                        break;
                    }
                    if (!projDataItemName.equals(item.getId())) continue;
                    foundProjTopCount = true;
                    break;
                }
                if (!foundProjTopCount) {
                    this.isDMRTriggeredForRelational = true;
                    this.stringOpForDMRTriggeredForRelational = action.getTopBottom().getType().toString();
                    return false;
                }
                onlyFoundProjTopCount = true;
            }
        }
        return onlyFoundProjTopCount;
    }

    public boolean setDMRValuesForForNewRelTopBottomCount() {
        if (!this.isNewRelTopBottomCountEnabled) {
            return false;
        }
        for (DataItem item : this.querySpec.getDataItems()) {
            if (item.getItemId() == null) continue;
            List actions = item.getSelection();
            for (Action action : actions) {
                if (action.getTopBottom() == null) continue;
                if (action.getTopBottom().getType().equals((Object)TopBottom.Type.TOPPERCENT) || action.getTopBottom().getType().equals((Object)TopBottom.Type.BOTTOMPERCENT)) {
                    this.isDMRTriggeredForRelational = true;
                    this.stringOpForDMRTriggeredForRelational = action.getTopBottom().getType().toString();
                    return true;
                }
                for (String projDataItemName : DataExecutor.getProjections(this.querySpec)) {
                    DataItem projDataItem = this.findDataItem(projDataItemName);
                    List nestedDataItemNames = projDataItem.getNest();
                    if (nestedDataItemNames == null || nestedDataItemNames.isEmpty() || nestedDataItemNames.size() < 2) continue;
                    for (int i = 1; i < nestedDataItemNames.size(); ++i) {
                        String nestedDataItemName = (String)nestedDataItemNames.get(i);
                        if (!nestedDataItemName.equals(item.getId())) continue;
                        this.isDMRTriggeredForRelational = true;
                        this.stringOpForDMRTriggeredForRelational = action.getTopBottom().getType().toString();
                        return true;
                    }
                }
            }
        }
        return true;
    }

    private boolean needBaseQuery() {
        if (this.isDimensional()) {
            return false;
        }
        for (DataItem dataItem : this.querySpec.getDataItems()) {
            List actions = dataItem.getSelection();
            for (Action action : actions) {
                if (action.getTopBottom() == null || action.getContext() == null || action.getContext().isEmpty()) continue;
                if (((Context)action.getContext().get(0)).getAggregate() == AggregateType.CALCULATED) {
                    return this.needSecondaryQuery;
                }
                if (((Context)action.getContext().get(0)).getAggregate() != null) continue;
                return this.queryIncludesAutoBinningDataItems && BaseActionHandler.useNewRelationalTopBottomCount(action.getTopBottom().getType(), this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQSResultSet executeImpl() {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        ParameterAccessCoordinator reqPAC = reqEnv.getRequestPAC();
        if (reqPAC == null) {
            reqEnv.setRequestPAC(this.requestPAC);
        }
        IV5ResultSet[] v5ResultSets = null;
        RSAPIDataset rsDataset = null;
        try {
            if (!this.qfbWrapper.isValidateMode()) {
                this.bindParameterValues(reqEnv);
                this.createDataSourceConnections(reqEnv);
                v5ResultSets = this.executeV5Request(reqEnv, this.plannedQuery);
                rsDataset = (RSAPIDataset)this.plannedQuery.getFirstDescendantOfTypeOrdered(401005, false);
            }
            EndorResultSet endorResultSet = new EndorResultSet(this.columns, this.querySpec, v5ResultSets, rsDataset, this.rowLimit.intValue(), this.qfbWrapper);
            return endorResultSet;
        }
        finally {
            if (v5ResultSets != null) {
                v5ResultSets[0].release();
            }
        }
    }

    public V5QuerySet generateV5QuerySet(PlanningEnvironment planEnv) {
        return this.generateV5QuerySet(planEnv, "");
    }

    @Override
    protected V5QuerySet generateV5QuerySet(PlanningEnvironment planEnv, String sampleMethod) {
        List filters;
        QueryHints hints;
        this.qfbWrapper.startRequestMarshalling();
        this.isValidQuerySpec();
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        V5QuerySet v5QuerySetNode = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySetNode.addToIndex();
        Boolean isModule = this.isModuleDataset();
        this.primaryQuery = TransformationUtils.buildV5QueryNode(nodeFactory, null, null, isModule, this.querySpec.getQueryHints());
        V5Selection v5Selection = (V5Selection)this.primaryQuery.getFirstChildByType(101009);
        String nullEdgeSuppression = "true";
        if (this.querySpec.getType().equals((Object)QuerySpec.Type.DETAIL)) {
            v5Selection.setAutoSummary(false);
            nullEdgeSuppression = "false";
        } else {
            v5Selection.setAutoSummary(true);
        }
        if (!this.isDimensional) {
            nullEdgeSuppression = "false";
        }
        v5QuerySetNode.addChild((IXQEQueryNode)this.primaryQuery);
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        if (this.needBaseQuery) {
            this.baseQuery = TransformationUtils.buildV5QueryNode(nodeFactory, BASE_QUERY_NAME, null, Boolean.FALSE, this.querySpec.getQueryHints());
            v5QuerySetNode.addChildBeforeNode((IXQEQueryNode)this.baseQuery, (IXQEQueryNode)this.primaryQuery);
            this.baseQuery.setPropertyValue("sourceModule", (Object)Boolean.FALSE);
            String refName = (String)this.baseQuery.getPropertyValue("name");
            V5Source v5Source = (V5Source)this.primaryQuery.getFirstChildByType(101007);
            v5Source.setQueryRef(refName);
        }
        if (this.needSecondaryQuery) {
            this.secondaryQuery = TransformationUtils.buildV5QueryNode(nodeFactory, SECONDARY_QUERY_NAME, this.primaryQuery, Boolean.FALSE, this.querySpec.getQueryHints());
            if (!QuerySpec.Type.MINMAX.equals((Object)this.querySpec.getType())) {
                ((V5Selection)this.secondaryQuery.getFirstChildByType(101009)).setAutoSummary(false);
            }
            v5QuerySetNode.addChild((IXQEQueryNode)this.secondaryQuery);
            v5QuerySetNode.setUnreferencedQueriesRemoved();
            v5QuerySetNode.setUnreferencedQRDsRemoved();
            v5QRD.setStringPropertyValue("name", (String)this.secondaryQuery.getPropertyValue("name") + ".0");
            v5QRD.setStringPropertyValue("refQuery", (String)this.secondaryQuery.getPropertyValue("name"));
        } else {
            v5QRD.setStringPropertyValue("name", (String)this.primaryQuery.getPropertyValue("name") + ".0");
            v5QRD.setStringPropertyValue("refQuery", (String)this.primaryQuery.getPropertyValue("name"));
        }
        if (this.rowLimit > 0) {
            Integer maxRows = this.startRow + this.rowLimit + 1;
            v5QRD.setStringPropertyValue("topNRows", maxRows.toString());
        }
        if (sampleMethod != null) {
            this.setupSampling(sampleMethod, this.primaryQuery, v5QuerySetNode, v5QRD);
        }
        if ((hints = this.querySpec.getQueryHints()) != null) {
            for (String hint : hints.getAdditionalProperties().keySet()) {
                Object queryHintValue = hints.getAdditionalProperties().get(hint);
                v5QRD.setPropertyValue(hint, queryHintValue);
                if (hint.equals(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName()) || hint.equals(V5Query.QueryHint.LOCAL_CACHE.getPropertyName())) continue;
                this.primaryQuery.setPropertyValue(hint, queryHintValue);
                if (this.secondaryQuery == null) continue;
                this.secondaryQuery.setPropertyValue(hint, queryHintValue);
            }
        }
        v5QuerySetNode.addChild((IXQEQueryNode)v5QRD);
        HashMap<String, ArrayList<String>> contextDependentMap = this.determineContextDependentMap();
        V5GroupBody v5GroupBody = null;
        V5ValueSet v5ValueSet = null;
        V5Edge v5Edge = (V5Edge)nodeFactory.createNode(101049, (IXQEQueryNode)v5QRD);
        V5EdgeSuppression v5EdgeSuppression = (V5EdgeSuppression)nodeFactory.createNode(101066);
        v5EdgeSuppression.setBooleanPropertyValue("nulls", "false");
        v5EdgeSuppression.setBooleanPropertyValue("zero", "false");
        v5EdgeSuppression.setBooleanPropertyValue("divByZero", "false");
        v5EdgeSuppression.setBooleanPropertyValue("overflow", "false");
        List<SuppressionType> suppressionTypes = this.getSuppress(this.querySpec);
        if (suppressionTypes.isEmpty()) {
            v5EdgeSuppression.setBooleanPropertyValue("nulls", nullEdgeSuppression);
        } else {
            for (SuppressionType suppressionType : suppressionTypes) {
                switch (suppressionType) {
                    case NULL: {
                        v5EdgeSuppression.setBooleanPropertyValue("nulls", "true");
                        break;
                    }
                    case ZERO: {
                        v5EdgeSuppression.setBooleanPropertyValue("zero", "true");
                        break;
                    }
                    case DIV_BY_ZERO: {
                        v5EdgeSuppression.setBooleanPropertyValue("divByZero", "true");
                        break;
                    }
                    case OVERFLOW: {
                        v5EdgeSuppression.setBooleanPropertyValue("overflow", "true");
                        break;
                    }
                }
            }
        }
        v5Edge.addChild((IXQEQueryNode)v5EdgeSuppression);
        v5Edge.setIntegerPropertyValue("edgeID", ZERO);
        v5Edge.setStringPropertyValue("name", ZERO);
        v5QRD.addChild((IXQEQueryNode)v5Edge);
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)nodeFactory.createNode(101050);
        v5Edge.addChild((IXQEQueryNode)v5EdgeGroup);
        v5ValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        v5ValueSet.setNameProperty("VS");
        v5EdgeGroup.addChild((IXQEQueryNode)v5ValueSet);
        v5GroupBody = (V5GroupBody)nodeFactory.createNode(101051);
        v5ValueSet.addChild((IXQEQueryNode)v5GroupBody);
        ArrayList<DataItem> autoBinnedDataItems = new ArrayList<DataItem>();
        int numAutoBinWithContext = 0;
        for (String dataItemId : DataExecutor.getProjections(this.querySpec)) {
            DataItem resultDataItem = this.findDataItem(dataItemId);
            if (resultDataItem == null) continue;
            if (resultDataItem.getBinning() != null && resultDataItem.getBinning().getAuto() != null) {
                if (null != resultDataItem.getBinning().getContext() && !resultDataItem.getBinning().getContext().isEmpty()) {
                    ++numAutoBinWithContext;
                }
                autoBinnedDataItems.add(resultDataItem);
                continue;
            }
            this.processProjection(nodeFactory, contextDependentMap, v5GroupBody, resultDataItem);
        }
        if (!autoBinnedDataItems.isEmpty()) {
            if (this.queryIncludesTopBottomPercentDataItems()) {
                throw new QueryServiceException(QueryServiceMessageKeys.REST_ERROR_TOPBOTTOM_PERCENT_AUTOGROUP_INVALID_SPEC);
            }
            if (numAutoBinWithContext > 1 || numAutoBinWithContext > 0 && autoBinnedDataItems.size() > 1) {
                throw new IllegalStateException("Only a single auto-binned data item is supported when it has contexts.");
            }
            for (DataItem dataItem : autoBinnedDataItems) {
                this.processProjection(nodeFactory, contextDependentMap, v5GroupBody, dataItem);
            }
        }
        if ((filters = this.querySpec.getFilters()) != null && !filters.isEmpty()) {
            Locale expressionLocale = ((RequestEnvironment)planEnv.getRequestEnvironment()).getExpressionLocale();
            boolean foundFilterForBins = false;
            V5Query targetQuery = this.primaryQuery;
            IXQEQueryNode[] topBottomFilters = null;
            if (this.getTopBottomCountQueries() != null && !this.getTopBottomCountQueries().isEmpty()) {
                for (IXQEQueryNode topBottomFilter : topBottomFilters = targetQuery.getChildrenOfType(101008)) {
                    targetQuery.detachChild(topBottomFilter);
                }
            }
            for (Filter currFilter : filters) {
                FilterExpression currFilterExpr = currFilter.getExpression();
                ArrayList<DataItem> dataItemList = new ArrayList<DataItem>();
                this.processNonProjectedDataItemsInFilters(nodeFactory, currFilterExpr, targetQuery, dataItemList);
                V5DetailFilter currDetailFilter = FilterGenerator.generateFilter(this, nodeFactory, targetQuery, currFilter, expressionLocale);
                boolean currFilterForBins = FilterGenerator.isForBins((IXQEQueryNode)currDetailFilter);
                if (!foundFilterForBins && currFilterForBins) {
                    foundFilterForBins = currFilterForBins;
                }
                if (!foundFilterForBins && currFilter.getType() == Filter.Type.PRE && this.needBaseQuery) {
                    this.baseQuery.addChild((IXQEQueryNode)currDetailFilter);
                    IXQEQueryNode[] dataItemRefs = currDetailFilter.getDescendantsOfType(201060, false);
                    for (IXQEQueryNode ref : dataItemRefs) {
                        V5DataItem changeToRef;
                        String name;
                        V5BoundDataItemReference boundRef = (V5BoundDataItemReference)ref;
                        V5DataItem referredDataItem = boundRef.getRefDataItem();
                        if (referredDataItem == null || (name = referredDataItem.getNameProperty()) == null || (changeToRef = this.baseQuery.getDataItemByName(name)) == null) continue;
                        boundRef.setRefDataItem(changeToRef);
                    }
                    continue;
                }
                targetQuery.addChild((IXQEQueryNode)currDetailFilter);
                if (this.getTopBottomCountQueries() == null || this.getTopBottomCountQueries().isEmpty()) continue;
                boolean applyFilter = true;
                if (this.getNonProjTopBottomCountInFilterDIs() != null && !this.getNonProjTopBottomCountInFilterDIs().isEmpty()) {
                    for (DataItem aTopbottomDI : this.getNonProjTopBottomCountInFilterDIs()) {
                        if (!BaseActionHandler.isDataItemReferencedByFilterExpression(currFilterExpr, aTopbottomDI.getId())) continue;
                        applyFilter = false;
                        break;
                    }
                }
                if (!applyFilter) continue;
                for (V5Query aQuery : this.getTopBottomCountQueries()) {
                    String targetDataItem;
                    if (currFilterExpr instanceof DataFilter && null != (targetDataItem = ((DataFilter)currFilterExpr).getDataItem()) && null == aQuery.getV5Selection().getDataItemByRefName(targetDataItem)) {
                        V5DataItem dataItem = targetQuery.getDataItemByName(targetDataItem);
                        aQuery.getV5Selection().addChild(nodeFactory.deepCopyNode((IXQEQueryNode)dataItem));
                    }
                    aQuery.addChild(nodeFactory.deepCopyNode((IXQEQueryNode)currDetailFilter));
                }
            }
            if (topBottomFilters != null) {
                for (IXQEQueryNode topBottomFilter : topBottomFilters) {
                    targetQuery.addChild(topBottomFilter);
                }
            }
            this.primaryQuery.setBooleanPropertyValue("containsQueryHint", Boolean.TRUE.toString());
            this.primaryQuery.setBooleanPropertyValue(V5Query.QueryHint.IGNORE_FILTERS_NOT_APPLICABLE.getPropertyName(), Boolean.TRUE.toString());
            if (foundFilterForBins) {
                this.buildSecondaryQueryForFilteringBins(nodeFactory);
            }
            this.buildSecondaryQueryForNonContextualTopBottom(nodeFactory);
        }
        this.buildV5SortGroup(this.primaryQuery, v5ValueSet, nodeFactory, v5GroupBody);
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        String path = this.dataset.getModuleConnectionPath();
        v5QuerySetNode.setStringPropertyValue("modelPath", path);
        DataSetType tp = this.dataset.getType();
        if (DataSetType.REPORT.equals((Object)tp)) {
            v5QuerySetNode.setStringPropertyValue("modelType", "report");
        } else if (!DataSetType.PACKAGE.equals((Object)tp)) {
            v5QuerySetNode.setStringPropertyValue("modelType", "module");
        }
        v5QuerySetNode.setPropertyValue("expressionLocale", (Object)LocaleConverter.localeToStr((Locale)reqEnv.getExpressionLocale()));
        if (QuerySpec.Intent.METADATA.equals((Object)this.querySpec.getIntent())) {
            this.primaryQuery.setStringPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName(), "metadata");
        } else if (QuerySpec.Intent.JOINDATA.equals((Object)this.querySpec.getIntent())) {
            this.primaryQuery.setPropertyValue("queryForTestJoin", (Object)true);
        }
        this.setPromptHandling(v5QuerySetNode);
        reqEnv.setModelPath(v5QuerySetNode.getModelPath());
        reqEnv.setModelType(v5QuerySetNode.getModelType());
        reqEnv.setUseDesignLocaleForExpressions(true);
        this.qfbWrapper.augmentV5Request(reqEnv, v5QuerySetNode);
        this.qfbWrapper.endRequestMarshalling();
        return v5QuerySetNode;
    }

    public Boolean isModuleDataset() {
        Boolean isModule = Boolean.TRUE;
        if (this.dataset.getType().equals((Object)DataSetType.PACKAGE)) {
            isModule = Boolean.FALSE;
        }
        return isModule;
    }

    private void setPromptHandling(V5QuerySet v5QuerySetNode) {
        String promptHandling;
        if (null != this.querySpec.getQueryHints() && null != this.querySpec.getQueryHints().getAdditionalProperties() && null != (promptHandling = (String)this.querySpec.getQueryHints().getAdditionalProperties().get("promptHandling")) && !promptHandling.isEmpty()) {
            v5QuerySetNode.setPromptHandling(promptHandling);
        }
    }

    private List<DataItem> processNonProjectedDataItemsInFilters(XQENodeFactory nodeFactory, FilterExpression currFilterExpr, V5Query targetQuery, List<DataItem> dataItemList) {
        if (currFilterExpr instanceof NotFilter) {
            FilterExpression notFilter = ((NotFilter)currFilterExpr).getNot();
            dataItemList = this.processNonProjectedDataItemsInFilters(nodeFactory, notFilter, targetQuery, dataItemList);
        } else if (currFilterExpr instanceof OrFilter) {
            List orFilters = ((OrFilter)currFilterExpr).getOr();
            for (FilterExpression currFilterExp : orFilters) {
                dataItemList = this.processNonProjectedDataItemsInFilters(nodeFactory, currFilterExp, targetQuery, dataItemList);
            }
            for (DataItem currDataItem : dataItemList) {
                if (currDataItem.getBinning() == null) continue;
                throw new IllegalStateException("The use of an auto-group in an OR or AND filter is not supported.");
            }
        } else if (currFilterExpr instanceof AndFilter) {
            List andFilters = ((AndFilter)currFilterExpr).getAnd();
            for (FilterExpression currFilterExp : andFilters) {
                dataItemList = this.processNonProjectedDataItemsInFilters(nodeFactory, currFilterExp, targetQuery, dataItemList);
            }
            for (DataItem currDataItem : dataItemList) {
                if (currDataItem.getBinning() == null) continue;
                throw new IllegalStateException("The use of an auto-group in an OR or AND filter is not supported.");
            }
        } else {
            DataFilter dataFilter = (DataFilter)currFilterExpr;
            if (null != dataFilter.getDataItem()) {
                String v5DataItemId = ((DataFilter)currFilterExpr).getDataItem();
                this.appendNonProjDataItemToQuery(nodeFactory, v5DataItemId, targetQuery);
                DataItem dataItem = FilterGenerator.findDataItem(this.getQuerySpec().getDataItems(), v5DataItemId);
                dataItemList.add(dataItem);
            } else if (dataFilter.getValues().isEmpty() && dataFilter.getValueDataItem() != null) {
                V5DataItem v5DataItem = targetQuery.getDataItemByName(dataFilter.getValueDataItem());
                if (v5DataItem == null) {
                    this.appendNonProjDataItemToQuery(nodeFactory, dataFilter.getValueDataItem(), targetQuery);
                }
                DataItem dataItem = FilterGenerator.findDataItem(this.getQuerySpec().getDataItems(), dataFilter.getValueDataItem());
                dataItemList.add(dataItem);
            }
        }
        return dataItemList;
    }

    private void processProjection(XQENodeFactory nodeFactory, HashMap<String, ArrayList<String>> contextDependentMap, V5GroupBody v5GroupBody, DataItem projectedDataItem) {
        List nest = projectedDataItem.getNest();
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        if (nest == null || nest.size() <= 0) {
            dataItems.add(projectedDataItem);
        } else {
            for (String nestDataItemsId : nest) {
                DataItem nestDataItem = this.findDataItem(nestDataItemsId);
                if (nestDataItem == null) continue;
                dataItems.add(nestDataItem);
            }
        }
        for (DataItem dataItem : dataItems) {
            this.processDataItem(nodeFactory, contextDependentMap, v5GroupBody, dataItem);
        }
    }

    private void processDataItem(XQENodeFactory nodeFactory, HashMap<String, ArrayList<String>> contextDependentMap, V5GroupBody v5GroupBody, DataItem dataItem) {
        boolean containsColumnHierarchy = false;
        ArrayList<DataItem> hierarchyFilters = new ArrayList<DataItem>();
        AggregateType aggType = null;
        String dataItemName = dataItem.getItemId();
        ColumnMetadata column = null;
        if (null != dataItemName) {
            column = this.getColumnMetadata(dataItemName);
            aggType = dataItem.getAggregate();
        }
        if (aggType == null && !this.querySpec.getType().equals((Object)QuerySpec.Type.MINMAX) && column != null && DataExecutor.isDimensional(column) && DataExecutor.isColumnAHierarchy(column)) {
            containsColumnHierarchy = true;
            for (DataItem dItem : this.querySpec.getDataItems()) {
                List dataItemActions;
                ColumnMetadata.SourceCategory sourceCategory;
                if (dItem.equals((Object)dataItem)) continue;
                ColumnMetadata otherColumn = null;
                if (null != dItem.getItemId()) {
                    otherColumn = this.getColumnMetadata(dItem.getItemId());
                }
                if (otherColumn == null || otherColumn.getHierarchy() == null || (sourceCategory = otherColumn.getSourceCategory()) == null || !otherColumn.getHierarchy().equals((Object)column.getHierarchy())) continue;
                if (sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY)) {
                    sourceCategory = otherColumn.getParentColumn().getSourceCategory();
                }
                if (sourceCategory == null || !sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) && !sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD) || (dataItemActions = dItem.getSelection()) == null) continue;
                for (Action diAction : dataItemActions) {
                    if (!DataExecutor.isHierarchyFilterSelection(diAction)) continue;
                    hierarchyFilters.add(dItem);
                }
            }
        }
        if (!this.needBaseQuery) {
            this.buildV5DataItemsForAttributes(dataItem, nodeFactory, v5GroupBody, hierarchyFilters, containsColumnHierarchy, contextDependentMap, this.primaryQuery);
        } else {
            String refDataItem = TransformationUtils.createInterQueryRefName(this.baseQuery, dataItem.getId());
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(refDataItem);
            TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, dataItem.getId(), null, (IXQEQueryNode)v5Expression, nodeFactory);
            this.buildV5DataItemsForAttributes(dataItem, nodeFactory, v5GroupBody, hierarchyFilters, containsColumnHierarchy, contextDependentMap, this.baseQuery);
        }
    }

    public V5DataItem appendNonProjDataItemToQuery(XQENodeFactory nodeFactory, String dataItem_id, V5Query targetQuery) {
        V5DataItem v5DataItem = targetQuery.getDataItemByName(dataItem_id);
        if (v5DataItem == null) {
            DataItem dataItem = FilterGenerator.findDataItem(this.getQuerySpec().getDataItems(), dataItem_id);
            if (dataItem != null) {
                boolean containsColumnHierarchy;
                ColumnMetadata column = this.getColumnMetadata(dataItem.getItemId());
                boolean bl = containsColumnHierarchy = dataItem.getAggregate() == null && !this.getQuerySpec().getType().equals((Object)QuerySpec.Type.MINMAX) && column != null && DataExecutor.isDimensional(column) && DataExecutor.isColumnAHierarchy(column);
                if (targetQuery == this.secondaryQuery || targetQuery == this.primaryQuery && !this.needBaseQuery && !this.needSecondaryQuery) {
                    this.buildV5DataItemsForAttributes(dataItem, nodeFactory, null, null, containsColumnHierarchy, null, targetQuery);
                } else {
                    V5Query query2;
                    V5Query query1;
                    V5Query query3 = null;
                    if (this.needBaseQuery && this.needSecondaryQuery) {
                        query1 = this.baseQuery;
                        query2 = this.primaryQuery;
                        query3 = this.secondaryQuery;
                    } else if (this.needSecondaryQuery) {
                        query1 = this.primaryQuery;
                        query2 = this.secondaryQuery;
                    } else {
                        query1 = this.baseQuery;
                        query2 = this.primaryQuery;
                    }
                    this.buildV5DataItemsForAttributes(dataItem, nodeFactory, null, null, containsColumnHierarchy, null, query1);
                    V5BoundDataItemReference ref = TransformationUtils.createBoundDataItemReference(query1, dataItem_id, nodeFactory, true);
                    TransformationUtils.buildDataItem((IXQEQueryNode)query2, dataItem_id, null, (IXQEQueryNode)ref, nodeFactory);
                    if (query3 != null) {
                        ref = TransformationUtils.createBoundDataItemReference(query2, dataItem_id, nodeFactory, true);
                        TransformationUtils.buildDataItem((IXQEQueryNode)query3, dataItem_id, null, (IXQEQueryNode)ref, nodeFactory);
                    }
                }
                v5DataItem = targetQuery.getDataItemByName(dataItem_id);
            } else if (ColumnMetadata.SourceCategory.NAMED_SET == this.getColumnMetadata(dataItem_id).getSourceCategory()) {
                dataItem = FilterGenerator.findDataItemByItemId(this.getQuerySpec().getDataItems(), dataItem_id);
                if (dataItem == null) {
                    ColumnMetadata namedSetMetadata = this.getColumnMetadata(dataItem_id);
                    com.ibm.bi.qs.model.api.AggregateType aggType = com.ibm.bi.qs.model.api.AggregateType.NONE;
                    V5MultiPartIdentifier multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(namedSetMetadata, nodeFactory);
                    String[] nameParts = UniqueNameParser.parseNoThrow((String)dataItem_id);
                    StringBuilder dataItem_name = new StringBuilder(QS_NAMEDSET_PREFIX);
                    dataItem_name.append(nameParts[nameParts.length - 1]);
                    TransformationUtils.buildDataItem((IXQEQueryNode)targetQuery, dataItem_name.toString(), aggType, (IXQEQueryNode)multiPartIdentifier, nodeFactory);
                    v5DataItem = targetQuery.getDataItemByName(dataItem_name.toString());
                } else {
                    v5DataItem = targetQuery.getDataItemByName(dataItem_id);
                }
            }
            if (dataItem == null && v5DataItem == null) {
                throw new QueryServiceException(QueryServiceMessageKeys.MISSING_QUERY_DATAITEM, dataItem_id, "dataset");
            }
        }
        return v5DataItem;
    }

    public void buildSecondaryQueryForFilteringBins(XQENodeFactory nodeFactory) {
        V5Query binningQuery = (V5Query)nodeFactory.deepCopyNode((IXQEQueryNode)this.primaryQuery);
        IXQEQueryNode[] detailFiltersFromBinningQuery = binningQuery.getDescendantsOfType(101008, false);
        ArrayList<IXQEQueryNode> toRemoveFromBinningQuery = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode detailFilter : detailFiltersFromBinningQuery) {
            if (!FilterGenerator.isForBins(detailFilter)) continue;
            toRemoveFromBinningQuery.add(detailFilter);
        }
        for (IXQEQueryNode detailFilter : toRemoveFromBinningQuery) {
            detailFilter.detach();
        }
        toRemoveFromBinningQuery.clear();
        ArrayList<IXQEQueryNode> toRemoveFromPrimaryQuery = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] detailFiltersFromPrimaryQuery = this.primaryQuery.getDescendantsOfType(101008, false);
        for (IXQEQueryNode detailFilter : detailFiltersFromPrimaryQuery) {
            if (FilterGenerator.isForBins(detailFilter)) continue;
            toRemoveFromPrimaryQuery.add(detailFilter);
        }
        for (IXQEQueryNode detailFilter : toRemoveFromPrimaryQuery) {
            detailFilter.detach();
        }
        toRemoveFromPrimaryQuery.clear();
        binningQuery.setStringPropertyValue("name", BINNING_QUERY);
        this.primaryQuery.getParent().addChildBeforeNode((IXQEQueryNode)binningQuery, (IXQEQueryNode)this.primaryQuery);
        V5Source v5Source = null;
        if (this.needBaseQuery) {
            v5Source = (V5Source)binningQuery.getFirstChildByType(101007);
            v5Source.setQueryRef(BASE_QUERY_NAME);
        }
        v5Source = (V5Source)this.primaryQuery.getFirstChildByType(101007);
        v5Source.setQueryRef(BINNING_QUERY);
        List dataItems = this.primaryQuery.getDescendantsOfTypeOrdered(101003, false);
        for (IXQEQueryNode dataItem : dataItems) {
            dataItem.detachChildren();
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            StringBuilder dataItemNameFromBiningQuery = new StringBuilder(BINNING_QUERY_QN);
            dataItemNameFromBiningQuery.append(((V5DataItem)dataItem).getNameProperty());
            dataItemNameFromBiningQuery.append(CLOSE_BRACKET);
            v5Expression.setExpression(dataItemNameFromBiningQuery.toString());
            dataItem.addChild((IXQEQueryNode)v5Expression);
        }
    }

    private void buildSecondaryQueryForNonContextualTopBottom(XQENodeFactory nodeFactory) {
        if (this.querySpec.getFilters() == null || this.querySpec.getFilters().isEmpty() || !this.hasNonContextualTopBottomCount) {
            return;
        }
        this.setUseSecondaryForNonContextualTopBottomCount(true);
        V5QuerySet querySet = (V5QuerySet)this.primaryQuery.getParent();
        V5Query binningQuery = querySet.getV5Query(BINNING_QUERY);
        if (binningQuery != null) {
            ArrayList<IXQEQueryNode> toRemoveFromBinningQuery = new ArrayList<IXQEQueryNode>();
            IXQEQueryNode[] detailFiltersFromTopBottomCount = binningQuery.getDescendantsOfType(101008, false);
            for (IXQEQueryNode detailFilter : detailFiltersFromTopBottomCount) {
                if (detailFilter.getPropertyValue("isTopBottomCountContextual") != Boolean.FALSE) continue;
                toRemoveFromBinningQuery.add(detailFilter);
            }
            for (IXQEQueryNode detailFilter : toRemoveFromBinningQuery) {
                detailFilter.detach();
            }
            toRemoveFromBinningQuery.clear();
            return;
        }
        V5Query rankBaseQuery = (V5Query)nodeFactory.deepCopyNode((IXQEQueryNode)this.primaryQuery);
        StringBuilder rankingQueryName = new StringBuilder("topBottomCountQuery");
        rankingQueryName.append(this.getNextSubQueryId());
        rankBaseQuery.setStringPropertyValue("name", rankingQueryName.toString());
        this.primaryQuery.getParent().addChildBeforeNode((IXQEQueryNode)rankBaseQuery, (IXQEQueryNode)this.primaryQuery);
        V5Source v5Source = (V5Source)this.primaryQuery.getFirstChildByType(101007);
        v5Source.setQueryRef(rankingQueryName.toString());
        ArrayList<IXQEQueryNode> detailFiltersToRemove = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] detailFiltersFromTopBottomCount = rankBaseQuery.getDescendantsOfType(101008, false);
        for (Object detailFilter : detailFiltersFromTopBottomCount) {
            if (detailFilter.getPropertyValue("isTopBottomCountContextual") != Boolean.FALSE) continue;
            detailFiltersToRemove.add((IXQEQueryNode)detailFilter);
        }
        for (IXQEQueryNode detailFilter : detailFiltersToRemove) {
            detailFilter.detach();
        }
        detailFiltersToRemove.clear();
        detailFiltersFromTopBottomCount = this.primaryQuery.getDescendantsOfType(101008, false);
        for (Object detailFilter : detailFiltersFromTopBottomCount) {
            if (detailFilter.getPropertyValue("isTopBottomCountContextual") == Boolean.FALSE) continue;
            detailFiltersToRemove.add((IXQEQueryNode)detailFilter);
        }
        for (IXQEQueryNode detailFilter : detailFiltersToRemove) {
            detailFilter.detach();
        }
        detailFiltersToRemove.clear();
        List dataItems = this.primaryQuery.getDescendantsOfTypeOrdered(101003, false);
        for (IXQEQueryNode dataItem : dataItems) {
            dataItem.detachChildren();
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            String rankBaseQueryDIName = BaseActionHandler.createInterQueryRefName(rankBaseQuery, ((V5DataItem)dataItem).getNameProperty());
            v5Expression.setExpression(rankBaseQueryDIName);
            dataItem.addChild((IXQEQueryNode)v5Expression);
        }
    }

    public DataItem findDataItem(String dataItemId) {
        DataItem dataItem = null;
        for (DataItem aDataItem : this.querySpec.getDataItems()) {
            String id = aDataItem.getId();
            if (id.compareTo(dataItemId) != 0) continue;
            dataItem = aDataItem;
            break;
        }
        return dataItem;
    }

    private void buildV5DataItemsForAttributes(DataItem dataItem, XQENodeFactory nodeFactory, V5GroupBody v5GroupBody, List<DataItem> hierarchyFilters, boolean containsHierarchy, HashMap<String, ArrayList<String>> contextDependentMap, V5Query targetV5Query) {
        AggregateType aggType;
        String expression = null;
        V5DataItem v5DataItem = null;
        com.ibm.bi.qs.model.api.AggregateType convertedAggType = null;
        String dataItemName = dataItem.getId();
        if (null == dataItem.getItemId() && (null != dataItem.getFunction() || null != dataItem.getCalculation())) {
            ArrayList<String> contextArray;
            V5Expression v5Expression = null;
            v5Expression = null != dataItem.getFunction() ? this.convertFunctionObjectToV5Expression(dataItem, nodeFactory) : this.convertCalculationObjectToV5Expression(dataItem, nodeFactory);
            v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, dataItemName, convertedAggType, (IXQEQueryNode)v5Expression, nodeFactory);
            v5DataItem.setPropertyValue("isQSDefinedCalculation", (Object)Boolean.TRUE);
            if (contextDependentMap != null && !contextDependentMap.isEmpty() && (contextArray = contextDependentMap.get(dataItemName)) != null && !contextArray.isEmpty()) {
                String[] nestedContextArray = contextArray.toArray(new String[0]);
                v5DataItem.setContextProperty(nestedContextArray);
            }
            if (v5GroupBody != null) {
                this.buildV5DataItemRef(v5GroupBody, nodeFactory, dataItemName);
                this.buildGroupBodyProperties(v5GroupBody, nodeFactory, containsHierarchy);
            }
            return;
        }
        ColumnMetadata column = this.getColumnMetadata(dataItem.getItemId());
        V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(column, nodeFactory);
        boolean applyAutoBinning = dataItem.getBinning() != null && dataItem.getBinning().getAuto() != null;
        ArrayList<String> rankCalcItemNames = new ArrayList<String>();
        if (!applyAutoBinning) {
            expression = this.applyActions(dataItem, nodeFactory, expression, identifier, applyAutoBinning, rankCalcItemNames);
            expression = this.applyHierarchyFilters(nodeFactory, hierarchyFilters, expression);
        }
        if ((aggType = dataItem.getAggregate()) != null) {
            convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
            this.projectionsTypes.put(dataItemName, ProjectionType.METRIC);
        } else {
            this.projectionsTypes.put(dataItemName, ProjectionType.CATEGORY);
        }
        if (column.getSourceCategory().equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && (convertedAggType != null || this.querySpec.getType().equals((Object)QuerySpec.Type.MINMAX))) {
            column = column.getParentColumn();
        }
        if (this.querySpec.getType().equals((Object)QuerySpec.Type.MINMAX)) {
            if (this.needSecondaryQuery) {
                this.buildV5DataItemsForMinMaxForCalculatedItem(dataItem, column, v5GroupBody, dataItemName, aggType, (IXQEQueryNode)identifier, nodeFactory);
                return;
            }
            dataItemName = this.buildV5DataItemsForMinMax(dataItem, column, v5GroupBody, dataItemName, aggType, (IXQEQueryNode)identifier, nodeFactory);
        } else {
            if (expression == null) {
                V5MultiPartIdentifier exp = identifier;
                if (dataItem.getBinning() != null && dataItem.getBinning().getAuto() != null) {
                    exp = this.buildAutoBinExpressions(targetV5Query, dataItem, nodeFactory, v5GroupBody, dataItemName);
                    StringBuilder binnedDataItemRef = new StringBuilder(OPEN_BRACKET).append(dataItemName).append(CLOSE_BRACKET);
                    expression = binnedDataItemRef.toString();
                    expression = this.applyActions(dataItem, nodeFactory, expression, identifier, applyAutoBinning, rankCalcItemNames);
                    expression = this.applyHierarchyFilters(nodeFactory, hierarchyFilters, expression);
                    if (!binnedDataItemRef.toString().equals(expression)) {
                        ((V5Expression)exp).setExpression(expression);
                    }
                    v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, dataItemName, convertedAggType, (IXQEQueryNode)exp, nodeFactory);
                } else {
                    if (convertedAggType == com.ibm.bi.qs.model.api.AggregateType.NULL_COUNT) {
                        convertedAggType = com.ibm.bi.qs.model.api.AggregateType.NONE;
                        StringBuilder nullCountTargetName = new StringBuilder(dataItemName).append("_NullCountTarget");
                        v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, nullCountTargetName.toString(), convertedAggType, (IXQEQueryNode)exp, nodeFactory);
                        exp = this.createNullCountAsString(nodeFactory, nullCountTargetName.toString(), column);
                    }
                    v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, dataItemName, convertedAggType, (IXQEQueryNode)exp, nodeFactory);
                }
            } else {
                ArrayList<String> contextArray;
                V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
                v5Expression.setExpression(expression);
                v5DataItem = TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, dataItemName, convertedAggType, (IXQEQueryNode)v5Expression, nodeFactory);
                if (contextDependentMap != null && !contextDependentMap.isEmpty() && (contextArray = contextDependentMap.get(dataItemName)) != null && !contextArray.isEmpty()) {
                    String[] nestedContextArray = contextArray.toArray(new String[0]);
                    v5DataItem.setContextProperty(nestedContextArray);
                }
            }
            String dataItemLabel = dataItem.getItemLabel();
            if (dataItemLabel != null) {
                v5DataItem.setStringPropertyValue("label", dataItemLabel);
            }
            if (aggType != null && column != null && column.getHierarchy() != null) {
                dataItemName = TransformationUtils.createMembersAggregateNEW(targetV5Query, column, dataItemName, this.dimensions, this.dataset, nodeFactory);
            }
        }
        if (null != v5DataItem && dataItem.getShowAll().booleanValue()) {
            v5DataItem.setPropertyValue("showall", (Object)true);
        }
        if (null != v5DataItem && column.isCalculation().booleanValue()) {
            v5DataItem.setModuleCalculation(true);
        }
        if (v5GroupBody != null) {
            this.buildV5DataItemRef(v5GroupBody, nodeFactory, dataItemName);
            this.buildGroupBodyProperties(v5GroupBody, nodeFactory, containsHierarchy);
            if (!rankCalcItemNames.isEmpty()) {
                for (String rankCalcItemName : rankCalcItemNames) {
                    this.buildV5DataItemRef(v5GroupBody, nodeFactory, rankCalcItemName);
                }
            }
        }
    }

    private V5Expression convertCalculationObjectToV5Expression(DataItem dataItem, XQENodeFactory nodeFactory) {
        String referencedDataItem;
        DataItem refDataItem;
        ColumnMetadata metadata;
        if (this.isDimensional) {
            throw new QueryServiceException(QueryServiceMessageKeys.PLN_UNSUPPORTED_CALC_OLAP, dataItem.getCalculation().getOperation());
        }
        if (this.isDMRTriggeredForRelational) {
            throw new QueryServiceException(QueryServiceMessageKeys.PLN_UNSUPPORTED_CALC_DMR_TRIGGERED, dataItem.getCalculation().getOperation(), this.stringOpForDMRTriggeredForRelational);
        }
        this.projectionsTypes.put(dataItem.getId(), ProjectionType.METRIC);
        String expression = null;
        Calculation calculation = dataItem.getCalculation();
        String operation = calculation.getOperation();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String searchString = QUERY_PLANNING_DEFINED_CALCULATIONS + operation;
        List o = calculation.getOperands();
        if ("sumSqr".equals(operation) && o != null && !o.isEmpty() && (metadata = this.getColumnMetadata((refDataItem = this.findDataItem(referencedDataItem = ((Operand)o.get(0)).getDataItem())).getItemId())).getType() != ColumnMetadata.Type.FACT && configuration.getPropertyValue((searchString = QUERY_PLANNING_DEFINED_CALCULATIONS + operation + "OnAttribute") + AT_EXPRESSION, null) == null) {
            searchString = QUERY_PLANNING_DEFINED_CALCULATIONS + operation;
        }
        if (null != configuration.getPropertyValue(searchString + AT_EXPRESSION, null)) {
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            expression = (String)configuration.getPropertyValue(searchString + AT_EXPRESSION, (Object)"");
            if (expression.contains(OPERAND_PLACE_HOLDER)) {
                List operands = calculation.getOperands();
                String[] operandOrder = null;
                operandOrder = configuration.getStringArrayProperty(searchString + AT_OPERAND_ORDER, null);
                if (operandOrder == null || operandOrder.length == 0 || operandOrder[0] == null) {
                    operandOrder = new String[]{ZERO};
                }
                String[] formatOp = new String[operandOrder.length];
                int pos = 0;
                for (String currOperand : operandOrder) {
                    StringBuilder op = new StringBuilder(OPEN_BRACKET);
                    String currDataItem = ((Operand)operands.get(Integer.valueOf(currOperand))).getDataItem();
                    op.append(currDataItem);
                    op.append(CLOSE_BRACKET);
                    formatOp[pos++] = op.toString();
                }
                String[] exprParts = expression.split(OPERAND_PLACE_HOLDER);
                if (exprParts.length > formatOp.length + 1) {
                    throw new IllegalStateException("!exprParts.length > formatArg.length + 1.");
                }
                int part = 0;
                StringBuilder formatedExpr = new StringBuilder(exprParts[part]);
                for (String currOperand : formatOp) {
                    formatedExpr.append(currOperand);
                    formatedExpr.append(exprParts[++part]);
                }
                v5Expression.setExpression(formatedExpr.toString());
            } else {
                v5Expression.setExpression(expression);
            }
            return v5Expression;
        }
        throw new IllegalStateException("!definedCalculations.");
    }

    private V5Expression convertFunctionObjectToV5Expression(DataItem dataItem, XQENodeFactory nodeFactory) {
        Function function = dataItem.getFunction();
        String functionName = function.getName();
        List args = function.getArguments();
        if ("getLocalizedBinLabel".equals(functionName)) {
            this.projectionsTypes.put(dataItem.getId(), ProjectionType.CATEGORY);
            if (args.isEmpty()) {
                throw new IllegalStateException("The function 'getLocalizedBinLabel' requires 1 argument.");
            }
            String resourceId = ((Argument)args.get(0)).getArgument();
            StringBuilder sbMacroExpr = new StringBuilder("#sq(substr(getResourceString('");
            sbMacroExpr.append(resourceId);
            sbMacroExpr.append("');13))#");
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(sbMacroExpr.toString());
            return v5Expression;
        }
        throw new IllegalStateException("Undefined function.");
    }

    private String applyHierarchyFilters(XQENodeFactory nodeFactory, List<DataItem> hierarchyFilters, String expression) {
        if (hierarchyFilters != null && !hierarchyFilters.isEmpty()) {
            for (DataItem filterItem : hierarchyFilters) {
                ColumnMetadata filterColumn = this.getColumnMetadata(filterItem.getItemId());
                V5MultiPartIdentifier filterIdentifier = TransformationUtils.createMultiPartIdentifier(filterColumn, nodeFactory);
                List selections = filterItem.getSelection();
                if (selections == null) continue;
                ArrayList<Action> handledActions = new ArrayList<Action>();
                ActionFactory actionFactory = ActionFactory.getInstance();
                for (Action action : selections) {
                    if (!DataExecutor.isHierarchyFilterSelection(action)) continue;
                    handledActions.add(action);
                    ActionContext actionContext = new ActionContext();
                    actionContext.add(BaseActionHandler.ParamName.EXPRESSION, expression);
                    actionContext.add(BaseActionHandler.ParamName.IDENTIFIER, filterIdentifier);
                    IActionHandler actionHandler = actionFactory.create(action, this, nodeFactory);
                    expression = actionHandler.execute(actionContext, action, filterItem);
                }
                selections.removeAll(handledActions);
            }
        }
        return expression;
    }

    private String applyActions(DataItem dataItem, XQENodeFactory nodeFactory, String expression, V5MultiPartIdentifier identifier, boolean applyAutoBinning, ArrayList<String> rankCalcItemNames) {
        List actions = dataItem.getSelection();
        if (actions != null) {
            ActionFactory actionFactory = ActionFactory.getInstance();
            for (Action action : actions) {
                ActionContext actionContext = new ActionContext();
                actionContext.add(BaseActionHandler.ParamName.EXPRESSION, expression);
                actionContext.add(BaseActionHandler.ParamName.IDENTIFIER, identifier);
                IActionHandler actionHandler = actionFactory.create(action, this, nodeFactory);
                expression = actionHandler.execute(actionContext, action, dataItem);
                if (!actionHandler.hasAdditionalCalculations()) continue;
                rankCalcItemNames.addAll(actionHandler.getRankCalcIdentifiers());
            }
        }
        return expression;
    }

    private IXQEQueryNode buildAutoBinExpressions(V5Query targetV5Query, DataItem dataItem, XQENodeFactory nodeFactory, V5GroupBody v5GroupBody, String dataItemName) {
        Binning binning = dataItem.getBinning();
        List contextList = binning.getContext();
        ArrayList<String> binningContextList = null;
        if (contextList != null && !contextList.isEmpty()) {
            binningContextList = new ArrayList<String>();
            for (Context currContext : contextList) {
                binningContextList.add(currContext.getItemId());
            }
        }
        String binnedDataItemName = dataItem.getItemId();
        String strNumericBinName = DataExecutor.buildNumericBinName(dataItemName);
        int maxDecimalPlaces = 2;
        if (binning.getAuto().getMaxDecPlaces() != null) {
            maxDecimalPlaces = binning.getAuto().getMaxDecPlaces();
        }
        if (this.isDimensional()) {
            throw new IllegalStateException("Auto-binning is not supported for dimensional data sources.");
        }
        return this.buildAutoBinExpressionsForRelWithoutContext(targetV5Query, nodeFactory, v5GroupBody, binning, binnedDataItemName, strNumericBinName, maxDecimalPlaces);
    }

    private IXQEQueryNode buildAutoBinExpressionsForRelWithoutContext(V5Query targetV5Query, XQENodeFactory nodeFactory, V5GroupBody v5GroupBody, Binning binning, String binnedDataItemName, String strNumericBinName, int maxDecimalPlaces) {
        EqualDistributionBinsExpression binBuilder = new EqualDistributionBinsExpression(binnedDataItemName, strNumericBinName, binning.getAuto().getNumberOfBins().intValue(), BINNING_AUTOMATIC_LABELS, null, maxDecimalPlaces, this.dataset.getContentLocale());
        String binNumberExpr = binBuilder.binNumberExpression();
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(binNumberExpr);
        TransformationUtils.buildDataItem((IXQEQueryNode)targetV5Query, strNumericBinName, null, (IXQEQueryNode)v5Expression, nodeFactory);
        if (v5GroupBody != null) {
            if (targetV5Query == this.baseQuery) {
                String refDataItem = TransformationUtils.createInterQueryRefName(this.baseQuery, strNumericBinName);
                V5Expression v5Expression1 = (V5Expression)nodeFactory.createNode(101004);
                v5Expression1.setExpression(refDataItem);
                TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, strNumericBinName, null, (IXQEQueryNode)v5Expression1, nodeFactory);
            }
            this.buildV5DataItemRef(v5GroupBody, nodeFactory, strNumericBinName);
        }
        String binLableExpr = binBuilder.binLabelExpression();
        v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(binLableExpr);
        V5Expression exp = v5Expression;
        return exp;
    }

    private IXQEQueryNode createNullCountAsString(XQENodeFactory nodeFactory, String countTargetName, ColumnMetadata column) {
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        StringBuilder dataItemNameRef = new StringBuilder(OPEN_BRACKET).append(countTargetName).append(CLOSE_BRACKET);
        if (column.getDataType() == ColumnMetadata.DataType.STRING) {
            StringBuilder if_lower_in_set_then_null = new StringBuilder("if( trim ( both; ").append((CharSequence)dataItemNameRef).append(" ) in ( ");
            ArrayList nullValues = this.querySpec.getNullValues();
            if (this.querySpec.getNullValues() == null) {
                nullValues = new ArrayList();
            }
            int i = 0;
            boolean foundEmptyString = false;
            for (String nullVal : nullValues) {
                foundEmptyString = !foundEmptyString && nullVal.equals("");
                if_lower_in_set_then_null.append(APOSTROPHE);
                if_lower_in_set_then_null.append(nullVal);
                if_lower_in_set_then_null.append(APOSTROPHE);
                if (++i >= this.querySpec.getNullValues().size()) continue;
                if_lower_in_set_then_null.append(COMMA);
            }
            if (!foundEmptyString) {
                if (!nullValues.isEmpty()) {
                    if_lower_in_set_then_null.append(COMMA);
                }
                if_lower_in_set_then_null.append(APOSTROPHE);
                if_lower_in_set_then_null.append(APOSTROPHE);
            }
            if_lower_in_set_then_null.append(" ) ) then ( null ) else ( ").append((CharSequence)dataItemNameRef).append(SPACE_CLOSE_PARENTHESIS);
            dataItemNameRef = if_lower_in_set_then_null;
        }
        StringBuilder if_null_then_one = new StringBuilder("if( ").append((CharSequence)dataItemNameRef).append(" is null ) then ( 1 ) else ( null )");
        StringBuilder count = new StringBuilder("count( ").append((CharSequence)if_null_then_one).append(SPACE_CLOSE_PARENTHESIS);
        v5Expression.setExpression(count.toString());
        return v5Expression;
    }

    private HashMap<String, ArrayList<String>> determineContextDependentMap() {
        HashMap contextMap = null;
        block0: for (DataItem qsDI : this.querySpec.getDataItems()) {
            List nestDataItems = qsDI.getNest();
            if (nestDataItems == null || nestDataItems.size() < 2) continue;
            block1: for (int idx = 1; idx < nestDataItems.size(); ++idx) {
                String dataItemId = (String)nestDataItems.get(idx);
                DataItem refDataItem = this.findDataItem(dataItemId);
                if (refDataItem == null) continue;
                List diActions = refDataItem.getSelection();
                if (diActions == null) continue block0;
                ArrayList<String> contextArray = new ArrayList<String>();
                for (Action action : diActions) {
                    TopBottom topBottom = action.getTopBottom();
                    if (topBottom == null || !topBottom.getType().equals((Object)TopBottom.Type.TOPCOUNT) && !topBottom.getType().equals((Object)TopBottom.Type.TOPPERCENT) && !topBottom.getType().equals((Object)TopBottom.Type.BOTTOMCOUNT) && !topBottom.getType().equals((Object)TopBottom.Type.BOTTOMPERCENT)) continue;
                    for (int n = 0; n < idx; ++n) {
                        String nestDataItemId = (String)nestDataItems.get(n);
                        DataItem nestDataItem = this.findDataItem(nestDataItemId);
                        if (nestDataItem == null) continue;
                        String contextItemId = nestDataItem.getId();
                        contextArray.add(contextItemId);
                    }
                    if (contextArray.isEmpty()) continue;
                    if (contextMap == null) {
                        contextMap = new HashMap();
                    }
                    contextMap.put(refDataItem.getId(), contextArray);
                    continue block1;
                }
            }
        }
        return contextMap;
    }

    private void buildGroupBodyProperties(V5GroupBody v5GroupBody, XQENodeFactory nodeFactory, boolean containsHierarchy) {
        if (v5GroupBody.hasChildOfType(101054)) {
            return;
        }
        if (containsHierarchy) {
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.PARENT_UNIQUE_NAME));
        }
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_UNIQUE_NAME));
        v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.MEMBER_CAPTION));
        if (this.querySpec.getAllProperties().booleanValue()) {
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.DIMENSION_UNIQUE_NAME));
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.HIERARCHY_UNIQUE_NAME));
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.LEVEL_UNIQUE_NAME));
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.LEVEL_LABEL));
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.LEVEL_NUMBER));
            v5GroupBody.addChild((IXQEQueryNode)TransformationUtils.createV5PropertyExpression(nodeFactory, RoleTypeEnum.PARENT_UNIQUE_NAME));
        }
    }

    private String buildV5DataItemsForMinMax(DataItem attribute, ColumnMetadata column, V5GroupBody v5GroupBody, String dataItemName, AggregateType aggType, IXQEQueryNode identifier, XQENodeFactory nodeFactory) {
        if (attribute.getAggregate() != null) {
            if (TransformationUtils.isMemberSet(column)) {
                dataItemName = TransformationUtils.createMembersAggregateNEW(this.primaryQuery, column, dataItemName, this.dimensions, this.dataset, nodeFactory);
            } else if (this.isDimensional) {
                com.ibm.bi.qs.model.api.AggregateType convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
                TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, dataItemName, convertedAggType, identifier, nodeFactory);
            } else {
                TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, dataItemName, null, identifier, nodeFactory);
            }
            String minDataItemName = dataItemName + _MIN;
            String maxDataItemName = dataItemName + _MAX;
            boolean isFact = column.getType() == ColumnMetadata.Type.FACT;
            this.buildV5Expression(this.primaryQuery, nodeFactory, minDataItemName, AggregateType.AUTOMATIC, this.generateMinMaxExpression(aggType, dataItemName, nodeFactory, "minimum", isFact));
            this.buildV5DataItemRef(v5GroupBody, nodeFactory, minDataItemName);
            this.buildV5Expression(this.primaryQuery, nodeFactory, maxDataItemName, AggregateType.AUTOMATIC, this.generateMinMaxExpression(aggType, dataItemName, nodeFactory, "maximum", isFact));
            return maxDataItemName;
        }
        com.ibm.bi.qs.model.api.AggregateType aggrTypeMin = com.ibm.bi.qs.model.api.AggregateType.MIN;
        com.ibm.bi.qs.model.api.AggregateType aggrTypeMax = com.ibm.bi.qs.model.api.AggregateType.MAX;
        ColumnMetadata.DataType dataType = column.getDataType();
        if (!ColumnMetadata.DataType.DATE.equals((Object)dataType) && !ColumnMetadata.DataType.TIME.equals((Object)dataType) && !ColumnMetadata.DataType.DATETIME.equals((Object)dataType) || TransformationUtils.isMemberSet(column)) {
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression("'--'");
            identifier = v5Expression;
            aggrTypeMin = null;
            aggrTypeMax = null;
        }
        String minDataItemName = dataItemName + _MIN;
        String maxDataItemName = dataItemName + _MAX;
        TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, minDataItemName, aggrTypeMin, identifier, nodeFactory);
        this.buildV5DataItemRef(v5GroupBody, nodeFactory, minDataItemName);
        TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, maxDataItemName, aggrTypeMax, nodeFactory.copyNode(identifier), nodeFactory);
        return maxDataItemName;
    }

    private void buildV5DataItemsForMinMaxForCalculatedItem(DataItem attribute, ColumnMetadata column, V5GroupBody v5GroupBody, String dataItemName, AggregateType aggType, IXQEQueryNode identifier, XQENodeFactory nodeFactory) {
        V5Expression v5Expression;
        for (DataItem dim : this.dimensions) {
            ColumnMetadata dimColumnMeta = this.getColumnMetadata(dim.getItemId());
            v5Expression = (V5Expression)nodeFactory.createNode(101004);
            V5MultiPartIdentifier multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(dimColumnMeta, nodeFactory);
            v5Expression.addChild((IXQEQueryNode)multiPartIdentifier);
            TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, dim.getId(), null, (IXQEQueryNode)v5Expression, nodeFactory);
        }
        v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.addChild(identifier);
        if (aggType == null) {
            aggType = AggregateType.NONE;
        }
        com.ibm.bi.qs.model.api.AggregateType convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
        TransformationUtils.buildDataItem((IXQEQueryNode)this.primaryQuery, dataItemName, convertedAggType, (IXQEQueryNode)v5Expression, nodeFactory);
        V5BoundDataItemReference v5BoundItemRef = TransformationUtils.createBoundDataItemReference(this.primaryQuery, dataItemName, nodeFactory, true);
        v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression("minimum(" + v5BoundItemRef.getIdentifier() + ")");
        TransformationUtils.buildDataItem((IXQEQueryNode)this.secondaryQuery, dataItemName + _MIN, com.ibm.bi.qs.model.api.AggregateType.MIN, (IXQEQueryNode)v5Expression, nodeFactory);
        v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression("maximum(" + v5BoundItemRef.getIdentifier() + ")");
        TransformationUtils.buildDataItem((IXQEQueryNode)this.secondaryQuery, dataItemName + _MAX, com.ibm.bi.qs.model.api.AggregateType.MAX, (IXQEQueryNode)v5Expression, nodeFactory);
        V5DataItemRef v5ItemRefMIN = (V5DataItemRef)nodeFactory.createNode(101015);
        V5DataItemRef v5ItemRefMAX = (V5DataItemRef)nodeFactory.createNode(101015);
        v5ItemRefMIN.setPropertyValue("refDataItem", (Object)(dataItemName + _MIN));
        v5ItemRefMAX.setPropertyValue("refDataItem", (Object)(dataItemName + _MAX));
        v5GroupBody.addChild((IXQEQueryNode)v5ItemRefMIN);
        v5GroupBody.addChild((IXQEQueryNode)v5ItemRefMAX);
    }

    public void buildV5DataItemRef(V5GroupBody v5GroupBody, XQENodeFactory nodeFactory, String dataItemName) {
        this.buildDataItemForSecondaryQuery(nodeFactory, dataItemName);
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nodeFactory.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", (Object)dataItemName);
        v5GroupBody.addChild((IXQEQueryNode)v5DataItemRef);
    }

    private void buildDataItemForSecondaryQuery(XQENodeFactory nodeFactory, String dataItemName) {
        V5DataItem dataItem = this.primaryQuery.getDataItemByName(dataItemName);
        if (this.needSecondaryQuery && this.secondaryQuery != null && dataItem != null && this.secondaryQuery.getDataItemByName(dataItemName) == null) {
            V5BoundDataItemReference ref = TransformationUtils.createBoundDataItemReference(this.primaryQuery, dataItemName, nodeFactory, true);
            TransformationUtils.buildDataItem((IXQEQueryNode)this.secondaryQuery, dataItemName, null, (IXQEQueryNode)ref, nodeFactory);
        }
    }

    private String generateMinMaxExpression(AggregateType aggType, String dataItemName, XQENodeFactory nodeFactory, String functionType, boolean isFact) {
        String escapedRef = OPEN_BRACKET + UniqueNameParser.escapeSquareBrackets((String)dataItemName) + CLOSE_BRACKET;
        if (isFact && this.isDimensional() && this.dimensions.isEmpty()) {
            return escapedRef;
        }
        return functionType + BLANK_SPACE + this.generateAgregationForExpression(aggType, escapedRef, nodeFactory);
    }

    private String generateAgregationForExpression(AggregateType aggType, String colId, XQENodeFactory nodeFactory) {
        String expression = "";
        if (!this.dimensions.isEmpty()) {
            if (this.isDimensional) {
                ArrayList<ColumnMetadata> hierarchies = new ArrayList<ColumnMetadata>();
                for (DataItem dim : this.dimensions) {
                    ColumnMetadata hierarchy;
                    ColumnMetadata columnMeta = this.getColumnMetadata(dim.getItemId());
                    if (columnMeta == null) continue;
                    boolean isMeasure = ColumnMetadata.SourceCategory.MEASURE.equals((Object)columnMeta.getSourceCategory());
                    ColumnMetadata columnMetadata = hierarchy = isMeasure ? columnMeta : columnMeta.getHierarchy();
                    if (hierarchies.contains(hierarchy)) continue;
                    hierarchies.add(hierarchy);
                    ColumnMetadata level = isMeasure ? columnMeta : TransformationUtils.getLowestProjectedLevel(hierarchy, this.dimensions, this.dataset);
                    String v5expression = null;
                    List actions = dim.getSelection();
                    if (actions != null && !actions.isEmpty()) {
                        V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(columnMeta, nodeFactory);
                        ActionFactory actionFactory = ActionFactory.getInstance();
                        for (Action action : actions) {
                            ActionContext actionContext = new ActionContext();
                            actionContext.add(BaseActionHandler.ParamName.EXPRESSION, v5expression);
                            actionContext.add(BaseActionHandler.ParamName.IDENTIFIER, identifier);
                            IActionHandler actionHandler = actionFactory.create(action, this, null);
                            v5expression = actionHandler.execute(actionContext, action, dim);
                        }
                    }
                    if (expression.length() > 0) {
                        expression = expression + SEPARATOR;
                    }
                    if (v5expression != null) {
                        expression = expression + BLANK_SPACE + v5expression;
                        continue;
                    }
                    expression = expression + BLANK_SPACE + level.getColumnId();
                }
                return SPACE_OPEN_PARENTHESIS_SPACE + colId + " within set" + expression + SPACE_CLOSE_PARENTHESIS;
            }
            boolean withinSet = false;
            for (DataItem dim : this.dimensions) {
                ColumnMetadata columnMeta = this.getColumnMetadata(dim.getItemId());
                String v5expression = null;
                List actions = dim.getSelection();
                if (actions != null && !actions.isEmpty()) {
                    V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(columnMeta, nodeFactory);
                    ActionFactory actionFactory = ActionFactory.getInstance();
                    for (Action action : actions) {
                        ActionContext actionContext = new ActionContext();
                        actionContext.add(BaseActionHandler.ParamName.EXPRESSION, v5expression);
                        actionContext.add(BaseActionHandler.ParamName.IDENTIFIER, identifier);
                        IActionHandler actionHandler = actionFactory.create(action, this, null);
                        v5expression = actionHandler.execute(actionContext, action, dim);
                    }
                }
                if (expression.length() > 0) {
                    expression = expression + SEPARATOR;
                }
                if (v5expression != null) {
                    expression = expression + BLANK_SPACE + v5expression;
                    withinSet = true;
                    continue;
                }
                expression = expression + BLANK_SPACE + columnMeta.getColumnId();
            }
            com.ibm.bi.qs.model.api.AggregateType convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
            if (withinSet) {
                expression = SPACE_OPEN_PARENTHESIS_SPACE + TransformationUtils.getV5SummaryFunction(convertedAggType) + SPACE_OPEN_PARENTHESIS_SPACE + colId + " ) within set" + expression + SPACE_CLOSE_PARENTHESIS;
            } else {
                String distinct = "";
                if (AggregateType.COUNTDISTINCT.equals((Object)aggType)) {
                    distinct = " distinct ";
                }
                expression = SPACE_OPEN_PARENTHESIS_SPACE + TransformationUtils.getV5SummaryFunction(convertedAggType) + SPACE_OPEN_PARENTHESIS_SPACE + distinct + colId + " for" + expression + " ) )";
            }
        } else {
            if (this.isDimensional) {
                return SPACE_OPEN_PARENTHESIS_SPACE + colId + SPACE_CLOSE_PARENTHESIS;
            }
            String distinct = "";
            if (AggregateType.COUNTDISTINCT.equals((Object)aggType)) {
                distinct = " distinct ";
            }
            com.ibm.bi.qs.model.api.AggregateType convertedAggType = com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString());
            expression = SPACE_OPEN_PARENTHESIS_SPACE + TransformationUtils.getV5SummaryFunction(convertedAggType) + SPACE_OPEN_PARENTHESIS_SPACE + distinct + colId + " ) )";
        }
        return expression;
    }

    private void buildV5Expression(V5Query v5Query, XQENodeFactory nodeFactory, String dataItemName, AggregateType aggType, String expression) {
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(expression);
        com.ibm.bi.qs.model.api.AggregateType convertedAggType = aggType != null ? com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString()) : null;
        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, convertedAggType, (IXQEQueryNode)v5Expression, nodeFactory);
    }

    public static boolean isDimensional(ColumnMetadata column) {
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        return sourceCategory != null && !sourceCategory.equals((Object)ColumnMetadata.SourceCategory.COLUMN) && !sourceCategory.equals((Object)ColumnMetadata.SourceCategory.CALCULATION);
    }

    static boolean isColumnAHierarchy(ColumnMetadata column) {
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        return sourceCategory != null && (sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD));
    }

    public static boolean isHierarchyFilterSelection(Action action) {
        if (action == null) {
            return false;
        }
        if (action.getIsNull() != null || action.getBetween() != null || action.getContainsignorecase() != null) {
            return true;
        }
        if (action.getSet() != null && !action.getSet().isEmpty() || action.getLt() != null || action.getLte() != null) {
            return true;
        }
        return action.getGt() != null || action.getGte() != null || action.getEq() != null;
    }

    @Override
    public void planExecution() {
        boolean hasSampling = this.querySpec.getSampling() != null;
        this.plannedQuery = this.planQuery(hasSampling, true);
    }

    @Override
    public String getExecutionPlan() {
        RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
        PlanningEnvironment planEnv = this.setupPlanningEnvironment(reqEnv);
        V5QuerySet querySet = this.generateV5QuerySet(planEnv, "BERNOULLI");
        return querySet.dumpToString();
    }

    public ColumnMetadata getColumnMetadata(String columnName) {
        ColumnMetadata metadata = this.columns.get(columnName);
        if (metadata == null && this.querySpec.getQueryHints() != null && "true".equals(this.querySpec.getQueryHints().getAdditionalProperties().get("promptValuesQuery"))) {
            return this.createDefaultMetadataObject(columnName);
        }
        if (metadata == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.MISSING_QUERY_COLUMN, columnName, this.dataset.getName());
        }
        return metadata;
    }

    private ColumnMetadata createDefaultMetadataObject(String columnName) {
        ColumnMetadata metadata = new ColumnMetadata();
        metadata.setColumnId(columnName);
        metadata.setColumnName(columnName);
        metadata.setDataType(ColumnMetadata.DataType.STRING);
        metadata.setCalculation(Boolean.valueOf(false));
        FieldOrdering ordering = new FieldOrdering();
        ordering.setNullPlacement(NullPlacement.FIRST);
        ordering.setOrder(com.ibm.bi.qs.model.api.SortOrder.ASC);
        metadata.setDefaultSort(new FieldOrdering());
        metadata.setSourceCategory(ColumnMetadata.SourceCategory.COLUMN);
        metadata.setType(ColumnMetadata.Type.ATTRIBUTE);
        return metadata;
    }

    public ProjectionType getDataItemProjectionType(String dataItemID) {
        for (DataItem di : this.querySpec.getDataItems()) {
            if (di.getId().compareTo(dataItemID) != 0) continue;
            return di.getAggregate() != null ? ProjectionType.METRIC : ProjectionType.CATEGORY;
        }
        throw new QueryServiceException(QueryServiceMessageKeys.MISSING_QUERY_DATAITEM, dataItemID, this.dataset.getName());
    }

    private void buildV5SortGroup(V5Query v5Query, V5ValueSet v5ValueSet, XQENodeFactory nodeFactory, V5GroupBody v5GroupBody) {
        if (this.querySpec.getType().equals((Object)QuerySpec.Type.MINMAX)) {
            return;
        }
        TreeMap<Integer, V5SortItem> sortItems = new TreeMap<Integer, V5SortItem>();
        Integer defaultPriority = 0;
        for (DataItem dataItem : this.querySpec.getDataItems()) {
            List nest = dataItem.getNest();
            if (nest != null && nest.size() > 0 || this.findNonProjTopBottomCountInFilter(dataItem.getId())) continue;
            for (Action action : dataItem.getSelection()) {
                Integer priority;
                ColumnMetadata column;
                FieldOrdering fieldOrder;
                List contexts;
                SortOrder order;
                Sort sort = action.getSort();
                if (sort == null || (order = sort.getType()) == SortOrder.NONE || order == SortOrder.HIERARCHIZE) continue;
                String sortByItem = dataItem.getId();
                if (action.getContext() != null && (contexts = action.getContext()).size() == 1) {
                    Context context = (Context)contexts.get(0);
                    String measureId = context.getItemId();
                    List columnList = this.dataset.getColumnMetadata();
                    ColumnMetadata refColumn = null;
                    for (ColumnMetadata col : columnList) {
                        if (!col.getColumnId().equals(measureId)) continue;
                        refColumn = col;
                        break;
                    }
                    if (refColumn == null) continue;
                    sortByItem = refColumn.getColumnId();
                    V5DataItem v5DataItem = v5Query.getDataItemByName(sortByItem);
                    if (v5DataItem == null) {
                        com.ibm.bi.qs.model.api.AggregateType convertedAggType = null;
                        if (!QuerySpec.Type.DETAIL.equals((Object)this.querySpec.getType())) {
                            AggregateType ctxAggType = context.getAggregate();
                            convertedAggType = ctxAggType != null ? com.ibm.bi.qs.model.api.AggregateType.fromValue((String)ctxAggType.toString()) : refColumn.getDefaultAggregation();
                        }
                        TopBottom topBottom = TransformationUtils.getTopBottomBeforeGiven(action, dataItem);
                        ColumnMetadata metadata = this.getColumnMetadata(dataItem.getItemId());
                        V5MultiPartIdentifier expression = null;
                        if (null != topBottom && this.getDataItemProjectionType(dataItem.getId()) != ProjectionType.METRIC && metadata.getType() != ColumnMetadata.Type.FACT && (null != this.getSecondaryQuery() || BaseActionHandler.useNewRelationalTopBottomCount(topBottom.getType(), this))) {
                            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
                            if (this.needBaseQuery) {
                                DataItem sortDataItem = DataExecutor.findDataItemByItemId(this.querySpec.getDataItems(), sortByItem);
                                sortByItem = sortDataItem != null ? sortDataItem.getId() : BaseActionHandler.generateItemNameReference(sortByItem, convertedAggType);
                            }
                            String aggregateExpr = ACTION_CONTEXT_AGGREGATE_FORMAT;
                            StringBuilder sb = new StringBuilder(OPEN_BRACKET);
                            sb = sb.append(dataItem.getId()).append(CLOSE_BRACKET);
                            v5Expression.setExpression(String.format(aggregateExpr, sortByItem, sb.toString()));
                            expression = v5Expression;
                            sortByItem = refColumn.getColumnName() + QS_ACTION_CONTEXT_AGGREGATE;
                            if (this.useSecondaryForNonContextualTopBottomCount()) {
                                V5Source v5Source = (V5Source)v5Query.getFirstChildByType(101007);
                                String refQuery = v5Source.getQueryRef();
                                if (refQuery == null) {
                                    throw new IllegalStateException("refQuery == null");
                                }
                                V5QuerySet v5QuerySet = (V5QuerySet)v5Query.getParent();
                                V5Query topBottomQuery = v5QuerySet.getV5Query(refQuery);
                                if (topBottomQuery == null) {
                                    throw new IllegalStateException("topBottomQuery == null");
                                }
                                TransformationUtils.buildDataItem((IXQEQueryNode)topBottomQuery, sortByItem, convertedAggType, (IXQEQueryNode)expression, nodeFactory);
                                V5Expression newV5Expression = (V5Expression)nodeFactory.createNode(101004);
                                String sortByItemRef = BaseActionHandler.createInterQueryRefName(topBottomQuery, sortByItem);
                                newV5Expression.setExpression(sortByItemRef);
                                TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, sortByItem, convertedAggType, (IXQEQueryNode)newV5Expression, nodeFactory);
                            } else {
                                TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, sortByItem, convertedAggType, (IXQEQueryNode)expression, nodeFactory);
                            }
                            this.buildDataItemForSecondaryQuery(nodeFactory, sortByItem);
                        } else {
                            expression = TransformationUtils.createMultiPartIdentifier(refColumn, nodeFactory);
                            TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, sortByItem, convertedAggType, (IXQEQueryNode)expression, nodeFactory);
                            this.buildV5DataItemRef(v5GroupBody, nodeFactory, sortByItem);
                        }
                    }
                }
                V5SortItem sortItem = (V5SortItem)nodeFactory.createNode(101056);
                String orderString = order == SortOrder.ASC ? "ascending" : "descending";
                sortItem.setStringPropertyValue("sortOrder", orderString);
                if (dataItem.getBinning() != null && dataItem.getBinning().getAuto() != null) {
                    String strNumericBinName;
                    String binnedDataItemName = dataItem.getId();
                    sortByItem = strNumericBinName = DataExecutor.buildNumericBinName(binnedDataItemName);
                }
                sortItem.setStringPropertyValue("refDataItem", sortByItem);
                NullPlacement placement = this.getNullPlacement(dataItem);
                if (placement != null) {
                    sortItem.setStringPropertyValue("nullPlace", placement == NullPlacement.FIRST ? "first" : "last");
                }
                if (this.multiEdgeSort && (fieldOrder = (column = this.getColumnMetadata(dataItem.getItemId())).getDefaultSort()) != null && fieldOrder.getReferencedIdentifier() != null) {
                    String deflectedColumn = fieldOrder.getReferencedIdentifier();
                    List columnList = this.dataset.getColumnMetadata();
                    ColumnMetadata refColumn = null;
                    for (ColumnMetadata col : columnList) {
                        if (!col.getColumnName().equals(deflectedColumn)) continue;
                        refColumn = col;
                        break;
                    }
                    if (refColumn != null) {
                        String deflectedSortItemName = TransformationUtils.getDeflectedDataItemName(deflectedColumn);
                        V5MultiPartIdentifier identifier = TransformationUtils.createMultiPartIdentifier(refColumn, nodeFactory);
                        com.ibm.bi.qs.model.api.AggregateType aggrTypeMin = com.ibm.bi.qs.model.api.AggregateType.MIN;
                        TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, deflectedSortItemName, aggrTypeMin, (IXQEQueryNode)identifier, nodeFactory);
                        this.buildV5DataItemRef(v5GroupBody, nodeFactory, deflectedSortItemName);
                    }
                }
                if ((priority = sort.getPriority()) == null) {
                    priority = defaultPriority;
                    Integer n = defaultPriority;
                    defaultPriority = defaultPriority + 1;
                    Integer n2 = defaultPriority;
                }
                if (sortItems.get(priority) != null) {
                    // empty if block
                }
                sortItems.put(priority, sortItem);
            }
        }
        for (Map.Entry entry : sortItems.entrySet()) {
            if (!this.isProjected(((V5SortItem)entry.getValue()).getRefDataItem())) {
                this.appendNonProjDataItemToQuery(nodeFactory, ((V5SortItem)entry.getValue()).getRefDataItem(), v5Query);
            }
            v5ValueSet.addChild((IXQEQueryNode)entry.getValue());
        }
    }

    public boolean findNonProjTopBottomCountInFilter(String dataItemId) {
        boolean skip = false;
        if (this.getTopBottomCountQueries() != null && !this.getTopBottomCountQueries().isEmpty() && this.getNonProjTopBottomCountInFilterDIs() != null && !this.getNonProjTopBottomCountInFilterDIs().isEmpty()) {
            for (DataItem currDataItem : this.getNonProjTopBottomCountInFilterDIs()) {
                if (!currDataItem.getId().equals(dataItemId)) continue;
                skip = true;
                break;
            }
        }
        return skip;
    }

    private boolean isProjected(String projection) {
        V5Query v5Query = this.needSecondaryQuery ? this.secondaryQuery : this.primaryQuery;
        return v5Query.getDataItemByName(projection) != null;
    }

    public static DataItem findDataItemByItemId(List<DataItem> dataItems, String aItemId) {
        if (null == aItemId || aItemId.isEmpty()) {
            return null;
        }
        for (DataItem dataItem : dataItems) {
            if (dataItem.getItemId() == null || !dataItem.getItemId().equals(aItemId)) continue;
            return dataItem;
        }
        return null;
    }

    public static String buildNumericBinName(String binnedDataItemName) {
        StringBuilder numericBinName = new StringBuilder(binnedDataItemName).append(NUM_BINS);
        String strNumericBinName = numericBinName.toString().replaceAll("\\s", "");
        return strNumericBinName;
    }

    private NullPlacement getNullPlacement(DataItem field) {
        NullPlacement placement = null;
        ColumnMetadata column = this.getColumnMetadata(field.getItemId());
        FieldOrdering fieldOrder = column.getDefaultSort();
        if (fieldOrder != null) {
            placement = fieldOrder.getNullPlacement();
        }
        return placement;
    }

    public V5Query getBaseQuery() {
        return this.baseQuery;
    }

    public V5Query getPrimaryQuery() {
        return this.primaryQuery;
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public V5Query getSecondaryQuery() {
        return this.secondaryQuery;
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    public boolean isDimensional() {
        return this.isDimensional;
    }

    private void isValidQuerySpec() {
        ArrayList<String> projections = new ArrayList<String>();
        for (String projection : DataExecutor.getProjections(this.querySpec)) {
            if (projections.indexOf(projection) == -1) {
                projections.add(projection);
                continue;
            }
            throw new QueryServiceException(QueryServiceMessageKeys.PLN_DUPLICATED_PROJECTION, projection);
        }
        ArrayList<String> dataItems = new ArrayList<String>();
        for (DataItem dataItem : this.querySpec.getDataItems()) {
            if (dataItems.indexOf(dataItem.getId()) == -1) {
                dataItems.add(dataItem.getId());
                continue;
            }
            throw new QueryServiceException(QueryServiceMessageKeys.PLN_DUPLICATED_DATAITEM, dataItem.getId());
        }
    }

    @Override
    protected Date getLastModifiedFromQueryPlan() {
        if (this.plannedQuery != null && this.plannedQuery instanceof PlannedV5QuerySet) {
            return ((PlannedV5QuerySet)this.plannedQuery).getLastModified();
        }
        return null;
    }

    public boolean queryIncludesAutoBinningDataItems() {
        return this.queryIncludesAutoBinningDataItems;
    }

    public boolean queryIncludesTopBottomPercentDataItems() {
        return this.queryIncludesTopBottomPercentDataItems;
    }

    public void setQueryIncludesTopBottomPercentDataItems(boolean value) {
        this.queryIncludesTopBottomPercentDataItems = value;
    }

    @Override
    public DataSet getDataSet() {
        return this.dataset;
    }

    public static List<String> getProjections(QuerySpec aQuerySpec) {
        if (Double.valueOf(aQuerySpec.getVersion()) < CURRENT_VERSION) {
            return aQuerySpec.getProjections();
        }
        return Collections.emptyList();
    }

    public static void setProjections(QuerySpec aQuerySpec, List<String> projections) {
        if (Double.valueOf(aQuerySpec.getVersion()) < CURRENT_VERSION) {
            aQuerySpec.setProjections(projections);
        }
    }

    private List<SuppressionType> getSuppress(QuerySpec aQuerySpec) {
        if (Double.valueOf(aQuerySpec.getVersion()) < CURRENT_VERSION) {
            return aQuerySpec.getSuppress();
        }
        return Collections.emptyList();
    }

    public int getNextSubQueryId() {
        return ++this.subQueryId;
    }

    public List<V5Query> getTopBottomCountQueries() {
        return this.topBottomCountQueries;
    }

    public void addTopBottomQuery(V5Query aQuery) {
        if (aQuery == null) {
            return;
        }
        if (this.topBottomCountQueries == null) {
            this.topBottomCountQueries = new ArrayList<V5Query>();
        }
        this.topBottomCountQueries.add(aQuery);
    }

    public List<DataItem> getNonProjTopBottomCountInFilterDIs() {
        return this.nonProjTopBottomCountInFilterDIs;
    }

    public void addNonProjTopBottomCountInFilterDIs(DataItem aDataItem) {
        if (aDataItem == null) {
            return;
        }
        if (this.nonProjTopBottomCountInFilterDIs == null) {
            this.nonProjTopBottomCountInFilterDIs = new ArrayList<DataItem>();
        }
        this.nonProjTopBottomCountInFilterDIs.add(aDataItem);
    }

    public boolean isDMRTriggeredForRelational() {
        return this.isDMRTriggeredForRelational;
    }

    public boolean hasNonContextualTopBottomCount() {
        return this.hasNonContextualTopBottomCount;
    }

    public void setHasNonContextualTopBottomCount(boolean value) {
        this.hasNonContextualTopBottomCount = value;
    }

    public boolean useSecondaryForNonContextualTopBottomCount() {
        return this.useSecondaryForNonContextualTopBottomCount;
    }

    public void setUseSecondaryForNonContextualTopBottomCount(boolean value) {
        this.useSecondaryForNonContextualTopBottomCount = value;
    }

    public static enum ZeroSuppressionState {
        NoSuppression,
        AllSuppression,
        SomeSuppression;

    }

    public static enum NullSuppressionState {
        NoSuppression,
        AllSuppression,
        SomeSuppression;

    }

    public static enum ProjectionType {
        CATEGORY,
        METRIC;

    }
}

