/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5FilterExpression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BetweenExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5CaptionFunction;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5ContainsExpression;
import com.cognos.xqe.ast.v5Exp.V5InRangeExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.common.generated.AndFilter;
import com.ibm.bi.qs.model.api.data.common.generated.DataFilter;
import com.ibm.bi.qs.model.api.data.common.generated.Filter;
import com.ibm.bi.qs.model.api.data.common.generated.FilterExpression;
import com.ibm.bi.qs.model.api.data.common.generated.FilterOperator;
import com.ibm.bi.qs.model.api.data.common.generated.NotFilter;
import com.ibm.bi.qs.model.api.data.common.generated.OrFilter;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.model.api.data.queryspec.generated.AggregateType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.xqe.v5.DataExecutor;
import com.ibm.bi.qs.xqe.v5.TransformationUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FilterGenerator {
    public static final String PROP_IS_FOR_BINS = "isForBins";
    private static final String PROP_IDENTIFIER = "identifier";
    public static final int MAX_UNSIGNED_16BIT_INTEGER = 65535;

    public static V5DetailFilter generateFilter(XQENodeFactory nodeFactory, V5Query v5Query, DataSet dataset, List<DataItem> dataItems, Filter filter, Locale locale) {
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setUseProperty("required");
        V5FilterExpression filterExpression = (V5FilterExpression)nodeFactory.createNode(101013);
        detailFilter.addChild((IXQEQueryNode)filterExpression);
        boolean postAA = filter.getType().equals((Object)Filter.Type.POST);
        IXQEQueryNode expression = FilterGenerator.getExpression(nodeFactory, v5Query, dataset, dataItems, filter.getExpression(), postAA, locale);
        if (FilterGenerator.isForBins(expression)) {
            expression.removeProperty(PROP_IS_FOR_BINS);
            FilterGenerator.setForBins((IXQEQueryNode)detailFilter);
        }
        filterExpression.addChild(expression);
        detailFilter.setPostAutoAggregation(postAA);
        return detailFilter;
    }

    public static V5DetailFilter generateFilter(DataExecutor datExecutor, XQENodeFactory nodeFactory, V5Query v5Query, Filter filter, Locale locale) {
        IXQEQueryNode[] boundDataItemRefs;
        DataSet dataset = datExecutor.getDataset();
        List dataItems = datExecutor.getQuerySpec().getDataItems();
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setUseProperty("required");
        V5FilterExpression filterExpression = (V5FilterExpression)nodeFactory.createNode(101013);
        detailFilter.addChild((IXQEQueryNode)filterExpression);
        boolean postAA = filter.getType().equals((Object)Filter.Type.POST);
        IXQEQueryNode expression = FilterGenerator.getExpression(nodeFactory, v5Query, dataset, dataItems, filter.getExpression(), postAA, locale);
        if (FilterGenerator.isForBins(expression)) {
            expression.removeProperty(PROP_IS_FOR_BINS);
            FilterGenerator.setForBins((IXQEQueryNode)detailFilter);
        }
        if (expression instanceof AbstractV5BooleanExpression) {
            filterExpression.setExpression(((AbstractV5BooleanExpression)expression).getOriginalExpression());
        } else {
            filterExpression.addChild(expression);
        }
        if (!postAA && datExecutor.getTopBottomCountQueries() != null && !datExecutor.getTopBottomCountQueries().isEmpty() && (boundDataItemRefs = expression.getDescendantsOfType(201060, false)) != null && boundDataItemRefs.length > 0) {
            for (IXQEQueryNode boundDataItemRef : boundDataItemRefs) {
                V5DataItem filteredDataItem = ((V5BoundDataItemReference)boundDataItemRef).getRefDataItem();
                String diName = filteredDataItem.getNameProperty();
                if (datExecutor.findNonProjTopBottomCountInFilter(diName)) continue;
                for (V5Query topbottomQuery : datExecutor.getTopBottomCountQueries()) {
                    V5DataItem currDataItem = topbottomQuery.getDataItemByName(diName);
                    if (currDataItem != null) continue;
                    currDataItem = (V5DataItem)nodeFactory.deepCopyNode((IXQEQueryNode)filteredDataItem);
                    topbottomQuery.getV5Selection().addChild((IXQEQueryNode)currDataItem);
                }
            }
        }
        detailFilter.setPostAutoAggregation(postAA);
        return detailFilter;
    }

    public static boolean isForBins(IXQEQueryNode node) {
        return node.getPropertyValue(PROP_IS_FOR_BINS) == Boolean.TRUE;
    }

    public static ColumnMetadata findMetadata(DataSet dataset, String dataItemId) {
        ColumnMetadata metadata = null;
        List columnList = dataset.getColumnMetadata();
        for (ColumnMetadata col : columnList) {
            if (!col.getColumnId().equals(dataItemId)) continue;
            metadata = col;
            break;
        }
        return metadata;
    }

    public static DataItem findDataItem(List<DataItem> dataItems, String dataItemId) {
        for (DataItem dataItem : dataItems) {
            if (!dataItem.getId().equals(dataItemId)) continue;
            return dataItem;
        }
        return null;
    }

    public static DataItem findDataItemByItemId(List<DataItem> dataItems, String aItemId) {
        if (null == aItemId || aItemId.isEmpty()) {
            return null;
        }
        for (DataItem dataItem : dataItems) {
            if (dataItem.getItemId() == null || !dataItem.getItemId().equals(aItemId) || !FilterGenerator.isDataItemUsableForFilter(dataItem)) continue;
            return dataItem;
        }
        return null;
    }

    private static boolean isDataItemUsableForFilter(DataItem dataItem) {
        if (dataItem.getBinning() != null || dataItem.getCalculation() != null || dataItem.getAggregate() != null) {
            return false;
        }
        if (dataItem.getNest() != null && !dataItem.getNest().isEmpty()) {
            return false;
        }
        if (dataItem.getSelection() == null || dataItem.getSelection().isEmpty()) {
            return true;
        }
        return dataItem.getSelection().size() == 1 && ((Action)dataItem.getSelection().get(0)).getSort() != null;
    }

    private static IXQEQueryNode createAndOrExpression(XQENodeFactory nodeFactory, V5Query v5Query, DataSet dataset, List<DataItem> dataItems, boolean postAA, List<FilterExpression> andOrFields, int subTypeAndOr, Locale locale) {
        IXQEQueryNode root = null;
        for (int k = andOrFields.size() - 1; k >= 0; --k) {
            FilterExpression filter = andOrFields.get(k);
            IXQEQueryNode expression = FilterGenerator.getExpression(nodeFactory, v5Query, dataset, dataItems, filter, postAA, locale);
            if (andOrFields.size() == 1) {
                return expression;
            }
            if (root == null) {
                root = expression;
                continue;
            }
            V5LogicalExpression v5AndOr = (V5LogicalExpression)nodeFactory.createNode(201003);
            v5AndOr.setSubType(subTypeAndOr);
            v5AndOr.addChild(expression);
            if (FilterGenerator.isForBins(expression)) {
                expression.removeProperty(PROP_IS_FOR_BINS);
                FilterGenerator.setForBins((IXQEQueryNode)v5AndOr);
            }
            v5AndOr.addChild(root);
            if (FilterGenerator.isForBins(root)) {
                root.removeProperty(PROP_IS_FOR_BINS);
                FilterGenerator.setForBins((IXQEQueryNode)v5AndOr);
            }
            root = v5AndOr;
        }
        return root;
    }

    private static IXQEQueryNode createNotBetweenExpression(XQENodeFactory nodeFactory, DataFilter filter, boolean postAA, IXQEQueryNode identifier, ColumnMetadata column) {
        DataFilter ltFilter = new DataFilter();
        ArrayList ltValue = new ArrayList();
        ltValue.add(filter.getValues().get(0));
        ltFilter.setValues(ltValue);
        DataFilter gtFilter = new DataFilter();
        ArrayList gtValue = new ArrayList();
        gtValue.add(filter.getValues().get(1));
        gtFilter.setValues(gtValue);
        IXQEQueryNode lt = FilterGenerator.createComparisonExpression(nodeFactory, ltFilter, postAA, identifier, 0, column);
        IXQEQueryNode gt = FilterGenerator.createComparisonExpression(nodeFactory, gtFilter, postAA, nodeFactory.deepCopyNode(identifier), 5, column);
        V5LogicalExpression v5AndOr = (V5LogicalExpression)nodeFactory.createNode(201003);
        v5AndOr.setSubType(1);
        v5AndOr.addChild(lt);
        v5AndOr.addChild(gt);
        return v5AndOr;
    }

    private static IXQEQueryNode createBetweenExpression(XQENodeFactory nodeFactory, DataFilter filter, boolean postAA, IXQEQueryNode identifier, ColumnMetadata column) {
        V5BetweenExpression between = null;
        if (column != null && !TransformationUtils.isMemberSet(column) && column.getXQEDataType() != null && "timestamp".equals(column.getXQEDataType().getTypeName())) {
            between = (V5InRangeExpression)nodeFactory.createNode(201012);
            between.setNativeName("in_range");
            between.addChild(identifier);
        } else {
            between = (V5BetweenExpression)nodeFactory.createNode(201008);
            if (TransformationUtils.isMemberSet(column)) {
                V5CaptionFunction captionFunction = (V5CaptionFunction)nodeFactory.createNode(201050);
                captionFunction.addChild(identifier);
                between.addChild((IXQEQueryNode)captionFunction);
            } else {
                between.addChild(identifier);
            }
            between.setNativeName("between");
        }
        IXQEQueryNode startLiteral = FilterGenerator.createValue(nodeFactory, postAA, column, (String)filter.getValues().get(0), filter, false);
        IXQEQueryNode endLiteral = FilterGenerator.createValue(nodeFactory, postAA, column, (String)filter.getValues().get(1), filter, false);
        between.addChild(startLiteral);
        between.addChild(endLiteral);
        return between;
    }

    private static IXQEQueryNode createInExpression(XQENodeFactory nodeFactory, V5Query v5Query, DataSet dataset, List<DataItem> dataItems, DataFilter filter, boolean postAA, IXQEQueryNode identifier, ColumnMetadata column, boolean isNot, Locale locale) {
        IXQEQueryNode inExpr = nodeFactory.createNode(201011);
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        if (ColumnMetadata.SourceCategory.NAMED_SET == sourceCategory) {
            if (filter.getValues().size() == 1 && ((String)filter.getValues().get(0)).equals(column.getColumnId())) {
                return FilterGenerator.createFilterHierarchyInNamedSet(nodeFactory, dataset, identifier, column, isNot, inExpr);
            }
            if (null != filter.getValueDataItem()) {
                String dataItemValue = filter.getValueDataItem();
                if (dataItemValue.equals(column.getColumnId())) {
                    return FilterGenerator.createFilterHierarchyInNamedSet(nodeFactory, dataset, identifier, column, isNot, inExpr);
                }
                DataItem dataItem = FilterGenerator.findDataItem(dataItems, dataItemValue);
                ColumnMetadata dataItemValueColumn = FilterGenerator.findMetadata(dataset, dataItem.getItemId());
                ColumnMetadata.SourceCategory dataItemValuesourceCategory = dataItemValueColumn.getSourceCategory();
                if (ColumnMetadata.SourceCategory.NAMED_SET == dataItemValuesourceCategory && dataItemValueColumn.getColumnId().equals(column.getColumnId())) {
                    return FilterGenerator.createFilterHierarchyInNamedSet(nodeFactory, dataset, identifier, column, isNot, inExpr);
                }
            }
        }
        boolean ignoreCase = filter.getIgnoreCase();
        boolean isNumeric = FilterGenerator.isNumeric(column.getDataType());
        if (ignoreCase && !isNumeric) {
            V5StringFunction lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
            lowerFn.setSubType(1);
            if (DataFilter.ValueType.DISPLAY == filter.getValueType() && TransformationUtils.isMemberSet(column)) {
                V5CaptionFunction captionFn = (V5CaptionFunction)nodeFactory.createNode(201050);
                captionFn.addChild(identifier);
                lowerFn.addChild((IXQEQueryNode)captionFn);
            } else {
                lowerFn.addChild(identifier);
            }
            inExpr.addChild((IXQEQueryNode)lowerFn);
        } else if (!isNumeric && DataFilter.ValueType.DISPLAY == filter.getValueType() && TransformationUtils.isMemberSet(column)) {
            V5CaptionFunction captionFn = (V5CaptionFunction)nodeFactory.createNode(201050);
            captionFn.addChild(identifier);
            inExpr.addChild((IXQEQueryNode)captionFn);
        } else {
            inExpr.addChild(identifier);
        }
        if (filter.getValues().isEmpty() && filter.getValueDataItem() != null) {
            String dataItemId = filter.getValueDataItem();
            DataItem dataItem = FilterGenerator.findDataItem(dataItems, dataItemId);
            if (dataItem == null) {
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Unable to find data item id: " + dataItemId);
            }
            AggregateType aggType = dataItem.getAggregate();
            ColumnMetadata column1 = FilterGenerator.findMetadata(dataset, dataItem.getItemId());
            ColumnMetadata.SourceCategory sourceCategory1 = column1.getSourceCategory();
            V5BoundDataItemReference multiPartIdentifier = null;
            String dataItemName = null;
            if (sourceCategory1 != null && sourceCategory1.equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && filter.getValueType() != DataFilter.ValueType.DISPLAY) {
                String columnId = column1.getParentColumn().getColumnId();
                column1 = FilterGenerator.findMetadata(dataset, columnId);
                dataItemName = column1.getColumnId();
                dataItemName = aggType != null ? dataItemName + "_" + aggType.toString() : dataItemName;
                multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(column1, nodeFactory);
            } else {
                dataItemName = dataItemId;
                multiPartIdentifier = TransformationUtils.createBoundDataItemReference(v5Query, dataItemId, nodeFactory, false);
            }
            inExpr.addChild((IXQEQueryNode)multiPartIdentifier);
        } else {
            boolean columnValue = false;
            if (filter.getValues().size() == 1) {
                String firstValue = (String)filter.getValues().get(0);
                ColumnMetadata column2 = FilterGenerator.findMetadata(dataset, firstValue);
                boolean bl = columnValue = column2 != null;
                if (columnValue) {
                    V5MultiPartIdentifier multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(column2, nodeFactory);
                    inExpr.addChild((IXQEQueryNode)multiPartIdentifier);
                }
            }
            if (!columnValue) {
                for (String value : filter.getValues()) {
                    boolean isBinned = FilterGenerator.isFilterOnBinned(dataItems, filter, identifier);
                    IXQEQueryNode literal = FilterGenerator.createValue(nodeFactory, postAA, column, value, filter, false, locale, isBinned);
                    if (ignoreCase && !isNumeric) {
                        V5StringFunction lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
                        lowerFn.setSubType(1);
                        lowerFn.addChild(literal);
                        inExpr.addChild((IXQEQueryNode)lowerFn);
                        continue;
                    }
                    inExpr.addChild(literal);
                }
            }
        }
        if (isNot) {
            V5LogicalExpression not = (V5LogicalExpression)nodeFactory.createNode(201003);
            not.setSubType(2);
            not.addChild(inExpr);
            return not;
        }
        return inExpr;
    }

    public static boolean isFilterOnBinned(List<DataItem> dataItems, DataFilter filter, IXQEQueryNode identifier) {
        String dataItemName;
        String[] nameParts;
        boolean isBinned = false;
        if (identifier != null && identifier.getPropertyValue(PROP_IDENTIFIER) != null && (nameParts = UniqueNameParser.parseNoThrow((String)(dataItemName = (String)identifier.getPropertyValue(PROP_IDENTIFIER)))) != null && nameParts.length == 1) {
            DataItem dataItem = FilterGenerator.findDataItem(dataItems, nameParts[0]);
            boolean bl = isBinned = dataItem != null && dataItem.getBinning() != null;
            if (isBinned) {
                FilterGenerator.setForBins(identifier);
            }
        }
        return isBinned;
    }

    public static void setForBins(IXQEQueryNode node) {
        node.setPropertyValue(PROP_IS_FOR_BINS, (Object)Boolean.TRUE);
    }

    private static IXQEQueryNode createFilterHierarchyInNamedSet(XQENodeFactory nodeFactory, DataSet dataset, IXQEQueryNode identifier, ColumnMetadata column, boolean isNot, IXQEQueryNode inExpr) {
        ColumnMetadata hierColumn = column.getHierarchy();
        V5MultiPartIdentifier hierarchyMultiPartIdentifier = TransformationUtils.createMultiPartIdentifier(hierColumn, nodeFactory);
        inExpr.addChild((IXQEQueryNode)hierarchyMultiPartIdentifier);
        inExpr.addChild(identifier);
        if (isNot) {
            V5LogicalExpression not = (V5LogicalExpression)nodeFactory.createNode(201003);
            not.setSubType(2);
            not.addChild(inExpr);
            return not;
        }
        return inExpr;
    }

    private static IXQEQueryNode createIsNullExpression(XQENodeFactory nodeFactory, IXQEQueryNode identifier, boolean isNot) {
        IXQEQueryNode isNullExpr = nodeFactory.createNode(201010);
        isNullExpr.addChild(identifier);
        if (isNot) {
            V5LogicalExpression not = (V5LogicalExpression)nodeFactory.createNode(201003);
            not.setSubType(2);
            not.addChild(isNullExpr);
            return not;
        }
        return isNullExpr;
    }

    private static IXQEQueryNode createComparisonExpression(XQENodeFactory nodeFactory, DataFilter filter, boolean postAA, IXQEQueryNode identifier, int subType, ColumnMetadata column) {
        V5ComparisonExpression compExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
        compExpr.addChild(identifier);
        if (TransformationUtils.isMemberSet(column)) {
            IXQEQueryNode caption = nodeFactory.createNode(201050);
            identifier.insertParent(caption);
        }
        compExpr.setSubType(subType);
        IXQEQueryNode literal = FilterGenerator.createValue(nodeFactory, postAA, column, (String)filter.getValues().get(0), filter, true);
        compExpr.addChild(literal);
        return compExpr;
    }

    private static IXQEQueryNode createBeginEndExpression(XQENodeFactory nodeFactory, DataFilter filter, boolean postAA, IXQEQueryNode identifier, int type, ColumnMetadata column) {
        IXQEQueryNode compExpr = nodeFactory.createNode(type);
        boolean ignoreCase = filter.getIgnoreCase();
        if (ignoreCase) {
            V5StringFunction lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
            lowerFn.setSubType(1);
            lowerFn.addChild(identifier);
            compExpr.addChild((IXQEQueryNode)lowerFn);
        } else {
            compExpr.addChild(identifier);
        }
        if (TransformationUtils.isMemberSet(column)) {
            IXQEQueryNode caption = nodeFactory.createNode(201050);
            identifier.insertParent(caption);
        }
        IXQEQueryNode literal = FilterGenerator.createValue(nodeFactory, postAA, column, (String)filter.getValues().get(0), filter, true);
        if (ignoreCase) {
            V5StringFunction lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
            lowerFn.setSubType(1);
            lowerFn.addChild(literal);
            compExpr.addChild((IXQEQueryNode)lowerFn);
        } else {
            compExpr.addChild(literal);
        }
        return compExpr;
    }

    private static IXQEQueryNode createContainsExpression(XQENodeFactory nodeFactory, DataFilter filter, boolean postAA, IXQEQueryNode identifier, ColumnMetadata column, boolean caseSensitive) {
        V5StringFunction lowerFn;
        IDataType xqeDataType;
        boolean ignoreCase;
        V5ContainsExpression containsExpr = (V5ContainsExpression)nodeFactory.createNode(201005);
        IXQEQueryNode operand = identifier;
        boolean columnIsNumericType = false;
        IXQEQueryNode literal = null;
        boolean bl = ignoreCase = !caseSensitive || filter.getIgnoreCase() != false;
        if (TransformationUtils.isMemberSet(column)) {
            operand = nodeFactory.createNode(201050);
            operand.addChild(identifier);
        } else if (column != null && (xqeDataType = column.getXQEDataType()) != null && !xqeDataType.isTextType()) {
            operand = FilterGenerator.castColumnToVarcharType(nodeFactory, identifier, xqeDataType);
            literal = nodeFactory.createNode(201026);
            ((V5LiteralValue)literal).setDataType((IDataType)DataTypeFactory.getVarcharType((int)((String)filter.getValues().get(0)).length()));
            ((V5LiteralValue)literal).setValue((String)filter.getValues().get(0));
            if (xqeDataType.isNumeric()) {
                columnIsNumericType = true;
            }
        }
        if (!ignoreCase || columnIsNumericType) {
            containsExpr.addChild(operand);
        } else {
            lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
            lowerFn.setSubType(1);
            lowerFn.addChild(operand);
            containsExpr.addChild((IXQEQueryNode)lowerFn);
        }
        if (literal == null) {
            literal = FilterGenerator.createValue(nodeFactory, postAA, column, (String)filter.getValues().get(0), filter, true);
        }
        if (!ignoreCase || columnIsNumericType) {
            containsExpr.addChild(literal);
        } else {
            lowerFn = (V5StringFunction)nodeFactory.createNode(201041);
            lowerFn.setSubType(1);
            containsExpr.addChild((IXQEQueryNode)lowerFn);
            lowerFn.addChild(literal);
        }
        return containsExpr;
    }

    private static IXQEQueryNode castColumnToVarcharType(XQENodeFactory nodeFactory, IXQEQueryNode identifier, IDataType xqeDataType) {
        int varCharLength = 65535;
        if (xqeDataType.hasPrecision()) {
            varCharLength = xqeDataType.getPrecision();
            if (xqeDataType.hasScale()) {
                varCharLength += xqeDataType.getScale();
            }
        } else if (xqeDataType.getLength() > 0) {
            varCharLength = xqeDataType.getLength();
        }
        V5CastFunction castFunction = (V5CastFunction)nodeFactory.createNode(201051);
        castFunction.addChild(identifier);
        V5CastTarget castTarget = (V5CastTarget)nodeFactory.createNode(201052);
        castTarget.setDataType((IDataType)DataTypeFactory.getVarcharType((int)varCharLength));
        castTarget.setPropertyValue("length", (Object)varCharLength);
        castFunction.addChild((IXQEQueryNode)castTarget);
        return castFunction;
    }

    private static IXQEQueryNode createValue(XQENodeFactory nodeFactory, boolean postAA, ColumnMetadata column, String value, DataFilter filter, boolean isString) {
        return FilterGenerator.createValue(nodeFactory, postAA, column, value, filter, isString, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static IXQEQueryNode createValue(XQENodeFactory nodeFactory, boolean postAA, ColumnMetadata column, String value, DataFilter filter, boolean isString, Locale locale, boolean isBinned) {
        V5MemberUniqueName v5MemberUniqueName;
        boolean useFUN;
        boolean bl = useFUN = column != null && column.isFacetEnabled() && filter.getValueType() != DataFilter.ValueType.DISPLAY;
        if (!isString && useFUN && (v5MemberUniqueName = TransformationUtils.createV5MemberUniqueNameForFUN(nodeFactory, value, locale)) != null) {
            return v5MemberUniqueName;
        }
        if (!isString && DataFilter.ValueType.DISPLAY != filter.getValueType() && TransformationUtils.isMemberSet(column)) {
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(value);
            return v5Expression;
        }
        V5LiteralValue literal = (V5LiteralValue)nodeFactory.createNode(201026);
        if (column == null || filter.getAdditionalProperties().get("appliedOnSummary") != null || postAA) {
            if (column != null && (column.getXQEDataType() != null && column.getXQEDataType().isTextType() || column.getDataType() != null && ColumnMetadata.DataType.STRING == column.getDataType())) {
                literal.setDataType((IDataType)DataTypeFactory.getVarcharType((int)value.length()));
            } else {
                if (!isBinned) {
                    V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
                    v5Expression.setExpression(value);
                    return v5Expression;
                }
                literal.setDataType((IDataType)DataTypeFactory.getStringType());
            }
        } else if (column.getXQEDataType() != null && column.getXQEDataType().isTextType() || column.getDataType() != null && ColumnMetadata.DataType.STRING == column.getDataType()) {
            literal.setDataType((IDataType)DataTypeFactory.getVarcharType((int)value.length()));
        } else if (isBinned) {
            literal.setDataType((IDataType)DataTypeFactory.getStringType());
        } else if (column.getXQEDataType().isNumeric()) {
            if (value != null) {
                literal.setDataType(FilterGenerator.getNumericDataType(value));
            } else {
                literal.setDataType(column.getXQEDataType());
            }
        } else {
            literal.setDataType(column.getXQEDataType());
        }
        Value v = (Value)literal.getDataType().createValue();
        v.set(value);
        if ("double".equals(literal.getDataType().getTypeName()) && Double.isInfinite(v.getDouble())) {
            DecimalType type = new DecimalType(Integer.MAX_VALUE, 2);
            v = DataValueFactory.createDecimalValue((DecimalType)type);
            ((BigDecimalValue)v).set(new BigDecimal(value));
        }
        literal.setPropertyValue("value", (Object)v);
        if (!v.isOK()) {
            literal.setNativeName(v.getState().toString());
            return literal;
        }
        literal.setNativeName(v.getString());
        return literal;
    }

    public static IDataType getNumericDataType(String value) {
        Object type;
        if (value.lastIndexOf(69) != -1 || value.lastIndexOf(101) != -1) {
            type = DataTypeFactory.getDoubleType();
        } else if (value.indexOf(46) != -1) {
            int precision = value.length();
            int scale = value.indexOf(46);
            if (scale != -1) {
                scale = --precision - scale;
            }
            type = precision <= 256 ? DataTypeFactory.getDecimalType((int)precision, (int)scale) : DataTypeFactory.getDoubleType();
        } else {
            try {
                long iValue = Long.parseLong(value);
                type = iValue <= 32767L && iValue >= -32768L ? DataTypeFactory.getSmallintType() : (iValue <= Integer.MAX_VALUE && iValue >= Integer.MIN_VALUE ? DataTypeFactory.getIntegerType() : DataTypeFactory.getLongType());
            }
            catch (NumberFormatException e) {
                type = value.length() <= 256 ? DataTypeFactory.getDecimalType((int)value.length(), (int)0) : DataTypeFactory.getDoubleType();
            }
        }
        return type;
    }

    private static IXQEQueryNode createForSummary(XQENodeFactory nodeFactory, V5Query v5Query, List<DataItem> dataItems, IXQEQueryNode identifier, AggregateType aggType, DataSet dataset) {
        ArrayList<V5BoundDataItemReference> forDimensions = new ArrayList<V5BoundDataItemReference>();
        boolean isForBins = false;
        for (DataItem dataItem : dataItems) {
            if (dataItem.getAggregate() != null || dataItem.getItemId() == null) continue;
            V5BoundDataItemReference dimension = null;
            if (dataItem.getBinning() == null) {
                ColumnMetadata columnMetadata = FilterGenerator.findMetadata(dataset, dataItem.getItemId());
                dimension = TransformationUtils.createMultiPartIdentifier(columnMetadata, nodeFactory);
            } else {
                dimension = TransformationUtils.createBoundDataItemReference(v5Query, dataItem.getId(), nodeFactory, false);
                isForBins = true;
            }
            forDimensions.add(dimension);
        }
        if (forDimensions.isEmpty()) {
            return null;
        }
        V5ValueSummaryFunction summary = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
        summary.setSubType(TransformationUtils.getV5SummaryFunctionType(aggType));
        if (AggregateType.COUNTDISTINCT.equals((Object)aggType)) {
            summary.setDistinct(true);
        } else {
            summary.setDistinct(false);
        }
        summary.setPrefilter(false);
        summary.addChild(identifier);
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        summary.addChild((IXQEQueryNode)forClause);
        for (IXQEQueryNode iXQEQueryNode : forDimensions) {
            forClause.addChild(iXQEQueryNode);
        }
        if (isForBins) {
            FilterGenerator.setForBins((IXQEQueryNode)summary);
        }
        return summary;
    }

    private static IXQEQueryNode getExpression(XQENodeFactory nodeFactory, V5Query v5Query, DataSet dataset, List<DataItem> dataItems, FilterExpression filter, boolean postAA, Locale locale) {
        IXQEQueryNode filterExpression;
        V5BoundDataItemReference multiPartIdentifier;
        String dataItemName;
        ColumnMetadata column;
        DataItem dataItem;
        if (filter instanceof NotFilter) {
            FilterExpression notFilter = ((NotFilter)filter).getNot();
            V5LogicalExpression not = (V5LogicalExpression)nodeFactory.createNode(201003);
            not.setSubType(2);
            IXQEQueryNode expression = FilterGenerator.getExpression(nodeFactory, v5Query, dataset, dataItems, notFilter, postAA, locale);
            not.addChild(expression);
            if (FilterGenerator.isForBins(expression)) {
                expression.removeProperty(PROP_IS_FOR_BINS);
                FilterGenerator.setForBins((IXQEQueryNode)not);
            }
            return not;
        }
        if (filter instanceof OrFilter) {
            List orFilters = ((OrFilter)filter).getOr();
            return FilterGenerator.createAndOrExpression(nodeFactory, v5Query, dataset, dataItems, postAA, orFilters, 1, locale);
        }
        if (filter instanceof AndFilter) {
            List andFilters = ((AndFilter)filter).getAnd();
            return FilterGenerator.createAndOrExpression(nodeFactory, v5Query, dataset, dataItems, postAA, andFilters, 0, locale);
        }
        DataFilter dataFilter = (DataFilter)filter;
        ColumnMetadata memberColumn = null;
        boolean queryAggregation = false;
        String filterId = dataFilter.getFilterId();
        if (filterId != null) {
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5Expression.setExpression(filterId);
            return v5Expression;
        }
        String dataItemId = dataFilter.getDataItem();
        String itemId = dataFilter.getItemId();
        V5BoundDataItemReference identifier = null;
        AggregateType aggType = null;
        if (dataItemId == null && itemId != null && null != (dataItem = FilterGenerator.findDataItemByItemId(dataItems, itemId))) {
            dataItemId = dataItem.getId();
        }
        if (dataItemId != null) {
            dataItem = FilterGenerator.findDataItem(dataItems, dataItemId);
            if (dataItem == null) {
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Unable to find data item id: " + dataItemId);
            }
            aggType = dataItem.getAggregate();
            queryAggregation = aggType != null;
            column = FilterGenerator.findMetadata(dataset, dataItem.getItemId());
            ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
            if (sourceCategory != null && sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && dataFilter.getValueType() != DataFilter.ValueType.DISPLAY) {
                String columnId = column.getParentColumn().getColumnId();
                column = FilterGenerator.findMetadata(dataset, columnId);
                dataItemName = column.getColumnId();
                dataItemName = aggType != null ? dataItemName + "_" + aggType.toString() : dataItemName;
                multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(column, nodeFactory);
            } else {
                dataItemName = dataItemId;
                multiPartIdentifier = TransformationUtils.createBoundDataItemReference(v5Query, dataItemId, nodeFactory, false);
                if (multiPartIdentifier == null) {
                    multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(column, nodeFactory);
                }
            }
        } else {
            column = FilterGenerator.findMetadata(dataset, itemId);
            if (column == null) {
                dataItemName = "";
                multiPartIdentifier = TransformationUtils.createBoundDataItemReference(v5Query, itemId, nodeFactory, false);
            } else {
                ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
                if (sourceCategory != null && sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && dataFilter.getValueType() == DataFilter.ValueType.USE) {
                    String columnId = column.getParentColumn().getColumnId();
                    column = FilterGenerator.findMetadata(dataset, columnId);
                }
                dataItemName = column.getColumnId();
                dataItemName = aggType != null ? dataItemName + "_" + aggType.toString() : dataItemName;
                multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(column, nodeFactory);
            }
        }
        boolean isMemberAggregate = false;
        if (queryAggregation && !ColumnMetadata.SourceCategory.MEASURE.equals((Object)column.getSourceCategory()) && !ColumnMetadata.SourceCategory.PROPERTY.equals((Object)column.getSourceCategory()) && !ColumnMetadata.SourceCategory.CALCULATION.equals((Object)column.getSourceCategory())) {
            if (TransformationUtils.isMemberSet(column)) {
                dataItemName = column.getColumnName() + "_" + aggType.toString();
                dataItemName = TransformationUtils.createMembersAggregateNEW(v5Query, column, dataItemName + "_FILTER", dataItems, dataset, nodeFactory);
                identifier = TransformationUtils.createBoundDataItemReference(v5Query, dataItemName, nodeFactory, false);
                isMemberAggregate = true;
                memberColumn = column;
            } else {
                identifier = FilterGenerator.createForSummary(nodeFactory, v5Query, dataItems, (IXQEQueryNode)multiPartIdentifier, aggType, dataset);
            }
            if (identifier == null) {
                int idx = 1;
                while (TransformationUtils.findV5DataItem((IXQEQueryNode)v5Query, dataItemName, (IXQEQueryNode)multiPartIdentifier) == TransformationUtils.FoundV5DataItem.DIFFERENT_EXPRESSION) {
                    StringBuilder sb = new StringBuilder(dataItemName);
                    sb.append("_").append(Integer.toString(idx++));
                    dataItemName = sb.toString();
                }
                com.ibm.bi.qs.model.api.AggregateType convertedAggType = aggType != null ? com.ibm.bi.qs.model.api.AggregateType.fromValue((String)aggType.toString()) : null;
                TransformationUtils.buildDataItem((IXQEQueryNode)v5Query, dataItemName, convertedAggType, (IXQEQueryNode)multiPartIdentifier, nodeFactory);
                identifier = TransformationUtils.createBoundDataItemReference(v5Query, dataItemName, nodeFactory, false);
            }
            dataFilter.setAdditionalProperty("appliedOnSummary", (Object)true);
            column = null;
        } else {
            identifier = multiPartIdentifier;
        }
        if (multiPartIdentifier == null && column == null && dataItemId == null) {
            throw new QueryServiceException(QueryServiceMessageKeys.MISSING_QUERY_DATAITEM, itemId, "column");
        }
        FilterOperator op = dataFilter.getOperator();
        if (op == FilterOperator.BETWEEN) {
            filterExpression = FilterGenerator.createBetweenExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, column);
        } else if (op == FilterOperator.NOTBETWEEN) {
            filterExpression = FilterGenerator.createNotBetweenExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, column);
        } else if (op == FilterOperator.LT) {
            filterExpression = FilterGenerator.createComparisonExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 0, column);
        } else if (op == FilterOperator.GT) {
            filterExpression = FilterGenerator.createComparisonExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 5, column);
        } else if (op == FilterOperator.GTE) {
            filterExpression = FilterGenerator.createComparisonExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 4, column);
        } else if (op == FilterOperator.LTE) {
            filterExpression = FilterGenerator.createComparisonExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 1, column);
        } else if (op == FilterOperator.BEGINSWITH) {
            filterExpression = FilterGenerator.createBeginEndExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 201006, column);
        } else if (op == FilterOperator.ENDSWITH) {
            filterExpression = FilterGenerator.createBeginEndExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, 201007, column);
        } else if (op == FilterOperator.CONTAINSIGNORECASE) {
            filterExpression = FilterGenerator.createContainsExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, column, false);
        } else if (op == FilterOperator.CONTAINS) {
            filterExpression = FilterGenerator.createContainsExpression(nodeFactory, dataFilter, postAA, (IXQEQueryNode)identifier, column, true);
        } else if (op == FilterOperator.IN) {
            filterExpression = FilterGenerator.createInExpression(nodeFactory, v5Query, dataset, dataItems, dataFilter, postAA, (IXQEQueryNode)identifier, column, false, locale);
        } else if (op == FilterOperator.NOTIN) {
            filterExpression = FilterGenerator.createInExpression(nodeFactory, v5Query, dataset, dataItems, dataFilter, postAA, (IXQEQueryNode)identifier, column, true, locale);
        } else if (op == FilterOperator.ISNULL) {
            filterExpression = FilterGenerator.createIsNullExpression(nodeFactory, (IXQEQueryNode)identifier, false);
        } else if (op == FilterOperator.ISNOTNULL) {
            filterExpression = FilterGenerator.createIsNullExpression(nodeFactory, (IXQEQueryNode)identifier, true);
        } else {
            return null;
        }
        if (FilterGenerator.isForBins((IXQEQueryNode)identifier)) {
            identifier.removeProperty(PROP_IS_FOR_BINS);
            FilterGenerator.setForBins(filterExpression);
        }
        if (isMemberAggregate) {
            ColumnMetadata lowestProjectedLevel = TransformationUtils.getLowestProjectedLevel(memberColumn.getHierarchy(), dataItems, dataset);
            multiPartIdentifier = TransformationUtils.createMultiPartIdentifier(lowestProjectedLevel, nodeFactory);
            IXQEQueryNode inExpr = nodeFactory.createNode(201011);
            inExpr.addChild((IXQEQueryNode)multiPartIdentifier);
            IXQEQueryNode filterNode = nodeFactory.createNode(201066);
            inExpr.addChild(filterNode);
            filterNode.addChild(nodeFactory.copyNode((IXQEQueryNode)multiPartIdentifier));
            filterNode.addChild(filterExpression);
            return inExpr;
        }
        return filterExpression;
    }

    private static boolean isNumeric(ColumnMetadata.DataType dataType) {
        switch (dataType) {
            case DECIMAL: 
            case FLOAT: 
            case INTEGER: {
                return true;
            }
        }
        return false;
    }
}

