/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagDMRSubquery;
import com.cognos.xqe.query.engine.NagSubquery;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import com.ibm.bi.qs.model.api.QueryFeedback;
import com.ibm.bi.qs.model.api.QueryFeedbackMode;
import com.ibm.bi.qs.model.api.data.common.generated.ParameterFeedbackInfo;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.util.ParameterUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QueryFeedbackWrapper {
    public static final String QUERY_FEEDBACK_KEY = "queryFeedback";
    public static final String PROPERTY_KEY = "property";
    public static final String NAME_KEY = "name";
    public static final String NATIVE_SQL = "nativeSQL";
    public static final String EMPTY_STR = "";
    public static final String NEWLINE = "\r\n";
    public static final String METADATA_RETRIEVAL_TIME_KEY = "metadataRetrievalTime";
    public static final String REQUEST_MARSHALLING_TIME_KEY = "requestMarshallingTime";
    public static final String PLANNING_TIME_KEY = "planningTime";
    public static final String EXECUTION_TIME_KEY = "executionTime";
    public static final String RESULT_MARSHALLING_TIME = "resultMarshallingTime";
    public static final String TOTAL_KEY = "total";
    public static final String EDGE_KEY = "edge";
    public static final String ROWSETS_KEY = "rowsets";
    private static final long ONE_MILLISECOND_IN_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    public static final NumberFormat NUMBER_FORMATTER = NumberFormat.getInstance(Locale.US);
    private final QueryFeedback[] qfbProperties;
    private int severityLevel;
    private QueryFeedbackMode qfbMode;
    private String locale = null;
    private final List<ResponseMessage> missingMembersMessages = new ArrayList<ResponseMessage>();
    private final List<ResponseMessage> nagMessages = new ArrayList<ResponseMessage>();
    private final List<ResponseMessage> cogSQLMDXMessages = new ArrayList<ResponseMessage>();
    private final List<ResponseMessage> nativeSQLMDXMessages = new ArrayList<ResponseMessage>();
    private final Map<String, List<RowsetColumnInfo>> edgeColumnInfo = new LinkedHashMap<String, List<RowsetColumnInfo>>();
    private long metadataRetrievalTime = 0L;
    private long requestMarshallingTime = 0L;
    private long planningTime = 0L;
    private long executionTime = 0L;
    private long resultMarshallingTime = 0L;
    private List<ParameterFeedbackInfo> usedParams = new ArrayList<ParameterFeedbackInfo>();

    public QueryFeedbackWrapper(String qfbValue) {
        this.qfbProperties = QueryFeedback.decomposeQFBQueryStringPropertyValue((String)qfbValue);
        this.severityLevel = this.qfbProperties.length > 0 ? 3 : -1;
        this.qfbMode = QueryFeedbackMode.EXECUTE;
    }

    public boolean requestedFeedback() {
        return this.qfbProperties.length > 0;
    }

    public boolean requestedColumnInfo() {
        return ArrayUtils.contains((Object[])this.qfbProperties, (Object)QueryFeedback.COLUMN_LIST);
    }

    public boolean requestedUsedParams() {
        return ArrayUtils.contains((Object[])this.qfbProperties, (Object)QueryFeedback.USED_PARAMS);
    }

    public void setSeverityLevel(String lvl) {
        this.severityLevel = "error".equalsIgnoreCase(lvl) ? 0 : ("warning".equalsIgnoreCase(lvl) ? 1 : ("keyTransformation".equalsIgnoreCase(lvl) ? 2 : 3));
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public void setQueryFeedbackMode(String mode) {
        this.qfbMode = QueryFeedbackMode.VALIDATE.getValue().equalsIgnoreCase(mode) ? QueryFeedbackMode.VALIDATE : QueryFeedbackMode.EXECUTE;
    }

    public QueryFeedbackMode getQueryFeedbackMode() {
        return this.qfbMode;
    }

    public boolean isValidateMode() {
        return QueryFeedbackMode.VALIDATE == this.qfbMode;
    }

    public void setMetadataRetrievalTime(long t) {
        this.metadataRetrievalTime = t;
    }

    public void startRequestMarshalling() {
        this.requestMarshallingTime = System.nanoTime();
    }

    public void endRequestMarshalling() {
        this.requestMarshallingTime = System.nanoTime() - this.requestMarshallingTime;
    }

    public void startPlanning() {
        this.planningTime = System.nanoTime();
    }

    public void endPlanning() {
        this.planningTime = System.nanoTime() - this.planningTime;
    }

    public void startExecution() {
        this.executionTime = System.nanoTime();
    }

    public void endExecution() {
        this.executionTime = System.nanoTime() - this.executionTime;
    }

    public void startResultMarshalling() {
        this.resultMarshallingTime = System.nanoTime();
    }

    public void endResultMarshalling() {
        this.resultMarshallingTime = System.nanoTime() - this.resultMarshallingTime;
    }

    public void incrementResultMarshallingTime(long t) {
        this.resultMarshallingTime += t;
    }

    public void augmentV5Request(RequestEnvironment reqEnv, V5QuerySet v5QuerySet) {
        if (this.requestedFeedback()) {
            IXQEQueryNode[] qrds;
            reqEnv.setMaxSeverityLevel(3);
            reqEnv.setMixedRequest(true);
            for (IXQEQueryNode rawQRD : qrds = v5QuerySet.getDescendantsOfType(101055, false)) {
                V5QueryResultDefinition qrd = (V5QueryResultDefinition)rawQRD;
                for (QueryFeedback qfb : this.qfbProperties) {
                    qrd.addQueryFeedback(qfb.getValue());
                }
            }
        }
    }

    public void augmentV5Request(Element root) {
        if (this.requestedFeedback()) {
            Element queryFeedback = DocumentHelper.createElement((String)QUERY_FEEDBACK_KEY);
            queryFeedback.addAttribute("severityLevel", ResponseMessage.severityLevelToString((int)this.severityLevel));
            for (QueryFeedback qfb : this.qfbProperties) {
                Element property = DocumentHelper.createElement((String)PROPERTY_KEY);
                property.addAttribute(NAME_KEY, qfb.getValue());
                queryFeedback.add(property);
            }
            root.add(queryFeedback);
        }
    }

    public Object perfToJSON() throws JSONException {
        OrderedJSONObject perfObj = new OrderedJSONObject();
        this.metadataRetrievalTime = this.metadataRetrievalTime > 0L ? this.metadataRetrievalTime : 0L;
        this.requestMarshallingTime = this.resultMarshallingTime > 0L ? this.requestMarshallingTime : 0L;
        this.planningTime = this.planningTime > 0L ? this.planningTime : 0L;
        this.executionTime = this.executionTime > 0L ? this.executionTime : 0L;
        this.resultMarshallingTime = this.resultMarshallingTime > 0L ? this.resultMarshallingTime : 0L;
        perfObj.put(METADATA_RETRIEVAL_TIME_KEY, (Object)NUMBER_FORMATTER.format(this.metadataRetrievalTime / ONE_MILLISECOND_IN_NS));
        perfObj.put(REQUEST_MARSHALLING_TIME_KEY, (Object)NUMBER_FORMATTER.format(this.requestMarshallingTime / ONE_MILLISECOND_IN_NS));
        perfObj.put(PLANNING_TIME_KEY, (Object)NUMBER_FORMATTER.format(this.planningTime / ONE_MILLISECOND_IN_NS));
        perfObj.put(EXECUTION_TIME_KEY, (Object)NUMBER_FORMATTER.format(this.executionTime / ONE_MILLISECOND_IN_NS));
        perfObj.put(RESULT_MARSHALLING_TIME, (Object)NUMBER_FORMATTER.format(this.resultMarshallingTime / ONE_MILLISECOND_IN_NS));
        perfObj.put(TOTAL_KEY, (Object)NUMBER_FORMATTER.format((this.metadataRetrievalTime + this.requestMarshallingTime + this.planningTime + this.executionTime + this.resultMarshallingTime) / ONE_MILLISECOND_IN_NS));
        return perfObj;
    }

    public Object columnListToJSON() throws JSONException {
        JSONArray columnListArr = new JSONArray();
        for (Map.Entry<String, List<RowsetColumnInfo>> edgeInfo : this.edgeColumnInfo.entrySet()) {
            OrderedJSONObject obj = new OrderedJSONObject();
            List<RowsetColumnInfo> rowsetsInfo = edgeInfo.getValue();
            obj.put(EDGE_KEY, (Object)edgeInfo.getKey());
            JSONArray rowsetArr = new JSONArray();
            for (RowsetColumnInfo rowsetInfo : rowsetsInfo) {
                rowsetArr.add(rowsetInfo.toJSON());
            }
            obj.put(ROWSETS_KEY, (Collection)rowsetArr);
            columnListArr.add((Object)obj);
        }
        return columnListArr;
    }

    public Object feedbackToJSON() {
        List<QueryFeedback> props;
        JSONArray messages;
        Locale theLocale;
        block6: {
            block5: {
                theLocale = null == this.locale ? null : LocaleConverter.strToLocale((String)this.locale);
                messages = new JSONArray();
                props = Arrays.asList(this.qfbProperties);
                if (props.contains(QueryFeedback.COGNOS_COMMAND_TEXT)) {
                    ((Stream)this.cogSQLMDXMessages.stream().sequential()).map(m -> m.toJSON(theLocale)).forEach(arg_0 -> ((JSONArray)messages).add(arg_0));
                }
                if (props.contains(QueryFeedback.NATIVE_COMMAND_TEXT)) break block5;
                if (!props.contains(QueryFeedback.NATIVE_COMMAND_TYPE)) break block6;
            }
            ((Stream)this.nativeSQLMDXMessages.stream().sequential()).map(m -> m.toJSON(theLocale)).forEach(arg_0 -> ((JSONArray)messages).add(arg_0));
        }
        if (props.size() == QueryFeedback.values().length) {
            ((Stream)this.missingMembersMessages.stream().sequential()).map(m -> m.toJSON(theLocale)).forEach(arg_0 -> ((JSONArray)messages).add(arg_0));
            ((Stream)this.nagMessages.stream().sequential()).map(m -> m.toJSON(theLocale)).forEach(arg_0 -> ((JSONArray)messages).add(arg_0));
        }
        return messages;
    }

    public Object usedParamsToJSON() {
        return ParameterUtil.parameterFeedbackToJSON(this.usedParams);
    }

    public static void retrieveColumnListFeedback(QueryFeedbackWrapper qfbWrapper, RSAPIDataset rsapiDataset) {
        if (null == qfbWrapper || !qfbWrapper.requestedColumnInfo() || qfbWrapper.isValidateMode()) {
            return;
        }
        for (RSAPIEdge edge : rsapiDataset.getEdges()) {
            LinkedList<RowsetColumnInfo> rowsetsInfo = new LinkedList<RowsetColumnInfo>();
            for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                if (rowset.getNumColumns() == 0) continue;
                RowsetColumnInfo rowsetInfo = new RowsetColumnInfo(rowset.getName());
                for (RSAPIColumn column : rowset.getColumns()) {
                    ColumnInfo columnInfo = new ColumnInfo(column.getName(), column.getName(), column.getDatatype().getTypeName(), column.getLength(), column.getPrecision(), column.getScale(), column.getNullsOK());
                    columnInfo.setResolvedAggregate(column.getResolvedAggregateType());
                    Governors governors = rsapiDataset.getGovernors();
                    if (null != governors && governors.getReportAsDatasource()) {
                        columnInfo.setSQLColumnIndex(column.getSqlColumnIndex());
                        columnInfo.setSQLColumnName(column.getSqlColumnName());
                        try {
                            columnInfo.setSQLColumnModelType(column.getDatatype().toModelType());
                        }
                        catch (Exception e) {
                            columnInfo.setSQLColumnModelType(column.getDatatype().toString());
                        }
                    }
                    rowsetInfo.add(columnInfo);
                }
                rowsetsInfo.add(rowsetInfo);
            }
            qfbWrapper.edgeColumnInfo.put(edge.getName(), rowsetsInfo);
        }
    }

    public static void retrieveQueryFeedback(QueryFeedbackWrapper qfbWrapper, IXQEQueryNode plannedQuery, RequestEnvironment reqEnv, ServletRequestContext servletRequestContext) {
        if (null == qfbWrapper) {
            return;
        }
        if (!qfbWrapper.requestedFeedback()) {
            qfbWrapper.endPlanning();
            return;
        }
        if (null != servletRequestContext) {
            qfbWrapper.locale = servletRequestContext.getProductLocale();
        }
        QueryFeedbackWrapper.executeForValidateDMR(reqEnv, plannedQuery);
        QueryFeedbackWrapper.captureMigrateNags(reqEnv, qfbWrapper);
        QueryFeedbackWrapper.captureMissingMembers(reqEnv, qfbWrapper);
        IXQEQueryNode[] rsapiDataSets = plannedQuery.getChildrenOfType(401005);
        if (rsapiDataSets != null) {
            for (IXQEQueryNode dataSet : rsapiDataSets) {
                String nativeCursorSQLText;
                RSAPIDataset rsapiDataSet = (RSAPIDataset)dataSet;
                if (rsapiDataSet == null) continue;
                ResponseMessage.ResponseMessageType responseMsgType = ResponseMessage.ResponseMessageType.UNKNOWN;
                StringBuilder nodeStr = new StringBuilder();
                String cognosSQL = rsapiDataSet.getCognosSQL();
                List nodeList = XQENodeSerializer.findQuerySourceNodes((IXQEQueryNode)rsapiDataSet);
                for (IXDataSource aNode : nodeList) {
                    if (aNode instanceof XMdx) {
                        if (nodeStr.length() != 0) {
                            nodeStr.append(NEWLINE);
                            nodeStr.append(NEWLINE);
                        }
                        nodeStr.append(aNode.getQueryText());
                        responseMsgType = ResponseMessage.ResponseMessageType.MDX_NODE_TYPE_INT;
                        cognosSQL = EMPTY_STR;
                        continue;
                    }
                    if (aNode instanceof XSql) {
                        if (rsapiDataSet.forXtabRelational()) continue;
                        if (nodeStr.length() != 0) {
                            nodeStr.append(NEWLINE);
                            nodeStr.append(NEWLINE);
                        }
                        String nativeSQL = aNode.getQueryText();
                        Governors g = rsapiDataSet.getGovernors();
                        if (g != null && Governors.UseSQLParameters.LITERAL == g.getUseSQLParameters()) {
                            XSql xsql = (XSql)aNode;
                            MultiRequestContext mrc = ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContext();
                            Parameters parameters = mrc.getRequestParameters().getParameters();
                            String sqlText = xsql.substituteParameterInNativeSQLWithLiteral(parameters);
                            StringBuilder fullSql = new StringBuilder();
                            if (xsql.getCommentText() != null) {
                                fullSql.append(xsql.getCommentText());
                                fullSql.append(NEWLINE);
                            }
                            fullSql.append(sqlText);
                            nativeSQL = fullSql.toString();
                        }
                        nodeStr.append(nativeSQL);
                        responseMsgType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
                        continue;
                    }
                    if (nodeStr.length() != 0) {
                        nodeStr.append(NEWLINE);
                        nodeStr.append(NEWLINE);
                    }
                    nodeStr.append(aNode.getQueryText());
                    responseMsgType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
                }
                if (null != cognosSQL && !EMPTY_STR.equals(cognosSQL) && qfbWrapper.severityLevel >= 2) {
                    ResponseMessage responseMessage = new ResponseMessage(qfbWrapper.severityLevel, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, cognosSQL);
                    qfbWrapper.cogSQLMDXMessages.add(responseMessage);
                }
                QueryFeedbackWrapper.captureNags(reqEnv, qfbWrapper);
                QueryFeedbackWrapper.captureSubquerySQLNags(reqEnv, qfbWrapper);
                if (rsapiDataSet.forDMRReport()) {
                    XQENodeSerializer.addSubqueryNagMessagesToResponseFolder((RequestEnvironment)reqEnv, (RSAPIDataset)rsapiDataSet, (String)nodeStr.toString(), (ResponseMessage.ResponseMessageType)ResponseMessage.ResponseMessageType.DMR_NODE_TYPE_INT);
                    QueryFeedbackWrapper.captureMDXSubqueriesNagMessages(reqEnv, qfbWrapper);
                    continue;
                }
                if (rsapiDataSet.forXtabRelational()) {
                    XQENodeSerializer.addSubqueryNagMessagesToResponseFolder((RequestEnvironment)reqEnv, (RSAPIDataset)rsapiDataSet, (String)nodeStr.toString(), (ResponseMessage.ResponseMessageType)ResponseMessage.ResponseMessageType.XTAB_REL_NODE_TYPE_INT);
                    QueryFeedbackWrapper.captureXTabForRelationalSubqueriesNagMessages(reqEnv, qfbWrapper);
                    continue;
                }
                if (!EMPTY_STR.equals(nodeStr.toString()) && 3 == qfbWrapper.severityLevel) {
                    reqEnv.getResponseMessageFolder().appendInfoResponseMessage(responseMsgType, nodeStr.toString(), "execute");
                    QueryFeedbackWrapper.captureNativeSQLMessages(reqEnv, qfbWrapper);
                }
                if (null == (nativeCursorSQLText = rsapiDataSet.getExecutionSQLCursors().getFormattedString()) || EMPTY_STR.equals(nativeCursorSQLText) || 2 != qfbWrapper.severityLevel) continue;
                reqEnv.getResponseMessageFolder().appendResponseMessage(2, ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT, nativeCursorSQLText, "execute");
                QueryFeedbackWrapper.captureNativeSQLMessages(reqEnv, qfbWrapper);
            }
        }
        qfbWrapper.endPlanning();
    }

    public static void retrieveParameterFeedbackInfo(QueryFeedbackWrapper qfbWrapper, List<ParameterFeedbackInfo> parameters) {
        for (ParameterFeedbackInfo param : parameters) {
            qfbWrapper.usedParams.add(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeForValidateDMR(RequestEnvironment reqEnv, IXQEQueryNode plannedQuery) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        for (IXQEQueryNode node : plannedQuery.getChildrenOfType(401005)) {
            RSAPIDataset dataSet = (RSAPIDataset)node;
            if (!dataSet.forDMRReport() || 3 != reqEnv.getMaxSeverityLevel()) continue;
            execEnv.getGovernors().setLocalCache("false");
            IXQEQueryNode[] mdxs = dataSet.getDescendantsOfType(501053, false);
            try {
                for (IXQEQueryNode mdx : mdxs) {
                    ((XMdxLocal)mdx).setExecuteForValidate(true);
                }
                QueryEngine.getInstance().executeRSAPIDataset(dataSet, execEnv);
            }
            finally {
                for (IXQEQueryNode mdx : mdxs) {
                    ((XMdxLocal)mdx).setExecuteForValidate(false);
                }
            }
            List dmrSQL = execEnv.getNagCollector().getNagOfSubqueryType(NagSubquery.NagSubqueryType.DMR);
            for (Nag dmrNag : dmrSQL) {
                NagDMRSubquery nag = (NagDMRSubquery)dmrNag;
                if (nag.getReportQueryName() != null) continue;
                nag.setReportQueryName(dataSet.getRefQueryName());
            }
        }
    }

    private static void captureMigrateNags(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        if (RequestEnvironment.MigrationBaseVersionEnum.COMPATIBLE == reqEnv.getMigrationBaseVersion()) {
            XQENodeSerializer.addMigrateMessagesInMessageFolder((RequestEnvironment)reqEnv);
        }
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getPlanningResponseMessages());
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getExecutionResponseMessages());
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getValidationResponseMessages());
        QueryFeedbackWrapper.clearResponseMessageFolder(responseMessageFolder);
    }

    private static void captureMissingMembers(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        qfbWrapper.missingMembersMessages.addAll(responseMessageFolder.getPlanningResponseMessages());
        qfbWrapper.missingMembersMessages.addAll(responseMessageFolder.getExecutionResponseMessages());
        Collections.sort(qfbWrapper.missingMembersMessages);
        qfbWrapper.missingMembersMessages.addAll(responseMessageFolder.getValidationResponseMessages());
        QueryFeedbackWrapper.clearResponseMessageFolder(responseMessageFolder);
    }

    private static void captureNags(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        XQENodeSerializer.addNagMessagesToResponseFolder((RequestEnvironment)reqEnv);
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getPlanningResponseMessages());
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getExecutionResponseMessages());
        qfbWrapper.nagMessages.addAll(responseMessageFolder.getValidationResponseMessages());
        QueryFeedbackWrapper.clearResponseMessageFolder(responseMessageFolder);
    }

    private static void captureSubquerySQLNags(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        XQENodeSerializer.addSubquerySQLNagsToResponseFolder((RequestEnvironment)reqEnv);
        ArrayList responseMessages = new ArrayList();
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        responseMessages.addAll(responseMessageFolder.getPlanningResponseMessages());
        responseMessages.addAll(responseMessageFolder.getExecutionResponseMessages());
        responseMessages.addAll(responseMessageFolder.getValidationResponseMessages());
        for (ResponseMessage responseMessage : responseMessages) {
            if (ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT == responseMessage.getType()) {
                qfbWrapper.cogSQLMDXMessages.add(responseMessage);
                continue;
            }
            if (ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT != responseMessage.getType()) continue;
            qfbWrapper.nativeSQLMDXMessages.add(responseMessage);
        }
        QueryFeedbackWrapper.clearResponseMessageFolder(responseMessageFolder);
    }

    private static void captureMDXSubqueriesNagMessages(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        ArrayList responseMessages = new ArrayList();
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        if (!responseMessageFolder.getResponseMessageFolders().isEmpty()) {
            ResponseMessageFolder newResponseMessageFolder = (ResponseMessageFolder)responseMessageFolder.getResponseMessageFolders().get(0);
            responseMessages.addAll(newResponseMessageFolder.getPlanningResponseMessages());
            responseMessages.addAll(newResponseMessageFolder.getExecutionResponseMessages());
            responseMessages.addAll(newResponseMessageFolder.getValidationResponseMessages());
            for (ResponseMessage responseMessage : responseMessages) {
                if ("MDX".equals(responseMessage.getQueryLanguage()) || "cognosSQL".equals(responseMessage.getQueryLanguage())) {
                    qfbWrapper.cogSQLMDXMessages.add(responseMessage);
                    continue;
                }
                if (!NATIVE_SQL.equals(responseMessage.getQueryLanguage())) continue;
                qfbWrapper.nativeSQLMDXMessages.add(responseMessage);
            }
            responseMessageFolder.getResponseMessageFolders().clear();
        }
    }

    private static void captureXTabForRelationalSubqueriesNagMessages(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        ArrayList responseMessages = new ArrayList();
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        if (!responseMessageFolder.getResponseMessageFolders().isEmpty()) {
            ResponseMessageFolder newResponseMessageFolder = (ResponseMessageFolder)responseMessageFolder.getResponseMessageFolders().get(0);
            responseMessages.addAll(newResponseMessageFolder.getPlanningResponseMessages());
            responseMessages.addAll(newResponseMessageFolder.getExecutionResponseMessages());
            responseMessages.addAll(newResponseMessageFolder.getValidationResponseMessages());
            for (ResponseMessage responseMessage : responseMessages) {
                if ("XTabRel".equals(responseMessage.getQueryLanguage()) || "cognosSQL".equals(responseMessage.getQueryLanguage())) {
                    qfbWrapper.cogSQLMDXMessages.add(responseMessage);
                    continue;
                }
                if (!NATIVE_SQL.equals(responseMessage.getQueryLanguage())) continue;
                qfbWrapper.nativeSQLMDXMessages.add(responseMessage);
            }
            responseMessageFolder.getResponseMessageFolders().clear();
        }
    }

    private static void captureNativeSQLMessages(RequestEnvironment reqEnv, QueryFeedbackWrapper qfbWrapper) {
        ArrayList responseMessages = new ArrayList();
        ResponseMessageFolder responseMessageFolder = reqEnv.getResponseMessageFolder();
        responseMessages.addAll(responseMessageFolder.getValidationResponseMessages());
        responseMessages.addAll(responseMessageFolder.getExecutionResponseMessages());
        responseMessages.addAll(responseMessageFolder.getPlanningResponseMessages());
        qfbWrapper.nativeSQLMDXMessages.addAll(responseMessages);
        QueryFeedbackWrapper.clearResponseMessageFolder(responseMessageFolder);
    }

    private static void clearResponseMessageFolder(ResponseMessageFolder responseMessageFolder) {
        responseMessageFolder.getPlanningResponseMessages().clear();
        responseMessageFolder.getExecutionResponseMessages().clear();
        responseMessageFolder.getValidationResponseMessages().clear();
    }

    private static class ColumnInfo {
        static final String NAME_KEY = "name";
        static final String SQL_NAME_KEY = "sqlName";
        static final String TYPE_KEY = "type";
        static final String LENGTH_KEY = "length";
        static final String PRECISION_KEY = "precision";
        static final String SCALE_KEY = "scale";
        static final String NULLS_ALLOWED_KEY = "nullsAllowed";
        static final String RESOLVED_AGGREGATE_KEY = "resolvedAggregate";
        static final String SQL_COLUMN_INDEX_KEY = "sqlColumnIndex";
        static final String SQL_COLUMN_NAME_KEY = "sqlColumnName";
        static final String SQL_COLUMN_MODEL_TYPE_KEY = "sqlColumnModelType";
        private final String name;
        private final String sqlName;
        private final String type;
        private final int length;
        private final int precision;
        private final int scale;
        private final boolean nullsAllowed;
        private String resolvedAggregate;
        private int sqlColumnIndex = -1;
        private String sqlColumnName;
        private String sqlColumnModelType;

        private ColumnInfo(String theName, String theSQLName, String theType, int theLength, int thePrecision, int theScale, boolean areNullsAllowed) {
            this.name = theName;
            this.sqlName = theSQLName;
            this.type = theType;
            this.length = theLength;
            this.precision = thePrecision;
            this.scale = theScale;
            this.nullsAllowed = areNullsAllowed;
        }

        public void setResolvedAggregate(String value) {
            this.resolvedAggregate = value;
        }

        public void setSQLColumnIndex(int value) {
            this.sqlColumnIndex = value;
        }

        public void setSQLColumnName(String value) {
            this.sqlColumnName = value;
        }

        public void setSQLColumnModelType(String value) {
            this.sqlColumnModelType = value;
        }

        public Object toJSON() throws JSONException {
            OrderedJSONObject obj = new OrderedJSONObject();
            obj.put("name", (Object)this.name);
            obj.put(SQL_NAME_KEY, (Object)this.sqlName);
            obj.put(TYPE_KEY, (Object)this.type);
            obj.put(LENGTH_KEY, this.length);
            obj.put(PRECISION_KEY, this.precision);
            obj.put(SCALE_KEY, this.scale);
            obj.put(NULLS_ALLOWED_KEY, this.nullsAllowed);
            if (null != this.resolvedAggregate) {
                obj.put(RESOLVED_AGGREGATE_KEY, (Object)this.resolvedAggregate);
            }
            if (-1 != this.sqlColumnIndex) {
                obj.put(SQL_COLUMN_INDEX_KEY, this.sqlColumnIndex);
            }
            if (null != this.sqlColumnName) {
                obj.put(SQL_COLUMN_NAME_KEY, (Object)this.sqlColumnName);
            }
            if (null != this.sqlColumnModelType) {
                obj.put(SQL_COLUMN_MODEL_TYPE_KEY, (Object)this.sqlColumnModelType);
            }
            return obj;
        }
    }

    private static class RowsetColumnInfo {
        static final String NAME_KEY = "name";
        static final String COLUMNS_KEY = "columns";
        private final String rowsetName;
        private final List<ColumnInfo> columnListInfo = new LinkedList<ColumnInfo>();

        private RowsetColumnInfo(String name) {
            this.rowsetName = name;
        }

        public void add(ColumnInfo columnInfo) {
            this.columnListInfo.add(columnInfo);
        }

        public Object toJSON() throws JSONException {
            OrderedJSONObject obj = new OrderedJSONObject();
            JSONArray arr = new JSONArray();
            for (ColumnInfo columnInfo : this.columnListInfo) {
                arr.add(columnInfo.toJSON());
            }
            obj.put("name", (Object)this.rowsetName);
            obj.put(COLUMNS_KEY, (Collection)arr);
            return obj;
        }
    }
}

