/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5PropertyExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberUniqueName;
import com.cognos.xqe.ast.v5Exp_new2.parser.ParseException;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.ast.v5Exp_new2.parser.TokenMgrError;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserUtil;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.SortOrder;
import com.ibm.bi.qs.model.api.data.queryspec.generated.Action;
import com.ibm.bi.qs.model.api.data.queryspec.generated.AggregateType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.DataItem;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QueryHints;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.TopBottom;
import com.ibm.bi.qs.xqe.v5.FilterGenerator;
import com.ibm.bi.qs.xqe.v5.XQELocalCacheController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class TransformationUtils {
    public static final String PROP_CHILD_INDEX_PROCESSED = "indexProcessedChildNode";
    public static final String PROP_CHILD_INDEX = "childIndex";
    public static final String QUERY_NAME_DEFAULT_VALUE = "query";

    public static FoundV5DataItem findV5DataItem(IXQEQueryNode v5Query, String name, IXQEQueryNode expression) {
        IXQEQueryNode[] v5Selections = v5Query.getChildrenOfTypeOrdered(101009);
        V5Selection v5Selection = (V5Selection)v5Selections[0];
        for (IXQEQueryNode currChild : v5Selection.getChildren()) {
            V5DataItem currDataItem;
            if (101003 != currChild.getType() || !name.equals((currDataItem = (V5DataItem)currChild).getNameProperty())) continue;
            if (!expression.isSameExpression(currDataItem.getChild(0), true)) {
                return FoundV5DataItem.DIFFERENT_EXPRESSION;
            }
            return FoundV5DataItem.SAME_EXPRESSION;
        }
        return FoundV5DataItem.NOT_FOUND;
    }

    public static V5DataItem buildDataItem(IXQEQueryNode v5Query, String name, com.ibm.bi.qs.model.api.AggregateType aggType, IXQEQueryNode expression, XQENodeFactory nodeFactory) {
        IXQEQueryNode[] v5Selections = v5Query.getChildrenOfTypeOrdered(101009);
        V5Selection v5Selection = (V5Selection)v5Selections[0];
        for (IXQEQueryNode currChild : v5Selection.getChildren()) {
            V5DataItem currDataItem;
            if (101003 != currChild.getType() || !name.equals((currDataItem = (V5DataItem)currChild).getNameProperty())) continue;
            boolean differentExpression = false;
            if (expression.getType() == currDataItem.getChild(0).getType() && !expression.isSameExpression(currDataItem.getChild(0), true)) {
                differentExpression = true;
            } else if (currDataItem.getChild(0).getNumberChildren() > 0 && expression.getType() == currDataItem.getChild(0).getChild(0).getType() && !expression.isSameExpression(currDataItem.getChild(0).getChild(0), true)) {
                differentExpression = true;
            } else if (expression.getType() != currDataItem.getChild(0).getType() && currDataItem.getChild(0).getNumberChildren() == 0) {
                differentExpression = true;
            } else if (expression.getType() != currDataItem.getChild(0).getType() && currDataItem.getChild(0).getNumberChildren() > 0 && expression.getType() != currDataItem.getChild(0).getChild(0).getType()) {
                differentExpression = true;
            }
            if (differentExpression) {
                throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Adding duplicate the data item name with different expression.");
            }
            return currDataItem;
        }
        V5DataItem v5DataItem = (V5DataItem)nodeFactory.createNode(101003, v5Query);
        if (com.ibm.bi.qs.model.api.AggregateType.DEFAULT != aggType) {
            v5DataItem.setStringPropertyValue("aggregate", TransformationUtils.getV5DataItemAggregate(aggType));
        }
        v5DataItem.setStringPropertyValue("detail", "automatic");
        v5DataItem.setStringPropertyValue("name", name);
        v5DataItem.setIsReferenced();
        v5DataItem.setStringPropertyValue("sort", "none");
        if (expression != null && expression.getType() != 101004) {
            V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
            v5DataItem.addChild((IXQEQueryNode)v5Expression);
            v5Expression.addChild(expression);
        } else if (expression != null) {
            v5DataItem.addChild(expression);
        }
        v5Selection.addChild((IXQEQueryNode)v5DataItem);
        return v5DataItem;
    }

    public static String getV5DataItemOrder(SortOrder sortOrder) {
        if (sortOrder != SortOrder.NONE && sortOrder != SortOrder.CUSTOM) {
            if (sortOrder == SortOrder.ASC) {
                return "ascending";
            }
            return "descending";
        }
        return "none";
    }

    public static SortOrder getSortOrderFromV5DataItem(V5DataItem v5DataItem) {
        if (v5DataItem == null || v5DataItem.getPropertyValue("sort") == null) {
            return null;
        }
        switch ((String)v5DataItem.getPropertyValue("sort")) {
            case "ascending": {
                return SortOrder.ASC;
            }
            case "descending": {
                return SortOrder.DESC;
            }
        }
        return null;
    }

    public static String getV5DataItemAggregate(com.ibm.bi.qs.model.api.AggregateType aggType) {
        if (aggType == null) {
            return "none";
        }
        switch (aggType) {
            case SUM: {
                return "total";
            }
            case COUNT: {
                return "count";
            }
            case COUNTDISTINCT: {
                return "countDistinct";
            }
            case AVG: {
                return "average";
            }
            case MIN: {
                return "minimum";
            }
            case MAX: {
                return "maximum";
            }
            case MEDIAN: {
                return "median";
            }
            case STDDEV: {
                return "standardDeviation";
            }
            case VARIANCE: {
                return "variance";
            }
            case NONE: {
                return "none";
            }
            case CALCULATED: {
                return "calculated";
            }
        }
        return "automatic";
    }

    public static String getV5SummaryFunction(com.ibm.bi.qs.model.api.AggregateType aggType) {
        if (aggType == null) {
            return "aggregate";
        }
        switch (aggType) {
            case SUM: {
                return "total";
            }
            case COUNT: {
                return "count";
            }
            case COUNTDISTINCT: {
                return "count";
            }
            case AVG: {
                return "average";
            }
            case MIN: {
                return "minimum";
            }
            case MAX: {
                return "maximum";
            }
            case MEDIAN: {
                return "median";
            }
            case STDDEV: {
                return "standard-deviation";
            }
            case VARIANCE: {
                return "variance";
            }
        }
        return "aggregate";
    }

    public static int getV5SummaryFunctionType(AggregateType aggType) {
        if (aggType == null) {
            return 0;
        }
        switch (aggType) {
            case SUM: {
                return 9;
            }
            case COUNT: {
                return 2;
            }
            case COUNTDISTINCT: {
                return 2;
            }
            case AVG: {
                return 1;
            }
            case MIN: {
                return 6;
            }
            case MAX: {
                return 4;
            }
            case MEDIAN: {
                return 5;
            }
            case STDDEV: {
                return 7;
            }
            case VARIANCE: {
                return 10;
            }
        }
        return 0;
    }

    public static void removeAllChildNodesBefore(IXQEQueryNode aNode, int position) {
        ArrayList<IXQEQueryNode> nodesToRemove = new ArrayList<IXQEQueryNode>();
        for (int j = 0; j < position; ++j) {
            nodesToRemove.add(aNode.getChild(j));
        }
        for (IXQEQueryNode childNode : nodesToRemove) {
            childNode.detach();
        }
    }

    public static V5BoundModelIdentifier createBoundModelIdentifier(IMetadata metadata, XQENodeFactory nodeFactory) {
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        newNode.setIdentifier(metadata.getID());
        newNode.setMetadata(metadata);
        return newNode;
    }

    public static V5MultiPartIdentifier createMultiPartIdentifier(ColumnMetadata column, XQENodeFactory nodeFactory) {
        V5MultiPartIdentifier identifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
        identifier.setIdentifier(column.getColumnId());
        return identifier;
    }

    public static String createMembersAggregateNEW(V5Query query, ColumnMetadata column, String name, List<DataItem> dataItems, DataSet dataset, XQENodeFactory nodeFactory) {
        boolean descendants = false;
        boolean hierarchyProjected = TransformationUtils.hierarchyProjected(column, dataItems, dataset);
        if (hierarchyProjected) {
            descendants = TransformationUtils.generateDescendantsNEW(column, dataItems, dataset);
        }
        StringBuilder expression = new StringBuilder("member ( ");
        if (descendants) {
            expression.append("count ( 1 within set descendants(currentmember(hierarchy(");
            expression.append(column.getHierarchy().getColumnId());
            expression.append(")); ");
            expression.append(column.getColumnId());
            expression.append("))");
        } else if (!hierarchyProjected) {
            expression.append("count ( 1 within set ");
            expression.append("[" + UniqueNameParser.escapeSquareBrackets((String)name) + "]");
            expression.append(")");
        } else {
            expression.append("1");
        }
        expression.append("; '").append(UniqueNameParser.parseLastIdentifierWithEscapedRightSquareBracket((String)column.getColumnId())).append("'; '").append(UniqueNameParser.parseLastIdentifierWithEscapedRightSquareBracket((String)column.getColumnId())).append("')");
        V5Expression v5Expression = (V5Expression)nodeFactory.createNode(101004);
        v5Expression.setExpression(expression.toString());
        String dataItemName = name + "_OLAPAGG";
        TransformationUtils.buildDataItem((IXQEQueryNode)query, dataItemName, null, (IXQEQueryNode)v5Expression, nodeFactory);
        return dataItemName;
    }

    public static ColumnMetadata getLowestProjectedLevel(ColumnMetadata hierarchy, List<DataItem> dimensions, DataSet dataset) {
        List levels = hierarchy.getChildColumns();
        ColumnMetadata lowestLevel = null;
        for (DataItem dim : dimensions) {
            ColumnMetadata queryColumn;
            if (dim.getAggregate() != null || (queryColumn = FilterGenerator.findMetadata(dataset, dim.getItemId())) == null || !hierarchy.equals((Object)queryColumn.getHierarchy())) continue;
            ColumnMetadata level = queryColumn;
            ColumnMetadata.SourceCategory queryColumnSourceCategory = queryColumn.getSourceCategory();
            if (queryColumnSourceCategory != null && queryColumnSourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY) && !TransformationUtils.projectsColumn(level = queryColumn.getParentColumn(), dimensions, dataset)) {
                return level;
            }
            if (level.equals((Object)hierarchy)) {
                return level;
            }
            if (lowestLevel != null && levels.indexOf(level) <= levels.indexOf(lowestLevel)) continue;
            lowestLevel = level;
        }
        return lowestLevel;
    }

    private static boolean projectsColumn(ColumnMetadata parent, List<DataItem> dimensions, DataSet dataset) {
        for (DataItem dim : dimensions) {
            ColumnMetadata queryColumn;
            if (dim.getAggregate() != null || !parent.equals((Object)(queryColumn = FilterGenerator.findMetadata(dataset, dim.getItemId())))) continue;
            return true;
        }
        return false;
    }

    private static boolean hierarchyProjected(ColumnMetadata column, List<DataItem> dimensions, DataSet dataset) {
        ColumnMetadata hierarchy = column.getHierarchy();
        if (hierarchy == null) {
            return false;
        }
        for (DataItem dim : dimensions) {
            if (dim.getAggregate() != null) continue;
            if (dim.getNest().isEmpty()) {
                return TransformationUtils.isHierarchyProjected(hierarchy, dataset, dim.getItemId());
            }
            List nestDataItems = dim.getNest();
            Iterator iterator = nestDataItems.iterator();
            if (!iterator.hasNext()) continue;
            String dataItemId = (String)iterator.next();
            return TransformationUtils.isHierarchyProjected(hierarchy, dataset, dataItemId);
        }
        return false;
    }

    private static boolean isHierarchyProjected(ColumnMetadata hierarchy, DataSet dataset, String dataItemId) {
        ColumnMetadata queryColumn = FilterGenerator.findMetadata(dataset, dataItemId);
        if (queryColumn == null) {
            return false;
        }
        ColumnMetadata queryColumnHierarchy = queryColumn.getHierarchy();
        return hierarchy.equals((Object)queryColumnHierarchy);
    }

    private static boolean generateDescendantsNEW(ColumnMetadata column, List<DataItem> dimensions, DataSet dataset) {
        ColumnMetadata.SourceCategory memberSourceCategory;
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        ColumnMetadata memberColumn = column;
        if (sourceCategory != null && sourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY)) {
            memberColumn = column.getParentColumn();
        }
        if ((memberSourceCategory = column.getSourceCategory()) != null && (memberSourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) || memberSourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD))) {
            return false;
        }
        ColumnMetadata parent = memberColumn.getParentColumn();
        List levels = parent.getChildColumns();
        for (DataItem dim : dimensions) {
            if (dim.getAggregate() != null) continue;
            if (dim.getNest().isEmpty()) {
                if (!TransformationUtils.isDesendantsGenerated(dataset, dim.getItemId(), column, parent, levels, memberColumn)) continue;
                return true;
            }
            List nestDataItems = dim.getNest();
            for (String dataItemId : nestDataItems) {
                if (!TransformationUtils.isDesendantsGenerated(dataset, dataItemId, column, parent, levels, memberColumn)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDesendantsGenerated(DataSet dataset, String itemId, ColumnMetadata column, ColumnMetadata parent, List<ColumnMetadata> levels, ColumnMetadata memberColumn) {
        ColumnMetadata queryColumn = FilterGenerator.findMetadata(dataset, itemId);
        if (!column.equals((Object)queryColumn) && queryColumn != null) {
            ColumnMetadata hierarchy;
            ColumnMetadata queryMemberColumn = queryColumn;
            ColumnMetadata.SourceCategory queryColumnSourceCategory = queryColumn.getSourceCategory();
            if (queryColumnSourceCategory != null && queryColumnSourceCategory.equals((Object)ColumnMetadata.SourceCategory.PROPERTY)) {
                queryMemberColumn = queryColumn.getParentColumn();
            }
            if (parent.equals((Object)(hierarchy = queryMemberColumn.getParentColumn())) && levels.indexOf(queryMemberColumn) < levels.indexOf(memberColumn)) {
                return true;
            }
        }
        return false;
    }

    public static V5Query buildV5QueryNode(XQENodeFactory nodeFactory, String name, V5Query sourceQuery, Boolean isModule, QueryHints hints) {
        V5Query v5Query = (V5Query)nodeFactory.createNode(101006);
        v5Query.setStringPropertyValue("name", name != null ? name : QUERY_NAME_DEFAULT_VALUE);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), (Object)"true");
        v5Query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), (Object)Governors.ExecutionOptimization.ALLROWS.toString());
        if (hints != null) {
            Map ap = hints.getAdditionalProperties();
            String v = (String)ap.get(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName());
            if (v != null && Governors.ExecutionOptimization.FIRSTROW.toString().equalsIgnoreCase(v)) {
                v5Query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), (Object)Governors.ExecutionOptimization.FIRSTROW.toString());
            }
            String dataCacheExpiry = (String)ap.get(V5Query.QueryHint.DATA_CACHE_EXPIRY.getPropertyName());
            String dataCacheUsePolicy = (String)ap.get(V5Query.QueryHint.DATA_CACHE_USE_POLICY.getPropertyName());
            if (dataCacheExpiry != null || dataCacheUsePolicy != null) {
                if (dataCacheExpiry != null && !"automatic".equalsIgnoreCase(dataCacheExpiry)) {
                    v5Query.setPropertyValue(V5Query.QueryHint.DATA_CACHE_EXPIRY.getPropertyName(), (Object)dataCacheExpiry);
                }
                if (dataCacheUsePolicy != null) {
                    v5Query.setPropertyValue(V5Query.QueryHint.DATA_CACHE_USE_POLICY.getPropertyName(), (Object)dataCacheUsePolicy);
                }
            } else {
                String localCache = (String)ap.get(V5Query.QueryHint.LOCAL_CACHE.getPropertyName());
                if (localCache != null) {
                    if (localCache.equalsIgnoreCase("yes")) {
                        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), (Object)true);
                    } else if (localCache.equalsIgnoreCase("no")) {
                        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), (Object)false);
                    }
                }
            }
        }
        v5Query.setPropertyValue("containsQueryHint", (Object)Boolean.TRUE);
        v5Query.setPropertyValue(V5Query.QueryHint.TREAT_EMPTY_DMR_MUN.getPropertyName(), (Object)Governors.DMREmptyMUNTreatment.EMPTY_OR_NULL.getValue());
        v5Query.setPropertyValue("isTabular", (Object)Boolean.TRUE);
        v5Query.setIsReferenced();
        V5Source v5Source = (V5Source)nodeFactory.createNode(101007);
        V5Selection v5Selection = (V5Selection)nodeFactory.createNode(101009);
        if (sourceQuery != null) {
            v5Query.setPropertyValue("sourceModule", (Object)Boolean.FALSE);
            String refName = (String)sourceQuery.getPropertyValue("name");
            v5Source.setQueryRef(refName);
        } else {
            v5Query.setPropertyValue("sourceModule", (Object)isModule);
        }
        v5Query.addChild((IXQEQueryNode)v5Source);
        v5Query.addChild((IXQEQueryNode)v5Selection);
        return v5Query;
    }

    public static V5Query buildV5QueryNodeDEPRECATED(XQENodeFactory nodeFactory, String name, V5Query sourceQuery, XQELocalCacheController localCacheController, Boolean isModule) {
        V5Query v5Query = (V5Query)nodeFactory.createNode(101006);
        v5Query.setStringPropertyValue("name", name != null ? name : QUERY_NAME_DEFAULT_VALUE);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), (Object)"true");
        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), (Object)localCacheController.isXQELocalCacheEnabled());
        v5Query.setPropertyValue("containsQueryHint", (Object)Boolean.TRUE);
        Governors governorObj = localCacheController.getLocalCachePolicyGovernor(v5Query);
        if (governorObj != null) {
            v5Query.setGovernors(governorObj);
        }
        v5Query.setPropertyValue("isTabular", (Object)Boolean.TRUE);
        v5Query.setIsReferenced();
        V5Source v5Source = (V5Source)nodeFactory.createNode(101007);
        V5Selection v5Selection = (V5Selection)nodeFactory.createNode(101009);
        if (sourceQuery != null) {
            v5Query.setPropertyValue("sourceModule", (Object)Boolean.FALSE);
            String refName = (String)sourceQuery.getPropertyValue("name");
            v5Source.setQueryRef(refName);
        } else {
            v5Query.setPropertyValue("sourceModule", (Object)isModule);
        }
        v5Query.addChild((IXQEQueryNode)v5Source);
        v5Query.addChild((IXQEQueryNode)v5Selection);
        return v5Query;
    }

    public static V5BoundDataItemReference createBoundDataItemReference(V5Query query, String name, XQENodeFactory nodeFactory, boolean isInterQueryRef) {
        V5DataItem dataItem = query.getDataItemByName(name);
        if (dataItem == null) {
            return null;
        }
        V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
        if (isInterQueryRef) {
            newNode.setIdentifier(TransformationUtils.createInterQueryRefName(query, name));
            newNode.setPropertyValue("isQueryRefItem", (Object)Boolean.TRUE);
        } else {
            newNode.setIdentifier(UniqueNameGenerator.createUniqueName((String)name));
        }
        newNode.setRefDataItem(dataItem);
        return newNode;
    }

    public static String createInterQueryRefName(V5Query query, String v5DataItemName) {
        String queryName = (String)query.getPropertyValue("name");
        String escapedName = UniqueNameParser.escapeSquareBrackets((String)v5DataItemName);
        return UniqueNameGenerator.createUniqueName((String)queryName, (String)escapedName);
    }

    public static V5PropertyExpression createV5PropertyExpression(XQENodeFactory nodeFactory, RoleTypeEnum role) {
        V5PropertyExpression v5PropertyExpression = (V5PropertyExpression)nodeFactory.createNode(101054);
        V5RoleValueFunction v5RoleValueFn = (V5RoleValueFunction)nodeFactory.createNode(201098);
        V5LiteralValue v5LiteralValue = (V5LiteralValue)nodeFactory.createNode(201026);
        v5LiteralValue.setDataType((IDataType)StringType.DEFAULTSTRINGTYPE);
        v5LiteralValue.setValue(role.toV5Keyword());
        v5RoleValueFn.addChild((IXQEQueryNode)v5LiteralValue);
        v5PropertyExpression.addChild((IXQEQueryNode)v5RoleValueFn);
        return v5PropertyExpression;
    }

    public static V5MemberUniqueName createV5MemberUniqueNameForFUN(XQENodeFactory nodeFactory, String facetUniqueName, Locale locale) {
        V5MemberUniqueName v5MemberUniqueName = (V5MemberUniqueName)nodeFactory.createNode(201028);
        SimpleNode node = TransformationUtils.parseUsingNewParser(facetUniqueName, locale);
        if (node != null && node instanceof ASTMemberUniqueName) {
            String logical = ((ASTMemberUniqueName)node).getLogical();
            String model = ((ASTMemberUniqueName)node).getModel();
            String physical = ((ASTMemberUniqueName)node).getPhysical();
            String nativeName = ((ASTMemberUniqueName)node).getNativeName();
            v5MemberUniqueName.setLogical(logical);
            if (model != null) {
                v5MemberUniqueName.setModel(model);
            }
            if (physical != null) {
                v5MemberUniqueName.setPhysical(physical);
            }
            if (nativeName != null) {
                v5MemberUniqueName.setNativeName(nativeName);
            }
        } else {
            return null;
        }
        return v5MemberUniqueName;
    }

    private static SimpleNode parseUsingNewParser(String expression, Locale expressionLocale) {
        SimpleNode parserNode = null;
        try {
            parserNode = V5ExpressionParserUtil.parseExpression((String)expression, (Locale)expressionLocale);
        }
        catch (ParseException parseException) {
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parserNode;
    }

    public static TopBottom getTopBottomBeforeGiven(Action anAction, DataItem dataItem) {
        for (Action currAction : dataItem.getSelection()) {
            if (currAction.equals((Object)anAction)) {
                return null;
            }
            if (null == currAction.getTopBottom()) continue;
            return currAction.getTopBottom();
        }
        return null;
    }

    public static boolean getMultiEdgeSortQueryHint(QuerySpec qs) {
        XQEConfiguration configuration;
        QueryHints qh;
        Map ap;
        Object hintValue;
        boolean multiEdgeSort = false;
        boolean hint = false;
        if (qs.getQueryHints() != null && (hintValue = (ap = (qh = qs.getQueryHints()).getAdditionalProperties()).get("multiEdgeSort")) != null) {
            multiEdgeSort = (Boolean)hintValue;
            hint = true;
        }
        if (!hint && (configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getBooleanProperty("queryPlanning.multiEdgeSort.[@enabled]", false)) {
            multiEdgeSort = true;
        }
        return multiEdgeSort;
    }

    public static String getDeflectedDataItemName(String deflectedReference) {
        return "_MIN (" + deflectedReference + ")";
    }

    public static boolean isMemberSet(ColumnMetadata column) {
        if (column == null) {
            return false;
        }
        ColumnMetadata.SourceCategory sourceCategory = column.getSourceCategory();
        return sourceCategory != null && (sourceCategory.equals((Object)ColumnMetadata.SourceCategory.LEVEL) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.NAMED_SET));
    }

    public static enum FoundV5DataItem {
        SAME_EXPRESSION,
        NOT_FOUND,
        DIFFERENT_EXPRESSION;

    }
}

