/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.service.IQSResultSet;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.xqe.results.QsResultSet;
import com.ibm.bi.qs.xqe.v5.BaseExecutor;
import com.ibm.bi.qs.xqe.v5.QueryFeedbackWrapper;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5DataExecutor
extends BaseExecutor {
    public static final String REQUEST_TYPE = V5DataExecutor.class.getSimpleName();
    public static final String EXECUTE_KEY = "execute";
    public static final String QUERYSET_XML_TAG = "querySet";
    public static final String __XML_MAPPER = "xmlMapper";
    public static final int DEFAULT_LIMIT = 1000;
    private QuerySpec querySpec;
    private Integer limit;
    private boolean isLimitProvided;
    private Map<Object, Object> jsonQuerySetSpec;
    private String xmlQuerySetSpec;
    private XmlMapper xmlMapper;

    public V5DataExecutor(QuerySpec querySpec, DataSet dataset, ServletRequestContext servletRequestContext) {
        super(servletRequestContext, REQUEST_TYPE, dataset);
        this.querySpec = querySpec;
        this.isLimitProvided = null != querySpec.getLimit();
        this.limit = this.isLimitProvided ? querySpec.getLimit() : 1000;
        this.timeLimit = querySpec.getTimeLimit();
        this.setRequestAndGlobalParameterValues(querySpec);
        this.setConnections(querySpec.getConnections());
        this.xmlMapper = (XmlMapper)servletRequestContext.getContextAttribute(__XML_MAPPER);
        this.xmlMapper.configure(FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL, true);
        String qfbValue = null;
        String qfbLevel = null;
        String qfbMode = null;
        if (null != servletRequestContext.getHttpServletRequest()) {
            qfbValue = servletRequestContext.getHttpServletRequest().getParameter("qfb");
            qfbLevel = servletRequestContext.getHttpServletRequest().getParameter("qfbLevel");
            qfbMode = servletRequestContext.getHttpServletRequest().getParameter("qfbMode");
        }
        this.qfbWrapper = new QueryFeedbackWrapper(qfbValue);
        this.qfbWrapper.setSeverityLevel(qfbLevel);
        this.qfbWrapper.setQueryFeedbackMode(qfbMode);
        this.qfbWrapper.setMetadataRetrievalTime(servletRequestContext.getMetadataRetrievalTime());
        if (querySpec.getV5QuerySet() instanceof Map) {
            this.jsonQuerySetSpec = (Map)querySpec.getV5QuerySet();
            this.augmentRawJSONV5QuerySpec();
            this.mergePropertiesToRawJSONV5QuerySpec();
        } else if (querySpec.getV5QuerySet() instanceof String) {
            this.xmlQuerySetSpec = (String)querySpec.getV5QuerySet();
        }
        String errMsg = this.validateQuerySpec();
        if (null != errMsg) {
            throw new IllegalStateException(errMsg);
        }
    }

    @Override
    public boolean convertsXMLToJSON() {
        return null == this.jsonQuerySetSpec;
    }

    public boolean isLimitProvided() {
        return this.isLimitProvided;
    }

    public int getLimit() {
        return this.limit;
    }

    protected void augmentRawJSONV5QuerySpec() {
        this.jsonQuerySetSpec.put("attr:forREST", true);
    }

    protected void mergePropertiesToRawJSONV5QuerySpec() {
        Map qrds;
        Object qrdPart;
        Object qrdsPart;
        LinkedHashMap<String, String> modelPath;
        Object modelPathPart = this.jsonQuerySetSpec.get("modelPath");
        DataSetType dsType = this.dataset.getType();
        if (!dsType.equals((Object)DataSetType.REPORT) && !dsType.equals((Object)DataSetType.PACKAGE)) {
            dsType = DataSetType.MODULE;
        }
        if (modelPathPart instanceof Map) {
            modelPath = (LinkedHashMap<String, String>)modelPathPart;
            Object modelPathValue = modelPath.get("content:");
            if (null == modelPathValue) {
                modelPath.put("attr:type", dsType.toString());
                modelPath.put("content:", this.dataset.getModuleConnectionPath());
            }
        } else if (null == modelPathPart) {
            modelPath = new LinkedHashMap<String, String>();
            modelPath.put("attr:type", dsType.toString());
            modelPath.put("content:", this.dataset.getModuleConnectionPath());
            this.jsonQuerySetSpec.put("modelPath", modelPath);
        }
        if (this.isLimitProvided && (qrdsPart = this.jsonQuerySetSpec.get("queryResultDefinitions")) instanceof Map && (qrdPart = (qrds = (Map)qrdsPart).get("queryResultDefinition")) instanceof List) {
            List qrdList = (List)qrdPart;
            for (Object qrdEntity : qrdList) {
                Map qrd;
                if (!(qrdEntity instanceof Map) || null != (qrd = (Map)qrdEntity).get("attr:topNRows")) continue;
                qrd.put("attr:topNRows", this.limit);
            }
        }
    }

    private String validateQuerySpec() {
        StringBuilder errMsg = null;
        String error1 = "Found no QRD. ";
        String error2 = "A single QRD is expected.";
        if (null != this.jsonQuerySetSpec) {
            Object qrdsPart = this.jsonQuerySetSpec.get("queryResultDefinitions");
            if (qrdsPart instanceof Map) {
                Map qrds = (Map)qrdsPart;
                Object qrdPart = qrds.get("queryResultDefinition");
                if (qrdPart == null) {
                    errMsg = new StringBuilder(error1);
                    errMsg.append(error2);
                }
                if (qrdPart instanceof List) {
                    List qrdList = (List)qrdPart;
                    if (qrdList.isEmpty()) {
                        errMsg = new StringBuilder(error1);
                        errMsg.append(error2);
                    } else if (qrdList.size() != 1) {
                        errMsg = new StringBuilder(error2);
                    }
                }
            }
        } else if (null != this.xmlQuerySetSpec) {
            String qrdStart = "<queryResultDefinition ";
            int qrdPos = this.xmlQuerySetSpec.indexOf("<queryResultDefinition ");
            if (qrdPos == -1) {
                errMsg = new StringBuilder(error1);
                errMsg.append(error2);
            }
            if ((qrdPos = this.xmlQuerySetSpec.substring(qrdPos + qrdStart.length()).indexOf("<queryResultDefinition ")) > -1) {
                errMsg = new StringBuilder(error2);
            }
        }
        if (errMsg != null) {
            return errMsg.toString();
        }
        return null;
    }

    @Override
    public DataSet getDataSet() {
        return this.dataset;
    }

    @Override
    protected Date getLastModifiedFromQueryPlan() {
        if (this.plannedQuery instanceof PlannedV5QuerySet) {
            return ((PlannedV5QuerySet)this.plannedQuery).getLastModified();
        }
        return null;
    }

    public String generateJSONAsString() throws IOException {
        JsonNode jsonNode = (JsonNode)this.xmlMapper.readValue(this.xmlQuerySetSpec, JsonNode.class);
        if (jsonNode instanceof ObjectNode) {
            ((ObjectNode)jsonNode).put("version", this.querySpec.getVersion());
        }
        return jsonNode.toString();
    }

    @Override
    public Document generateDocument() throws JsonProcessingException, DocumentException {
        this.qfbWrapper.startRequestMarshalling();
        Document document = null;
        if (!this.convertsXMLToJSON()) {
            Element execute = DocumentHelper.createElement((String)EXECUTE_KEY);
            document = DocumentHelper.parseText((String)this.generateV5RawXMLQuerySetAsString());
            execute.add(document.getRootElement());
            this.qfbWrapper.augmentV5Request(execute);
            document.setRootElement(execute);
        } else {
            document = DocumentHelper.parseText((String)this.xmlQuerySetSpec);
        }
        this.qfbWrapper.endRequestMarshalling();
        return document;
    }

    public String generateV5RawXMLQuerySetAsString() throws JsonProcessingException {
        return this.xmlMapper.writer().withRootName(QUERYSET_XML_TAG).writeValueAsString(this.jsonQuerySetSpec);
    }

    @Override
    public void planExecution() {
        this.plannedQuery = this.planQuery(false, false);
    }

    @Override
    public String getExecutionPlan() throws Exception {
        if (!this.convertsXMLToJSON()) {
            return this.generateDocument().asXML();
        }
        return this.generateJSONAsString();
    }

    public IQSResultSet executeImpl() {
        IV5ResultSet[] v5ResultSets = null;
        RSAPIDataset rsDataset = null;
        if (!this.qfbWrapper.isValidateMode()) {
            RequestEnvironment reqEnv = this.envHelper.getRequestEnvironment();
            ParameterAccessCoordinator reqPAC = reqEnv.getRequestPAC();
            if (reqPAC == null) {
                reqEnv.setRequestPAC(this.requestPAC);
            }
            this.bindParameterValues(reqEnv);
            this.createDataSourceConnections(reqEnv);
            v5ResultSets = this.executeV5Request(reqEnv, this.plannedQuery);
            rsDataset = (RSAPIDataset)this.plannedQuery.getFirstDescendantOfTypeOrdered(401005, false);
        }
        return new QsResultSet(this.querySpec, (IV5ResultSet)v5ResultSets[0], rsDataset, this.limit.intValue(), this.qfbWrapper);
    }
}

