/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.xqe.v5;

import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.Governors;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.QueryHint;

public class XQELocalCacheController {
    private boolean isXQELocalCacheEnabled = false;
    private DataSet dataSet;

    public XQELocalCacheController(DataSet dataset, QueryHint queryHint) {
        this.dataSet = dataset;
        XQEConfiguration configuration = this.getXQEConfiguration();
        this.isXQELocalCacheEnabled = configuration.getBooleanProperty("queryExecution.dataSetServiceLocalCache[@enabled]", false);
        if (this.isXQELocalCacheEnabled) {
            DataSetType type = dataset.getType();
            switch (type) {
                case DATASET2: 
                case UPLOADEDFILE: {
                    this.isXQELocalCacheEnabled = false;
                    break;
                }
                default: {
                    if (!queryHint.getRealtimeRefresh()) break;
                    this.isXQELocalCacheEnabled = false;
                }
            }
        }
    }

    public boolean isXQELocalCacheEnabled() {
        return this.isXQELocalCacheEnabled;
    }

    public Governors getLocalCachePolicyGovernor(V5Query v5Query) {
        Governors governorObj = null;
        if (this.isXQELocalCacheEnabled && this.dataSet.getType().equals((Object)DataSetType.MODULE) && !this.dataSet.getContainsPackage()) {
            governorObj = v5Query.getGovernors();
            governorObj = governorObj != null ? governorObj.copy() : new Governors();
            governorObj.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
        }
        return governorObj;
    }

    protected XQEConfiguration getXQEConfiguration() {
        return XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    }
}

