/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiFieldDesc;
import com.cognos.xqe.conn.bapi.JBapiStructure;
import com.cognos.xqe.conn.bapi.JBapiTable;
import java.util.TreeMap;

public class JBapiComplex {
    protected String mName = "";
    protected long mPHandle;
    private TreeMap<String, JBapiTable> mTableMap = null;
    private TreeMap<String, JBapiStructure> mStructureMap = null;
    protected int mFldCount = -1;
    protected JBapiFieldDesc[] mFldArray = null;

    public final boolean assignHandle(long paramHandle, String paramName) {
        if (paramHandle <= 0L) {
            return false;
        }
        this.mPHandle = paramHandle;
        this.mName = paramName;
        return true;
    }

    public final boolean isNested() {
        try {
            return JBapiComplex.CBComplIsNested(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("isNested: " + e.getMessage());
        }
    }

    public final long getHandle() {
        return this.mPHandle;
    }

    public final int getNumFields() {
        if (this.mFldCount < 0) {
            this.mFldCount = JBapiComplex.CBCompFieldCount(this.mPHandle);
        }
        return this.mFldCount;
    }

    public final int getStructLength(boolean bAsNUC) {
        int nLen = 0;
        try {
            nLen = JBapiComplex.CBCompGetStructLength(this.mPHandle, bAsNUC);
        }
        catch (JBapiException e) {
            throw new JBapiException("getStructLength: " + e.getMessage());
        }
        return nLen;
    }

    public final JBapiFieldDesc getFieldDesc(int fldIndex) {
        try {
            if (this.mFldArray == null) {
                this.mFldCount = JBapiComplex.CBCompFieldCount(this.mPHandle);
                if (this.mFldCount > 0) {
                    this.mFldArray = new JBapiFieldDesc[this.mFldCount];
                    for (int n = 0; n < this.mFldCount; ++n) {
                        this.mFldArray[n] = new JBapiFieldDesc();
                        JBapiComplex.CBCompGetFieldDesc(this.mPHandle, n, this.mFldArray[n]);
                    }
                }
            }
            if (fldIndex < 0 || fldIndex >= this.mFldCount) {
                return null;
            }
            return this.mFldArray[fldIndex];
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldDesc: " + e.getMessage());
        }
    }

    public final String getFieldName(int fldNumber) throws JBapiException {
        return JBapiComplex.CBCompGetFieldName(this.mPHandle, fldNumber);
    }

    public final boolean copyDataFrom(long srcHandle, boolean bInclComplex, boolean bForce) {
        try {
            if (JBapiComplex.CBComplCopyDataFrom(this.mPHandle, srcHandle, bInclComplex, bForce) > 0L) {
                return true;
            }
        }
        catch (JBapiException e) {
            throw new JBapiException("copyDataFrom: " + e.getMessage());
        }
        return false;
    }

    public final JBapiTable getTableField(String fieldName) {
        long hCurrent = 0L;
        JBapiTable retObj = null;
        try {
            hCurrent = JBapiComplex.CBComplGetNestedTable(this.mPHandle, fieldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getTableField: " + e.getMessage());
        }
        if (hCurrent == 0L) {
            throw new JBapiException("getTableField: No handle retrieved!");
        }
        if (this.mTableMap == null) {
            this.mTableMap = new TreeMap();
        }
        if ((retObj = this.mTableMap.get(fieldName)) == null) {
            retObj = new JBapiTable(hCurrent, fieldName);
            this.mTableMap.put(fieldName, retObj);
        }
        return retObj;
    }

    public final JBapiStructure getStructureField(String fieldName) {
        long hCurrent = 0L;
        JBapiStructure retObj = null;
        try {
            hCurrent = JBapiComplex.CBComplGetNestedStructure(this.mPHandle, fieldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getStructureField: " + e.getMessage());
        }
        if (hCurrent == 0L) {
            throw new JBapiException("getStructureField: No handle retrieved!");
        }
        if (this.mStructureMap == null) {
            this.mStructureMap = new TreeMap();
        }
        if ((retObj = this.mStructureMap.get(fieldName)) == null) {
            retObj = new JBapiStructure(hCurrent, fieldName);
            this.mStructureMap.put(fieldName, retObj);
        }
        return retObj;
    }

    public final String getFieldByIndex(int fldIndex) throws JBapiException {
        try {
            return JBapiComplex.CBComplGetFieldByIndex(this.mPHandle, fldIndex);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldByIndex: " + e.getMessage());
        }
    }

    public final int getFieldByIndexX(int fldIndex, char[] pDest) throws JBapiException {
        try {
            return JBapiComplex.CBComplGetFieldByIndexX(this.mPHandle, fldIndex, pDest, pDest.length);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldByIndexX error: " + e.getMessage());
        }
    }

    public final int getFieldIntByIndex(int fldIndex) {
        try {
            return JBapiComplex.CBComplGetIntByIndex(this.mPHandle, fldIndex);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldIntByIndex error: " + e.getMessage());
        }
    }

    public final int getFieldInt(String fldName) throws JBapiException {
        try {
            return JBapiComplex.CBCompGetFieldInt(this.mPHandle, fldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldInt: " + e.getMessage());
        }
    }

    public final long getFieldLongByIndexX(int fldIndex) throws JBapiException {
        try {
            String val = JBapiComplex.CBComplGetFieldByIndex(this.mPHandle, fldIndex);
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(nfe.getMessage());
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldLongByIndexX error: " + e.getMessage());
        }
    }

    public final double getFieldFloatByIndex(int fldIndex) {
        try {
            return JBapiComplex.CBComplGetFloatByIndex(this.mPHandle, fldIndex);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldFloatByIndex error: " + e.getMessage());
        }
    }

    public final double getFieldFloatByIndexX(int fldIndex) throws JBapiException {
        double ret = 0.0;
        try {
            String val = JBapiComplex.CBComplGetFieldByIndex(this.mPHandle, fldIndex);
            ret = Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException("getFieldFloatByIndexX error: " + nfe.getMessage());
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldFloatByIndexX error: " + e.getMessage());
        }
        return ret;
    }

    public final int getFieldBool(String fldName) throws JBapiException {
        try {
            return JBapiComplex.CBComplGetFieldBool(this.mPHandle, fldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldBool: " + e.getMessage());
        }
    }

    public final int getFieldBoolByIndex(int fldIndex) throws JBapiException {
        try {
            return JBapiComplex.CBComplGetFieldBoolByIdx(this.mPHandle, fldIndex);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldBool: " + e.getMessage());
        }
    }

    public final void setFieldByIndex(int fldIndex, String value) throws JBapiException {
        try {
            JBapiComplex.CBComplSetFieldByIndex(this.mPHandle, fldIndex, value);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldByIndex: " + e.getMessage());
        }
    }

    public final int setFieldIntByIndex(int fldIndex, int value) {
        try {
            return JBapiComplex.CBComplSetIntByIndex(this.mPHandle, fldIndex, value);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldIntByIndex error: " + e.getMessage());
        }
    }

    public final void setFieldInt(String fldName, int value) throws JBapiException {
        try {
            JBapiComplex.CBCompSetFieldInt(this.mPHandle, fldName, value);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldInt: " + e.getMessage());
        }
    }

    public final int setFieldFloatByIndex(int fldIndex, double value) {
        try {
            return JBapiComplex.CBComplSetFloatByIndex(this.mPHandle, fldIndex, value);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldFloatByIndex error: " + e.getMessage());
        }
    }

    public final void setFieldBool(String fldName, int bValue) throws JBapiException {
        try {
            JBapiComplex.CBComplSetFieldBool(this.mPHandle, fldName, bValue);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldBool: " + e.getMessage());
        }
    }

    public final void setFieldBoolByIndex(int fldIndex, int bValue) throws JBapiException {
        try {
            JBapiComplex.CBComplSetFieldBoolByIdx(this.mPHandle, fldIndex, bValue);
        }
        catch (JBapiException e) {
            throw new JBapiException("setFieldBoolByIndex: " + e.getMessage());
        }
    }

    public final long getRFCHandle(boolean bParent, boolean bUpdate) {
        try {
            return JBapiComplex.CBComplGetRFCHandle(this.mPHandle, bParent, bUpdate);
        }
        catch (JBapiException e) {
            throw new JBapiException("getRFCHandle error: " + e.getMessage());
        }
    }

    public String getName() {
        return this.mName;
    }

    private static native boolean CBComplIsNested(long var0) throws JBapiException;

    private static native long CBComplGetNestedTable(long var0, String var2) throws JBapiException;

    private static native long CBComplGetNestedStructure(long var0, String var2) throws JBapiException;

    private static native int CBCompGetStructLength(long var0, boolean var2) throws JBapiException;

    private static native int CBCompGetFieldDesc(long var0, int var2, JBapiFieldDesc var3) throws JBapiException;

    private static native int CBCompFieldCount(long var0) throws JBapiException;

    private static native String CBCompGetFieldName(long var0, int var2) throws JBapiException;

    private static native void CBCompSetFieldInt(long var0, String var2, int var3) throws JBapiException;

    private static native int CBCompGetFieldInt(long var0, String var2) throws JBapiException;

    private static native String CBComplGetFieldByIndex(long var0, int var2) throws JBapiException;

    private static native int CBComplGetFieldByIndexX(long var0, int var2, char[] var3, int var4) throws JBapiException;

    private static native int CBComplGetIntByIndex(long var0, int var2) throws JBapiException;

    private static native double CBComplGetFloatByIndex(long var0, int var2) throws JBapiException;

    private static native void CBComplSetFieldByIndex(long var0, int var2, String var3) throws JBapiException;

    private static native int CBComplSetIntByIndex(long var0, int var2, int var3) throws JBapiException;

    private static native int CBComplSetFloatByIndex(long var0, int var2, double var3) throws JBapiException;

    private static native long CBComplCopyDataFrom(long var0, long var2, boolean var4, boolean var5) throws JBapiException;

    private static native long CBComplGetRFCHandle(long var0, boolean var2, boolean var3) throws JBapiException;

    private static native int CBComplGetFieldBool(long var0, String var2) throws JBapiException;

    private static native int CBComplGetFieldBoolByIdx(long var0, int var2) throws JBapiException;

    private static native void CBComplSetFieldBool(long var0, String var2, int var3) throws JBapiException;

    private static native void CBComplSetFieldBoolByIdx(long var0, int var2, int var3) throws JBapiException;
}

