/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiConnectAttribs;
import com.cognos.xqe.conn.bapi.JBapiException;

public class JBapiConnect {
    private static final long serialVersionUID = 1005L;
    public static final String DEF_ENCODING = "utf-16le";
    private String mCnctString = null;
    private String mCharSetName = null;
    private JBapiConnectAttribs mCnctAttrs = null;
    private long mHCnct = 0L;
    private boolean mIsInvalid = false;

    public JBapiConnect() {
        this.mCharSetName = DEF_ENCODING;
    }

    public JBapiConnect(String charSetName) {
        this.mCharSetName = charSetName;
    }

    public final String getConnectString() throws JBapiException {
        return this.mCnctString;
    }

    public String getCharSet() {
        return this.mCharSetName;
    }

    public final JBapiConnectAttribs getConnectAttribs() throws JBapiException {
        if (this.mCnctAttrs == null) {
            this.mCnctAttrs = new JBapiConnectAttribs();
        }
        try {
            JBapiConnect.CBGetConnectAttribs(this.mHCnct, this.mCnctAttrs);
        }
        catch (JBapiException e) {
            throw new JBapiException("getConnectAttribs: " + e.getMessage());
        }
        return this.mCnctAttrs;
    }

    public String getSAPSystemVersion() throws JBapiException {
        if (this.mCnctAttrs == null) {
            this.getConnectAttribs();
        }
        return this.mCnctAttrs.sapRel;
    }

    public String getSAPKernelVersion() throws JBapiException {
        if (this.mCnctAttrs == null) {
            this.getConnectAttribs();
        }
        return this.mCnctAttrs.sapKernel;
    }

    public final void connect(String connection) throws JBapiException {
        this.mHCnct = JBapiConnect.CBConnect(connection);
    }

    public final void disconnect() throws JBapiException {
        if (this.mHCnct > 0L) {
            JBapiConnect.CBDisconnect(this.mHCnct);
        }
    }

    public final void invalidateConnection() {
        this.mIsInvalid = true;
    }

    public final boolean isValid(boolean bEnsure) throws JBapiException {
        if (!bEnsure && this.mIsInvalid) {
            return false;
        }
        try {
            return JBapiConnect.CBCheckHandle(this.mHCnct);
        }
        catch (JBapiException e) {
            throw new JBapiException("isValid: " + e.getMessage());
        }
    }

    public final boolean resetUserContext(boolean bClrCache) throws JBapiException {
        try {
            return JBapiConnect.CBResetUserContext(this.mHCnct, bClrCache);
        }
        catch (JBapiException e) {
            throw new JBapiException("resetUserContext: " + e.getMessage());
        }
    }

    public final int checkFunctionExists(String funcName) throws JBapiException {
        try {
            return JBapiConnect.CBCheckFunctionExists(this.mHCnct, funcName);
        }
        catch (JBapiException e) {
            throw new JBapiException("checkFunctionExists: " + e.getMessage());
        }
    }

    public final long getHandle() {
        return this.mHCnct;
    }

    private static native long CBConnect(String var0) throws JBapiException;

    private static native void CBDisconnect(long var0) throws JBapiException;

    private static native boolean CBCheckHandle(long var0) throws JBapiException;

    private static native int CBCheckFunctionExists(long var0, String var2) throws JBapiException;

    private static native int CBGetConnectAttribs(long var0, JBapiConnectAttribs var2) throws JBapiException;

    private static native boolean CBResetUserContext(long var0, boolean var2) throws JBapiException;
}

