/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher.logging;

import com.ibm.ba.flint.launcher.logging.JsonEventProcessor;
import com.ibm.ba.flint.launcher.logging.JsonEventReader;
import com.ibm.ba.flint.launcher.logging.JsonEventSocketServer;
import com.ibm.ba.flint.launcher.logging.LogEventHandler;
import com.ibm.ba.flint.launcher.logging.LogEventReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonEventReceiver
implements LogEventReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonEventSocketServer.class);
    private volatile boolean closed = false;
    private volatile boolean running = false;
    private ExecutorService executor;
    private volatile JsonEventProcessor processor;
    private volatile LogEventHandler handler;

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public final synchronized void start(LogEventHandler theHandler) {
        if (this.running) {
            throw new IllegalStateException("receiver is already running");
        }
        if (this.closed) {
            throw new IllegalStateException("receiver was closed");
        }
        if (null == theHandler) {
            throw new NullPointerException("theHandler was null");
        }
        this.running = true;
        this.handler = theHandler;
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(this::doRun);
        this.onStarted();
    }

    private synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.executor.shutdownNow();
        JsonEventProcessor theProcessor = this.processor;
        if (null != theProcessor) {
            theProcessor.close();
            this.processor = null;
        }
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOGGER.error("Timed out waiting for executor to terminate");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while stopping JsonEventReceiver", (Throwable)e);
        }
        finally {
            this.handler = null;
            this.executor = null;
            this.onStopped();
        }
    }

    @Override
    public final void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        try {
            if (this.isRunning()) {
                this.stop();
            }
        }
        finally {
            this.onClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processStream(InputStream stream) throws IOException {
        try (JsonEventProcessor theProcessor = new JsonEventProcessor(new JsonEventReader(stream), this.handler);){
            this.processor = theProcessor;
            if (!this.running) {
                return;
            }
            theProcessor.process();
        }
        finally {
            this.processor = null;
        }
    }

    protected abstract void onStarted();

    protected abstract void onStopped();

    protected abstract void onClosed();

    protected abstract void doRun();
}

