/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request;

import com.cognos.cdms.ds.sforce.request.SForceException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceAPIRequestTracker {
    private static final Logger logger = LoggerFactory.getLogger(SForceAPIRequestTracker.class);
    private static HashMap<String, SForceOrganizationLevelPermit> organizationObjects = new HashMap(10);
    private static ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private static AtomicInteger numberOfActiveRequests = new AtomicInteger(0);
    private static Object DUMMY = new Object();

    private SForceAPIRequestTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long startRequest(String organizationId, String userKey, boolean getUserLevelPermit, int maxConcurrentCallsLimit, int userConcurrentCallsLimit) {
        SForceOrganizationLevelPermit request = null;
        long requestId = RequestId.getNextId();
        if (logger.isDebugEnabled()) {
            logger.debug("Start new Request Trying to acquire permit" + requestId);
        }
        Lock readLock = globalLock.readLock();
        try {
            readLock.lock();
            request = organizationObjects.get(organizationId);
        }
        finally {
            readLock.unlock();
        }
        if (request == null) {
            Lock writeLock = globalLock.writeLock();
            try {
                writeLock.lock();
                if (!organizationObjects.containsKey(organizationId)) {
                    request = new SForceOrganizationLevelPermit(organizationId, maxConcurrentCallsLimit);
                    organizationObjects.put(organizationId, request);
                } else {
                    request = organizationObjects.get(organizationId);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        try {
            request.getPermit(requestId, userKey, getUserLevelPermit, userConcurrentCallsLimit);
        }
        catch (Exception ex) {
            logger.error("Permit *NOT* acquired Request " + requestId, (Throwable)ex);
            if (request.hasAcquiredOrganizationLevelPermit(requestId)) {
                SForceAPIRequestTracker.closeRequest(organizationId, userKey, requestId);
            }
            SForceException.rethrow(ex);
        }
        numberOfActiveRequests.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("Permit acquired Request " + requestId);
        }
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeRequest(String organizationId, String userKey, long requestId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Trying Close Request " + requestId);
        }
        SForceOrganizationLevelPermit request = null;
        Lock readLock = globalLock.readLock();
        try {
            readLock.lock();
            request = organizationObjects.get(organizationId);
        }
        finally {
            readLock.unlock();
        }
        if (request == null) {
            throw new SForceException(1900012, new Object[0]);
        }
        try {
            request.releasePermit(userKey, requestId);
            if (logger.isDebugEnabled()) {
                logger.debug("Close Request successful " + requestId);
            }
        }
        finally {
            numberOfActiveRequests.decrementAndGet();
        }
    }

    public static int getNumberOfActiveRequests() {
        return numberOfActiveRequests.get();
    }

    private static class RequestId {
        private static volatile AtomicLong idGenerator = new AtomicLong(0L);

        private RequestId() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static long getNextId() {
            long next = idGenerator.incrementAndGet();
            if (next >= 0L) return next;
            Class<RequestId> clazz = RequestId.class;
            synchronized (RequestId.class) {
                next = idGenerator.incrementAndGet();
                if (next >= 0L) return next;
                idGenerator = new AtomicLong(0L);
                return idGenerator.incrementAndGet();
            }
        }
    }

    private static class SForceOrganizationLevelPermit {
        private final String organizationId;
        private final int maxConcurrentRequests;
        private ConcurrentHashMap<Long, Object> currentOrganizationRequests;
        private final Semaphore organizationPermits;
        private ReadWriteLock orgLock = new ReentrantReadWriteLock();
        private HashMap<String, SForceUserLevelPermit> userRequests = new HashMap(10);

        private SForceOrganizationLevelPermit(String organizationId, int maxConcurrentRequests) {
            this.organizationId = organizationId;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.organizationPermits = new Semaphore(maxConcurrentRequests, true);
            this.currentOrganizationRequests = new ConcurrentHashMap(maxConcurrentRequests);
        }

        private void getPermit(long requestId, String userKey, boolean getUserLevelLock, int userConcurrentCallsLimit) throws InterruptedException {
            boolean acquired = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Trying to acquire Organization level permit " + requestId);
            }
            if (!(acquired = this.organizationPermits.tryAcquire(900L, TimeUnit.SECONDS))) {
                throw new SForceException(1900010, "organization", requestId);
            }
            this.currentOrganizationRequests.put(requestId, DUMMY);
            if (logger.isDebugEnabled()) {
                logger.debug("Organization level permit acquired successfully " + requestId);
            }
            if (getUserLevelLock) {
                this.getUserLevelPermit(requestId, userKey, userConcurrentCallsLimit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releasePermit(String userKey, long requestId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Trying to release Organization level permit " + requestId);
            }
            if (!this.currentOrganizationRequests.remove(requestId, DUMMY)) {
                throw new SForceException(1900011, requestId);
            }
            try {
                this.releaseUserLevelPermit(userKey, requestId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Organization level permit released successfuly " + requestId);
                }
            }
            finally {
                this.organizationPermits.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getUserLevelPermit(long requestId, String userKey, int userConcurrentCallsLimit) throws InterruptedException {
            SForceUserLevelPermit request = null;
            Lock readLock = this.orgLock.readLock();
            try {
                readLock.lock();
                request = this.userRequests.get(userKey);
            }
            finally {
                readLock.unlock();
            }
            if (request == null) {
                Lock writeLock = this.orgLock.writeLock();
                try {
                    writeLock.lock();
                    if (!this.userRequests.containsKey(userKey)) {
                        request = new SForceUserLevelPermit(userKey, userConcurrentCallsLimit);
                        this.userRequests.put(userKey, request);
                    } else {
                        request = this.userRequests.get(userKey);
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
            request.getPermit(requestId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseUserLevelPermit(String userKey, long requestId) {
            SForceUserLevelPermit request = null;
            Lock readLock = this.orgLock.readLock();
            try {
                readLock.lock();
                request = this.userRequests.get(userKey);
            }
            finally {
                readLock.unlock();
            }
            if (request == null) {
                return;
            }
            if (request.hasAcquiredUserLevelPermit(requestId)) {
                request.releasePermit(requestId);
            }
        }

        private boolean hasAcquiredOrganizationLevelPermit(long requestId) {
            return this.currentOrganizationRequests.containsKey(requestId);
        }

        private static class SForceUserLevelPermit {
            private final Semaphore userLevelPermits;
            private final String userKey;
            private final int maxConcurrentUserRequests;
            private ConcurrentHashMap<Long, Object> currentUserRequests;

            private SForceUserLevelPermit(String userKey, int maxConcurrentUserRequests) {
                this.maxConcurrentUserRequests = maxConcurrentUserRequests;
                this.userLevelPermits = new Semaphore(maxConcurrentUserRequests, true);
                this.userKey = userKey;
                this.currentUserRequests = new ConcurrentHashMap(maxConcurrentUserRequests);
            }

            private void getPermit(long requestId) throws InterruptedException {
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying to acquire User level permit " + requestId);
                }
                boolean acquired = false;
                acquired = this.userLevelPermits.tryAcquire(900L, TimeUnit.SECONDS);
                if (!acquired) {
                    throw new SForceException(1900010, "user", requestId);
                }
                this.currentUserRequests.put(requestId, DUMMY);
                if (logger.isDebugEnabled()) {
                    logger.debug("User level permit acquired succesfully " + requestId);
                }
            }

            private void releasePermit(long requestId) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying to release User level permit " + requestId);
                }
                if (!this.currentUserRequests.remove(requestId, DUMMY)) {
                    throw new SForceException(1900009, requestId);
                }
                this.userLevelPermits.release();
                if (logger.isDebugEnabled()) {
                    logger.debug("User level permit released " + requestId);
                }
            }

            private boolean hasAcquiredUserLevelPermit(long requestId) {
                return this.currentUserRequests.containsKey(requestId);
            }
        }
    }
}

