/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request;

import com.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.cognos.cdms.ds.sforce.request.ISForceBatchOperation;
import com.cognos.cdms.ds.sforce.request.ISForceOperation;
import com.cognos.cdms.ds.sforce.request.SForceBatchOperation;
import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.cognos.cdms.ds.sforce.request.provider.ISForceProvider;
import com.cognos.cdms.ds.sforce.request.provider.SForceProviderManager;
import com.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionManager;
import com.cognos.cdms.ds.sforce.soql.cursors.SForceSOQLCursor;
import com.cognos.cdms.ds.sforce.soql.parsers.SForceSOQLQuery;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.ws.ConnectionException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceRequestManager {
    private static final String PROXY_AUTHENTICATION_ERROR = "407 Error: Unauthorized";
    private static final String CONNECTION_REFUSED_ERROR = "Connection refused";
    private static final String INVALID_LOGIN = "INVALID_LOGIN";
    private static final Logger logger = LoggerFactory.getLogger(SForceRequestManager.class);

    private SForceRequestManager() {
    }

    public static SForceRequestManager getInstance() {
        return SForceRequestManagerHelper.getInstance();
    }

    private void checkProxyAuthenticationError(SForceAPIException apiEx, SForceConnectionParams connParams) {
        String message = apiEx.getMessage();
        if (connParams.isProxyEnabled() && null != message && message.indexOf(PROXY_AUTHENTICATION_ERROR) > -1) {
            throw new SForceException(1900014, new Object[0]);
        }
    }

    private void checkServerNotReachableError(SForceAPIException apiEx) {
        String message = apiEx.getMessage();
        if (null != message && message.indexOf(CONNECTION_REFUSED_ERROR) > -1) {
            throw new SForceException(1900015, new Object[0]);
        }
    }

    private void checkInvalidLoginError(SForceAPIException apiEx, String username) {
        String message = apiEx.getMessage();
        if (null != message && message.indexOf(INVALID_LOGIN) > -1) {
            if (username == null) {
                username = "";
            }
            throw new SForceException(1900016, username);
        }
    }

    public void validateConnection(SForceConnectionParams connParams) {
        if (logger.isDebugEnabled()) {
            logger.debug("Validating connection " + connParams.toString());
        }
        ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
        try {
            SForceSessionManager.getSession(connParams, provider);
        }
        catch (SForceAPIException apiEx) {
            String url = provider.getLoginUrl(connParams);
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            this.checkInvalidLoginError(apiEx, connParams.getUserName());
            throw new SForceException(1900001, (Throwable)apiEx, connParams.getUserName() + "@" + url, apiEx.getMessage());
        }
    }

    public SForceResultSet query(SForceConnectionParams connParams, String sql, boolean retrieveAllBatches) {
        SForceResultSet result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Sforce Query" + connParams.toString());
            logger.debug("Retreive all batches" + retrieveAllBatches);
            logger.debug("Query" + sql);
        }
        try {
            SForceQueryOperation operation = new SForceQueryOperation(connParams, sql, retrieveAllBatches);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEx) {
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            throw new SForceException(1900005, (Throwable)apiEx, sql, apiEx.getMessage());
        }
        return result;
    }

    public SForceSOQLCursor queryRelationShipQuery(SForceConnectionParams connParams, String sql, boolean retrieveAllBatches) {
        SForceSOQLCursor result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Sforce Query" + connParams.toString());
            logger.debug("Retreive all batches" + retrieveAllBatches);
            logger.debug("Query" + sql);
        }
        try {
            SForceQueryRelationshipQueryOperation operation = new SForceQueryRelationshipQueryOperation(connParams, sql, retrieveAllBatches);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEx) {
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            throw new SForceException(1900005, (Throwable)apiEx, sql, apiEx.getMessage());
        }
        return result;
    }

    ISForceQueryResult queryMore(SForceConnectionParams connParams, String queryLocator) {
        ISForceQueryResult result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("query more " + connParams.toString() + " Locator - " + queryLocator);
        }
        try {
            SForceQueryMoreOperation operation = new SForceQueryMoreOperation(connParams, queryLocator);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEX) {
            this.checkProxyAuthenticationError(apiEX, connParams);
            this.checkServerNotReachableError(apiEX);
            throw new SForceException(apiEX);
        }
        return result;
    }

    public SForceTable[] describeGlobal(SForceConnectionParams connParams) {
        if (logger.isDebugEnabled()) {
            logger.debug("Describe Global operation " + connParams.toString());
        }
        SForceTable[] result = null;
        try {
            SForceDescribeGlobalOperation operation = new SForceDescribeGlobalOperation(connParams);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEx) {
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            throw new SForceException(1900006, (Throwable)apiEx, apiEx.getMessage());
        }
        return result;
    }

    public HashMap<String, SForceTableInfo> describeSObjects(SForceConnectionParams connParams, String[] objectNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Describe SObjects operation " + connParams.toString());
        }
        HashMap<String, SForceTableInfo> result = null;
        try {
            SForceDescribeSobjectsOperation operation = new SForceDescribeSobjectsOperation(connParams, objectNames);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEx) {
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            throw new SForceException(1900008, (Throwable)apiEx, apiEx.getMessage());
        }
        return result;
    }

    public SForceTableInfo describeSObject(SForceConnectionParams connParams, String objectName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Describe SObject operation" + connParams.toString());
        }
        SForceTableInfo result = null;
        try {
            SForceDescribeSobjectOperation operation = new SForceDescribeSobjectOperation(connParams, objectName);
            result = this.getOperation(operation, connParams.getMaximumRetries(), connParams.getWaitBetweenRetries()).execute();
        }
        catch (SForceAPIException apiEx) {
            this.checkProxyAuthenticationError(apiEx, connParams);
            this.checkServerNotReachableError(apiEx);
            throw new SForceException(1900007, (Throwable)apiEx, objectName, apiEx.getMessage());
        }
        return result;
    }

    protected <E> ISForceOperation<E> getOperation(ISForceOperation<E> operation, int maxRetries, int waitBetweenRetries) {
        SForceRetryOperation<E> retryOp = new SForceRetryOperation<E>(operation, maxRetries, waitBetweenRetries);
        return new SForceSessionExpiryCheckOperation(retryOp);
    }

    private static class SForceSessionExpiryCheckOperation<E>
    implements ISForceOperation<E> {
        private ISForceOperation<E> sforceOperation;

        private SForceSessionExpiryCheckOperation(ISForceOperation<E> sforceOperation) {
            this.sforceOperation = sforceOperation;
        }

        @Override
        public E execute() throws SForceAPIException {
            try {
                return this.sforceOperation.execute();
            }
            catch (SForceAPIException apiEx) {
                String message = apiEx.getMessage();
                if (message != null && this.hasSessionExpired(message)) {
                    SForceConnectionParams connectionParameters = this.getConnectionParameters();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Session Expired " + connectionParameters.toString());
                    }
                    ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
                    ISForceSession session = SForceSessionManager.getSession(connectionParameters, provider);
                    SForceSessionKey sessionKey = session.getSessionkey();
                    SForceSessionManager.invalidateSession(connectionParameters, sessionKey);
                    SForceSessionManager.getSession(connectionParameters, provider);
                    return this.sforceOperation.execute();
                }
                throw apiEx;
            }
        }

        private boolean hasSessionExpired(String message) {
            String msg = message.toLowerCase();
            String[] expiryMsgs = new String[]{"Session expired or invalid".toLowerCase(), "Invalid Session ID found in SessionHeader".toLowerCase()};
            if (message == null) {
                return false;
            }
            for (String expmsg : expiryMsgs) {
                if (msg.indexOf(expmsg) <= -1) continue;
                return true;
            }
            return false;
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.sforceOperation.getConnectionParameters();
        }
    }

    private static class SForceRetryOperation<E>
    implements ISForceOperation<E> {
        private ISForceOperation<E> operation;
        private int maxRetries;
        private int waitBetweenRetries;

        public SForceRetryOperation(ISForceOperation<E> operation, int maxRetries, int waitBetweenRetries) {
            this.operation = operation;
            this.maxRetries = maxRetries;
            this.waitBetweenRetries = waitBetweenRetries;
        }

        @Override
        public E execute() throws SForceAPIException {
            E result = null;
            String message = null;
            boolean networkFailure = false;
            for (int tryCount = 0; tryCount <= this.maxRetries; ++tryCount) {
                try {
                    result = this.operation.execute();
                    break;
                }
                catch (SForceAPIException apiEx) {
                    message = apiEx.getMessage();
                    if (this.isNetworkFailure(message)) {
                        networkFailure = true;
                    }
                    throw apiEx;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        message = cause.getMessage();
                        if (this.isNetworkFailure(message)) {
                            networkFailure = true;
                        }
                        throw new SForceAPIException(e);
                    }
                    throw new SForceAPIException(e);
                }
                if (!networkFailure) continue;
                if (tryCount == this.maxRetries) {
                    throw new SForceAPIException(message);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Network failure executing operation " + message);
                    logger.debug("Retrying operation.....");
                }
                try {
                    Thread.sleep(this.waitBetweenRetries * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new SForceAPIException(ie);
                }
            }
            return result;
        }

        private boolean isNetworkFailure(String message) {
            return message != null && (message.indexOf("Connection reset") != -1 || message.indexOf(SForceRequestManager.CONNECTION_REFUSED_ERROR) != -1 || message.indexOf("Read timed out") != -1);
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.operation.getConnectionParameters();
        }
    }

    private static class SForceQueryMoreOperation
    implements ISForceOperation<ISForceQueryResult> {
        private String queryLocator;
        private SForceConnectionParams connectionParams;

        private SForceQueryMoreOperation(SForceConnectionParams connectionParams, String queryLocator) {
            this.queryLocator = queryLocator;
            this.connectionParams = connectionParams;
        }

        @Override
        public ISForceQueryResult execute() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getQueryProvider();
            return SForceSessionManager.getSession(this.connectionParams, provider).queryMore(this.queryLocator);
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }
    }

    private static class SForceQueryRelationshipQueryOperation
    implements ISForceOperation<SForceSOQLCursor> {
        private String selectQuery;
        private SForceConnectionParams connectionParams;
        private boolean retrieveAllBatches;

        private SForceQueryRelationshipQueryOperation(SForceConnectionParams connectionParams, String selectQuery, boolean retrieveAllBatches) {
            this.selectQuery = selectQuery;
            this.connectionParams = connectionParams;
            this.retrieveAllBatches = retrieveAllBatches;
        }

        @Override
        public SForceSOQLCursor execute() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getQueryProvider();
            SForceSOQLQuery query = new SForceSOQLQuery(this.selectQuery);
            return provider.createSOQLCursor(this.connectionParams, query);
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }
    }

    private static class SForceQueryOperation
    implements ISForceOperation<SForceResultSet> {
        private String selectQuery;
        private SForceConnectionParams connectionParams;
        private boolean retrieveAllBatches;

        private SForceQueryOperation(SForceConnectionParams connectionParams, String selectQuery, boolean retrieveAllBatches) {
            this.selectQuery = selectQuery;
            this.connectionParams = connectionParams;
            this.retrieveAllBatches = retrieveAllBatches;
        }

        @Override
        public SForceResultSet execute() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getQueryProvider();
            return SForceSessionManager.getSession(this.connectionParams, provider).query(this.selectQuery, this.retrieveAllBatches);
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }
    }

    private class SForceDescribeSobjectsOperation
    extends SForceBatchOperation<HashMap<String, SForceTableInfo>> {
        private String[] objectNames;
        private SForceConnectionParams connectionParams;

        public SForceDescribeSobjectsOperation(SForceConnectionParams connectionParams, String[] objectNames) {
            super(HashMap.class, 100);
            this.objectNames = objectNames;
            this.connectionParams = connectionParams;
        }

        @Override
        public HashMap<String, SForceTableInfo> executeBatch() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
            try {
                return SForceSessionManager.getSession(this.connectionParams, provider).getTablesMetadata(this.objectNames);
            }
            catch (ConnectionException e) {
                throw new SForceAPIException(e);
            }
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }

        public HashMap<String, SForceTableInfo> mergeOutputs(HashMap<String, SForceTableInfo>[] outputs) {
            HashMap<String, SForceTableInfo> finalResult = new HashMap<String, SForceTableInfo>();
            HashMap<String, SForceTableInfo>[] hashMapArray = outputs;
            int n = hashMapArray.length;
            for (int i = 0; i < n; ++i) {
                HashMap<String, SForceTableInfo> sobjectResults;
                HashMap<String, SForceTableInfo> results = sobjectResults = hashMapArray[i];
                finalResult.putAll(results);
            }
            DescribeSObjectResult[] sobjectResult = new DescribeSObjectResult[finalResult.size()];
            return finalResult;
        }

        @Override
        public ISForceBatchOperation<HashMap<String, SForceTableInfo>>[] splitInputs(int batchSize) {
            int totalNoOfRecords = this.objectNames.length;
            int totalNoOfBatches = totalNoOfRecords / batchSize;
            ISForceBatchOperation[] inputs = new ISForceBatchOperation[++totalNoOfBatches];
            for (int index = 0; index < totalNoOfBatches; ++index) {
                String[] batch = new String[Math.min(batchSize, totalNoOfRecords - index * batchSize)];
                System.arraycopy(this.objectNames, index * batchSize, batch, 0, batch.length);
                inputs[index] = new SForceDescribeSobjectsOperation(this.connectionParams, batch);
            }
            return inputs;
        }
    }

    private static class SForceDescribeSobjectOperation
    implements ISForceOperation<SForceTableInfo> {
        private String objectName;
        private SForceConnectionParams connectionParams;

        public SForceDescribeSobjectOperation(SForceConnectionParams connectionParams, String objectName) {
            this.objectName = objectName;
            this.connectionParams = connectionParams;
        }

        @Override
        public SForceTableInfo execute() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
            try {
                return SForceSessionManager.getSession(this.connectionParams, provider).getTableMetadata(this.objectName);
            }
            catch (ConnectionException e) {
                throw new SForceAPIException(e);
            }
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }
    }

    private static class SForceDescribeGlobalOperation
    implements ISForceOperation<SForceTable[]> {
        private SForceConnectionParams connectionParams;

        public SForceDescribeGlobalOperation(SForceConnectionParams connectionParams) {
            this.connectionParams = connectionParams;
        }

        @Override
        public SForceTable[] execute() throws SForceAPIException {
            ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
            try {
                return SForceSessionManager.getSession(this.connectionParams, provider).getTables();
            }
            catch (ConnectionException e) {
                throw new SForceAPIException(e);
            }
        }

        @Override
        public SForceConnectionParams getConnectionParameters() {
            return this.connectionParams;
        }
    }

    private static class SForceRequestManagerHelper {
        private static SForceRequestManager instance = new SForceRequestManager();

        private SForceRequestManagerHelper() {
        }

        private static SForceRequestManager getInstance() {
            return instance;
        }
    }
}

