/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request.session;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.provider.ISForceProvider;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceCredentials {
    private static final Logger logger = LoggerFactory.getLogger(SForceCredentials.class);
    private static int SSO_TOKEN_LENGTH = 3;
    private String token;
    private String sessionId;
    private String sessionUrl;
    private String organizationId;
    private boolean ssoEnabled = false;
    private boolean loggedIn = false;
    private String password;
    private SForceConnectionParams connectionParams;
    private ISForceProvider provider;

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isSSO() {
        return this.ssoEnabled;
    }

    public SForceCredentials(SForceConnectionParams param, ISForceProvider provider) {
        this.connectionParams = param;
        this.provider = provider;
        this.parseCredentials(param);
    }

    private void parseCredentials(SForceConnectionParams param) {
        if (param.getPassword() == null) {
            return;
        }
        int pwdDelimiterIndex = -1;
        int sessionIdDelimiterIndex = -1;
        int sessionUrlDelimiterIndex = -1;
        StringBuilder sb = new StringBuilder(param.getPassword());
        if (param.getPassword().length() >= SSO_TOKEN_LENGTH) {
            this.token = param.getPassword().substring(0, SSO_TOKEN_LENGTH);
            pwdDelimiterIndex = sb.indexOf(this.token);
            if (pwdDelimiterIndex == 0 && (sessionIdDelimiterIndex = sb.indexOf(this.token, pwdDelimiterIndex + 1)) > pwdDelimiterIndex + 1 && (sessionUrlDelimiterIndex = sb.indexOf(this.token, sessionIdDelimiterIndex + 1)) > sessionIdDelimiterIndex + 1) {
                this.ssoEnabled = true;
                this.loggedIn = true;
            }
        }
        if (this.ssoEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug("SSO enabled " + param.toString());
            }
            this.password = sb.substring(pwdDelimiterIndex + 3, sessionIdDelimiterIndex);
            this.sessionId = sb.substring(sessionIdDelimiterIndex + 3, sessionUrlDelimiterIndex);
            this.sessionUrl = sb.substring(sessionUrlDelimiterIndex + 3);
            if (logger.isDebugEnabled()) {
                logger.debug("Retrieved SessionId from connection parameters " + param.toString());
            }
        } else {
            this.password = param.getPassword();
        }
    }

    public SForceSessionKey getSessionKey() throws SForceAPIException {
        if (logger.isDebugEnabled()) {
            logger.debug("reading sessionkey for " + this.connectionParams.toString());
            logger.debug("is SSO " + this.isSSO());
        }
        SForceSessionKey key = null;
        key = !this.isLoggedIn() && !this.isSSO() ? this.provider.login(this.connectionParams) : new SForceSessionKey(this.sessionId, this.sessionUrl, this.organizationId, this.connectionParams.getConnectionKey());
        return key;
    }
}

